/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.util;

import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.token.WSCredentialTokenMapperInterface;
import com.ibm.ws.wssecurity.platform.util.WSSSubjectHelper;
import com.ibm.ws.wssecurity.platform.websphere.util.WSSOpaqueTokenHelper;
import com.ibm.ws.wssecurity.platform.websphere.wssapi.token.impl.TokenPropagationCallbackHandler;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.security.token.AuthenticationToken;
import com.ibm.wsspi.security.token.WSOpaqueTokenHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.axis2.util.ObjectStateUtils;

public class WSSSubjectHelperImpl
implements WSSSubjectHelper,
Externalizable {
    private static final long serialVersionUID = -7832034184844111080L;
    private static final int VERSION = 1;
    private static final TraceComponent tc = Tr.register(WSSSubjectHelperImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final ContextManager mgr = ContextManagerFactory.getInstance();
    private static final WSOpaqueTokenHelper wsOpaHelper = WSOpaqueTokenHelper.getInstance();
    private static final WSSOpaqueTokenHelper wssOpaHelper = WSSOpaqueTokenHelper.getInstance();
    private static final boolean isServerSecurityEnabled = WSSSubjectHelperImpl.isServerSecurityEnabled();
    public static final String DESERIALIZE_ASYNCH_CONTEXT = "system.DESERIALIZE_ASYNCH_CONTEXT";
    private int version = 1;
    private byte[] opaqueToken;
    private byte[] loginToken;
    private Subject subject = null;

    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public byte[] serializeSubject(Subject subject) {
        this.subject = subject;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            this.writeExternal(objectOutputStream);
            objectOutputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Fail to serialize Token. ", exception.getStackTrace());
            }
            return null;
        }
    }

    public Subject deserializeSubject(byte[] byArray) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            this.readExternal(objectInputStream);
            objectInputStream.close();
            byteArrayInputStream.close();
            this.subject = (Subject)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws LoginException {
                    return WSSSubjectHelperImpl.this.doLogin();
                }
            });
            return this.subject;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Fail to de-serialize Token. ", exception.getStackTrace());
            }
            return null;
        }
    }

    public Subject doLogin() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doLogin", new Object[]{"Login token=" + this.loginToken, "Subject token=" + this.opaqueToken});
        }
        Subject subject = null;
        try {
            ArrayList arrayList = null;
            arrayList = isServerSecurityEnabled ? wsOpaHelper.createTokenHolderListFromOpaqueToken(this.opaqueToken) : wssOpaHelper.createTokenHolderListFromOpaqueToken(this.opaqueToken);
            String string = "system.wss.inbound.deserialize";
            TokenPropagationCallbackHandler tokenPropagationCallbackHandler = new TokenPropagationCallbackHandler(null, arrayList, this.loginToken);
            LoginContext loginContext = new LoginContext(string, tokenPropagationCallbackHandler);
            loginContext.login();
            subject = loginContext.getSubject();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "doLogin", "493", this);
            LoginException loginException = new LoginException("Failed to deserialize Context.");
            loginException.initCause(exception);
            throw loginException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doLogin");
        }
        return subject;
    }

    private byte[] createSubjectToken(Subject subject) throws WSLoginFailedException, WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSubjectToken", "Subject is null? " + (subject == null));
        }
        byte[] byArray = null;
        if (subject != null) {
            byArray = isServerSecurityEnabled ? wsOpaHelper.createOpaqueTokenFromSubject(subject) : wssOpaHelper.createOpaqueTokenFromSubject(subject);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSubjectToken", "Token created is null? " + (byArray == null));
        }
        return byArray;
    }

    private ArrayList createAndCacheTokenHolderList(byte[] byArray) throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createAndCacheTokenHolderList", byArray);
        }
        ArrayList arrayList = wsOpaHelper.createTokenHolderListFromOpaqueToken(byArray);
        String string = wsOpaHelper.getOpaqueTokenLookup();
        mgr.put(string, arrayList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createAndCacheTokenHolderList", "tokenList=" + arrayList);
        }
        return arrayList;
    }

    private void removeTokenHolderListFromCache() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeTokenHolderListFromCache");
        }
        String string = wsOpaHelper.getOpaqueTokenLookup();
        mgr.put(string, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeTokenHolderListFromCache");
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "writeObject", objectOutput);
            }
            try {
                this.loginToken = null;
                this.opaqueToken = null;
                if (this.subject != null) {
                    WSCredential wSCredential;
                    this.opaqueToken = this.createSubjectToken(this.subject);
                    if (isServerSecurityEnabled && (wSCredential = SubjectHelper.getWSCredentialFromSubject(this.subject)) != null) {
                        WSCredentialTokenMapperInterface wSCredentialTokenMapperInterface = mgr.getWSCredTokenMapper();
                        AuthenticationToken authenticationToken = wSCredentialTokenMapperInterface.createAuthTokenFromWSCredential(wSCredential);
                        this.loginToken = authenticationToken != null ? authenticationToken.getBytes() : null;
                    }
                }
            }
            catch (WSLoginFailedException wSLoginFailedException) {
                FFDCFilter.processException((Throwable)wSLoginFailedException, "writeObject", "592", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "writeObject", wSLoginFailedException);
                }
            }
            catch (WSSecurityException wSSecurityException) {
                FFDCFilter.processException((Throwable)wSSecurityException, "writeObject", "597", this);
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug(tc, "writeObject", wSSecurityException);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writeObject", "Serializing Context version: " + this.version + ", serialVersionUID=" + -7832034184844111080L);
        }
        objectOutput.writeInt(this.version);
        ObjectStateUtils.writeObject(objectOutput, this.opaqueToken, "opaqueToken");
        ObjectStateUtils.writeObject(objectOutput, this.loginToken, "loginToken");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeObject");
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readObject", objectInput);
        }
        this.version = objectInput.readInt();
        switch (this.version) {
            case 1: {
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "readObject", "Deserializing Context version: " + this.version + ", serialVersionUID=" + -7832034184844111080L);
                break;
            }
            default: {
                throw new InvalidClassException("Unsupported Context version: " + this.version);
            }
        }
        Object object = null;
        object = ObjectStateUtils.readObject(objectInput, "opaqueToken");
        if (object != null) {
            this.opaqueToken = (byte[])object;
        }
        if ((object = ObjectStateUtils.readObject(objectInput, "loginToken")) != null) {
            this.loginToken = (byte[])object;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readObject");
        }
    }

    private static final boolean isServerSecurityEnabled() {
        try {
            return mgr.isServerSecurityEnabled();
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isServerSecurityEnabled ", exception.getMessage());
            }
            return false;
        }
    }
}

