/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.util;

import com.ibm.ws.wssecurity.platform.util.WSSSelfManagedData;
import com.ibm.ws.wssecurity.platform.util.WSSSubjectHelper;
import com.ibm.ws.wssecurity.platform.util.WSSSubjectHelperFactory;
import com.ibm.ws.wssecurity.platform.websphere.util.WSSOpaqueTokenHelper;
import com.ibm.ws.wssecurity.util.PlatformContextUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.security.token.TokenHolder;
import com.ibm.wsspi.wssecurity.core.Constants;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.axis2.context.MessageContext;

public class WSSSelfManagedDataImpl
implements WSSSelfManagedData {
    private static final TraceComponent tc = Tr.register(WSSSelfManagedDataImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static WSSOpaqueTokenHelper opaqueTokenHelper = WSSOpaqueTokenHelper.getInstance();
    public static final String WSSSubject = Constants.WSSECURITY_TOKEN_WSSSUBJECT;

    public synchronized byte[] getSerializedSelfManagedData(Map map) {
        if (map == null) {
            return null;
        }
        ArrayList<TokenHolder> arrayList = new ArrayList<TokenHolder>();
        Object v = map.get(WSSSubject);
        if (v != null && v instanceof Subject) {
            byte[] byArray = null;
            Subject subject = (Subject)v;
            WSSSubjectHelper wSSSubjectHelper = WSSSubjectHelperFactory.getInstance();
            byArray = wSSSubjectHelper.serializeSubject(subject);
            TokenHolder tokenHolder = new TokenHolder(byArray, WSSSubject, 1);
            arrayList.add(tokenHolder);
        }
        return opaqueTokenHelper.createOpaqueTokenFromTokenHolderList(null, arrayList);
    }

    public synchronized Map getDeserializedSelfManagedData(byte[] byArray) {
        HashMap<String, Subject> hashMap = new HashMap<String, Subject>();
        ArrayList arrayList = new ArrayList();
        try {
            arrayList = opaqueTokenHelper.createTokenHolderListFromOpaqueToken(byArray);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getDeserializedSelfManagedData(byte[] subjByte) fails with " + exception.getMessage());
            }
            return null;
        }
        ListIterator listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            TokenHolder tokenHolder = (TokenHolder)listIterator.next();
            if (!tokenHolder.getName().equals(WSSSubject)) continue;
            try {
                WSSSubjectHelper wSSSubjectHelper = WSSSubjectHelperFactory.getInstance();
                Subject subject = wSSSubjectHelper.deserializeSubject(tokenHolder.getBytes());
                hashMap.put(WSSSubject, subject);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Fail to deserialize Token. ", exception.getStackTrace());
            }
        }
        return hashMap;
    }

    public boolean serializeWSSProperty(MessageContext messageContext) throws IOException {
        if (!PlatformContextUtil.isWebSphereServerProcess()) {
            return false;
        }
        Subject subject = (Subject)messageContext.getProperty(Constants.WSSECURITY_TOKEN_WSSSUBJECT);
        if (subject == null) {
            return false;
        }
        try {
            HashMap<String, Subject> hashMap = new HashMap<String, Subject>();
            hashMap.put(WSSSubject, subject);
            WSSSelfManagedDataImpl wSSSelfManagedDataImpl = new WSSSelfManagedDataImpl();
            byte[] byArray = wSSSelfManagedDataImpl.getSerializedSelfManagedData(hashMap);
            messageContext.setProperty(WSSSubject, byArray);
            return true;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Fail to serialize WSSSubject. ", exception);
            }
            return false;
        }
    }

    public boolean deserializeWSSProperty(MessageContext messageContext) {
        if (!PlatformContextUtil.isWebSphereServerProcess()) {
            return true;
        }
        byte[] byArray = null;
        Object object = messageContext.getProperty(WSSSubject);
        if (object == null) {
            return false;
        }
        WSSSelfManagedDataImpl wSSSelfManagedDataImpl = new WSSSelfManagedDataImpl();
        byArray = (byte[])object;
        Map map = wSSSelfManagedDataImpl.getDeserializedSelfManagedData(byArray);
        if ((object = map.get(WSSSubject)) != null && object instanceof Subject) {
            messageContext.setProperty(Constants.WSSECURITY_TOKEN_WSSSUBJECT, (Subject)object);
        }
        return true;
    }
}

