/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.util;

import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.util.WsObjectInputStream;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.security.token.AuthenticationToken;
import com.ibm.wsspi.security.token.Token;
import com.ibm.wsspi.security.token.TokenHolder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.ObjectOutputStream;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.CredentialExpiredException;

public class WSSOpaqueTokenHelper {
    private static final TraceComponent tc = Tr.register(WSSOpaqueTokenHelper.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static WSSOpaqueTokenHelper wsOpaqueTokenHelper = null;
    public static final String tokenHeader = "WSOPAQUE";
    private final byte[] tokenHeaderBytes = StringBytesConversion.getConvertedBytes((String)"WSOPAQUE");
    private final int tokenHeaderSize = this.tokenHeaderBytes.length;
    private final int tokenVersion = 1;
    private final String tokenHeaderLookup = "WSOPAQUE:1";
    public static final String wsCredHashHeader = "WSCREDHASH";
    private final byte[] wsCredHashHeaderBytes = StringBytesConversion.getConvertedBytes((String)"WSCREDHASH");
    private final int wsCredHashHeaderSize = this.wsCredHashHeaderBytes.length;
    public static final String wsTokensHeader = "WSTOKEN";
    private final byte[] wsTokensHeaderBytes = StringBytesConversion.getConvertedBytes((String)"WSTOKEN");
    private final int wsTokensHeaderSize = this.wsTokensHeaderBytes.length;
    public static final String customTokensHeader = "CUSTOM";
    private final byte[] customTokensHeaderBytes = StringBytesConversion.getConvertedBytes((String)"CUSTOM");
    private final int customTokensHeaderSize = this.customTokensHeaderBytes.length;
    public static final String customPublicTokensHeader = "CUSTOM_PUBLIC";
    public static final String customPublicTokensHeaderEnding = " (1)";
    private final byte[] customPublicTokensHeaderBytes = StringBytesConversion.getConvertedBytes((String)"CUSTOM_PUBLIC");
    private final int customPublicTokensHeaderSize = this.customPublicTokensHeaderBytes.length;
    public static final String customPrivateTokensHeader = "CUSTOM_PRIVATE";
    public static final String customPrivateTokensHeaderEnding = " (2)";
    private final byte[] customPrivateTokensHeaderBytes = StringBytesConversion.getConvertedBytes((String)"CUSTOM_PRIVATE");
    private final int customPrivateTokensHeaderSize = this.customPrivateTokensHeaderBytes.length;
    public static final String customPrincipalTokensHeader = "CUSTOM_PRINCIPAL";
    public static final String customPrincipalTokensHeaderEnding = " (3)";
    private final byte[] customPrincipalTokensHeaderBytes = StringBytesConversion.getConvertedBytes((String)"CUSTOM_PRINCIPAL");
    private final int customPrincipalTokensHeaderSize = this.customPrincipalTokensHeaderBytes.length;
    private static ArrayList excludeList = null;

    public static WSSOpaqueTokenHelper getInstance() {
        if (wsOpaqueTokenHelper == null) {
            wsOpaqueTokenHelper = new WSSOpaqueTokenHelper();
        }
        return wsOpaqueTokenHelper;
    }

    private WSSOpaqueTokenHelper() {
    }

    public String getOpaqueTokenName() {
        return tokenHeader;
    }

    public String getOpaqueTokenLookup() {
        return "WSOPAQUE:1";
    }

    public int getOpaqueTokenVersion() {
        return 1;
    }

    public byte[] createOpaqueTokenFromSubject(final Subject subject) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createOpaqueTokenFromSubject");
        }
        if (subject == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createOpaqueTokenFromSubject");
            }
            return null;
        }
        try {
            ArrayList arrayList = null;
            try {
                arrayList = (ArrayList)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws WSLoginFailedException {
                        return WSSOpaqueTokenHelper.this.getForwardableTokensFromSubject(subject);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.security.token.WSOpaqueTokenHelper.createOpaqueTokenFromSubject", "249", this);
                Tr.debug(tc, "Exception getting private/public tokens from Subject.", new Object[]{privilegedActionException.getException()});
                return null;
            }
            if (arrayList == null && tc.isDebugEnabled()) {
                Tr.debug(tc, "Token list is null.");
            }
            if (arrayList == null && tc.isDebugEnabled()) {
                Tr.debug(tc, "subject token lists are null.");
            }
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            if (arrayList != null) {
                Object[] objectArray = arrayList.toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    arrayList2.add(objectArray[i]);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createOpaqueTokenFromSubject");
            }
            return this.createOpaqueTokenFromTokenHolderList(subject, arrayList2);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred creating opaque token.", new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.token.WSOpaqueTokenHelper.updatePropagationTokenWithSubjectChange", "334", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createOpaqueTokenFromSubject");
            }
            throw new WSLoginFailedException(exception.getMessage(), exception);
        }
    }

    public synchronized byte[] createOpaqueTokenFromTokenHolderList(Subject subject, ArrayList arrayList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createOpaqueTokenFromTokenHolderList");
        }
        if ((arrayList == null || arrayList.size() == 0) && tc.isDebugEnabled()) {
            Tr.debug(tc, "Returning null token.", new Object[]{arrayList});
        }
        try {
            Object object;
            DataOutputStream dataOutputStream;
            ByteArrayOutputStream byteArrayOutputStream;
            block33: {
                byteArrayOutputStream = new ByteArrayOutputStream(500);
                dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Token header size: " + this.tokenHeaderSize);
                }
                dataOutputStream.write(this.tokenHeaderBytes, 0, this.tokenHeaderSize);
                dataOutputStream.write(1);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Writing opaque token header/version: WSOPAQUE/V1");
                }
                WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
                Hashtable hashtable = null;
                if (wSCredential != null) {
                    hashtable = ((WSCredentialImpl)wSCredential).getTable();
                }
                byte[] byArray = null;
                int n = 0;
                if (hashtable != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Attempting to write wsCred hashtable.");
                    }
                    try {
                        byArray = this.serialize_internal(hashtable, ObjectOutputStream.class);
                        if (byArray != null) {
                            n = byArray.length;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Offset size: " + byteArrayOutputStream.size());
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "wsCredHashHeaderSize: " + this.wsCredHashHeaderSize);
                            }
                            dataOutputStream.write(this.wsCredHashHeaderBytes, 0, this.wsCredHashHeaderSize);
                            dataOutputStream.writeInt(n);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Writing wsCred hashtable, length: " + n);
                            }
                            dataOutputStream.write(byArray, 0, n);
                        }
                    }
                    catch (Exception exception) {
                        byArray = null;
                        n = 0;
                        Tr.warning(tc, "security.sap.warning.serializing.custom.objects.from.subject", new Object[]{hashtable});
                        if (!tc.isDebugEnabled()) break block33;
                        Tr.debug(tc, "Exception occurred writing wsCred hashtable.", new Object[]{exception});
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Total tokens to write: " + arrayList.size());
            }
            dataOutputStream.write(this.wsTokensHeaderBytes, 0, this.wsTokensHeaderSize);
            dataOutputStream.write(arrayList.size());
            for (int i = 0; i < arrayList.size(); ++i) {
                object = null;
                int n = 0;
                byte[] byArray = null;
                int n2 = 0;
                byte[] byArray2 = null;
                int n3 = 0;
                TokenHolder tokenHolder = (TokenHolder)arrayList.get(i);
                if (tokenHolder == null) continue;
                object = tokenHolder.getName();
                n2 = tokenHolder.getVersion();
                byArray2 = tokenHolder.getBytes();
                if (object == null || n2 == 0 || byArray2 == null) continue;
                byArray = StringBytesConversion.getConvertedBytes((String)object);
                n = byArray.length;
                n3 = byArray2.length;
                dataOutputStream.writeInt(n);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Writing token name: " + (String)object);
                }
                dataOutputStream.write(byArray, 0, n);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Writing token version: " + n2);
                }
                dataOutputStream.write(n2);
                dataOutputStream.writeInt(n3);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Writing token bytes, length: " + n3);
                }
                dataOutputStream.write(byArray2, 0, n3);
            }
            ArrayList arrayList2 = null;
            try {
                if (subject != null) {
                    object = subject;
                    arrayList2 = (ArrayList)AccessController.doPrivileged(new PrivilegedExceptionAction((Subject)object){
                        final /* synthetic */ Subject val$subjectPriv;
                        {
                            this.val$subjectPriv = subject;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public Object run() throws CredentialDestroyedException, CredentialExpiredException {
                            Subject subject = this.val$subjectPriv;
                            synchronized (subject) {
                                String string;
                                Object object;
                                ArrayList<TokenHolder> arrayList = new ArrayList<TokenHolder>();
                                Object object22 = null;
                                byte[] byArray = null;
                                for (Object object2 : this.val$subjectPriv.getPublicCredentials()) {
                                    if (object2 instanceof AuthenticationToken || object2 instanceof WSCredential) continue;
                                    try {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Serializing custom public object: ", new Object[]{object2});
                                        }
                                        byArray = WSSOpaqueTokenHelper.this.serialize_internal(object2, ObjectOutputStream.class);
                                        Object object3 = null;
                                        try {
                                            object = object2.getClass().getName();
                                            object3 = (String)object + WSSOpaqueTokenHelper.customPublicTokensHeaderEnding;
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        if (object3 == null) {
                                            object3 = WSSOpaqueTokenHelper.customPublicTokensHeader;
                                        }
                                        if (byArray == null) continue;
                                        arrayList.add(new TokenHolder(byArray, (String)object3, 1));
                                    }
                                    catch (Exception exception) {
                                        Tr.warning(tc, "security.sap.warning.serializing.custom.objects.from.subject", new Object[]{object2});
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Exception occurred serializing custom public object.", new Object[]{exception});
                                        }
                                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.token.WSOpaqueTokenHelper.createOpaqueTokenFromTokenHolderList", "515", this);
                                    }
                                }
                                for (Object object4 : this.val$subjectPriv.getPrivateCredentials()) {
                                    if (object4 instanceof AuthenticationToken || object4 instanceof WSCredential) continue;
                                    try {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Serializing custom private object: ", new Object[]{object4});
                                        }
                                        byArray = WSSOpaqueTokenHelper.this.serialize_internal(object4, ObjectOutputStream.class);
                                        object = null;
                                        try {
                                            string = object4.getClass().getName();
                                            object = string + WSSOpaqueTokenHelper.customPrivateTokensHeaderEnding;
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        if (object == null) {
                                            object = WSSOpaqueTokenHelper.customPrivateTokensHeader;
                                        }
                                        if (byArray == null) continue;
                                        arrayList.add(new TokenHolder(byArray, (String)object, 1));
                                    }
                                    catch (Exception exception) {
                                        Tr.warning(tc, "security.sap.warning.serializing.custom.objects.from.subject", new Object[]{object4});
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Exception occurred serializing custom public object.", new Object[]{exception});
                                        }
                                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.token.WSOpaqueTokenHelper.createOpaqueTokenFromTokenHolderList", "554", this);
                                    }
                                }
                                for (Principal principal : this.val$subjectPriv.getPrincipals()) {
                                    if (principal instanceof WSPrincipal) continue;
                                    try {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Serializing custom principal object: ", new Object[]{principal});
                                        }
                                        byArray = WSSOpaqueTokenHelper.this.serialize_internal(principal, ObjectOutputStream.class);
                                        string = null;
                                        try {
                                            String string2 = principal.getClass().getName();
                                            string = string2 + WSSOpaqueTokenHelper.customPrincipalTokensHeaderEnding;
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        if (string == null) {
                                            string = WSSOpaqueTokenHelper.customPrincipalTokensHeader;
                                        }
                                        if (byArray == null) continue;
                                        arrayList.add(new TokenHolder(byArray, string, 1));
                                    }
                                    catch (Exception exception) {
                                        Tr.warning(tc, "security.sap.warning.serializing.custom.objects.from.subject", new Object[]{principal});
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Exception occurred serializing custom public object.", new Object[]{exception});
                                        }
                                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.token.WSOpaqueTokenHelper.createOpaqueTokenFromTokenHolderList", "592", this);
                                    }
                                }
                                return arrayList;
                            }
                        }
                    });
                }
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.security.server.lm.wsSAPInboundLoginModule.commit", "606", this);
                throw new WSLoginFailedException(privilegedActionException.getException().getMessage(), privilegedActionException.getException());
            }
            if (arrayList2 != null && arrayList2.size() > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Total custom tokens to write: " + arrayList2.size());
                }
                dataOutputStream.write(this.customTokensHeaderBytes, 0, this.customTokensHeaderSize);
                dataOutputStream.write(arrayList2.size());
                for (int i = 0; i < arrayList2.size(); ++i) {
                    String string = null;
                    int n = 0;
                    byte[] byArray = null;
                    int n4 = 0;
                    byte[] byArray3 = null;
                    int n5 = 0;
                    TokenHolder tokenHolder = (TokenHolder)arrayList2.get(i);
                    if (tokenHolder == null) continue;
                    string = tokenHolder.getName();
                    n4 = tokenHolder.getVersion();
                    byArray3 = tokenHolder.getBytes();
                    if (string == null || n4 == 0 || byArray3 == null) continue;
                    byArray = StringBytesConversion.getConvertedBytes((String)string);
                    n = byArray.length;
                    n5 = byArray3.length;
                    dataOutputStream.writeInt(n);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Writing token name: " + string);
                    }
                    dataOutputStream.write(byArray, 0, n);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Writing token version: " + n4);
                    }
                    dataOutputStream.write(n4);
                    dataOutputStream.writeInt(n5);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Writing token bytes, length: " + n5);
                    }
                    dataOutputStream.write(byArray3, 0, n5);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Total opaque token length: " + byteArrayOutputStream.size());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createOpaqueTokenFromTokenHolderList");
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.token.WSOpaqueTokenHelper.createOpaqueTokenFromTokenHolderList", "673", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred creating opaque token.", new Object[]{exception});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createOpaqueTokenFromTokenHolderList");
            }
            return null;
        }
    }

    public ArrayList createTokenHolderListFromOpaqueToken(byte[] byArray) throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTokenHolderListFromOpaqueToken");
        }
        if (byArray == null || byArray.length == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning null token holder ArrayList.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTokenHolderListFromOpaqueToken");
            }
            return null;
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            boolean bl = this.checkOpaqueTokenHeader(dataInputStream);
            if (bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Successfully read the opaque token header, beginning to process token.");
                }
                ArrayList<TokenHolder> arrayList = new ArrayList<TokenHolder>();
                boolean bl2 = this.checkCredHashHeader(dataInputStream);
                if (bl2) {
                    byte[] byArray2 = null;
                    boolean bl3 = false;
                    byArray2 = this.readCredHashTableBytes(dataInputStream);
                    if (byArray2 != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Successfully retrieved wsCredHash bytes.");
                        }
                        arrayList.add(new TokenHolder(byArray2, wsCredHashHeader, 1));
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "wsCredHash bytes could not be read from InputStream.");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The wsCred hashtable not present in opaque byte array.");
                }
                boolean bl4 = this.checkTokensHeader(dataInputStream);
                if (bl4) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Reading standard tokens from opaque token.");
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "There are no tokens present in opaque byte array.");
                    }
                    throw new WSSecurityException("There are no tokens present in opaque byte array.");
                }
                this.readTokens(dataInputStream, arrayList);
                bl4 = this.checkCustomTokensHeader(dataInputStream);
                if (bl4) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Reading custom tokens from opaque token.");
                    }
                    this.readTokens(dataInputStream, arrayList);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "There are no custom tokens present in opaque byte array.");
                }
                return arrayList;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Not a WAS opaque authorization token, returning null.");
            }
            return null;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.token.WSOpaqueTokenHelper.createOpaqueTokenFromTokenHolderList", "784", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred creating opaque token.", new Object[]{exception});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTokenHolderListFromOpaqueToken");
            }
            return null;
        }
    }

    private void readTokens(DataInputStream dataInputStream, ArrayList arrayList) throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readTokens");
        }
        try {
            int n = dataInputStream.readByte();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Number of tokens to be handled: " + n);
            }
            for (int i = 0; i < n; ++i) {
                String string = null;
                byte[] byArray = null;
                int n2 = 0;
                byte by = 0;
                byte[] byArray2 = null;
                int n3 = 0;
                n2 = dataInputStream.readInt();
                byArray = new byte[n2];
                dataInputStream.read(byArray, 0, n2);
                string = StringBytesConversion.getConvertedString((byte[])byArray);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found token name: " + string);
                }
                by = dataInputStream.readByte();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Token version: " + by);
                }
                n3 = dataInputStream.readInt();
                byArray2 = new byte[n3];
                dataInputStream.read(byArray2, 0, n3);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Token bytes length: " + n3);
                }
                if (byArray2 == null || string == null) {
                    throw new WSSecurityException("malformed token, cannot retrieve token bytes.");
                }
                arrayList.add(new TokenHolder(byArray2, string, by));
            }
        }
        catch (WSSecurityException wSSecurityException) {
            FFDCFilter.processException((Throwable)wSSecurityException, "com.ibm.ws.security.token.WSOpaqueTokenHelper.readTokens", "842", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "readTokens exception", new Object[]{wSSecurityException});
            }
            throw wSSecurityException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.token.WSOpaqueTokenHelper.readTokens", "848", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "readTokens exception", new Object[]{exception});
            }
            throw new WSSecurityException(exception.getMessage(), exception);
        }
    }

    private byte[] readCredHashTableBytes(DataInputStream dataInputStream) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readCredHashTableBytes");
        }
        try {
            dataInputStream.mark(dataInputStream.available());
            int n = 0;
            byte[] byArray = null;
            n = dataInputStream.readInt();
            if (n > 0) {
                byArray = new byte[n];
                dataInputStream.read(byArray, 0, n);
                return byArray;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "readCredHashTableBytes, invalid size = " + n);
            }
            return null;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.token.WSOpaqueTokenHelper.readCredHashTableBytes", "889", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "readCredHashTableBytes exception", new Object[]{exception});
            }
            return null;
        }
    }

    private boolean checkOpaqueTokenHeader(DataInputStream dataInputStream) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkOpaqueTokenHeader");
        }
        try {
            byte[] byArray = null;
            String string = null;
            byArray = new byte[this.tokenHeaderSize];
            dataInputStream.read(byArray, 0, this.tokenHeaderSize);
            if (byArray != null) {
                string = StringBytesConversion.getConvertedString((byte[])byArray);
                if (string.equals(tokenHeader)) {
                    byte by = dataInputStream.readByte();
                    if (by == 1) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "checkOpaqueTokenHeader, true");
                        }
                        return true;
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkOpaqueTokenHeader, version mismatch, version = " + by);
                    }
                    return false;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkOpaqueTokenHeader, invalid header, false");
                }
                return false;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkOpaqueTokenHeader, no header, false");
            }
            return false;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.token.WSOpaqueTokenHelper.checkOpaqueTokenHeader", "944", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkOpaqueTokenHeader exception", new Object[]{exception});
            }
            return false;
        }
    }

    private boolean checkCredHashHeader(DataInputStream dataInputStream) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkCredHashHeader");
        }
        try {
            dataInputStream.mark(dataInputStream.available());
            byte[] byArray = null;
            String string = null;
            byArray = new byte[this.wsCredHashHeaderSize];
            dataInputStream.read(byArray, 0, this.wsCredHashHeaderSize);
            if (byArray != null) {
                string = StringBytesConversion.getConvertedString((byte[])byArray);
                if (string.equals(wsCredHashHeader)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkCredHashHeader, true");
                    }
                    return true;
                }
                dataInputStream.reset();
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkCredHashHeader, false");
                }
                return false;
            }
            dataInputStream.reset();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkCredHashHeader, no header, false");
            }
            return false;
        }
        catch (Exception exception) {
            try {
                dataInputStream.reset();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.token.WSOpaqueTokenHelper.checkCredHashHeader", "998", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkCredHashHeader exception", new Object[]{exception});
            }
            return false;
        }
    }

    private boolean checkTokensHeader(DataInputStream dataInputStream) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkTokensHeader");
        }
        try {
            dataInputStream.mark(dataInputStream.available());
            byte[] byArray = null;
            String string = null;
            byArray = new byte[this.wsTokensHeaderSize];
            dataInputStream.read(byArray, 0, this.wsTokensHeaderSize);
            if (byArray != null) {
                string = StringBytesConversion.getConvertedString((byte[])byArray);
                if (string.equals(wsTokensHeader)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkTokensHeader, true");
                    }
                    return true;
                }
                dataInputStream.reset();
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkTokensHeader, false");
                }
                return false;
            }
            dataInputStream.reset();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkTokensHeader, no header, false");
            }
            return false;
        }
        catch (Exception exception) {
            try {
                dataInputStream.reset();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.token.WSOpaqueTokenHelper.checkTokensHeader", "1052", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkTokensHeader exception", new Object[]{exception});
            }
            return false;
        }
    }

    private boolean checkCustomTokensHeader(DataInputStream dataInputStream) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkCustomTokensHeader");
        }
        try {
            dataInputStream.mark(dataInputStream.available());
            byte[] byArray = null;
            String string = null;
            byArray = new byte[this.customTokensHeaderSize];
            dataInputStream.read(byArray, 0, this.customTokensHeaderSize);
            if (byArray != null) {
                string = StringBytesConversion.getConvertedString((byte[])byArray);
                if (string.equals(customTokensHeader)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkCustomTokensHeader, true");
                    }
                    return true;
                }
                dataInputStream.reset();
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkCustomTokensHeader, false");
                }
                return false;
            }
            dataInputStream.reset();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkCustomTokensHeader, no header, false");
            }
            return false;
        }
        catch (Exception exception) {
            try {
                dataInputStream.reset();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.token.WSOpaqueTokenHelper.checkCustomTokensHeader", "1106", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkCustomTokensHeader exception", new Object[]{exception});
            }
            return false;
        }
    }

    private byte[] serialize_internal(Object object, Class clazz) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        byte[] byArray = null;
        try {
            objectOutputStream.writeObject(object);
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception serializing object. ", new Object[]{exception});
            }
            throw exception;
        }
        finally {
            try {
                objectOutputStream.close();
                byteArrayOutputStream.close();
            }
            catch (Exception exception) {}
        }
        return byArray;
    }

    private Object deserialize_internal(byte[] byArray, Class clazz) throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        WsObjectInputStream wsObjectInputStream = new WsObjectInputStream(byteArrayInputStream);
        Object object = null;
        try {
            object = wsObjectInputStream.readObject();
        }
        catch (Exception exception) {
            Tr.warning(tc, "security.sap.warning.deserializing.custom.objects.from.subject");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception deserializing object. ", new Object[]{exception});
            }
            throw exception;
        }
        finally {
            try {
                wsObjectInputStream.close();
                byteArrayInputStream.close();
            }
            catch (Exception exception) {}
        }
        return object;
    }

    public static byte[] serialize(Object object) throws Exception {
        return WSSOpaqueTokenHelper.serialize(object, ObjectOutputStream.class);
    }

    private static byte[] serialize(Object object, Class clazz) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        byte[] byArray = null;
        try {
            objectOutputStream.writeObject(object);
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception serializing object. ", new Object[]{exception});
            }
            throw exception;
        }
        finally {
            try {
                objectOutputStream.close();
                byteArrayOutputStream.close();
            }
            catch (Exception exception) {}
        }
        return byArray;
    }

    public static Object deserialize(byte[] byArray) throws Exception {
        return WSSOpaqueTokenHelper.deserialize(byArray, WsObjectInputStream.class);
    }

    private static Object deserialize(byte[] byArray, Class clazz) throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        WsObjectInputStream wsObjectInputStream = new WsObjectInputStream(byteArrayInputStream);
        Object object = null;
        try {
            object = wsObjectInputStream.readObject();
        }
        catch (Exception exception) {
            Tr.warning(tc, "security.sap.warning.deserializing.custom.objects.from.subject");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception deserializing object. ", new Object[]{exception});
            }
            throw exception;
        }
        finally {
            try {
                wsObjectInputStream.close();
                byteArrayInputStream.close();
            }
            catch (Exception exception) {}
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList getForwardableTokensFromSubject(Subject subject) throws WSLoginFailedException {
        if (subject == null) {
            Tr.debug(tc, "Null Subject passed in.");
            return null;
        }
        try {
            Subject subject2 = subject;
            synchronized (subject2) {
                ArrayList<TokenHolder> arrayList = new ArrayList<TokenHolder>();
                Set<Object> set = subject.getPrivateCredentials();
                Set<Object> set2 = subject.getPublicCredentials();
                for (Object iterator : set) {
                    if (!(iterator instanceof AuthenticationToken)) continue;
                    AuthenticationToken authenticationToken = (AuthenticationToken)iterator;
                    if (authenticationToken.isForwardable()) {
                        if (!authenticationToken.isValid()) {
                            Tr.debug(tc, "Token with name " + authenticationToken.getName() + " is expired.");
                            throw new WSLoginFailedException("Token with name " + authenticationToken.getName() + " is expired.");
                        }
                        arrayList.add(new TokenHolder(authenticationToken.getBytes(), authenticationToken.getName(), authenticationToken.getVersion()));
                        continue;
                    }
                    Tr.debug(tc, "Token with name " + authenticationToken.getName() + " is not forwardable.");
                }
                for (Object object : set2) {
                    Token token;
                    if (!(object instanceof Token) || !(token = (Token)object).isForwardable() || !token.isValid()) continue;
                    arrayList.add(new TokenHolder(token.getBytes(), token.getName(), token.getVersion()));
                }
                if (arrayList != null && arrayList.size() > 0) {
                    return arrayList;
                }
                return null;
            }
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            FFDCFilter.processException((Throwable)wSLoginFailedException, "com.ibm.ws.security.token.WSOpaqueTokenHelper.getForwardableAuthzTokensFromSubject", "1345", this);
            Tr.debug(tc, "WSLoginFailedException getting forwardable tokens from Subject.", new Object[]{wSLoginFailedException});
            throw wSLoginFailedException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.token.WSOpaqueTokenHelper.getForwardableAuthzTokensFromSubject", "1351", this);
            Tr.debug(tc, "Exception getting forwardable tokens from Subject.", new Object[]{exception});
            throw new WSLoginFailedException(exception.getMessage(), exception);
        }
    }
}

