/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.trust.server.sts.ext.cache;

import com.ibm.websphere.cache.ChangeEvent;
import com.ibm.websphere.cache.ChangeListener;
import com.ibm.websphere.cache.DistributedMap;
import com.ibm.websphere.cache.InvalidationEvent;
import com.ibm.websphere.cache.InvalidationListener;
import com.ibm.ws.wssecurity.platform.trust.server.sts.ext.CacheableToken;
import com.ibm.ws.wssecurity.platform.trust.server.sts.ext.cache.STSTokenCache;
import com.ibm.ws.wssecurity.platform.websphere.auth.WSSDistributedCache;
import com.ibm.ws.wssecurity.trust.server.sts.ext.ExternalizableToken;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCT;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import java.util.Properties;

public class STSTokenCacheImpl
implements STSTokenCache {
    public static final String IS_DISTRIBUTED = "distributedCache";
    public static final String CACHE_SIZE = "com.ibm.ws.cache.CacheConfig.cacheSize";
    public static final String DISABLE_DEPENDENCY_ID = "com.ibm.ws.cache.CacheConfig.disableDependencyId";
    public static final String DISABLE_TEMPLATES_SUPPORT = "com.ibm.ws.cache.CacheConfig.disableTemplatesSupport";
    public static final String ENABLE_DISK_OFFLOAD = "com.ibm.ws.cache.CacheConfig.enableDiskOffload";
    public static final String ENABLE_NIO_SUPPORT = "com.ibm.ws.cache.CacheConfig.enableNioSupport";
    public static final String DISK_OFFLOAD_LOCATION = "com.ibm.ws.cache.CacheConfig.diskOffloadLocation";
    public static final String USE_LISTENER_CONTEXT = "com.ibm.ws.cache.CacheConfig.useListenerContext";
    public static final String FLUSH_TO_DISK_ON_STOP = "com.ibm.ws.cache.CacheConfig.flushToDiskOnStop";
    public static final String ENABLE_CACHE_REPLICATION = "com.ibm.ws.cache.CacheConfig.enableCacheReplication";
    public static final String REPLICATION_DOMAIN = "com.ibm.ws.cache.CacheConfig.replicationDomain";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    private Class elementType = ExternalizableToken.class;
    private Hashtable localMap = WSSDistributedCache.getSCTLocalCacheForService();
    private DistributedMap distributedMap = WSSDistributedCache.getSCTDistributedCacheForService();
    private boolean distributedEnabled = false;
    private static final String CLASS_NAME = STSTokenCacheImpl.class.getName();
    private static final TraceComponent tc = Tr.register(STSTokenCacheImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public STSTokenCacheImpl() {
    }

    public STSTokenCacheImpl(String string, Class clazz, Properties properties) {
        this();
        String string2 = "STSTokenCacheImpl(config=" + properties.toString() + ")";
        STSTokenCacheImpl.trEntry(string2);
        this.elementType = clazz;
        String string3 = properties.getProperty(IS_DISTRIBUTED, FALSE).toLowerCase();
        this.distributedEnabled = string3.equals(TRUE);
        this.localMap = WSSDistributedCache.getSCTLocalCacheForService();
        this.distributedMap = WSSDistributedCache.getSCTDistributedCacheForService();
        if (this.distributedMap != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Distributed Map For Service created!");
            }
            this.distributedMap.enableListener(true);
            boolean bl = this.distributedMap.addInvalidationListener(new InvalidationListener(){

                public void fireEvent(InvalidationEvent invalidationEvent) {
                    if (invalidationEvent.getCauseOfInvalidation() == 3 || invalidationEvent.getCauseOfInvalidation() == 1 || invalidationEvent.getCauseOfInvalidation() == 5) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Fire event");
                            Tr.debug(tc, "The identifier = " + (String)invalidationEvent.getId());
                        }
                        STSTokenCacheImpl.this.localMap.remove((String)invalidationEvent.getId());
                    }
                }
            });
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid Listener  enabled = " + bl);
            }
            if (this.distributedEnabled) {
                this.distributedMap.addChangeListener(new ChangeListener(){

                    public void cacheEntryChanged(ChangeEvent changeEvent) {
                        if (changeEvent.getCauseOfChange() == 1 || changeEvent.getCauseOfChange() == 2) {
                            STSTokenCacheImpl.this.mergeSCT((String)changeEvent.getId());
                        }
                    }
                });
            }
        }
        if (tc.isDebugEnabled() && this.distributedEnabled) {
            Tr.debug(tc, "distributedEnabled = true");
        }
        STSTokenCacheImpl.trExit(string2);
    }

    public CacheableToken getToken(String string) {
        String string2 = "getToken(identifier=" + string + ")";
        STSTokenCacheImpl.trEntry(string2);
        CacheableToken cacheableToken = (CacheableToken)this.localMap.get(string);
        if (cacheableToken == null && this.distributedEnabled) {
            STSTokenCacheImpl.trDebug("Token not found in local cache.");
            byte[] byArray = (byte[])this.distributedMap.get((Object)string);
            if (byArray != null) {
                STSTokenCacheImpl.trDebug("Token found in distributed cache. Deserializing...");
                cacheableToken = this.deserializeBytes(byArray);
                if (cacheableToken != null) {
                    STSTokenCacheImpl.trDebug("Deserialization succeeded. Updating the local cache.");
                    this.localMap.put(string, cacheableToken);
                }
            }
        }
        STSTokenCacheImpl.trExit(string2);
        return cacheableToken;
    }

    public boolean cacheToken(String string, CacheableToken cacheableToken, long l) {
        String string2 = "cacheToken(identifier=" + string + "," + CacheableToken.class.getName() + "," + "cacheTimeout=" + l + ")";
        STSTokenCacheImpl.trEntry(string2);
        if (string == null || cacheableToken == null || this.distributedMap != null && !(cacheableToken instanceof ExternalizableToken)) {
            STSTokenCacheImpl.trDebug(string2 + ": Identifier or token argument is null or the distributed cache is enabled " + "and the token argument is not an instance of UnserializedToken.");
            return false;
        }
        this.putToken(string, cacheableToken, l);
        STSTokenCacheImpl.trExit(string2);
        return true;
    }

    public boolean containsToken(String string) {
        String string2 = "containsToken(identifier=" + string + ")";
        STSTokenCacheImpl.trEntry(string2);
        boolean bl = this.localMap.containsKey(string);
        if (!bl && this.distributedMap != null) {
            STSTokenCacheImpl.trDebug("Token not found in local cache.");
            bl = this.distributedMap.containsKey((Object)string);
            if (!bl) {
                STSTokenCacheImpl.trDebug("Token not found in distributed cache.");
            }
        }
        STSTokenCacheImpl.trExit(string2);
        return bl;
    }

    public CacheableToken removeToken(String string) {
        String string2 = "removeToken(identifier=" + string + ")";
        STSTokenCacheImpl.trEntry(string2);
        CacheableToken cacheableToken = (CacheableToken)this.localMap.remove(string);
        if (this.distributedEnabled) {
            byte[] byArray = (byte[])this.distributedMap.remove((Object)string);
            if (cacheableToken == null && byArray != null) {
                cacheableToken = this.deserializeBytes(byArray);
            }
        } else {
            this.distributedMap.remove((Object)string);
        }
        STSTokenCacheImpl.trExit(string2);
        return cacheableToken;
    }

    public boolean updateToken(String string, CacheableToken cacheableToken, long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateToken (identifier = " + string + ":" + "CacheableToken, cahcheTimeout = " + l);
        }
        boolean bl = false;
        if (string != null && !(bl = this.cacheToken(string, cacheableToken, l))) {
            this.removeToken(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateToken (identifier = " + string + ":" + "CacheableToken, cahcheTimeout = " + l);
        }
        return bl;
    }

    private void putToken(String string, CacheableToken cacheableToken, long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "putToken (identifier = " + string + ":" + "token, cahcheTimeout = " + l);
        }
        Long l2 = new Long(l / 1000L);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Time to live in cache needs to be specified in seconds = " + l2);
        }
        this.localMap.put(string, cacheableToken);
        if (this.distributedEnabled) {
            byte[] byArray = this.getSerializationBytes((ExternalizableToken)cacheableToken);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Save SCT in distributedMap.");
            }
            this.distributedMap.put((Object)string, (Object)byArray, 1, l2.intValue(), 2, null);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Saving SCT identifier in distributed Map, so localmap can be altered. Using distributed map as monitor ONLY");
            }
            this.distributedMap.put((Object)string, (Object)"NonDistributed", 1, l2.intValue(), 1, null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "putToken (identifier = " + string + ":" + "token, cahcheTimeout = " + l);
        }
    }

    private void removeLocalTokenAndExpiration(String string) {
        this.localMap.remove(string);
    }

    private byte[] getSerializationBytes(ExternalizableToken externalizableToken) {
        byte[] byArray;
        block2: {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byArray = null;
            try {
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                externalizableToken.writeExternal(objectOutputStream);
                objectOutputStream.close();
                byteArrayOutputStream.close();
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "Fail to serialize Token. ", exception.getStackTrace());
            }
        }
        return byArray;
    }

    private ExternalizableToken deserializeBytes(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ExternalizableToken externalizableToken = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            externalizableToken = (ExternalizableToken)this.elementType.newInstance();
            externalizableToken.readExternal(objectInputStream);
            objectInputStream.close();
            byteArrayInputStream.close();
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Fail to deserialize Token. ", exception.getStackTrace());
            }
            return null;
        }
        return externalizableToken;
    }

    private void mergeSCT(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mergeSCT(String Key):" + string);
        }
        byte[] byArray = (byte[])this.distributedMap.get((Object)string);
        SCT sCT = new SCT();
        if (byArray != null) {
            Object object;
            try {
                object = new ObjectInputStream(new ByteArrayInputStream(byArray));
                sCT.readExternal((ObjectInput)object);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error when deserializing SCT. ", exception.getStackTrace());
                }
                sCT = null;
            }
            if (tc.isDebugEnabled() && sCT != null) {
                Tr.debug(tc, "instances list (before merge) :" + sCT.getInstances());
            }
            object = new SCT();
            object = (SCT)this.localMap.get(string);
            if (object != null && ((SCT)object).getInstances() != null && sCT != null) {
                String[] stringArray = ((SCT)object).getInstances();
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    if (sCT.getKeyHistoryEntry(stringArray[i]) != null) continue;
                    sCT.setKeyHistoryEntry(((SCT)object).getKeyHistoryEntry(stringArray[i]));
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "copy key insatnce:" + stringArray[i]);
                }
            }
            if (sCT != null) {
                this.localMap.put(string, sCT);
                if (tc.isDebugEnabled()) {
                    for (int i = 0; i < sCT.getInstances().length; ++i) {
                        Tr.debug(tc, "instances list (after merge) : " + sCT.getInstances()[i]);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mergeSCT(String key)");
        }
    }

    private static void trEntry(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
    }

    private static void trExit(String string) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    private static void trDebug(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string);
        }
    }
}

