/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.registry;

import com.ibm.ISecurityUtilityImpl.SecurityServer;
import com.ibm.WebSphereSecurityImpl.SecurityServerImpl;
import com.ibm.ws.security.auth.BasicAuthData;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.wssecurity.platform.registry.RegistryException;
import com.ibm.ws.wssecurity.platform.registry.Result;
import com.ibm.ws.wssecurity.platform.registry.UserRegistry;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Properties;

public class WasUserRegistry
implements UserRegistry {
    private static final TraceComponent tc = Tr.register(WasUserRegistry.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String clsName = WasUserRegistry.class.getName();
    static ContextManager ctxMgr = ContextManagerFactory.getInstance();

    public void initialize(Properties properties) throws RegistryException {
    }

    public String checkPassword(String string, String string2) throws RegistryException {
        Object object;
        if (tc.isDebugEnabled()) {
            object = string2 == null ? "null" : "not null";
            Tr.debug(tc, "Username [" + string + "], password [" + (String)object + "]");
        }
        try {
            object = SecServer.instance;
            if (object != null) {
                boolean bl;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Authenticating using SecurityServer.simple_authenticate()");
                }
                if (bl = object.simple_authenticate(new BasicAuthData(string, new String(string2)))) {
                    return string;
                }
                return null;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Authenticating using UserRegistry.checkPassword()");
            }
            return ctxMgr.getRegistry(ctxMgr.getDefaultRealm()).checkPassword(string, string2);
        }
        catch (Exception exception) {
            throw new RegistryException(exception.getMessage());
        }
    }

    public String mapCertificate(X509Certificate[] x509CertificateArray) throws RegistryException {
        try {
            return ctxMgr.getRegistry(ctxMgr.getDefaultRealm()).mapCertificate(x509CertificateArray);
        }
        catch (Exception exception) {
            throw new RegistryException(exception.getMessage());
        }
    }

    public String getRealm() {
        try {
            return ctxMgr.getRegistry(ctxMgr.getDefaultRealm()).getRealm();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Result getUsers(String string, int n) throws RegistryException {
        return null;
    }

    public String getUserDisplayName(String string) throws RegistryException {
        try {
            return ctxMgr.getRegistry(ctxMgr.getDefaultRealm()).getUserDisplayName(string);
        }
        catch (Exception exception) {
            throw new RegistryException(exception.getMessage());
        }
    }

    public String getUniqueUserId(String string) throws RegistryException {
        try {
            return ctxMgr.getRegistry(ctxMgr.getDefaultRealm()).getUniqueUserId(string);
        }
        catch (Exception exception) {
            throw new RegistryException(exception.getMessage());
        }
    }

    public String getUserSecurityName(String string) throws RegistryException {
        try {
            return ctxMgr.getRegistry(ctxMgr.getDefaultRealm()).getUserSecurityName(string);
        }
        catch (Exception exception) {
            throw new RegistryException(exception.getMessage());
        }
    }

    public boolean isValidUser(String string) throws RegistryException {
        try {
            return ctxMgr.getRegistry(ctxMgr.getDefaultRealm()).isValidUser(string);
        }
        catch (Exception exception) {
            throw new RegistryException(exception.getMessage());
        }
    }

    public Result getGroups(String string, int n) throws RegistryException {
        return null;
    }

    public String getGroupDisplayName(String string) throws RegistryException {
        try {
            return ctxMgr.getRegistry(ctxMgr.getDefaultRealm()).getGroupDisplayName(string);
        }
        catch (Exception exception) {
            throw new RegistryException(exception.getMessage());
        }
    }

    public String getUniqueGroupId(String string) throws RegistryException {
        try {
            return ctxMgr.getRegistry(ctxMgr.getDefaultRealm()).getUniqueGroupId(string);
        }
        catch (Exception exception) {
            throw new RegistryException(exception.getMessage());
        }
    }

    public List getUniqueGroupIds(String string) throws RegistryException {
        try {
            return ctxMgr.getRegistry(ctxMgr.getDefaultRealm()).getUniqueGroupIds(string);
        }
        catch (Exception exception) {
            throw new RegistryException(exception.getMessage());
        }
    }

    public String getGroupSecurityName(String string) throws RegistryException {
        try {
            return ctxMgr.getRegistry(ctxMgr.getDefaultRealm()).getGroupSecurityName(string);
        }
        catch (Exception exception) {
            throw new RegistryException(exception.getMessage());
        }
    }

    public boolean isValidGroup(String string) throws RegistryException {
        try {
            return ctxMgr.getRegistry(ctxMgr.getDefaultRealm()).isValidGroup(string);
        }
        catch (Exception exception) {
            throw new RegistryException(exception.getMessage());
        }
    }

    public List getGroupsForUser(String string) throws RegistryException {
        try {
            return ctxMgr.getRegistry(ctxMgr.getDefaultRealm()).getGroupsForUser(string);
        }
        catch (Exception exception) {
            throw new RegistryException(exception.getMessage());
        }
    }

    public Result getUsersForGroup(String string, int n) throws RegistryException {
        return null;
    }

    private static class SecServer {
        private static SecurityServer instance;

        private SecServer() {
        }

        private static void init() {
            try {
                instance = new SecurityServerImpl();
            }
            catch (Exception exception) {
                Tr.processException(exception, clsName + ".SecServer.init", "53");
                throw new ExceptionInInitializerError(exception);
            }
        }

        static {
            SecServer.init();
        }
    }
}

