/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.auth;

import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.websphere.wssecurity.wssapi.token.LTPAPropagationToken;
import com.ibm.websphere.wssecurity.wssapi.token.LTPAToken;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.websphere.wssecurity.wssapi.token.UsernameToken;
import com.ibm.websphere.wssecurity.wssapi.token.X509Token;
import com.ibm.ws.security.auth.CacheException;
import com.ibm.ws.security.auth.SecurityCache;
import com.ibm.ws.security.token.WSCredentialTokenMapperInterface;
import com.ibm.ws.wssecurity.platform.auth.SubjectCache;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManagerFactory;
import com.ibm.ws.wssecurity.token.WSSUserRegistryProcessor;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;

public class WasSubjectCacheImpl
implements SubjectCache {
    private static final TraceComponent tc = Tr.register(WasSubjectCacheImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String clsName = WasSubjectCacheImpl.class.getName();
    private static SecurityCache cache = null;
    private static WSCredentialTokenMapperInterface wsCredTokenMapper = null;
    private static String defaultRealm = WSSContextManagerFactory.getInstance().getDefaultRealm();

    public String createUniqueCachekey(Subject subject) {
        String string;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createUniqueIDForAuthCache");
            }
            string = null;
            try {
                string = WasSubjectCacheImpl.getWSCredentialTokenMapperInterface().createSubjectUniqueID(subject);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Caught exception while getting unique ID from subject.", new Object[]{exception});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createUniqueIDForAuthCache: " + string);
        }
        return string;
    }

    public Subject getSubjectFromAuthCacheByUniqueID(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSubjectFromAuthCacheByUniqueID with " + string);
        }
        Subject subject = null;
        if (WasSubjectCacheImpl.getSecurityCache() != null && string != null && string.length() > 0) {
            try {
                subject = WasSubjectCacheImpl.getSecurityCache().getSubject(string);
            }
            catch (CacheException cacheException) {
                Tr.processException(cacheException, clsName + ".getSubjectFromAuthCacheByUniqueID", "53");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Caught exception while looking up subject from AuthCache.", new Object[]{cacheException});
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Not looking Subject in cache because SecurityCache instance is null.");
        }
        subject = this.validateSubject(subject);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSubjectFromAuthCacheByUniqueID with " + string);
        }
        return subject;
    }

    public Subject getSubjectFromAuthCacheByToken(SecurityToken securityToken) {
        Subject subject;
        block17: {
            subject = null;
            if (WasSubjectCacheImpl.getSecurityCache() != null && securityToken != null) {
                try {
                    if (securityToken instanceof UsernameToken) {
                        UsernameToken usernameToken = (UsernameToken)securityToken;
                        String string = usernameToken.getUsername();
                        if (string != null && string.length() > 0) {
                            char[] cArray = null;
                            final UsernameToken usernameToken2 = usernameToken;
                            cArray = (char[])AccessController.doPrivileged(new PrivilegedAction<Object>(){

                                @Override
                                public Object run() {
                                    return usernameToken2.getPassword();
                                }
                            });
                            String string2 = null;
                            if (cArray != null) {
                                string2 = new String(cArray);
                            }
                            subject = string2 == null || string2.length() == 0 ? WasSubjectCacheImpl.getSecurityCache().getSubject(defaultRealm, string) : WasSubjectCacheImpl.getSecurityCache().getSubject(defaultRealm, string, string2);
                        }
                    } else if (securityToken instanceof LTPAPropagationToken) {
                        subject = null;
                    } else if (securityToken instanceof LTPAToken) {
                        final LTPAToken lTPAToken = (LTPAToken)securityToken;
                        byte[] byArray = (byte[])AccessController.doPrivileged(new PrivilegedAction<Object>(){

                            @Override
                            public Object run() {
                                return lTPAToken.getBinary();
                            }
                        });
                        if (byArray != null) {
                            subject = WasSubjectCacheImpl.getSecurityCache().getSubject(byArray);
                        }
                    } else if (securityToken instanceof X509Token) {
                        X509Token x509Token = (X509Token)securityToken;
                        String string = WSSUserRegistryProcessor.mapCertificate(x509Token.getCertificate());
                        if (string == null || string.length() == 0) {
                            string = x509Token.getPrincipal();
                        }
                        subject = WasSubjectCacheImpl.getSecurityCache().getSubject(defaultRealm, string);
                    } else {
                        String string = securityToken.getPrincipal();
                        if (string != null) {
                            subject = WasSubjectCacheImpl.getSecurityCache().getSubject(defaultRealm, string);
                        }
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block17;
                    Tr.debug(tc, "Caught exception looking up Subject from AuthgetSecurityCache(): " + exception);
                }
            }
        }
        subject = this.validateSubject(subject);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getCachedSubjectUsingToken: returning Subject = " + subject);
        }
        return subject;
    }

    public void addSubjectToAuthCache(Subject subject) {
        if (subject == null || WasSubjectCacheImpl.getSecurityCache() == null) {
            return;
        }
        String string = WasSubjectCacheImpl.getWSCredentialTokenMapperInterface().createSubjectUniqueID(subject);
        if (string == null || string.length() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unique ID is null. Adding Subject to AuthCache");
            }
            WasSubjectCacheImpl.getSecurityCache().insert(subject);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding Subject with ID " + string + " to AuthCache");
            }
            WasSubjectCacheImpl.getSecurityCache().insert(subject, new Object[]{string});
        }
    }

    public Subject validateSubject(Subject subject) {
        return this.validateSubject(subject, false);
    }

    public Subject validateSubject(Subject subject, boolean bl) {
        if (subject != null) {
            WSCredential wSCredential = subject.getPublicCredentials(WSCredential.class).iterator().next();
            if (wSCredential != null) {
                boolean bl2 = wSCredential.isDestroyed();
                boolean bl3 = false;
                try {
                    bl3 = wSCredential.isForwardable();
                }
                catch (Exception exception) {
                    bl2 = true;
                }
                long l = 0L;
                if (bl) {
                    l = WasSubjectCacheImpl.getSecurityCache().getCushion();
                }
                boolean bl4 = WasSubjectCacheImpl.getWSCredentialTokenMapperInterface().checkCushionValidityOfAllTokens(subject, l);
                if (tc.isDebugEnabled()) {
                    if (bl3) {
                        Tr.debug(tc, "credential is forwardable, subject valid = " + bl4);
                    } else {
                        Tr.debug(tc, "non-forwardable Subject");
                    }
                }
                if (bl2 || bl3 && !bl4) {
                    subject = null;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Credential has expired or is destroyed, logging in again.");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cached subject is valid.");
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No WSCredential in Subject, logging in again.");
                }
                subject = null;
            }
        }
        return subject;
    }

    private static SecurityCache getSecurityCache() {
        if (cache != null) {
            return cache;
        }
        cache = _authCacheClass._authCache;
        return cache;
    }

    private static WSCredentialTokenMapperInterface getWSCredentialTokenMapperInterface() {
        if (wsCredTokenMapper != null) {
            return wsCredTokenMapper;
        }
        wsCredTokenMapper = _wsCredToken._wsCredTokenMapper;
        return wsCredTokenMapper;
    }

    private static class _authCacheClass {
        static SecurityCache _authCache = null;
        private static final String FACTORY_CLASS = "com.ibm.ws.security.auth.AuthCache";

        private _authCacheClass() {
        }

        private static Method getAuthCacheGetInstanceMethod() {
            Method method = null;
            Class clazz = _authCacheClass.getAuthCacheClass();
            if (clazz != null) {
                try {
                    method = clazz.getMethod("getInstance", null);
                }
                catch (Exception exception) {
                    Tr.processException(exception, clsName + ".getAuthCacheGetInstanceMethod", "1021");
                    throw new UndeclaredThrowableException(exception);
                }
            }
            return method;
        }

        private static Class getAuthCacheClass() {
            Class<?> clazz = null;
            Class<?> clazz2 = null;
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                clazz2 = classLoader != null ? classLoader.loadClass(FACTORY_CLASS) : Class.forName(FACTORY_CLASS);
                clazz = clazz2;
            }
            catch (Exception exception) {
                Tr.processException(exception, clsName + ".getAuthCacheClass", "1048");
                throw new UndeclaredThrowableException(exception);
            }
            return clazz;
        }

        static {
            try {
                Method method = _authCacheClass.getAuthCacheGetInstanceMethod();
                if (method != null) {
                    _authCache = (SecurityCache)method.invoke(null, (Object[])null);
                    if (tc.isDebugEnabled()) {
                        if (_authCache == null) {
                            Tr.debug(tc, "AuthCache.getInstance method returned null.");
                        } else {
                            Tr.debug(tc, "AuthCache.getInstance method returned an AuthCache instance.");
                        }
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unable to get AuthCache.getInstance method.");
                }
            }
            catch (Exception exception) {
                Tr.processException(exception, clsName + "init", "1005");
            }
        }
    }

    private static class _wsCredToken {
        static WSCredentialTokenMapperInterface _wsCredTokenMapper = null;

        private _wsCredToken() {
        }

        static {
            try {
                Class<?> clazz = Class.forName("com.ibm.ws.security.token.WSCredentialTokenMapper");
                Object obj = clazz.newInstance();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Got instance of WSCredTokenMapper.");
                }
                _wsCredTokenMapper = (WSCredentialTokenMapperInterface)obj;
            }
            catch (Exception exception) {
                Tr.processException(exception, clsName + "init", "981");
            }
        }
    }
}

