/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.auth;

import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.websphere.wssecurity.wssapi.token.LTPAPropagationToken;
import com.ibm.websphere.wssecurity.wssapi.token.LTPAToken;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.websphere.wssecurity.wssapi.token.UsernameToken;
import com.ibm.websphere.wssecurity.wssapi.token.X509Token;
import com.ibm.ws.security.auth.CacheException;
import com.ibm.ws.security.auth.SecurityCache;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.token.WSCredentialTokenMapperInterface;
import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.platform.auth.PlatformLoginHelper;
import com.ibm.ws.wssecurity.token.WSSUserRegistryProcessor;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.wsspi.security.auth.callback.WSCallbackHandlerFactory;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.SecurityPermission;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WasLoginHelper
implements PlatformLoginHelper {
    private static final TraceComponent tc = Tr.register(WasLoginHelper.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WasLoginHelper.class.getName();
    public static final String AUTH_JAASCONFIG = "security.wssecurity.auth.login.jaasConfig";
    private static final SecurityPermission MAP_CREDENTIAL = new SecurityPermission("mapCredential");

    /*
     * Unable to fully structure code
     */
    @Override
    public void login(String var1_1, SecurityTokenWrapper var2_2, Map<Object, Object> var3_3) throws SoapSecurityException {
        block61: {
            block60: {
                block59: {
                    if (WasLoginHelper.tc.isEntryEnabled()) {
                        Tr.entry(WasLoginHelper.tc, "login(String jaasConfig[" + var1_1 + "]," + "SecurityTokenWrapper tokenWrapper[" + var2_2 + "]," + "Map context)");
                    }
                    var4_4 = var2_2.getSecurityToken();
                    var5_5 = (Subject)var3_3.get("com.ibm.wsspi.wssecurity.core.subject");
                    var6_6 = ContextManagerFactory.getInstance();
                    var7_7 = null;
                    if (var6_6 == null) {
                        Tr.error(WasLoginHelper.tc, "security.wssecurity.ctxmgr.isnull");
                    } else {
                        var7_7 = var6_6.getDefaultRealm();
                    }
                    var8_8 = null;
                    var9_9 = null;
                    try {
                        var8_8 = _wsCredToken._wsCredTokenMapper;
                        if (var8_8 != null && var5_5 != null) {
                            var9_9 = var8_8.createSubjectUniqueID(var5_5);
                        }
                    }
                    catch (Exception var10_10) {
                        Tr.processException((Throwable)var10_10, WasLoginHelper.clsName + ".login", "396", this);
                        if (!WasLoginHelper.tc.isDebugEnabled()) break block59;
                        Tr.debug(WasLoginHelper.tc, "Caught exception while getting unique ID from subject.", new Object[]{var10_10});
                    }
                }
                if (WasLoginHelper.tc.isDebugEnabled()) {
                    Tr.debug(WasLoginHelper.tc, "Unique ID from tokens in contextSubject: " + var9_9);
                }
                var10_11 = _authCacheClass._authCache;
                var11_12 = null;
                if (var10_11 == null) ** GOTO lbl41
                if (var9_9 == null || var9_9.length() == 0) {
                    if (WasLoginHelper.tc.isDebugEnabled()) {
                        Tr.debug(WasLoginHelper.tc, "Unique ID based on tokens is null. Look for Subject in AuthCache using token.");
                    }
                    var11_12 = this.getCachedSubjectUsingToken(var10_11, var4_4, var7_7);
                } else {
                    try {
                        var11_12 = var10_11.getSubject(var9_9);
                    }
                    catch (CacheException var12_13) {
                        Tr.processException((Throwable)var12_13, WasLoginHelper.clsName + ".login", "419", this);
                        if (WasLoginHelper.tc.isDebugEnabled()) {
                            Tr.debug(WasLoginHelper.tc, "Caught exception while looking up subject from AuthCache.", new Object[]{var12_13});
                        }
                        break block60;
                    }
lbl41:
                    // 1 sources

                    if (WasLoginHelper.tc.isDebugEnabled()) {
                        Tr.debug(WasLoginHelper.tc, "Not looking Subject in cache because SecurityCache instance is null.");
                    }
                }
            }
            if (var11_12 != null) {
                var12_14 = var11_12.getPublicCredentials(WSCredential.class).iterator().next();
                if (var12_14 != null) {
                    var13_15 = var12_14.isDestroyed();
                    var14_17 = false;
                    try {
                        var14_17 = var12_14.isForwardable();
                    }
                    catch (Exception var15_19) {
                        var13_15 = true;
                    }
                    var15_20 = var8_8.checkCushionValidityOfAllTokens(var11_12, var10_11.getCushion());
                    if (WasLoginHelper.tc.isDebugEnabled()) {
                        if (var14_17) {
                            Tr.debug(WasLoginHelper.tc, "credential is forwardable, subject valid = " + var15_20);
                        } else {
                            Tr.debug(WasLoginHelper.tc, "non-forwardable Subject");
                        }
                    }
                    if (var13_15 || var14_17 && !var15_20) {
                        var11_12 = null;
                        if (WasLoginHelper.tc.isDebugEnabled()) {
                            Tr.debug(WasLoginHelper.tc, "Credential has expired or is destroyed, logging in again.");
                        }
                    } else if (WasLoginHelper.tc.isDebugEnabled()) {
                        Tr.debug(WasLoginHelper.tc, "Cached subject is valid.");
                    }
                } else {
                    if (WasLoginHelper.tc.isDebugEnabled()) {
                        Tr.debug(WasLoginHelper.tc, "No WSCredential in Subject, logging in again.");
                    }
                    var11_12 = null;
                }
            }
            var12_14 = (SecurityTokenManagerImpl)var3_3.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
            if (var11_12 != null) break block61;
            if (WasLoginHelper.tc.isDebugEnabled()) {
                Tr.debug(WasLoginHelper.tc, "Subject not found in AuthCache.");
            }
            var13_16 = VaultImpl.getSecurityConfiguration();
            var14_18 = null;
            if (var13_16 != null) {
                var14_18 = var13_16.getAuthMechAuthAlias();
            }
            if (WasLoginHelper.tc.isDebugEnabled()) {
                Tr.debug(WasLoginHelper.tc, "authMech is " + var14_18);
            }
            try {
                block63: {
                    block64: {
                        block62: {
                            if (!(var4_4 instanceof UsernameToken)) break block62;
                            var15_21 = (UsernameToken)var4_4;
                            var16_28 = var15_21.getUsername();
                            if (var16_28 == null || var16_28.length() == 0) {
                                Tr.error(WasLoginHelper.tc, "security.wssecurity.WSEC6735E", new Object[]{var4_4.getValueType().toString(), "Login cancelled: username string is null or empty."});
                                throw SoapSecurityException.format("security.wssecurity.LoginProcessor.s11", "Login cancelled: username string is null or empty.");
                            }
                            var17_32 = var15_21;
                            var18_34 = (char[])AccessController.doPrivileged(new PrivilegedAction<Object>(){

                                @Override
                                public Object run() {
                                    return var17_32.getPassword();
                                }
                            });
                            var19_36 = null;
                            if (var18_34 != null) {
                                var19_36 = new String(var18_34);
                            }
                            var11_12 = var19_36 == null || var19_36.length() == 0 ? this.jaasLogin(var14_18, var16_28, var7_7) : this.jaasLogin(var14_18, var16_28, var7_7, var19_36);
                            var12_14.addToSubject(var11_12);
                            if (WasLoginHelper.tc.isDebugEnabled()) {
                                Tr.debug(WasLoginHelper.tc, "UsernameToken found.");
                                Tr.debug(WasLoginHelper.tc, "Username [" + var16_28 + "], Password [" + (var18_34 == null ? "null" : "not null") + "].");
                            }
                            break block63;
                        }
                        if (!(var4_4 instanceof X509Token)) break block64;
                        var15_22 = (X509Token)var4_4;
                        var16_29 = WSSUserRegistryProcessor.mapCertificate(var15_22.getCertificate());
                        if (var16_29 == null || var16_29.length() == 0) {
                            var16_29 = var15_22.getPrincipal();
                            if (WasLoginHelper.tc.isDebugEnabled()) {
                                Tr.debug(WasLoginHelper.tc, "User security from X509BSToken.getPrincipal() [" + var16_29 + "]");
                            }
                        } else if (WasLoginHelper.tc.isDebugEnabled()) {
                            Tr.debug(WasLoginHelper.tc, "User security from UserRegistryProcessor.mapCertificate() [" + var16_29 + "]");
                        }
                        var11_12 = this.jaasLogin(var14_18, var16_29, var7_7);
                        var12_14.addToSubject(var11_12);
                        if (WasLoginHelper.tc.isDebugEnabled()) {
                            Tr.debug(WasLoginHelper.tc, "X509BSToken found.");
                            Tr.debug(WasLoginHelper.tc, "Username [" + var15_22.getCertificate().getSubjectX500Principal().getName() + "].");
                        }
                        break block63;
                    }
                    if (!(var4_4 instanceof LTPAPropagationToken)) ** GOTO lbl133
                    var16_30 = var15_23 = (LTPAPropagationToken)var4_4;
                    var17_33 = (WSCredential)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            return var16_30.getWSCredential();
                        }
                    });
                    var18_35 = var15_23.getWSPrincipal();
                    if (var17_33 != null) {
                        this.addToSubject(var3_3, var17_33);
                        this.addToSubject(var3_3, var18_35);
                        this.addToSubject(var3_3, var4_4);
                        if (WasLoginHelper.tc.isDebugEnabled()) {
                            Tr.debug(WasLoginHelper.tc, "LTPATokenWrapper found.");
                            Tr.debug(WasLoginHelper.tc, "WSCredential [" + var17_33 + "].");
                            Tr.debug(WasLoginHelper.tc, "WSPrincipal [" + var18_35 + "].");
                        }
                    } else {
                        if (WasLoginHelper.tc.isDebugEnabled()) {
                            Tr.debug(WasLoginHelper.tc, "No WSCredential found in LTPATokenWrapper.");
                        }
                        throw SoapSecurityException.format("security.wssecurity.WSEC0168E");
lbl133:
                        // 1 sources

                        if (var4_4 instanceof LTPAToken) {
                            var15_24 = (LTPAToken)var4_4;
                            var16_31 = (byte[])AccessController.doPrivileged(new PrivilegedAction<Object>(){

                                @Override
                                public Object run() {
                                    return var15_24.getBinary();
                                }
                            });
                            if (var16_31 == null) {
                                if (WasLoginHelper.tc.isDebugEnabled()) {
                                    Tr.debug(WasLoginHelper.tc, "Null credential value found for the LTPA token to login.");
                                }
                                throw SoapSecurityException.format("security.wssecurity.LoginProcessor.s11", "Null credentials for the LTPA token.");
                            }
                            var11_12 = this.jaasLogin(var14_18, var16_31);
                            var12_14.addToSubject(var11_12);
                            if (WasLoginHelper.tc.isDebugEnabled()) {
                                Tr.debug(WasLoginHelper.tc, "LTPA Token found.");
                                Tr.debug(WasLoginHelper.tc, "Credential [" + var16_31 + "].");
                            }
                        } else {
                            var15_25 = var4_4.getPrincipal();
                            if (var15_25 == null) {
                                if (WasLoginHelper.tc.isDebugEnabled()) {
                                    Tr.debug(WasLoginHelper.tc, "Null principal value found for the custom token to login.");
                                }
                                throw SoapSecurityException.format("security.wssecurity.LoginProcessor.s11", "Null principal for the custom token.");
                            }
                            var11_12 = this.jaasLogin(var14_18, var15_25, var7_7);
                            var12_14.addToSubject(var11_12);
                            if (WasLoginHelper.tc.isDebugEnabled()) {
                                Tr.debug(WasLoginHelper.tc, "Token [" + var4_4.getValueType() + "] found.");
                                Tr.debug(WasLoginHelper.tc, "Principal [" + var15_25 + "].");
                            }
                        }
                    }
                }
                if (var8_8 == null || var11_12 == null || var10_11 == null) ** GOTO lbl181
                this.addTokensToLoginSubject(var3_3, var11_12);
                var9_9 = var8_8.createSubjectUniqueID(var11_12);
                if (var9_9 == null || var9_9.length() == 0) {
                    if (WasLoginHelper.tc.isDebugEnabled()) {
                        Tr.debug(WasLoginHelper.tc, "Unique ID is null. Adding Subject to AuthCache");
                    }
                    var10_11.insert(var11_12);
                }
                if (WasLoginHelper.tc.isDebugEnabled()) {
                    Tr.debug(WasLoginHelper.tc, "Adding Subject with ID " + var9_9 + " to AuthCache");
                }
                var10_11.insert(var11_12, new Object[]{var9_9});
            }
            catch (LoginException var15_26) {
                Tr.processException((Throwable)var15_26, WasLoginHelper.clsName + ".login", "616", this);
                Tr.error(WasLoginHelper.tc, "security.wssecurity.WSEC6735E", new Object[]{var4_4.getValueType().toString(), var15_26});
                throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, "security.wssecurity.LoginProcessor.s11", var15_26.toString(), (Throwable)var15_26);
            }
            catch (Exception var15_27) {
                Tr.processException((Throwable)var15_27, WasLoginHelper.clsName + ".login", "621", this);
                Tr.error(WasLoginHelper.tc, "security.wssecurity.WSEC6735E", new Object[]{var4_4.getValueType().toString(), var15_27});
                throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, "security.wssecurity.LoginProcessor.s11", var15_27.toString(), (Throwable)var15_27);
            }
        }
        if (WasLoginHelper.tc.isDebugEnabled()) {
            Tr.debug(WasLoginHelper.tc, "Subject found in AuthCache.");
        }
        var12_14.addToSubject(var11_12);
lbl181:
        // 4 sources

        if (WasLoginHelper.tc.isDebugEnabled()) {
            Tr.debug(WasLoginHelper.tc, "Subject after authentication: " + var11_12);
        }
        var2_2.setUsedToLogin(true);
        if (WasLoginHelper.tc.isEntryEnabled()) {
            Tr.exit(WasLoginHelper.tc, "login(String jaasConfig, Token token, Map context)");
        }
    }

    private void addToSubject(Map<Object, Object> map, final WSCredential wSCredential) {
        final Subject subject = (Subject)map.get("com.ibm.wsspi.wssecurity.core.subject");
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                if (!subject.getPublicCredentials().contains(wSCredential)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding WSCredential to Subject: " + wSCredential);
                    }
                    subject.getPublicCredentials().add(wSCredential);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WSCredential already in Subject: " + wSCredential);
                }
                return null;
            }
        });
        map.put("com.ibm.wsspi.wssecurity.core.subject", subject);
    }

    private void addToSubject(Map<Object, Object> map, final SecurityToken securityToken) {
        final Subject subject = (Subject)map.get("com.ibm.wsspi.wssecurity.core.subject");
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                if (!subject.getPrivateCredentials().contains(securityToken)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding Token to Subject: " + securityToken);
                    }
                    subject.getPrivateCredentials().add(securityToken);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Token already in Subject: " + securityToken);
                }
                return null;
            }
        });
        map.put("com.ibm.wsspi.wssecurity.core.subject", subject);
    }

    private void addToSubject(Map<Object, Object> map, final WSPrincipal wSPrincipal) {
        final Subject subject = (Subject)map.get("com.ibm.wsspi.wssecurity.core.subject");
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                if (!subject.getPrincipals().contains(wSPrincipal)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding WSPrincipal to Subject: " + wSPrincipal);
                    }
                    subject.getPrincipals().add((Principal)wSPrincipal);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WSPrincipal already in Subject: " + wSPrincipal);
                }
                return null;
            }
        });
        map.put("com.ibm.wsspi.wssecurity.core.subject", subject);
    }

    private void addTokensToLoginSubject(Map<Object, Object> map, final Subject subject) {
        final Subject subject2 = (Subject)map.get("com.ibm.wsspi.wssecurity.core.subject");
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                for (Object object : subject2.getPrivateCredentials()) {
                    if (object == null) continue;
                    if (!subject.getPrivateCredentials().contains(object)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding private object to Subject: " + object);
                        }
                        subject.getPrivateCredentials().add(object);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Private object already in Subject: " + object);
                }
                return null;
            }
        });
    }

    private Subject getCachedSubjectUsingToken(SecurityCache securityCache, SecurityToken securityToken, String string) {
        Subject subject;
        block17: {
            subject = null;
            if (securityCache != null && securityToken != null) {
                try {
                    if (securityToken instanceof UsernameToken) {
                        UsernameToken usernameToken = (UsernameToken)securityToken;
                        String string2 = usernameToken.getUsername();
                        if (string2 != null && string2.length() > 0) {
                            char[] cArray = null;
                            final UsernameToken usernameToken2 = usernameToken;
                            cArray = (char[])AccessController.doPrivileged(new PrivilegedAction<Object>(){

                                @Override
                                public Object run() {
                                    return usernameToken2.getPassword();
                                }
                            });
                            String string3 = null;
                            if (cArray != null) {
                                string3 = new String(cArray);
                            }
                            subject = string3 == null || string3.length() == 0 ? securityCache.getSubject(string, string2) : securityCache.getSubject(string, string2, string3);
                        }
                    } else if (securityToken instanceof LTPAPropagationToken) {
                        subject = null;
                    } else if (securityToken instanceof LTPAToken) {
                        final LTPAToken lTPAToken = (LTPAToken)securityToken;
                        byte[] byArray = (byte[])AccessController.doPrivileged(new PrivilegedAction<Object>(){

                            @Override
                            public Object run() {
                                return lTPAToken.getBinary();
                            }
                        });
                        if (byArray != null) {
                            subject = securityCache.getSubject(byArray);
                        }
                    } else if (securityToken instanceof X509Token) {
                        X509Token x509Token = (X509Token)securityToken;
                        String string4 = WSSUserRegistryProcessor.mapCertificate(x509Token.getCertificate());
                        if (string4 == null || string4.length() == 0) {
                            string4 = x509Token.getPrincipal();
                        }
                        subject = securityCache.getSubject(string, string4);
                    } else {
                        String string5 = securityToken.getPrincipal();
                        if (string5 != null) {
                            subject = securityCache.getSubject(string, string5);
                        }
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block17;
                    Tr.debug(tc, "Caught exception looking up Subject from AuthCache: " + exception);
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getCachedSubjectUsingToken: returning Subject = " + subject);
        }
        return subject;
    }

    private Subject jaasLogin(String string, String string2, String string3) throws LoginException, WSLoginFailedException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + MAP_CREDENTIAL.toString());
            }
            securityManager.checkPermission(MAP_CREDENTIAL);
        }
        if (string2 == null || string2.length() == 0) {
            throw new WSLoginFailedException("Username is null.");
        }
        LoginContext loginContext = new LoginContext(string, WSCallbackHandlerFactory.getInstance().getCallbackHandler(string2, string3, (String)null));
        loginContext.login();
        Subject subject = loginContext.getSubject();
        if (subject == null) {
            throw new WSLoginFailedException("Subject returned from login module is null.");
        }
        return subject;
    }

    private Subject jaasLogin(String string, String string2, String string3, String string4) throws LoginException, WSLoginFailedException {
        if (string2 == null || string2.length() == 0 || string4 == null || string4.length() == 0) {
            throw new WSLoginFailedException("Username and/or password is null.");
        }
        LoginContext loginContext = new LoginContext(string, WSCallbackHandlerFactory.getInstance().getCallbackHandler(string2, string3, string4));
        loginContext.login();
        Subject subject = loginContext.getSubject();
        if (subject == null) {
            throw new WSLoginFailedException("Subject returned from login module is null.");
        }
        return subject;
    }

    private Subject jaasLogin(String string, byte[] byArray) throws LoginException, WSLoginFailedException {
        LoginContext loginContext = new LoginContext(string, WSCallbackHandlerFactory.getInstance().getCallbackHandler(byArray));
        loginContext.login();
        Subject subject = loginContext.getSubject();
        if (subject == null) {
            throw new WSLoginFailedException("Subject returned from login module is null.");
        }
        return subject;
    }

    private static class _authCacheClass {
        static SecurityCache _authCache = null;
        private static final String FACTORY_CLASS = "com.ibm.ws.security.auth.AuthCache";

        private _authCacheClass() {
        }

        private static Method getAuthCacheGetInstanceMethod() {
            Method method = null;
            Class clazz = _authCacheClass.getAuthCacheClass();
            if (clazz != null) {
                try {
                    method = clazz.getMethod("getInstance", null);
                }
                catch (Exception exception) {
                    Tr.processException(exception, clsName + ".getAuthCacheGetInstanceMethod", "1021");
                    throw new UndeclaredThrowableException(exception);
                }
            }
            return method;
        }

        private static Class getAuthCacheClass() {
            Class<?> clazz = null;
            Class<?> clazz2 = null;
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                clazz2 = classLoader != null ? classLoader.loadClass(FACTORY_CLASS) : Class.forName(FACTORY_CLASS);
                clazz = clazz2;
            }
            catch (Exception exception) {
                Tr.processException(exception, clsName + ".getAuthCacheClass", "1048");
                throw new UndeclaredThrowableException(exception);
            }
            return clazz;
        }

        static {
            try {
                Method method = _authCacheClass.getAuthCacheGetInstanceMethod();
                if (method != null) {
                    _authCache = (SecurityCache)method.invoke(null, (Object[])null);
                    if (tc.isDebugEnabled()) {
                        if (_authCache == null) {
                            Tr.debug(tc, "AuthCache.getInstance method returned null.");
                        } else {
                            Tr.debug(tc, "AuthCache.getInstance method returned an AuthCache instance.");
                        }
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unable to get AuthCache.getInstance method.");
                }
            }
            catch (Exception exception) {
                Tr.processException(exception, clsName + "init", "1005");
            }
        }
    }

    private static class _wsCredToken {
        static WSCredentialTokenMapperInterface _wsCredTokenMapper = null;

        private _wsCredToken() {
        }

        static {
            try {
                Class<?> clazz = Class.forName("com.ibm.ws.security.token.WSCredentialTokenMapper");
                Object obj = clazz.newInstance();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Got instance of WSCredTokenMapper.");
                }
                _wsCredTokenMapper = (WSCredentialTokenMapperInterface)obj;
            }
            catch (Exception exception) {
                Tr.processException(exception, clsName + "init", "981");
            }
        }
    }
}

