/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.auth;

import com.ibm.websphere.cache.DistributedMap;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.cache.DistributedObjectCacheFactory;
import java.util.Hashtable;

public final class WSSDistributedCache {
    private static DistributedMap distributedMapForClient = null;
    private static DistributedMap distributedMapForServer = null;
    private static Hashtable nonDistributedMapForClient = new Hashtable();
    private static Hashtable nonDistributedMapForService = new Hashtable();
    private static final String _DMAPClient = "com.ibm.ws.wssecurity.sctClientCacheMap";
    private static final String _DMAPServer = "com.ibm.ws.wssecurity.sctServiceCacheMap";
    private static final TraceComponent tc = Tr.register(WSSDistributedCache.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public static DistributedMap initializeService() {
        block2: {
            distributedMapForServer = null;
            try {
                distributedMapForServer = DistributedObjectCacheFactory.getMap((String)_DMAPServer);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "Fail to initialize SCT cache now. SCT distributed cache will be re-initialized later.");
            }
        }
        return distributedMapForServer;
    }

    public static DistributedMap initializeClient() {
        block2: {
            distributedMapForClient = null;
            try {
                distributedMapForClient = DistributedObjectCacheFactory.getMap((String)_DMAPClient);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "Fail to initialize SCT cache now. SCT distributed cache will be re-initialized later.");
            }
        }
        return distributedMapForClient;
    }

    public static DistributedMap getSCTDistributedCacheForClient() {
        if (distributedMapForClient != null) {
            return distributedMapForClient;
        }
        return WSSDistributedCache.initializeClient();
    }

    public static DistributedMap getSCTDistributedCacheForService() {
        if (distributedMapForServer != null) {
            return distributedMapForServer;
        }
        return WSSDistributedCache.initializeService();
    }

    public static Hashtable getSCTLocalCacheForClient() {
        return nonDistributedMapForClient;
    }

    public static Hashtable getSCTLocalCacheForService() {
        return nonDistributedMapForService;
    }
}

