/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.auth;

import com.ibm.websphere.cache.ChangeEvent;
import com.ibm.websphere.cache.ChangeListener;
import com.ibm.websphere.cache.DistributedMap;
import com.ibm.websphere.cache.InvalidationEvent;
import com.ibm.websphere.cache.InvalidationListener;
import com.ibm.ws.wssecurity.platform.auth.SecureConversationCacheConfigFactory;
import com.ibm.ws.wssecurity.platform.auth.SecurityTokenCache;
import com.ibm.ws.wssecurity.platform.websphere.auth.WSSDistributedCache;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCT;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.Date;
import java.util.Hashtable;

public class SecureConversationCacheImpl
implements SecurityTokenCache {
    private Hashtable nonDistributedMap;
    private DistributedMap distributedMap;
    private boolean isDistributed = SecureConversationCacheConfigFactory.getInstance().isDistributedCache();
    private long extraTime = SecureConversationCacheConfigFactory.getInstance().getSCCacheGraceTimeMilliseconds();
    private static final String comp = "security.wssecurity";
    private static final TraceComponent tc = Tr.register(SecureConversationCacheImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public SecureConversationCacheImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SecureConversationCacheImpl");
        }
        this.nonDistributedMap = WSSDistributedCache.getSCTLocalCacheForClient();
        this.distributedMap = WSSDistributedCache.getSCTDistributedCacheForClient();
        this.distributedMap.enableListener(true);
        this.distributedMap.addInvalidationListener(new InvalidationListener(){

            public void fireEvent(InvalidationEvent invalidationEvent) {
                if (invalidationEvent.getCauseOfInvalidation() == 3 || invalidationEvent.getCauseOfInvalidation() == 1 || invalidationEvent.getCauseOfInvalidation() == 5) {
                    if (!SecureConversationCacheImpl.this.distributedMap.containsKey((Object)((String)invalidationEvent.getId()))) {
                        SecureConversationCacheImpl.this.nonDistributedMap.remove((String)invalidationEvent.getId());
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Entry expired:" + (String)invalidationEvent.getId());
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Do not remove new cache entry: " + (String)invalidationEvent.getId());
                    }
                }
            }
        });
        if (this.isDistributed) {
            this.distributedMap.addChangeListener(new ChangeListener(){

                public void cacheEntryChanged(ChangeEvent changeEvent) {
                    if (changeEvent.getCauseOfChange() == 1 || changeEvent.getCauseOfChange() == 2) {
                        SecureConversationCacheImpl.this.mergeSCT((String)changeEvent.getId());
                    }
                }
            });
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SecureConversationCacheImpl");
        }
    }

    public Object get(String string) {
        byte[] byArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get(String identifier)", string);
        }
        String string2 = string;
        SCT sCT = null;
        Object v = this.nonDistributedMap.get(string2);
        if (v != null || string.endsWith(":WSSECURITY_SCT_Config")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "get(String identifier)", string);
            }
            return v;
        }
        if (this.isDistributed && v == null && (byArray = (byte[])this.distributedMap.get((Object)string2)) != null) {
            sCT = new SCT();
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
                sCT.readExternal(objectInputStream);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error when deserializing SCT. ", exception.getStackTrace());
                }
                sCT = null;
            }
            if (sCT != null) {
                this.nonDistributedMap.put(string2, sCT);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get(String identifier)", string);
        }
        return sCT;
    }

    public void Invalidate(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Invalidate(String identifier)", string);
        }
        String string2 = string;
        this.nonDistributedMap.remove(string2);
        this.distributedMap.remove((Object)string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Invalidate(String identifier)", string);
        }
    }

    public void put(String string, Object object, Object object2) {
        this.put(string, object);
    }

    public void put(String string, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "put(String identifier, Object token)", string);
        }
        String string2 = string;
        SCT sCT = (SCT)object;
        int n = this.getSCTExpirationTime(sCT);
        this.nonDistributedMap.put(string2, object);
        if (this.isDistributed) {
            this.distributedMap.put((Object)string2, (Object)sCT.getSerializationBytes(), 1, n, 2, null);
        } else {
            this.distributedMap.put((Object)string2, (Object)"NonDistributed", 1, n, 1, null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "put(String identifier, Object token)", string);
        }
    }

    private int getSCTExpirationTime(SCT sCT) {
        String[] stringArray = sCT.getInstances();
        int n = 600;
        if (stringArray.length > 0) {
            Date date = sCT.getExpiration(stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                if (!sCT.getExpiration(stringArray[i]).after(date)) continue;
                date = sCT.getExpiration(stringArray[i]);
            }
            long l = System.currentTimeMillis() / 1000L;
            long l2 = date.getTime() / 1000L;
            n = new Long(l2 - l).intValue();
        }
        if (n < 0) {
            n = 0;
        }
        n += new Long(this.extraTime).intValue();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SCT stay in cache for " + n + " seconds");
        }
        return n;
    }

    private void mergeSCT(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mergeSCT(String key)=" + string);
        }
        byte[] byArray = (byte[])this.distributedMap.get((Object)string);
        SCT sCT = new SCT();
        if (byArray != null) {
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
                sCT.readExternal(objectInputStream);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error when deserializing SCT. ", exception.getStackTrace());
                }
                sCT = null;
            }
            if (tc.isDebugEnabled() && sCT != null) {
                for (int i = 0; i < sCT.getInstances().length; ++i) {
                    Tr.debug(tc, "instances list (before merge) :" + sCT.getInstances()[i]);
                }
            }
            SCT sCT2 = new SCT();
            sCT2 = (SCT)this.nonDistributedMap.get(string);
            if (sCT2 != null && sCT2.getInstances() != null && sCT != null) {
                String[] stringArray = sCT2.getInstances();
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    if (sCT.getKeyHistoryEntry(stringArray[i]) != null) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "copy missing key instance:" + stringArray[i]);
                    }
                    sCT.setKeyHistoryEntry(sCT2.getKeyHistoryEntry(stringArray[i]));
                }
            }
            if (sCT != null) {
                this.nonDistributedMap.put(string, sCT);
                if (tc.isDebugEnabled()) {
                    for (int i = 0; i < sCT.getInstances().length; ++i) {
                        Tr.debug(tc, "instances list (after merge) : " + sCT.getInstances()[i]);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mergeSCT(String key)");
        }
    }
}

