/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.websphere.auth;

import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.wssecurity.platform.auth.SecureConversationCacheConfig;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.xmlns.prod.websphere._200608.wssecureconversation.cache.Configuration;
import com.ibm.xmlns.prod.websphere._200608.wssecureconversation.cache.Property;
import com.ibm.xmlns.prod.websphere._200608.wssecureconversation.cache.SCClientCache;
import java.io.File;
import javax.xml.bind.JAXBContext;

public class SecureConversationCacheConfigImpl
implements SecureConversationCacheConfig {
    private static final String SCConfigFile = "WSSCCache.xml";
    private static final String Package_Namespace = "com.ibm.xmlns.prod.websphere._200608.wssecureconversation.cache";
    private static RepositoryContext repContext;
    protected static final String[] preDefinedProps;
    private static long cacheGraceMilliseconds;
    private static long cacheCushionMilliseconds;
    private static final long cacheCushionMin = 180000L;
    private static long clockSkewMilliseconds;
    private static long maxClockSkewMilliseconds;
    private static boolean isDistributedCache;
    private static boolean isCacheConfigInitialized;
    private static final String clsName;
    private static final String comp = "security.wssecurity";
    private static TraceComponent tc;

    public SecureConversationCacheConfigImpl() {
        if (!isCacheConfigInitialized) {
            SecureConversationCacheConfigImpl.init();
        }
    }

    private static void init() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadConfiguration()");
        }
        Configuration configuration = null;
        try {
            object4 = SecureConversationCacheConfigImpl.LocateWSSCCacheConfig(SCConfigFile);
            object3 = JAXBContext.newInstance(Package_Namespace);
            object2 = ((JAXBContext)object3).createUnmarshaller();
            object = (SCClientCache)object2.unmarshal(new File((String)object4));
            configuration = ((SCClientCache)object).getConfiguration().get(0);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, clsName, "001");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Fail to load WS-SecureConversation cache configuration. Using default.");
            }
            Tr.warning(tc, "security.wssecurity.SecureConversationCacheConfigImpl.s01");
            return;
        }
        object4 = configuration.getProperty();
        object3 = object4.iterator();
        while (object3.hasNext()) {
            Long l;
            object2 = (Property)object3.next();
            object = ((Property)object2).getName();
            String string = ((Property)object2).getValue();
            if (preDefinedProps[0].equalsIgnoreCase((String)object) && string != null && string.trim().length() > 0) {
                l = new Long(string);
                if (l > 0L) {
                    cacheCushionMilliseconds = l < 3L ? 180000L : l * 60L * 1000L;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cacheCushionMilliseconds=" + cacheCushionMilliseconds);
                }
            }
            if (preDefinedProps[1].equalsIgnoreCase((String)object) && string != null && string.trim().length() > 0) {
                l = new Long(string);
                if (cacheGraceMilliseconds <= l * 60L * 1000L) {
                    cacheGraceMilliseconds = l * 60L * 1000L;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cacheGraceMilliseconds=" + cacheGraceMilliseconds);
                }
            }
            if (preDefinedProps[2].equalsIgnoreCase((String)object) && string != null && string.trim().length() > 0 && (string = string.trim()).equalsIgnoreCase("true")) {
                isDistributedCache = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "isDistributedCache = true");
                }
            }
            if (!preDefinedProps[3].equalsIgnoreCase((String)object) || string == null || string.trim().length() <= 0) continue;
            l = new Long(string);
            clockSkewMilliseconds = l * 60L * 1000L <= maxClockSkewMilliseconds ? l * 60L * 1000L : maxClockSkewMilliseconds;
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "clockSkewMilliseconds=" + clockSkewMilliseconds);
        }
        isCacheConfigInitialized = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadConfiguration()");
        }
    }

    public long getSCCacheCushionMilliseconds() {
        if (!isCacheConfigInitialized) {
            SecureConversationCacheConfigImpl.init();
        }
        return cacheCushionMilliseconds;
    }

    public long getSCCacheGraceTimeMilliseconds() {
        if (!isCacheConfigInitialized) {
            SecureConversationCacheConfigImpl.init();
        }
        return cacheGraceMilliseconds;
    }

    public long getClockSkewToleranceMilliseconds() {
        if (!isCacheConfigInitialized) {
            SecureConversationCacheConfigImpl.init();
        }
        return clockSkewMilliseconds;
    }

    public boolean isDistributedCache() {
        if (!isCacheConfigInitialized) {
            SecureConversationCacheConfigImpl.init();
        }
        return isDistributedCache;
    }

    private static String LocateWSSCCacheConfig(String string) {
        AdminService adminService = AdminServiceFactory.getAdminService();
        String string2 = System.getProperty("user.install.root");
        String string3 = adminService.getCellName();
        String string4 = string2 + File.separator + "config" + File.separator + "cells" + File.separator + string3 + File.separator + string;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "WSSC Cache config file = " + string4);
        }
        return string4;
    }

    static {
        preDefinedProps = new String[]{"renewIntervalBeforeTimeoutMinutes", "minutesInCacheAfterTimeout", "DistributedCache", "clockSkewToleranceInMinutes"};
        cacheGraceMilliseconds = 600000L;
        cacheCushionMilliseconds = 600000L;
        clockSkewMilliseconds = 180000L;
        maxClockSkewMilliseconds = 600000L;
        isDistributedCache = false;
        isCacheConfigInitialized = false;
        clsName = SecureConversationCacheConfigImpl.class.getName();
        tc = Tr.register(SecureConversationCacheConfigImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    }
}

