/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.auth;

import com.ibm.ws.wssecurity.platform.auth.SecurityTokenCache;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.timer.Alarm;
import com.ibm.ws.wssecurity.util.timer.AlarmListener;
import com.ibm.ws.wssecurity.util.timer.AlarmManager;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCT;
import java.util.Date;
import java.util.HashMap;

public class SecureConversationCacheImpl
implements SecurityTokenCache {
    private HashMap<String, Object> nonDistributedMap;
    private HashMap<String, Object> activeAlarms;
    private static final String clsName = SecureConversationCacheImpl.class.getName();
    private static final TraceComponent tc = Tr.register(SecureConversationCacheImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public SecureConversationCacheImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SecureConversationCacheImpl");
        }
        this.nonDistributedMap = new HashMap();
        this.activeAlarms = new HashMap();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SecureConversationCacheImpl");
        }
    }

    public Object get(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get(String identifier)", string);
        }
        Object object = this.nonDistributedMap.get(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get(String identifier)", string);
        }
        return object;
    }

    public void Invalidate(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Invalidate(String identifier)", string);
        }
        this.nonDistributedMap.remove(string);
        this.removeAlarm(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Invalidate(String identifier)", string);
        }
    }

    public void put(String string, Object object, Object object2) {
        this.put(string, object);
        if (object2 == null) {
            return;
        }
        String string2 = string + ":WSSECURITY_SCT_Config";
        this.nonDistributedMap.put(string2, object2);
        SCT sCT = (SCT)object;
        int n = this.getSCTExpirationTime(sCT);
        this.removeAlarm(string2);
        Alarm alarm = null;
        if (n > 0) {
            alarm = AlarmManager.createDeferrable(n, new AlarmListener(){

                public void alarm(Object object) {
                    SecureConversationCacheImpl.this.Invalidate((String)object);
                }
            }, string2);
            this.activeAlarms.put(string2, alarm);
        }
    }

    public void put(String string, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "put(String identifier, Object token)", string);
        }
        this.nonDistributedMap.put(string, object);
        SCT sCT = (SCT)object;
        int n = this.getSCTExpirationTime(sCT);
        this.removeAlarm(string);
        Alarm alarm = null;
        if (n > 0) {
            alarm = AlarmManager.createDeferrable(n, new AlarmListener(){

                public void alarm(Object object) {
                    SecureConversationCacheImpl.this.Invalidate((String)object);
                }
            }, string);
            this.activeAlarms.put(string, alarm);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "put(String identifier, Object token)", string);
        }
    }

    private void removeAlarm(String string) {
        Alarm alarm = (Alarm)this.activeAlarms.get(string);
        if (alarm != null) {
            this.activeAlarms.remove(string);
            alarm.cancel();
        }
    }

    private int getSCTExpirationTime(SCT sCT) {
        String[] stringArray = sCT.getInstances();
        int n = 600000;
        if (stringArray.length > 0) {
            Date date = sCT.getExpiration(stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                if (!sCT.getExpiration(stringArray[i]).after(date)) continue;
                date = sCT.getExpiration(stringArray[i]);
            }
            long l = System.currentTimeMillis();
            long l2 = date.getTime();
            n = new Long(l2 - l).intValue();
        }
        if (n < 0) {
            n = 0;
        }
        n += 600000;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SCT will stay in ccahe for " + n + " milliseconds");
        }
        return n;
    }
}

