/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.auth;

import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.wssecurity.platform.auth.SecureConversationCacheFactory;
import com.ibm.ws.wssecurity.platform.auth.SecurityTokenCache;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCT;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.Parameter;

public class SecureConversationCacheHelper {
    private static final TraceComponent tc = Tr.register(SecureConversationCacheHelper.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String CLS_NAME = SecureConversationCacheHelper.class.getName();
    private static final String comp = "security.wssecurity";
    private static String sessionIdentifier = Constants.WSSECURITY_SECURECONVERSATION_IDENTIFIER;
    private static SecurityTokenCache _sCache = SecureConversationCacheFactory.getInstance();
    private static String clusterName = null;
    private static final String SERVICE_SCOPE = "SERVICE_SCOPE";
    private static String sctscope = "com.ibm.ws.wssecurity.sc.SCTScope";

    public static Object getSecurityContextTokenFromCacheByUUID(String string) {
        if (string == null) {
            return null;
        }
        return _sCache.get(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String computeKey(MessageContext messageContext) throws SoapSecurityException {
        Object object;
        if (messageContext == null) {
            return null;
        }
        if (clusterName == null) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        Server server = (Server)WsServiceRegistry.getService(this, Server.class);
                        if (server != null) {
                            clusterName = server.getClusterName();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "cluster name from server service=" + clusterName);
                            }
                            if (clusterName == null) {
                                clusterName = server.getName();
                            }
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                object = privilegedActionException.getException();
                Tr.processException((Throwable)object, CLS_NAME, "getSecurityContextTokenFromCacheByContext_1");
            }
            if (clusterName == null) {
                clusterName = "";
            }
        }
        String string = null;
        object = null;
        String string2 = null;
        ConfigurationContext configurationContext = messageContext.getConfigurationContext();
        if (configurationContext == null) throw SoapSecurityException.format("security.wssecurity.SecureConversationCacheHelper.s02");
        Object object2 = configurationContext.getAxisConfiguration();
        if (object2 == null) throw SoapSecurityException.format("security.wssecurity.SecureConversationCacheHelper.s01");
        Object object3 = ((AxisDescription)object2).getParameter("ApplicationName");
        if (object3 != null) {
            string = (String)((Parameter)object3).getValue();
        }
        if ((object3 = ((AxisDescription)object2).getParameter("ModuleName")) != null) {
            object = (String)((Parameter)object3).getValue();
        }
        object2 = messageContext.getTo();
        if (object2 == null) {
            throw SoapSecurityException.format("security.wssecurity.SecureConversationCacheHelper.s03");
        }
        string2 = ((EndpointReference)object2).getAddress();
        if (string == null) {
            string = "J2SE_THIN_CLIENT";
        }
        if (object == null) {
            object = "J2SE_THIN_CLIENT_MODULE";
        }
        if (object2 == null) {
            throw SoapSecurityException.format("security.wssecurity.SecureConversationCacheHelper.s03");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "clusterName=" + clusterName);
            Tr.debug(tc, "appName=" + string);
            Tr.debug(tc, "moduleName=" + (String)object);
            Tr.debug(tc, "endPoint=" + object2);
        }
        object3 = clusterName + string + (String)object + string2;
        if (!tc.isEntryEnabled()) return object3;
        Tr.exit(tc, "computeKey(MessageContext) returns [" + (String)object3 + "]");
        return object3;
    }

    public static Object getSecurityContextTokenFromCacheByContext(MessageContext messageContext) {
        if (messageContext == null) {
            return null;
        }
        Object object = null;
        String string = null;
        string = SecureConversationCacheHelper.getClientCacheKeyFromMessage(messageContext);
        if (string != null) {
            object = _sCache.get(string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getting it from message context using session key=[" + string + "], lookup result=[" + object + "]");
            }
        }
        if (object == null && !SERVICE_SCOPE.equalsIgnoreCase(SecureConversationCacheHelper.getSCTScope(messageContext))) {
            try {
                string = SecureConversationCacheHelper.computeKey(messageContext);
                if (string != null) {
                    object = _sCache.get(string);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getting it from cache using non-session key=[" + string + "], lookup result=[" + object + "]");
                }
            }
            catch (SoapSecurityException soapSecurityException) {
                Tr.processException(soapSecurityException, CLS_NAME, "getSecurityContextTokenFromCacheByContext_1");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "getSecurityContextTokenFromCacheByContext(MessageContext) returns [" + object + "]");
        }
        return object;
    }

    public static void setPeristentSecurityContextTokenToCache(String string, Object object, Object object2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setPersistentSecurityContextTokenToCache(String uuid = " + string);
        }
        if (string == null || string.trim().length() == 0) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setting cache using uuid as a key = " + string);
        }
        _sCache.put(string, object, object2);
        String string2 = ((SCT)object).getClientID();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setting cache using non-session key of " + string2);
        }
        if (string2 != null) {
            _sCache.put(string2, object, null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setPersistentSecurityContextTokenToCache(String uuid = " + string);
        }
    }

    public static void setSecurityContextTokenToCache(String string, MessageContext messageContext, Object object, Object object2) {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        if (SERVICE_SCOPE.equalsIgnoreCase(SecureConversationCacheHelper.getSCTScope(messageContext))) {
            if (string != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "setting cache using session key of " + string);
                }
                _sCache.put(string, object, object2);
                SecureConversationCacheHelper.addClientCacheKeyToMessage(messageContext, string);
            }
        } else {
            try {
                String string2 = SecureConversationCacheHelper.computeKey(messageContext);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "setting cache using non-session key of " + string2);
                }
                if (string2 != null) {
                    _sCache.put(string2, object, null);
                } else if (messageContext == null) {
                    string2 = ((SCT)object).getClientID();
                }
                if (string2 != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "setting cache using non-session key of " + string2);
                    }
                    _sCache.put(string2, object, null);
                }
            }
            catch (SoapSecurityException soapSecurityException) {
                Tr.processException(soapSecurityException, CLS_NAME, "getSecurityContextTokenFromCacheByContext_1");
            }
            if (string != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "setting cache using session key of " + string);
                }
                _sCache.put(string, object, object2);
                SecureConversationCacheHelper.addClientCacheKeyToMessage(messageContext, string);
            }
        }
    }

    public static void invalidateCache(String string) {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        Object object = SecureConversationCacheHelper.getSecurityContextTokenFromCacheByUUID(string);
        if (object instanceof SCT) {
            String string2;
            SCT sCT = (SCT)object;
            String string3 = sCT.getClientID();
            if (string3 != null) {
                _sCache.Invalidate(string3);
            }
            if ((string2 = sCT.getIdentifier()) != null && !string2.equals(string3)) {
                _sCache.Invalidate(string2);
            }
        } else {
            _sCache.Invalidate(string);
        }
    }

    public static void cleanupContexts(MessageContext messageContext) {
        Parameter parameter;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanupContexts(MessageContext) " + messageContext);
        }
        String string = "";
        EndpointReference endpointReference = messageContext.getTo();
        if (endpointReference != null) {
            string = endpointReference.getAddress();
        }
        if (string == null) {
            string = "";
        }
        if (messageContext.getProperty(sessionIdentifier + string) != null) {
            messageContext.setProperty(sessionIdentifier + string, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "removed session identifier from message context.");
            }
        }
        if (messageContext.getAxisService() != null && (parameter = messageContext.getAxisService().getParameter(sessionIdentifier + string)) != null) {
            try {
                messageContext.getAxisService().removeParameter(parameter);
                Parameter parameter2 = messageContext.getAxisService().getParameter(sessionIdentifier);
                if (parameter2 != null) {
                    messageContext.getAxisService().removeParameter(parameter2);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "removed session identifier from service context.");
                }
            }
            catch (AxisFault axisFault) {
                // empty catch block
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanupContexts(MessageContext) " + messageContext);
        }
    }

    public static void invalidateCache(MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invalidateCache(MessageContext) " + messageContext);
        }
        if (messageContext == null) {
            return;
        }
        Object object = SecureConversationCacheHelper.getSecurityContextTokenFromCacheByContext(messageContext);
        if (object instanceof SCT) {
            String string;
            SCT sCT = (SCT)object;
            String string2 = sCT.getClientID();
            if (string2 != null) {
                _sCache.Invalidate(string2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "removed sct from cache using non-session key = " + string2);
                }
            }
            if ((string = sCT.getIdentifier()) != null && !string.equals(string2)) {
                _sCache.Invalidate(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "removed sct from cache using session key = " + string);
                }
            }
            SecureConversationCacheHelper.cleanupContexts(messageContext);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invalidateCache(MessageContext) " + messageContext);
        }
    }

    private static String getClientCacheKeyFromMessage(MessageContext messageContext) {
        Parameter parameter;
        String string;
        if (messageContext == null) {
            return null;
        }
        String string2 = "";
        EndpointReference endpointReference = messageContext.getTo();
        if (endpointReference != null) {
            string2 = endpointReference.getAddress();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Need endPoint as part of the session key = " + string2);
        }
        if (string2 == null) {
            string2 = "";
        }
        if ((string = (String)messageContext.getProperty(sessionIdentifier + string2)) != null && string.length() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning SecureConversation session id is (message context)" + string);
            }
            return string;
        }
        if (messageContext.getAxisService() != null && (parameter = messageContext.getAxisService().getParameter(sessionIdentifier + string2)) != null) {
            string = (String)parameter.getValue();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SecureConversation session id is " + string);
        }
        return string;
    }

    private static void addClientCacheKeyToMessage(MessageContext messageContext, String string) {
        if (string != null && string.trim().length() > 0 && messageContext != null) {
            String string2 = "";
            EndpointReference endpointReference = messageContext.getTo();
            if (endpointReference != null) {
                string2 = endpointReference.getAddress();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " Adding endPoint to the session key = " + string2);
            }
            if (string2 == null) {
                string2 = "";
            }
            messageContext.setProperty(sessionIdentifier + string2, string);
            Parameter parameter = new Parameter(sessionIdentifier + string2, string);
            try {
                messageContext.getAxisService().addParameter(parameter);
                messageContext.getAxisService().addParameter(new Parameter(sessionIdentifier, string));
            }
            catch (Exception exception) {
                Tr.debug(tc, "Unable to add client sessionId to AxisContext. ", exception);
            }
        }
    }

    private static String getSCTScope(MessageContext messageContext) {
        if (messageContext == null) {
            return null;
        }
        return (String)messageContext.getProperty(sctscope);
    }
}

