/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.platform.auth;

import com.ibm.ws.wssecurity.platform.auth.SecureConversationCacheConfig;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.Constants;

public class SecureConversationCacheConfigImpl
implements SecureConversationCacheConfig {
    private static long cacheCushionMilliseconds = 600000L;
    private static final long cacheCushionMin = 180000L;
    private static long clockSkewMilliseconds = 180000L;
    private static long maxClockSkewMilliseconds = 600000L;
    private static boolean isCacheConfigInitialized = false;
    private static final String cacheCushionProp = Constants.WSSECURITY_SECURECONVERSATION_CACHE_CUSHION;
    private static final String clockSkewProp = Constants.WSSECURITY_SECURECONVERSATION_CLOCK_SKEW_TOLERANCE;
    private static TraceComponent tc = Tr.register(SecureConversationCacheConfigImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public SecureConversationCacheConfigImpl() {
        SecureConversationCacheConfigImpl.init();
    }

    private static void init() {
        long l;
        String string = System.getProperty(cacheCushionProp);
        if (string != null && string.trim().length() > 0) {
            l = new Long(string) * 60L * 1000L;
            if (l > 0L) {
                cacheCushionMilliseconds = l < 180000L ? 180000L : l;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cacheCushionMilliseconds=" + cacheCushionMilliseconds);
            }
        }
        if ((string = System.getProperty(clockSkewProp)) != null && string.trim().length() > 0) {
            l = new Long(string) * 60L * 1000L;
            clockSkewMilliseconds = l <= maxClockSkewMilliseconds ? l : maxClockSkewMilliseconds;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "clockSkewMilliseconds = " + clockSkewMilliseconds);
            }
        }
        isCacheConfigInitialized = true;
    }

    public long getSCCacheCushionMilliseconds() {
        if (!isCacheConfigInitialized) {
            SecureConversationCacheConfigImpl.init();
        }
        return cacheCushionMilliseconds;
    }

    public long getSCCacheGraceTimeMilliseconds() {
        if (!isCacheConfigInitialized) {
            SecureConversationCacheConfigImpl.init();
        }
        return cacheCushionMilliseconds;
    }

    public boolean isDistributedCache() {
        return false;
    }

    public long getClockSkewToleranceMilliseconds() {
        if (!isCacheConfigInitialized) {
            SecureConversationCacheConfigImpl.init();
        }
        return clockSkewMilliseconds;
    }
}

