/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.keyinfo;

import com.ibm.ws.wssecurity.config.KeyInfoGeneratorConfig;
import com.ibm.ws.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.wssecurity.keyinfo.WSSKeyInfoComponent;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.security.Key;
import java.util.Map;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyInfoGenerator
implements WSSKeyInfoComponent {
    private static final TraceComponent tc = Tr.register(KeyInfoGenerator.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private boolean _initialized = false;

    @Override
    public void init(Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    public Key getKey(OMDocument oMDocument, OMElement oMElement, Map<Object, Object> map, Map<Object, Object> map2) throws SoapSecurityException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKey(Document doc[" + DOMUtils.getDisplayName(oMDocument) + "]," + "OMElement parent[" + DOMUtils.getDisplayName(oMElement) + "]," + "Map type," + "Map context)");
        }
        Key key = null;
        WSSGeneratorConfig wSSGeneratorConfig = (WSSGeneratorConfig)map2.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
        KeyInfoGeneratorConfig keyInfoGeneratorConfig = (KeyInfoGeneratorConfig)map2.remove("com.ibm.ws.wssecurity.impl.config.keyinfoGenerator.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "KeyInfoGeneratorConfig [" + keyInfoGeneratorConfig + "].");
        }
        OMElement oMElement2 = null;
        oMElement2 = oMDocument.getOMDocumentElement().getOMFactory().createOMElement("KeyInfo", com.ibm.ws.wssecurity.common.Constants.NS_DSIG, "ds");
        String string = (String)map.get(Constants.WSSECURITY_KEY_TYPE);
        boolean bl = false;
        if ("EncryptingKey".equals(string)) {
            bl = true;
            oMElement2.declareNamespace(com.ibm.ws.wssecurity.common.Constants.NS_DSIG, "ds");
        }
        if (wSSGeneratorConfig.isUserDefinedComponentsUsed()) {
            object = DOMUtils.getOneChildElement(oMElement, com.ibm.ws.wssecurity.common.Constants.NS_DSIG, "KeyInfo");
            OMNode oMNode = object.getNextOMSibling();
            object.detach();
            if (oMNode == null) {
                oMElement.addChild(oMElement2);
            } else {
                oMNode.insertSiblingBefore(oMElement2);
            }
        } else if (bl) {
            object = DOMUtils.getOneChildElement(oMElement, com.ibm.ws.wssecurity.common.Constants.NS_ENC, "CipherData");
            if (object == null) {
                oMElement.addChild(oMElement2);
            } else {
                object.insertSiblingBefore(oMElement2);
            }
        } else {
            oMElement.addChild(oMElement2);
        }
        object = keyInfoGeneratorConfig.getContentGenerator().getInstance();
        if (object == null) {
            throw SoapSecurityException.format("security.wssecurity.KeyInfoGenerator.getKey01");
        }
        map2.put("com.ibm.ws.wssecurity.impl.config.keyinfoContentGenerator.configKey", keyInfoGeneratorConfig.getContentGenerator());
        key = object.getKey(oMDocument, oMElement2, map, map2);
        if (key == null) {
            throw SoapSecurityException.format("security.wssecurity.KeyInfoGenerator.getKey02");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Created the element [" + DOMUtils.getDisplayName(oMElement2) + "].");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKey(OMDocument doc,OMElement parent,Map type,Map context) returns Key[key]");
        }
        return key;
    }
}

