/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.keyinfo;

import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.common.Result;
import com.ibm.ws.wssecurity.common.ResultPool;
import com.ibm.ws.wssecurity.config.KeyInfoConsumerConfig;
import com.ibm.ws.wssecurity.config.KeyInfoContentConsumerConfig;
import com.ibm.ws.wssecurity.core.WSSConsumer;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoConsumerComponent;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoResult;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.TokenConsumerConfig;
import java.security.AccessController;
import java.security.Key;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyInfoConsumer
implements KeyInfoConsumerComponent {
    private static final TraceComponent tc = Tr.register(KeyInfoConsumer.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    public static final String KEYNAME = "KEYNAME";
    public static final String KEYID = "KEYID";
    public static final String STRREF = "STRREF";
    public static final String EMB = "EMB";
    public static final String X509ISSUER = "X509ISSUER";
    public static final String UNKNOWN = "UNKNOWN";
    public static final String THUMBPRINT = "THUMBPRINT";
    private boolean _initialized = false;

    @Override
    public void init(Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    @Override
    public Key getKey(OMElement oMElement, Map<Object, Object> map, Map<Object, Object> map2) throws SoapSecurityException {
        Object object;
        Object object2;
        KeyInfoResult keyInfoResult;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKey(OMElement target[" + DOMUtils.getDisplayName(oMElement) + "]," + "Map type," + "Map context)");
        }
        Object object3 = null;
        KeyInfoConsumerConfig keyInfoConsumerConfig = (KeyInfoConsumerConfig)map2.remove("com.ibm.ws.wssecurity.impl.config.keyinfoConsumer.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "KeyInfoConsumerConfig [" + keyInfoConsumerConfig + "].");
        }
        boolean bl = false;
        KeyInfoContentConsumerConfig keyInfoContentConsumerConfig = null;
        Exception[] exceptionArray = new Exception[keyInfoConsumerConfig.getContentConsumers().size()];
        int n = 0;
        Iterator<KeyInfoContentConsumerConfig> iterator = keyInfoConsumerConfig.getContentConsumers().iterator();
        while (iterator != null && iterator.hasNext()) {
            Object object4;
            Object object5;
            Map<Object, Object> map3;
            Object object6;
            keyInfoContentConsumerConfig = iterator.next();
            keyInfoResult = KeyInfoConsumer.getProcessedResult(map2, keyInfoContentConsumerConfig);
            if (keyInfoResult != null) {
                if (keyInfoResult.getError() != null) {
                    exceptionArray[n++] = keyInfoResult.getError();
                    continue;
                }
                object3 = keyInfoResult.getKey();
                object2 = keyInfoContentConsumerConfig.getProperties();
                object = (String)object2.get("com.ibm.ws.wssecurity.config.keystore.consumerkeyStoreRef");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "HW keystore name is : " + (String)object);
                }
                map2.put("com.ibm.ws.wssecurity.config.keystore.consumerkeyStoreRef", object);
                if (bl) continue;
                keyInfoResult.setUsed(true);
                bl = true;
                continue;
            }
            object2 = (SecurityTokenManagerImpl)map2.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
            try {
                object = keyInfoContentConsumerConfig.getInstance();
                object6 = keyInfoContentConsumerConfig.getTokenConsumer();
                if (object6 != null && ((String)((Object)(map3 = (object5 = DOMUtils.getFirstElement(oMElement)).getLocalName()))).equals("SecurityTokenReference") && "Reference".equals(map3 = (object4 = DOMUtils.getFirstElement((OMNode)object5)).getLocalName())) {
                    String string = DOMUtils.getAttribute((OMElement)object4, "URI");
                    HashMap hashMap = (HashMap)map2.get("com.ibm.ws.wssecurity.constants.tokenCache");
                    if (hashMap.get(string = string.substring(1)) != null) {
                        WSSConsumer.callStoredTokenConsumer((TokenConsumerConfig)object6, map2, string);
                    }
                }
                map2.put("com.ibm.ws.wssecurity.impl.config.keyinfoContentConsumer.configKey", keyInfoContentConsumerConfig);
                object5 = object.getKey(oMElement, map, map2);
                if (object5 == null) {
                    throw SoapSecurityException.format("security.wssecurity.KeyInfoGenerator.getKey02");
                }
                if (object3 == null) {
                    object3 = object5;
                    map3 = keyInfoContentConsumerConfig.getProperties();
                    object4 = (String)map3.get("com.ibm.ws.wssecurity.config.keystore.consumerkeyStoreRef");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "HW keystorename is : " + (String)object4);
                    }
                    map2.put("com.ibm.ws.wssecurity.config.keystore.consumerkeyStoreRef", object4);
                }
                if ((map3 = ((SecurityTokenManagerImpl)object2).getUnprocessedTokenWrapper()) != null) {
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            map3.setProcessed(true);
                            return null;
                        }
                    });
                }
                if ((keyInfoResult = KeyInfoConsumer.getUnprocessedResult(map2)) != null) {
                    keyInfoResult.setProcessed(true);
                    if (!bl) {
                        keyInfoResult.setUsed(true);
                    }
                    keyInfoResult.setKey((Key)object3);
                }
                bl = true;
            }
            catch (Exception exception) {
                exceptionArray[n++] = exception;
                object6 = map2.remove(Constants.WSSECURITY_TOKEN_FOR_ERROR_HANDLING);
                if (object6 != null && object6 instanceof SecurityToken) {
                    object5 = (SecurityToken)object6;
                    map3 = new SecurityTokenWrapper((SecurityToken)object5);
                    object4 = keyInfoContentConsumerConfig.getTokenConsumer();
                    ((SecurityTokenWrapper)((Object)map3)).setUsedTokenConsumer(object4.hashCode(), object4.getClass().getName().hashCode());
                    ((SecurityTokenWrapper)((Object)map3)).setKeyInfoType(null);
                    if (exception instanceof SoapSecurityException) {
                        ((SecurityTokenWrapper)((Object)map3)).setError((SoapSecurityException)exception);
                    }
                    ((SecurityTokenWrapper)((Object)map3)).setProcessed(true);
                }
                if ((keyInfoResult = KeyInfoConsumer.getUnprocessedResult(map2)) == null) continue;
                keyInfoResult.setError(exception);
                keyInfoResult.setProcessed(true);
            }
        }
        iterator = keyInfoConsumerConfig.getOtherContentConsumers().iterator();
        while (iterator != null && iterator.hasNext()) {
            keyInfoContentConsumerConfig = iterator.next();
            keyInfoResult = KeyInfoConsumer.getProcessedResult(map2, keyInfoContentConsumerConfig);
            if (keyInfoResult != null) continue;
            try {
                object2 = keyInfoContentConsumerConfig.getInstance();
                map2.put("com.ibm.ws.wssecurity.impl.config.keyinfoContentConsumer.configKey", keyInfoContentConsumerConfig);
                object = object2.getKey(oMElement, map, map2);
                if (object == null) {
                    throw SoapSecurityException.format("security.wssecurity.KeyInfoGenerator.getKey02");
                }
                if (object3 == null) {
                    object3 = object;
                }
                if ((keyInfoResult = KeyInfoConsumer.getUnprocessedResult(map2)) == null) continue;
                keyInfoResult.setProcessed(true);
            }
            catch (Exception exception) {
                keyInfoResult = KeyInfoConsumer.getUnprocessedResult(map2);
                if (keyInfoResult == null) continue;
                keyInfoResult.setError(exception);
                keyInfoResult.setProcessed(true);
            }
        }
        if (!bl) {
            if (n == 1) {
                if (exceptionArray[0] instanceof SoapSecurityException) {
                    throw (SoapSecurityException)exceptionArray[0];
                }
                throw SoapSecurityException.format("security.wssecurity.KeyInfoConsumer.getKey04", new String[]{exceptionArray[0].getMessage()}, (Throwable)exceptionArray[0]);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, n + " exceptions were catched.");
                for (int i = 0; i < n; ++i) {
                    Tr.debug(tc, "No." + i + "'s exception: " + exceptionArray[i]);
                }
            }
            throw SoapSecurityException.format("security.wssecurity.KeyInfoConsumer.getKey03", new String[]{exceptionArray[n - 1].getMessage()}, (Throwable)exceptionArray[n - 1]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getkey(OMElement target,Map type,Map context) returns Key[" + object3 + "]");
        }
        return object3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getKeyInfoType(OMElement oMElement, String string) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyInfoType(OMElement target[" + DOMUtils.getDisplayName(oMElement) + "]," + "String [" + string + "])");
        }
        String string2 = UNKNOWN;
        OMElement oMElement2 = DOMUtils.getFirstElement(oMElement);
        if (oMElement2 != null && DOMUtils.equals(oMElement2, com.ibm.ws.wssecurity.common.Constants.NS_DSIG, "KeyName")) {
            string2 = KEYNAME;
        } else {
            if (!DOMUtils.equals(oMElement2, string, "SecurityTokenReference")) throw SoapSecurityException.format("security.wssecurity.KeyInfoConsumer.getKeyInfoType01");
            if (DOMUtils.equals(oMElement2 = DOMUtils.getFirstElement(oMElement2), string, "KeyIdentifier")) {
                String string3 = DOMUtils.getAttribute(oMElement2, "ValueType");
                string2 = string3.equals(com.ibm.ws.wssecurity.common.Constants.THUMBPRINTSHA1.getLocalPart()) ? THUMBPRINT : KEYID;
            } else if (DOMUtils.equals(oMElement2, string, "Reference")) {
                string2 = STRREF;
            } else if (DOMUtils.equals(oMElement2, string, "Embedded")) {
                string2 = EMB;
            } else {
                if (!DOMUtils.equals(oMElement2, com.ibm.ws.wssecurity.common.Constants.NS_DSIG, "X509Data")) throw SoapSecurityException.format("security.wssecurity.KeyInfoConsumer.getKeyInfoType01");
                string2 = X509ISSUER;
            }
        }
        if (!tc.isEntryEnabled()) return string2;
        Tr.exit(tc, "getKeyInfoType(OMElement target,String  nsWsse) returns String[" + string2 + "]");
        return string2;
    }

    public static QName getValueType(OMElement oMElement, String string, String string2, int n) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getValueType(OMElement target[" + DOMUtils.getDisplayName(oMElement) + "]," + "String kitype[" + string + "]," + "String nsWsse[" + string2 + "]," + "int wssVersion[" + n + "])");
        }
        QName qName = null;
        if (string == STRREF) {
            OMElement oMElement2 = DOMUtils.getOneElement(oMElement, string2, "Reference");
            if (oMElement2 == null) {
                throw SoapSecurityException.format("security.wssecurity.KeyInfoConsumer.getValueType01");
            }
            String string3 = DOMUtils.getAttribute(oMElement2, "ValueType");
            qName = DOMUtils.getQName(oMElement, string3, n);
        } else if (string == KEYID || string == THUMBPRINT) {
            OMElement oMElement3 = DOMUtils.getOneElement(oMElement, string2, "KeyIdentifier");
            if (oMElement3 == null) {
                throw SoapSecurityException.format("security.wssecurity.KeyInfoConsumer.getValueType02");
            }
            String string4 = DOMUtils.getAttribute(oMElement3, "ValueType");
            qName = DOMUtils.getQName(oMElement, string4, n);
        } else if (string == EMB) {
            OMElement oMElement4 = DOMUtils.getOneElement(oMElement, string2, "Embedded");
            if (oMElement4 == null) {
                throw SoapSecurityException.format("security.wssecurity.KeyInfoConsumer.getValueType03");
            }
            OMElement oMElement5 = DOMUtils.getFirstElement(oMElement4);
            if (oMElement5 != null) {
                if (oMElement5.getLocalName().equals("BinarySecurityToken") && string2.equals(oMElement5.getNamespace() == null ? null : oMElement5.getNamespace().getName())) {
                    String string5 = DOMUtils.getAttribute(oMElement5, "ValueType");
                    qName = DOMUtils.getQName(oMElement, string5, n);
                } else {
                    String string6 = oMElement5.getLocalName();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getValueType(OMElement target,String kitype,String nsWsse) returns QName[" + qName + "]");
        }
        return qName;
    }

    private static KeyInfoResult getUnprocessedResult(Map<Object, Object> map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUnprocessedResult(Map context)");
        }
        KeyInfoResult keyInfoResult = null;
        Result[] resultArray = ResultPool.get(map, KeyInfoResult.class);
        if (resultArray != null) {
            for (int i = 0; i < resultArray.length; ++i) {
                KeyInfoResult keyInfoResult2 = (KeyInfoResult)resultArray[i];
                if (keyInfoResult2.isProcessed()) continue;
                keyInfoResult = keyInfoResult2;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUnprocessedResult(Map context) returns KeyInfoResult[" + keyInfoResult + "]");
        }
        return keyInfoResult;
    }

    private static KeyInfoResult getProcessedResult(Map<Object, Object> map, KeyInfoContentConsumerConfig keyInfoContentConsumerConfig) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProcessedResult(Map context,KeyInfoContentConsumerConfig kconfig");
        }
        KeyInfoResult keyInfoResult = null;
        Result[] resultArray = ResultPool.get(map, KeyInfoResult.class);
        if (resultArray != null) {
            for (int i = 0; i < resultArray.length; ++i) {
                KeyInfoResult keyInfoResult2 = (KeyInfoResult)resultArray[i];
                if (!keyInfoContentConsumerConfig.equals(keyInfoResult2.getKeyInfoContentConsumer())) continue;
                keyInfoResult = keyInfoResult2;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProcessedResult(Map context,KeyInfoContentConsumerConfig kconfig) returns KeyInfoResult[" + keyInfoResult + "]");
        }
        return keyInfoResult;
    }
}

