/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.impl.auth.module;

import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.auth.callback.WSCredTokenCallbackImpl;
import com.ibm.websphere.security.auth.callback.WSRealmNameCallbackImpl;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.websphere.wssecurity.wssapi.token.LTPAPropagationToken;
import com.ibm.websphere.wssecurity.wssapi.token.LTPAToken;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.websphere.wssecurity.wssapi.token.UsernameToken;
import com.ibm.websphere.wssecurity.wssapi.token.X509Token;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.wssecurity.config.CallerConfig;
import com.ibm.ws.wssecurity.platform.auth.SubjectCache;
import com.ibm.ws.wssecurity.platform.auth.SubjectCacheFactory;
import com.ibm.ws.wssecurity.token.WSSUserRegistryProcessor;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.wsspi.security.auth.callback.WSAppContextCallback;
import com.ibm.wsspi.security.auth.callback.WSServletRequestCallback;
import com.ibm.wsspi.security.auth.callback.WSServletResponseCallback;
import com.ibm.wsspi.security.auth.callback.WSTokenHolderCallback;
import com.ibm.wsspi.security.auth.callback.WSX509CertificateChainCallback;
import com.ibm.wsspi.wssecurity.core.Constants;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSWSSLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(WSWSSLoginModule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private String comp = "security.wssecurity";
    private CallbackHandler _handler;
    private Map _sharedState;
    private Map<Object, Object> _context = null;
    private SecurityToken _callerIdentityToken = null;
    private static SubjectCache authCcahe = SubjectCacheFactory.getInstance();
    private Subject _subject = null;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options)");
        }
        this._handler = callbackHandler;
        this._sharedState = map;
        this._subject = subject;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(Subject, CallbackHandler, Map, Map)");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean login() throws LoginException {
        Subject subject;
        Object object;
        Object object2;
        Object object3;
        block37: {
            NameCallback nameCallback;
            block40: {
                block39: {
                    WSCredTokenCallbackImpl wSCredTokenCallbackImpl;
                    block38: {
                        block36: {
                            Object object4;
                            Boolean bl;
                            if (tc.isEntryEnabled()) {
                                Tr.entry(tc, "login()");
                            }
                            if ((bl = (Boolean)this._sharedState.get(Constants.WSSECURITY_CALLER_PROCESS_DONE)) == null || !bl.booleanValue()) {
                                String string = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s01");
                                throw new LoginException(string);
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "It seems that caller identification process is successfully done.");
                            }
                            CallerConfig callerConfig = (CallerConfig)this._sharedState.get("com.ibm.wsspi.wssecurity.core.config.callerConfig.configKey");
                            this._callerIdentityToken = (SecurityToken)this._sharedState.get(Constants.WSSECURITY_CALLER_IDENTITY);
                            SecurityToken securityToken = (SecurityToken)this._sharedState.get(Constants.WSSECURITY_TRUSTED_IDENTITY);
                            QName qName = callerConfig.getCallerIdentity();
                            QName qName2 = this._callerIdentityToken.getValueType();
                            if (this._callerIdentityToken == null) {
                                String string = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s01");
                                throw new LoginException(string);
                            }
                            if (!qName2.equals(qName)) {
                                String string = ConfigUtil.getMessage(this.comp + ".PrivateConsumerConfig.s30", new String[]{qName2.toString(), qName.toString()});
                                throw new LoginException(string);
                            }
                            if (securityToken != null) {
                                object3 = callerConfig.getTrustedIdentity();
                                object4 = securityToken.getValueType();
                                if (!((QName)object4).equals(object3)) {
                                    String string = ConfigUtil.getMessage(this.comp + ".PrivateConsumerConfig.s30", new String[]{((QName)object4).toString(), ((QName)object3).toString()});
                                    throw new LoginException(string);
                                }
                            }
                            if (tc.isDebugEnabled()) {
                                object3 = this._callerIdentityToken.getValueType();
                                Tr.debug(tc, "Caller identity token [" + object3 + "].");
                                object3 = securityToken == null ? null : securityToken.getValueType();
                                Tr.debug(tc, "Trusted identity token [" + object3 + "].");
                            }
                            if ((object3 = (Callback[])this._sharedState.get("Callback")) != null) {
                                int n = ((Callback[])object3).length;
                                for (int i = 0; i < n; ++i) {
                                    if (!(object3[i] instanceof PropertyCallback)) continue;
                                    this._context = ((PropertyCallback)object3[i]).getProperties();
                                    break;
                                }
                            }
                            if (this._context == null) {
                                object4 = new PropertyCallback(null);
                                object3 = new Callback[]{object4};
                                try {
                                    this._handler.handle((Callback[])object3);
                                }
                                catch (Exception exception) {
                                    throw new LoginException(ConfigUtil.getMessage(this.comp + ".BSTokenLoginModule.s01", new String[]{exception.toString()}));
                                }
                                this._context = ((PropertyCallback)object4).getProperties();
                            }
                            object4 = ContextManagerFactory.getInstance();
                            String string = null;
                            if (object4 == null) {
                                Tr.error(tc, "security.wssecurity.ctxmgr.isnull");
                            } else {
                                string = object4.getDefaultRealm();
                            }
                            object3 = new Callback[9];
                            nameCallback = new NameCallback("Username: ");
                            object3[0] = nameCallback;
                            PasswordCallback passwordCallback = new PasswordCallback("Password: ", false);
                            object3[1] = passwordCallback;
                            wSCredTokenCallbackImpl = new WSCredTokenCallbackImpl("Credential Token: ");
                            object3[2] = wSCredTokenCallbackImpl;
                            object3[3] = new WSServletRequestCallback("HttpServletRequest: ");
                            object3[4] = new WSServletResponseCallback("HttpServletResponse: ");
                            object3[5] = new WSAppContextCallback("ApplicationContextCallback: ");
                            object3[6] = new WSTokenHolderCallback("Authz Token List: ");
                            object3[7] = new WSRealmNameCallbackImpl("Realm Name", string);
                            object3[8] = new WSX509CertificateChainCallback("X509Certificate[]: ");
                            if (!(this._callerIdentityToken instanceof UsernameToken)) break block36;
                            object2 = (UsernameToken)this._callerIdentityToken;
                            object = object2.getUsername();
                            if (object == null || ((String)object).length() == 0) {
                                Tr.error(tc, this.comp + ".WSEC6735E", new Object[]{object2.getValueType().toString(), "Login cancelled: username string is null or empty."});
                                String string2 = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s11", new String[]{"Login cancelled: username string is null or empty."});
                                throw new LoginException(string2);
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Realm is = " + string);
                            }
                            object = WSSUserRegistryProcessor.removeRealm(string, (String)object);
                            nameCallback.setName((String)object);
                            char[] cArray = (char[])AccessController.doPrivileged(new PrivilegedAction<Object>((UsernameToken)object2){
                                final /* synthetic */ UsernameToken val$unt;
                                {
                                    this.val$unt = usernameToken;
                                }

                                @Override
                                public Object run() {
                                    return this.val$unt.getPassword();
                                }
                            });
                            passwordCallback.setPassword(cArray);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "UsernameToken found.");
                                Tr.debug(tc, "Username [" + (String)object + "], Password [" + (cArray == null ? "null" : "not null") + "].");
                            }
                            break block37;
                        }
                        if (!(this._callerIdentityToken instanceof X509Token)) break block38;
                        object2 = (X509Token)this._callerIdentityToken;
                        object = WSSUserRegistryProcessor.mapCertificate(object2.getCertificate());
                        if (object == null || ((String)object).length() == 0) {
                            object = object2.getPrincipal();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "User security from X509BSToken.getPrincipal() [" + (String)object + "]");
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "User security from UserRegistryProcessor.mapCertificate() [" + (String)object + "]");
                        }
                        nameCallback.setName((String)object);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "X509BSToken found.");
                            Tr.debug(tc, "Username [" + (String)object + "].");
                        }
                        break block37;
                    }
                    if (!(this._callerIdentityToken instanceof LTPAToken)) break block39;
                    object2 = (LTPAToken)this._callerIdentityToken;
                    object = (byte[])AccessController.doPrivileged(new PrivilegedAction<Object>((LTPAToken)object2){
                        final /* synthetic */ LTPAToken val$ltpa;
                        {
                            this.val$ltpa = lTPAToken;
                        }

                        @Override
                        public Object run() {
                            return this.val$ltpa.getBinary();
                        }
                    });
                    if (object == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Null credential value found for the LTPA token to login.");
                        }
                        String string = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s11", new String[]{"Null credentials for the LTPA token."});
                        throw new LoginException(string);
                    }
                    wSCredTokenCallbackImpl.setCredToken((byte[])object);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "LTPA Token found.");
                        Tr.debug(tc, "Credential [" + object + "].");
                    }
                    break block37;
                }
                if (!(this._callerIdentityToken instanceof LTPAPropagationToken)) break block40;
                object2 = (LTPAPropagationToken)this._callerIdentityToken;
                object = (WSCredential)AccessController.doPrivileged(new PrivilegedAction<Object>((LTPAPropagationToken)object2){
                    final /* synthetic */ LTPAPropagationToken val$ltpap;
                    {
                        this.val$ltpap = lTPAPropagationToken;
                    }

                    @Override
                    public Object run() {
                        return this.val$ltpap.getWSCredential();
                    }
                });
                WSPrincipal wSPrincipal = object2.getWSPrincipal();
                if (object != null) {
                    WSWSSLoginModule.addToSubject(this._context, (WSCredential)object);
                    WSWSSLoginModule.addToSubject(this._context, wSPrincipal);
                    WSWSSLoginModule.addToSubject(this._context, (SecurityToken)object2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "LTPA Propagation Token found.");
                        Tr.debug(tc, "WSCredential [" + object + "].");
                        Tr.debug(tc, "WSPrincipal [" + wSPrincipal + "].");
                    }
                    break block37;
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No WSCredential found in LTPA Propagation Token.");
                    }
                    String string = ConfigUtil.getMessage(this.comp + ".WSEC0168E");
                    throw new LoginException(string);
                }
            }
            object2 = this._callerIdentityToken;
            object = object2.getPrincipal();
            if (object == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Null principal value found for the custom token to login.");
                }
                String string = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s11", new String[]{"Null principal for the custom token."});
                throw new LoginException(string);
            }
            nameCallback.setName((String)object);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Token [" + object2.getValueType() + "] found.");
                Tr.debug(tc, "Principal [" + (String)object + "].");
            }
        }
        object2 = (SecurityTokenManagerImpl)this._context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
        object = ((SecurityTokenManagerImpl)object2).getTokenWrapper(this._callerIdentityToken);
        if (object != null) {
            ((SecurityTokenWrapper)object).setUsedToLogin(true);
        }
        if ((subject = authCcahe.getSubjectFromAuthCacheByToken(this._callerIdentityToken)) != null) {
            this._subject = subject;
        }
        this._sharedState.put("Callback", object3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login()");
        }
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        this._context.put(Constants.WSSECURITY_TOKEN_LOGININFO, this._callerIdentityToken);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return false;
    }

    @Override
    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return false;
    }

    private static final void addToSubject(Map<Object, Object> map, final WSCredential wSCredential) {
        final Subject subject = (Subject)map.get("com.ibm.wsspi.wssecurity.core.subject");
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                if (!subject.getPublicCredentials().contains(wSCredential)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding WSCredential to Subject: " + wSCredential);
                    }
                    subject.getPublicCredentials().add(wSCredential);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WSCredential already in Subject: " + wSCredential);
                }
                return null;
            }
        });
    }

    private static final void addToSubject(Map<Object, Object> map, final SecurityToken securityToken) {
        final Subject subject = (Subject)map.get("com.ibm.wsspi.wssecurity.core.subject");
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                if (!subject.getPrivateCredentials().contains(securityToken)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding Token to Subject: " + securityToken);
                    }
                    subject.getPrivateCredentials().add(securityToken);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Token already in Subject: " + securityToken);
                }
                return null;
            }
        });
    }

    private static final void addToSubject(Map<Object, Object> map, final WSPrincipal wSPrincipal) {
        final Subject subject = (Subject)map.get("com.ibm.wsspi.wssecurity.core.subject");
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                if (!subject.getPrincipals().contains(wSPrincipal)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding WSPrincipal to Subject: " + wSPrincipal);
                    }
                    subject.getPrincipals().add((Principal)wSPrincipal);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WSPrincipal already in Subject: " + wSPrincipal);
                }
                return null;
            }
        });
    }
}

