/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.impl.auth.module;

import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.websphere.wssecurity.wssapi.token.UsernameToken;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.config.CallerConfig;
import java.util.Collection;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.xml.namespace.QName;

public class UNTCallerLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(UNTCallerLoginModule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private String comp = "security.wssecurity";
    private Map _sharedState;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options)");
        }
        this._sharedState = map;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(Subject, CallbackHandler, Map, Map)");
        }
    }

    public boolean login() throws LoginException {
        Boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login()");
        }
        if ((bl = (Boolean)this._sharedState.get(Constants.WSSECURITY_CALLER_PROCESS_DONE)) == null || !bl.booleanValue()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Caller identification process is not done yet. So the process of this login module is continued.");
            }
            CallerConfig callerConfig = (CallerConfig)this._sharedState.get("com.ibm.wsspi.wssecurity.core.config.callerConfig.configKey");
            Collection collection = (Collection)this._sharedState.get(Constants.WSSECURITY_CALLER_IDENTITY_CANDIDATES);
            Collection collection2 = (Collection)this._sharedState.get(Constants.WSSECURITY_TRUSTED_IDENTITY_CANDIDATES);
            Collection collection3 = (Collection)this._sharedState.get(Constants.WSSECURITY_TRUSTED_IDENTITY_LIST);
            SecurityToken securityToken = null;
            Object object = null;
            if (callerConfig.useIdentityAssertion()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Identity Assertion IS used.");
                }
                if (callerConfig.trustAnyTrustedIdentity()) {
                    QName qName;
                    boolean bl2;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Any trusted identity is trusted in an unconditional way.");
                        Tr.debug(tc, "Checking caller identity only...");
                    }
                    boolean bl3 = bl2 = com.ibm.ws.wssecurity.common.Constants.UNTOKEN.equals(qName = callerConfig.getCallerIdentity()) || com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11.equals(qName);
                    if (bl2) {
                        Object object2;
                        for (SecurityToken securityToken2 : collection) {
                            UsernameToken usernameToken;
                            char[] cArray;
                            if (!(securityToken2 instanceof UsernameToken) || (cArray = (usernameToken = (UsernameToken)securityToken2).getPassword()) != null && cArray.length != 0) continue;
                            if (securityToken != null) {
                                String string = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s05");
                                throw new LoginException(string);
                            }
                            securityToken = securityToken2;
                        }
                        if (securityToken == null) {
                            object2 = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s01");
                            throw new LoginException((String)object2);
                        }
                        if (collection2.size() == 0) {
                            object2 = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s02");
                            throw new LoginException((String)object2);
                        }
                        bl = Boolean.TRUE;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found caller identity.");
                        }
                    }
                } else {
                    boolean bl4;
                    Object object3;
                    Object object4;
                    Object object5;
                    QName qName;
                    boolean bl5;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Trusted identity should be also validated.");
                    }
                    boolean bl6 = bl5 = com.ibm.ws.wssecurity.common.Constants.UNTOKEN.equals(qName = callerConfig.getCallerIdentity()) || com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11.equals(qName);
                    if (bl5) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Checking both caller identity and trusted identity...");
                        }
                        if (collection3 == null) {
                            String string = ConfigUtil.getMessage(this.comp + ".WSEC6842E");
                            throw new LoginException(string);
                        }
                        object5 = collection.iterator();
                        while (object5.hasNext()) {
                            SecurityToken securityToken3 = (SecurityToken)object5.next();
                            if (!(securityToken3 instanceof UsernameToken) || (object4 = (Object)(object3 = (UsernameToken)securityToken3).getPassword()) != null && ((Object)object4).length != 0) continue;
                            if (securityToken != null) {
                                String string = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s05");
                                throw new LoginException(string);
                            }
                            securityToken = securityToken3;
                        }
                        if (securityToken == null) {
                            object5 = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s01");
                            throw new LoginException((String)object5);
                        }
                    }
                    boolean bl7 = bl4 = com.ibm.ws.wssecurity.common.Constants.UNTOKEN.equals(object5 = callerConfig.getTrustedIdentity()) || com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11.equals(object5);
                    if (bl4) {
                        object3 = collection2.iterator();
                        while (object3.hasNext()) {
                            object4 = (SecurityToken)object3.next();
                            if (!(object4 instanceof UsernameToken)) continue;
                            String string = object4.getPrincipal();
                            UsernameToken usernameToken = (UsernameToken)object4;
                            char[] cArray = usernameToken.getPassword();
                            if (cArray == null || cArray.length <= 0) continue;
                            if (!collection3.contains(string)) {
                                String string2 = string + "is not a trusted id";
                                throw new LoginException(string2);
                            }
                            if (object != null) {
                                String string3 = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s04");
                                throw new LoginException(string3);
                            }
                            object = object4;
                        }
                        if (object == null) {
                            object3 = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s02");
                            throw new LoginException((String)object3);
                        }
                    }
                    if (bl5 && bl4) {
                        bl = Boolean.TRUE;
                    } else if (bl5) {
                        object3 = (SecurityToken)this._sharedState.get(Constants.WSSECURITY_TRUSTED_IDENTITY);
                        if (object3 != null) {
                            bl = Boolean.TRUE;
                        }
                    } else if (bl4 && (object3 = (SecurityToken)this._sharedState.get(Constants.WSSECURITY_CALLER_IDENTITY)) != null) {
                        bl = Boolean.TRUE;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found both caller identity and trusted identity.");
                    }
                }
            } else {
                QName qName;
                boolean bl8;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Identity Assertion IS NOT used.");
                }
                boolean bl9 = bl8 = com.ibm.ws.wssecurity.common.Constants.UNTOKEN.equals(qName = callerConfig.getCallerIdentity()) || com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11.equals(qName);
                if (bl8) {
                    for (SecurityToken securityToken4 : collection) {
                        UsernameToken usernameToken;
                        char[] cArray;
                        if (!(securityToken4 instanceof UsernameToken) || (cArray = (usernameToken = (UsernameToken)securityToken4).getPassword()) == null || cArray.length <= 0) continue;
                        if (securityToken != null) {
                            String string = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s05");
                            throw new LoginException(string);
                        }
                        securityToken = securityToken4;
                    }
                    if (securityToken == null) {
                        String string = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s01");
                        throw new LoginException(string);
                    }
                    bl = Boolean.TRUE;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found caller identity.");
                    }
                }
            }
            if (bl != null && bl.booleanValue()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Logged that caller identification process is successfully done.");
                }
                this._sharedState.put(Constants.WSSECURITY_CALLER_PROCESS_DONE, bl);
            }
            if (securityToken != null) {
                Tr.debug(tc, "Stored the caller identity [" + securityToken + "].");
                this._sharedState.put(Constants.WSSECURITY_CALLER_IDENTITY, securityToken);
            }
            if (object != null) {
                Tr.debug(tc, "Stored the trusted identity [" + object + "].");
                this._sharedState.put(Constants.WSSECURITY_TRUSTED_IDENTITY, object);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Since caller identification process is successfully done, the process of this login module is skipped.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login()");
        }
        return true;
    }

    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return true;
    }

    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return false;
    }

    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return false;
    }
}

