/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.impl.auth.module;

import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.impl.auth.callback.STSRulesCallback;
import com.ibm.ws.wssecurity.trust.server.sts.STSCallbackHandler;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCT;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenImpl;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.Identity;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.IdentityList;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.IdentityPart;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class STSDefaultLoginModule
implements LoginModule {
    private CallbackHandler handler;
    private static final TraceComponent tc = Tr.register(STSDefaultLoginModule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    @Override
    public boolean abort() throws LoginException {
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        return true;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> map, Map<String, ?> map2) {
        STSDefaultLoginModule.trDebug("initialize: callbackHandler.getClass(): " + callbackHandler.getClass().getName());
        this.handler = callbackHandler;
        STSDefaultLoginModule.trDebug("initialize: handler.getClass(): " + this.handler.getClass().getName());
    }

    @Override
    public boolean login() throws LoginException {
        String string = "login";
        STSDefaultLoginModule.trEntry(string);
        if (this.handler == null) {
            STSDefaultLoginModule.trDebug("Login module has not yet been initialized (CallbackHandler is null).");
            STSDefaultLoginModule.trExit(string);
            throw new LoginException();
        }
        Callback[] callbackArray = new Callback[1];
        STSDefaultLoginModule.trDebug("handler.getClass(): " + this.handler.getClass().getName());
        if (this.handler instanceof STSCallbackHandler) {
            STSDefaultLoginModule.trDebug("handler instanceof STSCallbackHandler is true");
        } else {
            STSDefaultLoginModule.trDebug("handler instanceof STSCallbackHandler is false");
        }
        STSDefaultLoginModule.trDebug("Adding STSRulesCallback callback to list of callbacks to handle.");
        callbackArray[0] = new STSRulesCallback();
        STSDefaultLoginModule.trDebug("Invoking the CallbackHandler.");
        try {
            this.handler.handle(callbackArray);
        }
        catch (Exception exception) {
            STSDefaultLoginModule.trDebug("CallbackHandler failed with exception: " + exception.getLocalizedMessage());
            STSDefaultLoginModule.trExit(string);
            throw new LoginException();
        }
        STSRulesCallback sTSRulesCallback = (STSRulesCallback)callbackArray[0];
        if (!sTSRulesCallback.isSuccessful()) {
            STSDefaultLoginModule.trDebug("CallbackHandler returned with failure.");
            STSDefaultLoginModule.trExit(string);
            throw new LoginException();
        }
        STSDefaultLoginModule.trDebug("CallbackHandler returned successfully.");
        IdentityList identityList = sTSRulesCallback.getRules();
        if (identityList == null) {
            STSDefaultLoginModule.trDebug("No rules exist therefore bypassing security check");
        } else {
            SecurityToken securityToken = sTSRulesCallback.getToken();
            if (securityToken == null) {
                STSDefaultLoginModule.trDebug("Rules exist and token is null");
                STSDefaultLoginModule.trExit(string);
                throw new LoginException();
            }
            ArrayList<String> arrayList = null;
            Class<?> clazz = securityToken.getClass();
            STSDefaultLoginModule.trDebug("token is of type: " + clazz.getName());
            try {
                if (SCT.class.isAssignableFrom(clazz)) {
                    arrayList = ((SCT)securityToken).getAppliesToList();
                    STSDefaultLoginModule.trDebug("principalList: " + arrayList);
                }
                if (!SecurityTokenImpl.class.isAssignableFrom(clazz)) {
                    STSDefaultLoginModule.trDebug("token not a SecurityTokenImpl, unable to getPrincipal");
                    throw new LoginException();
                }
                String string2 = securityToken.getPrincipal();
                STSDefaultLoginModule.trDebug("token.getPrincipal(): " + string2);
                arrayList = new ArrayList<String>();
                arrayList.add(string2);
            }
            catch (Exception exception) {
                STSDefaultLoginModule.trDebug("exception caught while getting token principal: " + exception.getMessage());
                throw new LoginException();
            }
            int n = 0;
            while (n < arrayList.size()) {
                STSDefaultLoginModule.trDebug("principal.get(" + n + "): " + arrayList.get(n));
            }
            STSDefaultLoginModule.trDebug("Searching through identity rules for match to principal.");
            STSDefaultLoginModule.trDebug("This login module implementation requires matching principal values to pass. All IdentityParts of an Identity must be satisfied.");
            List<Identity> list = identityList.getIdentity();
            Iterator<Identity> iterator = list.iterator();
            boolean bl = false;
            block5: while (iterator.hasNext()) {
                Identity identity = iterator.next();
                List<IdentityPart> list2 = identity.getIdentityPart();
                if (list2.size() != 1) {
                    STSDefaultLoginModule.trDebug("Found an Identity with more than one IdentityPart. This will not be satisfied. Moving on to the next Identity.");
                    continue;
                }
                IdentityPart identityPart = list2.get(0);
                String string3 = identityPart.getName();
                String string4 = identityPart.getValue();
                STSDefaultLoginModule.trDebug("Listing IdentityPart.");
                STSDefaultLoginModule.trDebug("  Name: " + string3 + "  Value: " + string4);
                int n2 = 0;
                while (n2 < arrayList.size()) {
                    if (string3.equals("Principal") && string4.equals(arrayList.get(n2))) {
                        STSDefaultLoginModule.trDebug("Found a match!");
                        bl = true;
                        continue block5;
                    }
                    STSDefaultLoginModule.trDebug("Does not match.");
                }
            }
            if (!bl) {
                STSDefaultLoginModule.trDebug("Could not find a match. Login failed.");
                STSDefaultLoginModule.trExit(string);
                throw new LoginException();
            }
        }
        STSDefaultLoginModule.trDebug("Login successful!");
        STSDefaultLoginModule.trExit(string);
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        return true;
    }

    private static void trEntry(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
    }

    private static void trExit(String string) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    private static void trDebug(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string);
        }
    }
}

