/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.impl.auth.module;

import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.common.Result;
import com.ibm.ws.wssecurity.common.ResultPool;
import com.ibm.ws.wssecurity.impl.auth.callback.TrustedIdentityCallback;
import com.ibm.ws.wssecurity.token.AuthResult;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.config.CallerConfig;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class PreCallerLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(PreCallerLoginModule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private String comp = "security.wssecurity";
    private CallbackHandler _handler;
    private Map _sharedState;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options)");
        }
        this._handler = callbackHandler;
        this._sharedState = map;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(Subject, CallbackHandler, Map, Map)");
        }
    }

    public boolean login() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login()");
        }
        TrustedIdentityCallback trustedIdentityCallback = new TrustedIdentityCallback();
        PropertyCallback propertyCallback = new PropertyCallback(null);
        Callback[] callbackArray = new Callback[]{trustedIdentityCallback, propertyCallback};
        try {
            this._handler.handle(callbackArray);
        }
        catch (Exception exception) {
            throw new LoginException(ConfigUtil.getMessage(this.comp + ".BSTokenLoginModule.s01", new String[]{exception.toString()}));
        }
        Set<String> set = trustedIdentityCallback.getIdentityList();
        Map<Object, Object> map = propertyCallback.getProperties();
        CallerConfig callerConfig = (CallerConfig)map.get("com.ibm.wsspi.wssecurity.core.config.callerConfig.configKey");
        Result[] resultArray = ResultPool.get(map, AuthResult.class);
        int n = resultArray.length;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The length of auth results = " + n);
        }
        if (n == 0) {
            String string = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s01");
            throw new LoginException(string);
        }
        HashSet<SecurityToken> hashSet = new HashSet<SecurityToken>();
        HashSet<SecurityToken> hashSet2 = new HashSet<SecurityToken>();
        if (callerConfig.useIdentityAssertion()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Identity Assertion IS used.");
            }
            if (callerConfig.trustAnyTrustedIdentity()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Any trusted identity is trusted in an unconditional way.");
                    Tr.debug(tc, "Checking caller identity only...");
                }
                for (int i = 0; i < n; ++i) {
                    AuthResult authResult = (AuthResult)resultArray[i];
                    if (!authResult.isCallerIdentityCandidate()) continue;
                    SecurityTokenWrapper securityTokenWrapper = authResult.getTokenWrapper();
                    SecurityToken securityToken = securityTokenWrapper.getSecurityToken();
                    if (securityToken == null) {
                        String string = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s03");
                        throw new LoginException(string);
                    }
                    hashSet.add(securityToken);
                }
                if (hashSet.size() == 0) {
                    String string = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s01");
                    throw new LoginException(string);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Trusted identity should be also validated.");
                }
                for (int i = 0; i < n; ++i) {
                    SecurityToken securityToken;
                    SecurityTokenWrapper securityTokenWrapper;
                    AuthResult authResult = (AuthResult)resultArray[i];
                    if (authResult.isCallerIdentityCandidate()) {
                        securityTokenWrapper = authResult.getTokenWrapper();
                        securityToken = securityTokenWrapper.getSecurityToken();
                        if (securityToken == null) {
                            String string = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s03");
                            throw new LoginException(string);
                        }
                        hashSet.add(securityToken);
                    }
                    if (!authResult.isTrustedIdentityCandidate()) continue;
                    securityTokenWrapper = authResult.getTokenWrapper();
                    securityToken = securityTokenWrapper.getSecurityToken();
                    if (securityToken == null) {
                        String string = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s03");
                        throw new LoginException(string);
                    }
                    hashSet2.add(securityToken);
                }
                if (hashSet.size() == 0) {
                    String string = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s01");
                    throw new LoginException(string);
                }
                if (hashSet2.size() == 0) {
                    String string = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s02");
                    throw new LoginException(string);
                }
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Identity Assertion IS NOT used.");
                Tr.debug(tc, "Checking caller identity only...");
            }
            for (int i = 0; i < n; ++i) {
                AuthResult authResult = (AuthResult)resultArray[i];
                if (!authResult.isCallerIdentityCandidate()) continue;
                SecurityTokenWrapper securityTokenWrapper = authResult.getTokenWrapper();
                SecurityToken securityToken = securityTokenWrapper.getSecurityToken();
                if (securityToken == null) {
                    String string = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s03");
                    throw new LoginException(string);
                }
                hashSet.add(securityToken);
            }
            if (hashSet.size() == 0) {
                String string = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s01");
                throw new LoginException(string);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Stored the callbacks [" + callbackArray + "].");
        }
        this._sharedState.put("Callback", callbackArray);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Stored the caller configuration [" + callerConfig + "].");
        }
        this._sharedState.put("com.ibm.wsspi.wssecurity.core.config.callerConfig.configKey", callerConfig);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Stored the caller identity candidates [" + hashSet + "].");
        }
        this._sharedState.put(Constants.WSSECURITY_CALLER_IDENTITY_CANDIDATES, hashSet);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Stored the trusted identity candidates [" + hashSet2 + "].");
        }
        this._sharedState.put(Constants.WSSECURITY_TRUSTED_IDENTITY_CANDIDATES, hashSet2);
        if (set != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Stored the trusted identity list [" + set + "].");
            }
            this._sharedState.put(Constants.WSSECURITY_TRUSTED_IDENTITY_LIST, set);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login()");
        }
        return true;
    }

    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return true;
    }

    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return false;
    }

    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return false;
    }
}

