/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.impl.auth.module;

import com.ibm.websphere.wssecurity.wssapi.token.LTPAPropagationToken;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.config.CallerConfig;
import java.util.Collection;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.xml.namespace.QName;

public class LTPAPropagationCallerLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(LTPAPropagationCallerLoginModule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private String comp = "security.wssecurity";
    private Map _sharedState;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options)");
        }
        this._sharedState = map;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(Subject, CallbackHandler, Map, Map)");
        }
    }

    public boolean login() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login()");
        }
        boolean bl = true;
        Boolean bl2 = (Boolean)this._sharedState.get(Constants.WSSECURITY_CALLER_PROCESS_DONE);
        if (bl2 == null || !bl2.booleanValue()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Caller identification process is not done yet. So the process of this login module is continued.");
            }
            CallerConfig callerConfig = (CallerConfig)this._sharedState.get("com.ibm.wsspi.wssecurity.core.config.callerConfig.configKey");
            Collection collection = (Collection)this._sharedState.get(Constants.WSSECURITY_CALLER_IDENTITY_CANDIDATES);
            Collection collection2 = (Collection)this._sharedState.get(Constants.WSSECURITY_TRUSTED_IDENTITY_CANDIDATES);
            Collection collection3 = (Collection)this._sharedState.get(Constants.WSSECURITY_TRUSTED_IDENTITY_LIST);
            SecurityToken securityToken = null;
            SecurityToken securityToken2 = null;
            if (callerConfig.useIdentityAssertion()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Identity Assertion IS used.");
                }
                if (callerConfig.trustAnyTrustedIdentity()) {
                    QName qName;
                    boolean bl3;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Any trusted identity is trusted in an unconditional way.");
                        Tr.debug(tc, "Checking caller identity only...");
                    }
                    if (bl3 = com.ibm.ws.wssecurity.common.Constants.LTPA_TOKEN_PROPAGATION.equals(qName = callerConfig.getCallerIdentity())) {
                        Object object;
                        for (SecurityToken securityToken3 : collection) {
                            if (!(securityToken3 instanceof LTPAPropagationToken)) continue;
                            if (securityToken != null) {
                                String string = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s05");
                                throw new LoginException(string);
                            }
                            securityToken = securityToken3;
                        }
                        if (securityToken == null) {
                            object = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s01");
                            throw new LoginException((String)object);
                        }
                        if (collection2.size() == 0) {
                            object = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s02");
                            throw new LoginException((String)object);
                        }
                        bl2 = Boolean.TRUE;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found caller identity.");
                        }
                    }
                } else {
                    Object object;
                    boolean bl4;
                    Object object2;
                    QName qName;
                    boolean bl5;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Trusted identity should be also validated.");
                    }
                    if (bl5 = com.ibm.ws.wssecurity.common.Constants.LTPA_TOKEN_PROPAGATION.equals(qName = callerConfig.getCallerIdentity())) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Checking both caller identity and trusted identity...");
                        }
                        if (collection3 == null) {
                            String string = ConfigUtil.getMessage(this.comp + ".WSEC6842E");
                            throw new LoginException(string);
                        }
                        object2 = collection.iterator();
                        while (object2.hasNext()) {
                            SecurityToken securityToken4 = (SecurityToken)object2.next();
                            if (!(securityToken4 instanceof LTPAPropagationToken)) continue;
                            if (securityToken != null) {
                                String string = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s05");
                                throw new LoginException(string);
                            }
                            securityToken = securityToken4;
                        }
                        if (securityToken == null) {
                            object2 = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s01");
                            throw new LoginException((String)object2);
                        }
                    }
                    if (bl4 = com.ibm.ws.wssecurity.common.Constants.LTPA_TOKEN_PROPAGATION.equals(object2 = callerConfig.getTrustedIdentity())) {
                        object = collection2.iterator();
                        while (object.hasNext()) {
                            SecurityToken securityToken5 = (SecurityToken)object.next();
                            if (!(securityToken5 instanceof LTPAPropagationToken)) continue;
                            String string = securityToken5.getPrincipal();
                            if (!collection3.contains(string)) {
                                String string2 = string + "is not a trusted id";
                                throw new LoginException(string2);
                            }
                            if (securityToken2 != null) {
                                String string3 = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s04");
                                throw new LoginException(string3);
                            }
                            securityToken2 = securityToken5;
                        }
                        if (securityToken2 == null) {
                            object = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s02");
                            throw new LoginException((String)object);
                        }
                    }
                    if (bl5 && bl4) {
                        bl2 = Boolean.TRUE;
                    } else if (bl5) {
                        object = (SecurityToken)this._sharedState.get(Constants.WSSECURITY_TRUSTED_IDENTITY);
                        if (object != null) {
                            bl2 = Boolean.TRUE;
                        }
                    } else if (bl4 && (object = (SecurityToken)this._sharedState.get(Constants.WSSECURITY_CALLER_IDENTITY)) != null) {
                        bl2 = Boolean.TRUE;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found both caller identity and trusted identity.");
                    }
                }
            } else {
                QName qName;
                boolean bl6;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Identity Assertion IS NOT used.");
                }
                if (bl6 = com.ibm.ws.wssecurity.common.Constants.LTPA_TOKEN_PROPAGATION.equals(qName = callerConfig.getCallerIdentity())) {
                    for (SecurityToken securityToken6 : collection) {
                        if (!(securityToken6 instanceof LTPAPropagationToken)) continue;
                        if (securityToken != null) {
                            String string = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s05");
                            throw new LoginException(string);
                        }
                        securityToken = securityToken6;
                    }
                    if (securityToken == null) {
                        String string = ConfigUtil.getMessage(this.comp + ".LoginProcessor.s01");
                        throw new LoginException(string);
                    }
                    bl2 = Boolean.TRUE;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found caller identity.");
                    }
                }
            }
            if (bl2 != null && bl2.booleanValue()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Logged that caller identification process is successfully done.");
                }
                this._sharedState.put(Constants.WSSECURITY_CALLER_PROCESS_DONE, bl2);
            }
            if (securityToken != null) {
                Tr.debug(tc, "Stored the caller identity [" + securityToken + "].");
                this._sharedState.put(Constants.WSSECURITY_CALLER_IDENTITY, securityToken);
            }
            if (securityToken2 != null) {
                Tr.debug(tc, "Stored the trusted identity [" + securityToken2 + "].");
                this._sharedState.put(Constants.WSSECURITY_TRUSTED_IDENTITY, securityToken2);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Since caller identification process is successfully done, the process of this login module is skipped.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login()");
        }
        return bl;
    }

    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return true;
    }

    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return false;
    }

    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return false;
    }
}

