/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.impl.auth.callback;

import com.ibm.security.trust10.TrustException;
import com.ibm.security.trust10.client.STSRequestorFactory;
import com.ibm.security.trust10.client.om.RSTTemplateImpl;
import com.ibm.security.trust10.client.om.STSConfigImpl;
import com.ibm.security.trust10.types.IRequestSecurityTokenResponse;
import com.ibm.security.trust10.types.IRequestSecurityTokenResponseCollection;
import com.ibm.security.trust10.types.IRequestedSecurityToken;
import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateGeneratorConfig;
import com.ibm.ws.wssecurity.handler.PolicyConfigUtil;
import com.ibm.ws.wssecurity.handler.PolicyOutboundConfig;
import com.ibm.ws.wssecurity.impl.auth.callback.SCTCallback;
import com.ibm.ws.wssecurity.platform.auth.SecureConversationCacheConfigFactory;
import com.ibm.ws.wssecurity.platform.auth.SecureConversationCacheHelper;
import com.ibm.ws.wssecurity.token.UTC;
import com.ibm.ws.wssecurity.trust.server.sts.Util.STSPolicySetUtil;
import com.ibm.ws.wssecurity.trust.server.sts.Util.STSTokenUtil;
import com.ibm.ws.wssecurity.trust.server.sts.ext.sct.SCTHelper;
import com.ibm.ws.wssecurity.util.Axis2Util;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.SecurityUIDGenerator;
import com.ibm.ws.wssecurity.util.TokenHolder;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCT;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCTGenerateLoginModule;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCTWrapper;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.CallbackHandlerConfig;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.jaxws.ClientConfigurationFactory;

public class WSTrustCallbackHandler
implements CallbackHandler {
    private static final TraceComponent tc = Tr.register(WSTrustCallbackHandler.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSTrustCallbackHandler.class.getName();
    private static long cushion = SecureConversationCacheConfigFactory.getInstance().getSCCacheCushionMilliseconds();
    private CallbackHandlerConfig _config = null;
    private static Map clientIDMap = new HashMap();
    private static Object lockObj = new Object();

    public WSTrustCallbackHandler() {
    }

    public WSTrustCallbackHandler(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSTrustCallbackHandler(Map properties)");
        }
        if (map == null) {
            Tr.error(tc, "context passed into the callback handler is null.");
            this._config = null;
        } else {
            this._config = (CallbackHandlerConfig)map.get("com.ibm.wsspi.wssecurity.impl.config.callbackHandler.configKey");
            if (this._config == null && tc.isDebugEnabled()) {
                Tr.debug(tc, "WARNING: The configuration of callback handler is null.");
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "CallbackHandlerConfig [" + this._config + "].");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSTrustCallbackHandler(Map properties)");
        }
    }

    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        Object object;
        String string;
        boolean bl;
        SCT sCT;
        boolean bl2;
        MessageContext messageContext;
        Object object2;
        HashMap<Object, Object> hashMap;
        SCTCallback sCTCallback;
        block22: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "handle(Callback[] callbacks)");
            }
            if (callbackArray == null || callbackArray.length == 0) {
                throw new UnsupportedCallbackException(null, "There is no callback.");
            }
            sCTCallback = null;
            hashMap = new HashMap<Object, Object>();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, callbackArray.length + " callbacks");
            }
            for (int i = 0; i < callbackArray.length; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "callbacks[" + i + "] is " + callbackArray[i].getClass().getName());
                }
                if (callbackArray[i] instanceof SCTCallback) {
                    sCTCallback = (SCTCallback)callbackArray[i];
                    sCTCallback.setExist(true);
                    continue;
                }
                if (!(callbackArray[i] instanceof PropertyCallback) || (object2 = ((PropertyCallback)callbackArray[i]).getProperties()) == null) continue;
                hashMap.putAll((Map<Object, Object>)object2);
            }
            messageContext = (MessageContext)hashMap.get("com.ibm.wsspi.wssecurity.core.messageContext");
            object2 = null;
            AxisService axisService = (AxisService)hashMap.get("com.ibm.ws.wssecurity.core.Constants.WSSECURITY_AXIS_SERVICE");
            String string2 = (String)hashMap.get("com.ibm.ws.wssecurity.sc.SCT.Cancel");
            bl2 = false;
            if (string2 != null && string2.equalsIgnoreCase("true")) {
                bl2 = true;
            }
            sCT = (SCT)hashMap.get("com.ibm.ws.wssecurity.core.Constants.WSSECURITY_SCT");
            bl = false;
            try {
                if (messageContext != null) {
                    bl = Axis2Util.isServiceProvider(messageContext);
                    break block22;
                }
                if (axisService != null) {
                    bl = Axis2Util.isServiceProvider(axisService);
                    break block22;
                }
                throw new UnsupportedCallbackException(null, " Unknown Context or Service.");
            }
            catch (Exception exception) {
                throw new UnsupportedCallbackException(null, exception.getMessage());
            }
        }
        if (!bl2 && (object2 = (SCTWrapper)messageContext.getProperty("com.ibm.ws.wssecurity.sc.SCTInUse")) != null && ((SCTWrapper)object2).getSCT() != null && hashMap.get("com.ibm.ws.wssecurity.core.Constants.WSSECURITY_SCT") == null) {
            object2 = (SCTWrapper)messageContext.getProperty("com.ibm.ws.wssecurity.sc.SCTInUse");
            string = ((SCTWrapper)object2).getCurrentInstance();
            sCT = ((SCTWrapper)object2).getSCT();
            object = new Date();
            if (!sCT.isCancelled() && sCT.getExpiration(string).getTime() - ((Date)object).getTime() > 0L) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Valid SCT is already in use by this handler. Use the reference");
                }
                sCTCallback.setToken((SCTWrapper)object2);
                sCTCallback.setExist(true);
                return;
            }
            object2 = null;
            sCT = null;
        }
        string = null;
        if (this._config != null && messageContext != null) {
            string = (String)this._config.getProperties().get("com.ibm.ws.wssecurity.sc.SCTScope");
            messageContext.setProperty("com.ibm.ws.wssecurity.sc.SCTScope", string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SCT Scope property = " + string);
        }
        if (bl) {
            object2 = this.getServerSideSCT(messageContext);
        } else {
            object = (WSSGeneratorConfig)hashMap.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
            if (tc.isDebugEnabled() && object == null) {
                Tr.debug(tc, "null WSSGenerator Config object");
            }
            object2 = this.getClientSideSCT(messageContext, (WSSGeneratorConfig)object, sCT, bl2);
        }
        messageContext.setProperty("com.ibm.ws.wssecurity.sc.SCTInUse", object2);
        sCTCallback.setToken((SCTWrapper)object2);
        sCTCallback.setExist(true);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Succeeded to get necessary information through the callbacks.");
        }
        if (messageContext.getProperty("com.ibm.ws.wssecurity.sc.SCTScope") != null) {
            messageContext.setProperty("com.ibm.ws.wssecurity.sc.SCTScope", null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handle(Callback[] callbacks)");
        }
    }

    private SCTWrapper getClientSideSCT(MessageContext messageContext, WSSGeneratorConfig wSSGeneratorConfig, SCT sCT, boolean bl) throws IOException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "client side. Getting SCToken from global cache");
        }
        if (sCT == null) {
            sCT = (SCT)SecureConversationCacheHelper.getSecurityContextTokenFromCacheByContext(messageContext);
        }
        SCTWrapper sCTWrapper = null;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = this.isCancelInProgress(messageContext);
        if (!bl6 && sCT != null) {
            bl5 = sCT.isCancelled();
        }
        String string = null;
        Date date = new Date();
        if (sCT != null) {
            string = this.searchInstanceList(sCT);
            if (string == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Security context token is expired, try to renew the token");
                }
                if (!sCT.isRenewableAfterExpiration()) {
                    Tr.info(tc, "security.wssecurity.WSTrustCallbackHandler.expiredSCT");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Security Context Token is expired and is not renewable after expiration. Issuing new SCT.");
                    }
                    bl4 = true;
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Security context token is expired, try to renew the token");
                    }
                    bl3 = true;
                }
            } else if (!bl5) {
                if (sCT.isValid(string, 0L)) {
                    if (sCT.getExpiration(string).getTime() - date.getTime() > cushion) {
                        bl2 = true;
                        sCTWrapper = this.createSCTWrapper(sCT, string);
                        sCTWrapper.setSCT(sCT);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Client side cache. Security context token is a valid token and instance = " + string);
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Client side cache. Security context token is about to expire. Renew the token");
                        }
                        if (sCT.isRenewable()) {
                            bl3 = true;
                        } else {
                            Tr.info(tc, "security.wssecurity.WSEC7235I");
                            bl4 = true;
                        }
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Security context token is expired, try to renew the token");
                    }
                    if (!sCT.isRenewableAfterExpiration()) {
                        Tr.info(tc, "security.wssecurity.WSTrustCallbackHandler.expiredSCT");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Security Context Token is expired and is not renewable after expiration. Issuing new SCT.");
                        }
                        bl4 = true;
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Security context token is expired, renewing the token");
                        }
                        bl3 = true;
                    }
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SCT is cancelled, issuing new SCT");
                }
                bl4 = true;
            }
        } else {
            bl4 = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No Security Context Token found in  client side cache, Issue new SCT.");
            }
        }
        if (bl4 && bl) {
            Tr.info(tc, "security.wssecurity.WSEC7234I");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The specified SCT for cancel is either invalidated or could not be renewed. Cancel is not processed.");
            }
            return sCTWrapper;
        }
        try {
            if (bl4 || bl3) {
                boolean bl7 = false;
                String string2 = null;
                if (!"SERVICE_SCOPE".equalsIgnoreCase((String)messageContext.getProperty("com.ibm.ws.wssecurity.sc.SCTScope")) && (string2 = SecureConversationCacheHelper.computeKey(messageContext)) != null) {
                    bl7 = WSTrustCallbackHandler.hasBeenRequested(string2);
                }
                if (bl7) {
                    try {
                        Thread.sleep(300000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Other thread already obtain SCT for this client. Getting SCT from cache now.");
                    }
                    sCT = (SCT)SecureConversationCacheHelper.getSecurityContextTokenFromCacheByContext(messageContext);
                    string = this.searchInstanceList(sCT);
                    sCTWrapper = this.createSCTWrapper(sCT, string);
                    sCTWrapper.setSCT(sCT);
                } else {
                    try {
                        sCTWrapper = this.obtainSCT(messageContext, sCT, wSSGeneratorConfig, bl4, bl3, bl);
                        sCT = sCTWrapper.getSCT();
                        SecureConversationCacheHelper.setSecurityContextTokenToCache(sCT.getIdentifier(), messageContext, sCT, null);
                        WSTrustCallbackHandler.wakeupOtherRequests(string2);
                    }
                    catch (Exception exception) {
                        if (string2 != null) {
                            WSTrustCallbackHandler.wakeupOtherRequests(string2);
                        }
                        throw new SoapSecurityException(exception.getMessage());
                    }
                }
            }
            if (bl) {
                sCTWrapper = this.cancelSCToken(wSSGeneratorConfig, sCT);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "handle(Callback[] callbacks). SCT cancelled.");
                }
                return sCTWrapper;
            }
        }
        catch (SoapSecurityException soapSecurityException) {
            throw new IOException(ConfigUtil.getMessage("security.wssecurity.SCTGenerateLoginModule.issueSCT", new String[]{soapSecurityException.toString()}));
        }
        if (sCT != null) {
            if (sCT.getExpiration(sCTWrapper.getCurrentInstance()).getTime() - sCT.getCreation(sCTWrapper.getCurrentInstance()).getTime() < cushion) {
                Tr.error(tc, "security.wssecurity.WSTrustCallbackHandler.clientCushionAndSCT");
                throw new IOException(ConfigUtil.getMessage("security.wssecurity.WSTrustCallbackHandler.clientCushionAndSCT"));
            }
            HashMap<String, String> hashMap = null;
            hashMap = (HashMap<String, String>)messageContext.getProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP");
            if (hashMap == null) {
                hashMap = new HashMap<String, String>();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Save the sct uuid and instance in the wss-ramp propertymap");
                }
            }
            hashMap.put("com.ibm.ws.wssecurity.sc.CurrentInstance", sCTWrapper.getCurrentInstance());
            hashMap.put(Constants.WSSECURITY_SECURECONVERSATION_IDENTIFIER, sCT.getUUID());
            messageContext.setProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP", hashMap);
        }
        return sCTWrapper;
    }

    private SCTWrapper obtainSCT(MessageContext messageContext, SCT sCT, WSSGeneratorConfig wSSGeneratorConfig, boolean bl, boolean bl2, boolean bl3) throws SoapSecurityException {
        SCTWrapper sCTWrapper = null;
        if (bl) {
            sCTWrapper = this.issueSCToken(messageContext, wSSGeneratorConfig);
        } else if (bl2) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SCT is expired or about to expire = " + sCT.getUUID());
            }
            try {
                sCTWrapper = this.renewSCToken(messageContext, wSSGeneratorConfig, sCT);
            }
            catch (Exception exception) {
                bl = true;
                if (bl3) {
                    Tr.info(tc, "security.wssecurity.WSEC7234I");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The specified SCT for cancel is either invalidated or could not be renewed. Cancel is not processed.");
                    }
                    return sCTWrapper;
                }
                Tr.info(tc, "security.wssecurity.WSEC7235I");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The specified SCT " + sCT.getIdentifier() + " could not be renewed. A new SCT will be issued.");
                }
                sCTWrapper = this.issueSCToken(messageContext, wSSGeneratorConfig);
            }
        }
        return sCTWrapper;
    }

    private SCTWrapper getServerSideSCT(MessageContext messageContext) throws IOException {
        String string = null;
        String string2 = null;
        HashMap hashMap = null;
        SCTWrapper sCTWrapper = null;
        SCT sCT = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Getting SCT from trust service directly.");
        }
        string = TokenHolder.getTokenFromContext("INBOUND_SCTOKEN", messageContext);
        string2 = TokenHolder.getInstanceFromContext(messageContext);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Found SCT uuid in inbound message context:" + string);
            Tr.debug(tc, "Found Key instance uuid in inbound message context:" + string2);
        }
        if (string == null && (hashMap = (HashMap)messageContext.getProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP")) != null) {
            string = (String)hashMap.get(Constants.WSSECURITY_SECURECONVERSATION_IDENTIFIER);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found SCT uuid in WSS_RAMP_PROPERTYMAP:" + string);
            }
        }
        if (string != null) {
            if (SCTHelper.getCache() != null) {
                sCT = (SCT)SCTHelper.getCache().getToken(string);
            }
            if (sCT == null) {
                sCT = (SCT)STSTokenUtil.getToken(string, "http://schemas.xmlsoap.org/ws/2005/02/sc/sct");
            }
        }
        if (sCT == null) {
            Tr.error(tc, "security.wssecurity.SCTConsumeLoginModule.invalidSCT02");
            throw new IOException(ConfigUtil.getMessage("security.wssecurity.SCTConsumeLoginModule.invalidSCT02"));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Server side. Got SCToken from message context and uuid = " + sCT.getUUID());
            Tr.debug(tc, "Got token from message context and instance = " + string2);
        }
        if (string2 == null) {
            string2 = this.searchExistingInstance(sCT);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "using latest key instance (must do this for RAMP...):" + string2);
            }
        }
        if (sCT != null && sCT.isValid(string2, 0L) && !sCT.isCancelled()) {
            sCTWrapper = this.createSCTWrapper(sCT, string2);
            sCTWrapper.setSCT(sCT);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Server side. Security context token is a valid token");
            }
        } else {
            throw new IOException(ConfigUtil.getMessage("security.wssecurity.SCTConsumeLoginModule.invalidSCT02"));
        }
        return sCTWrapper;
    }

    private SCTWrapper issueSCToken(MessageContext messageContext, WSSGeneratorConfig wSSGeneratorConfig) throws SoapSecurityException {
        Object object;
        Object object2;
        Object object3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "requestSCToken()");
        }
        ConfigurationContext configurationContext = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        SCT sCT = null;
        SCTWrapper sCTWrapper = null;
        boolean bl = false;
        String string4 = "true";
        String string5 = "false";
        String string6 = null;
        configurationContext = messageContext.getConfigurationContext();
        if (tc.isDebugEnabled()) {
            if (!configurationContext.getAxisConfiguration().getEngagedModules().isEmpty()) {
                object3 = configurationContext.getAxisConfiguration().getEngagedModules().iterator();
                while (object3.hasNext()) {
                    Tr.debug(tc, "Engaged Module = ", object3.next());
                }
            }
            if (wSSGeneratorConfig == null) {
                Tr.debug(tc, "Null security generator config to new message context");
            } else {
                Tr.debug(tc, "Valid security generator config to new message context");
            }
        }
        object3 = null;
        if (wSSGeneratorConfig != null && ((PrivateGeneratorConfig)wSSGeneratorConfig).getBootstrapGeneratorConfig() != null && ((PrivateGeneratorConfig)wSSGeneratorConfig).getBootstrapConsumerConfig() != null) {
            bl = true;
            object3 = ((PolicyOutboundConfig)wSSGeneratorConfig).getAlgorithmSuite();
        }
        String string7 = "http://www.w3.org/2005/08/addressing/anonymous";
        if (wSSGeneratorConfig != null) {
            string2 = ((PolicyOutboundConfig)wSSGeneratorConfig).getSCTIssuer();
            if (tc.isDebugEnabled() && string2 != null && string2.length() > 0) {
                Tr.debug(tc, "SCT Issuer from policy is:" + string2);
            }
        }
        if (string2 == null || string2.length() == 0) {
            if (messageContext.getTo() != null) {
                string2 = messageContext.getTo().getAddress();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The End Point Address (from mc) is: " + string2);
                }
            } else {
                object2 = messageContext.getOptions();
                if (object2 != null) {
                    string2 = ((Options)object2).getTo().getAddress();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The End Point Address (from options, from mc returns null) is: " + string2);
                }
            }
        }
        string = messageContext.getEnvelope().getNamespace().getName();
        string3 = (String)messageContext.getProperty("WSAddressingVersion");
        if (string3 == null || string3.length() == 0) {
            string3 = com.ibm.ws.wssecurity.common.Constants.NS_WSADDRS[0];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No namespace defined for WS-Addressing on the message context.");
                Tr.debug(tc, "Setting final WS-Addressing level in the trust service request." + string3);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Namespace for WS-Addressing [" + string3 + "]. This will be set on trust service request");
        }
        object2 = new RSTTemplateImpl();
        object2.set("TokenType", "http://schemas.xmlsoap.org/ws/2005/02/sc/sct");
        object2.set("RequestType", "http://schemas.xmlsoap.org/ws/2005/02/trust/Issue");
        String string8 = null;
        int n = 0;
        string8 = PolicyConfigUtil.getMinimumSymmetricKeyLength((String)object3);
        n = Integer.parseInt(string8);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Key Size (in bits) based on the algorihthm Suite, " + (String)object3 + " = " + n);
        }
        object2.set("AppliesTo", string2);
        object2.set("Entropy", "BinarySecret");
        object2.set("BinarySecret", "/Nonce");
        object2.set("EntropyLength", string8);
        object2.setKeySize(string8);
        STSConfigImpl sTSConfigImpl = null;
        try {
            sTSConfigImpl = new STSConfigImpl();
            object = SecurityUIDGenerator.createUID();
            sTSConfigImpl.set("MESSAGE_ID", (String)object);
            sTSConfigImpl.set("MESSAGE_REPLYTO", string7);
            sTSConfigImpl.set("MESSAGE_TO", string2);
            sTSConfigImpl.set("MESSAGE_ACTION", "http://schemas.xmlsoap.org/ws/2005/02/trust/RST/SCT");
            sTSConfigImpl.set("soap_level", string);
            sTSConfigImpl.set("addressing_level", string3);
            sTSConfigImpl.set("CONTEXT_URI", "http://www.ibm.com/login/");
            sTSConfigImpl.set("STS_NAME", "SSI");
        }
        catch (AxisFault axisFault) {
            throw SoapSecurityException.format("Axis fault during trust client API invocation", axisFault);
        }
        catch (TrustException trustException) {
            throw SoapSecurityException.format("Trust Exception during the trust client API invocation", trustException);
        }
        object = Axis2Util.getPolicySetConfig(messageContext);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("CONFIG_CONTEXT", configurationContext);
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        hashMap2.put("Sandesha2UnreliableMessage", "true");
        hashMap2.put("com.ibm.ws.wssecurity.sc.bootstrapProperty", new Boolean(true));
        if (bl) {
            hashMap2.put("com.ibm.ws.wssecurity.sc.bootstrapAndAppPolicyConfig", wSSGeneratorConfig);
            if (wSSGeneratorConfig instanceof PrivateGeneratorConfig) {
                hashMap2.put("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey", ((PrivateGeneratorConfig)wSSGeneratorConfig).getBootstrapConsumerConfig());
            }
        }
        this.copySessionAffinityPropertiesToMap(messageContext, hashMap2);
        HashMap hashMap3 = new HashMap();
        hashMap2.put("SC_COOKIE_MAP", hashMap3);
        hashMap.put("axis2_messagecontext_propertymap", hashMap2);
        hashMap.put("STS_Conf", sTSConfigImpl);
        hashMap.put("RSTTemplate", object2);
        try {
            Object object4;
            Iterator<IRequestSecurityTokenResponse> iterator;
            STSRequestorFactory sTSRequestorFactory = new STSRequestorFactory();
            ServiceClient serviceClient = (ServiceClient)sTSRequestorFactory.init(hashMap);
            AxisService axisService = serviceClient.getAxisService();
            if (axisService != null) {
                axisService.addParameter(new Parameter("WASAxis2PolicySet", object));
                axisService.addParameter(new Parameter("Sandesha2UnreliableMessage", "true"));
            }
            byte[] byArray = sTSRequestorFactory.getEntropyKey();
            byte[] byArray2 = null;
            String string9 = null;
            String string10 = null;
            String string11 = null;
            String string12 = null;
            String string13 = null;
            Date date = null;
            Date date2 = null;
            OMElement oMElement = null;
            IRequestSecurityTokenResponseCollection iRequestSecurityTokenResponseCollection = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "About to call Trust client with Issue request.");
            }
            iRequestSecurityTokenResponseCollection = sTSRequestorFactory.issue(serviceClient);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Trust client Issue is successful.");
            }
            if ((iterator = iRequestSecurityTokenResponseCollection.getRSTRCollection()).hasNext()) {
                Object object5;
                OMElement oMElement2;
                object4 = iterator.next();
                byArray2 = object4.getSecret();
                String string14 = "Lifetime";
                IRequestedSecurityToken iRequestedSecurityToken = object4.getRequestedSecurityToken();
                string12 = object4.getTokenCreated();
                string13 = object4.getTokenExpires();
                if (string12 == null) {
                    Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.getSCTLifetime");
                    throw SoapSecurityException.format("security.wssecurity.SCTGenerateLoginModule.getSCTLifetime");
                }
                date = WSTrustCallbackHandler.parseDateTime(string12);
                if (string13 == null) {
                    Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.getSCTLifetime");
                    throw SoapSecurityException.format("security.wssecurity.SCTGenerateLoginModule.getSCTLifetime");
                }
                date2 = WSTrustCallbackHandler.parseDateTime(string13);
                string14 = "KeySize";
                String string15 = null;
                OMElement oMElement3 = (OMElement)object4.getTokenElement(string14);
                if (oMElement3 != null) {
                    string15 = oMElement3.getText();
                    n = new Integer(string15);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Key Size from the RSTR = " + n);
                    }
                }
                if ((oMElement3 = (OMElement)object4.getTokenElement(string14 = "Renewing")) != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Renewing element from the RSTR looks like: " + DOMUtils.toString(oMElement3));
                    }
                    string5 = oMElement3.getAttributeValue(new QName("", "OK"));
                    string4 = oMElement3.getAttributeValue(new QName("", "Allow"));
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Renew properties of the token, isRenewable =  " + string4 + ", renewableAfterExpiration = " + string5);
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No Renewing information in the RSTR element. ");
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Renew properties of the token, isRenewable =  " + string4 + ", renewableAfterExpiration = " + string5);
                    }
                }
                string14 = "SecurityContextToken";
                oMElement = (OMElement)iRequestedSecurityToken.getTokenElement(string14);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "sct element from the RSTR looks like: " + DOMUtils.toString(oMElement));
                }
                if (oMElement != null) {
                    oMElement2 = DOMUtils.getChildElement(oMElement, com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC, "Identifier");
                    string9 = DOMUtils.getStringValue(oMElement2);
                    object5 = IdUtils.getInstance().getIdAttributeName(oMElement);
                    if (object5 != null) {
                        string10 = oMElement.getAttributeValue((QName)object5);
                    }
                    if ((oMElement2 = DOMUtils.getChildElement(oMElement, com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC, "Instance")) != null) {
                        string11 = DOMUtils.getStringValue(oMElement2);
                    }
                }
                if ((oMElement3 = (OMElement)object4.getTokenElement(string14 = "AppliesTo")) != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "AppliesTo element from the RSTR looks like: " + DOMUtils.toString(oMElement3));
                    }
                    if ((oMElement2 = DOMUtils.getChildElement(oMElement3, string3, "EndpointReference")) != null && tc.isDebugEnabled()) {
                        Tr.debug(tc, "EndpointReference element from the RSTR looks like: " + DOMUtils.toString(oMElement2));
                    }
                    if ((object5 = DOMUtils.getChildElement(oMElement2, string3, "Address")) != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Address element from the RSTR looks like: " + DOMUtils.toString((OMNode)object5));
                        }
                        string6 = DOMUtils.getStringValue((OMNode)object5);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "AppliesTo from the RSTR looks like: " + string6);
                        }
                    }
                } else {
                    boolean bl2 = false;
                    object5 = object4.getExtraElements();
                    while (object5.hasNext()) {
                        oMElement3 = (OMElement)object5.next();
                        if (!"AppliesTo".equals(oMElement3.getLocalName())) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "AppliesTo element from the RSTR looks like: " + DOMUtils.toString(oMElement3));
                        }
                        bl2 = true;
                        break;
                    }
                    if (bl2) {
                        OMElement oMElement4;
                        OMElement oMElement5 = DOMUtils.getChildElement(oMElement3, string3, "EndpointReference");
                        if (oMElement5 != null && tc.isDebugEnabled()) {
                            Tr.debug(tc, "EndpointReference element from the RSTR looks like: " + DOMUtils.toString(oMElement5));
                        }
                        if ((oMElement4 = DOMUtils.getChildElement(oMElement5, string3, "Address")) != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Address element from the RSTR looks like: " + DOMUtils.toString(oMElement4));
                            }
                            string6 = DOMUtils.getStringValue(oMElement4);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "AppliesTo from the RSTR looks like: " + string6);
                            }
                        }
                    }
                }
            }
            sCT = new SCT(string9);
            object4 = null;
            if (string11 == null) {
                string11 = "FristKey_" + string9;
            }
            object4 = new SCT.KeyHistoryEntry(string11, byArray, byArray2, date, date2, SCT.SCTState.ISSUED);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RSTR returns with Requested Security Token: uuid = " + string9 + ", id = " + string10 + ", created = " + date.toString() + ", expires = " + date2.toString() + ", and instance = " + string11);
            }
            sCT.setKeyHistoryEntry((SCT.KeyHistoryEntry)object4);
            sCT.setKeySize(n);
            sCT.setId(string10);
            sCT.setTokenID(string10);
            sCT.setReferenceURI("#" + string10);
            sCT.setUsedForSigAndEnc(true);
            sCT.setClientID(SecureConversationCacheHelper.computeKey(messageContext));
            sCT.setXML(new OMStructure(oMElement));
            if (string6 != null) {
                sCT.setAppliesTo(string6);
            }
            if (string4 != null) {
                sCT.setRenewable(Boolean.valueOf(string4));
            }
            if (string5 != null) {
                sCT.setRenewableAfterExpiration(Boolean.valueOf(string5));
            }
            sCT.setIssuer(string2);
            sCTWrapper = this.createSCTWrapper(sCT, string11);
            sCTWrapper.setSCT(sCT);
            sCTWrapper.setXML(new OMStructure(oMElement));
            this.copySessionAffinityPropertiesFromMap(messageContext, hashMap3);
        }
        catch (SoapSecurityException soapSecurityException) {
            Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.issueSCT", new Object[]{soapSecurityException});
            throw soapSecurityException;
        }
        catch (Exception exception) {
            Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.issueSCT", new Object[]{exception});
            throw SoapSecurityException.format("security.wssecurity.SCTGenerateLoginModule.issueSCT", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "requestSCToken()");
        }
        return sCTWrapper;
    }

    private SCTWrapper renewSCToken(MessageContext messageContext, WSSGeneratorConfig wSSGeneratorConfig, SCT sCT) throws SoapSecurityException {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "requestSCToken()");
        }
        ConfigurationContext configurationContext = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        SCT sCT2 = null;
        SCTWrapper sCTWrapper = null;
        boolean bl = false;
        String string4 = "true";
        String string5 = "false";
        String string6 = "http://www.w3.org/2005/08/addressing/anonymous";
        String string7 = null;
        if (wSSGeneratorConfig != null && ((PrivateGeneratorConfig)wSSGeneratorConfig).getBootstrapGeneratorConfig() != null && ((PrivateGeneratorConfig)wSSGeneratorConfig).getBootstrapConsumerConfig() != null) {
            bl = true;
            string7 = ((PolicyOutboundConfig)wSSGeneratorConfig).getAlgorithmSuite();
        }
        if (messageContext == null) {
            string = com.ibm.ws.wssecurity.common.Constants.NS_SOAP;
            string3 = com.ibm.ws.wssecurity.common.Constants.NS_WSADDRS[0];
            string2 = sCT.getIssuer();
            configurationContext = this.getConfigurationContext(string2);
        } else {
            configurationContext = messageContext.getConfigurationContext();
            if (tc.isDebugEnabled()) {
                if (!configurationContext.getAxisConfiguration().getEngagedModules().isEmpty()) {
                    object2 = configurationContext.getAxisConfiguration().getEngagedModules().iterator();
                    while (object2.hasNext()) {
                        Tr.debug(tc, "Engaged Module = ", object2.next());
                    }
                }
                if (wSSGeneratorConfig == null) {
                    Tr.debug(tc, "Null security generator config to new message context");
                }
            }
            string2 = sCT.getIssuer();
            string = messageContext.getEnvelope().getNamespace().getName();
            string3 = (String)messageContext.getProperty("WSAddressingVersion");
            if (string3 == null || string3.length() == 0) {
                string3 = com.ibm.ws.wssecurity.common.Constants.NS_WSADDRS[0];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No namespace defined for WS-Addressing on the message context.");
                    Tr.debug(tc, "Setting final WS-Addressing level in the trust service request." + string3);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Namespace for WS-Addressing [" + string3 + "]. This will be set on trust service request");
            }
        }
        object2 = null;
        int n = 0;
        object2 = messageContext.getEnvelope().getOMFactory();
        Object object3 = messageContext.getProperty("com.ibm.ws.wssecurity.constants.wssVersion");
        n = 0;
        if (object3 != null && object3 instanceof Integer) {
            n = (Integer)object3;
        }
        OMElement oMElement = SCTGenerateLoginModule.createTokenElement((OMFactory)object2, null, null, sCT.getId(), sCT.getUUID(), null, n);
        RSTTemplateImpl rSTTemplateImpl = new RSTTemplateImpl();
        rSTTemplateImpl.set("AppliesTo", string2);
        rSTTemplateImpl.set("TokenType", "http://schemas.xmlsoap.org/ws/2005/02/sc/sct");
        rSTTemplateImpl.set("RequestType", "http://schemas.xmlsoap.org/ws/2005/02/trust/Renew");
        rSTTemplateImpl.setRenewTarget(oMElement);
        string4 = new Boolean(sCT.isRenewable()).toString();
        string5 = new Boolean(sCT.isRenewableAfterExpiration()).toString();
        String string8 = null;
        int n2 = 0;
        string8 = PolicyConfigUtil.getMinimumSymmetricKeyLength(string7);
        n2 = Integer.parseInt(string8);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Key Size (in bits) based on the algorihthm Suite, " + string7 + " = " + n2);
        }
        rSTTemplateImpl.set("Entropy", "BinarySecret");
        rSTTemplateImpl.set("BinarySecret", "/Nonce");
        rSTTemplateImpl.set("EntropyLength", string8);
        rSTTemplateImpl.setKeySize(string8);
        STSConfigImpl sTSConfigImpl = null;
        try {
            sTSConfigImpl = new STSConfigImpl();
            object = SecurityUIDGenerator.createUID();
            sTSConfigImpl.set("MESSAGE_ID", (String)object);
            sTSConfigImpl.set("MESSAGE_REPLYTO", string6);
            sTSConfigImpl.set("MESSAGE_TO", string2);
            sTSConfigImpl.set("MESSAGE_ACTION", "http://schemas.xmlsoap.org/ws/2005/02/trust/RST/Renew");
            sTSConfigImpl.set("soap_level", string);
            sTSConfigImpl.set("addressing_level", string3);
            sTSConfigImpl.set("CONTEXT_URI", "http://www.ibm.com/login/");
            sTSConfigImpl.set("STS_NAME", "SSI");
        }
        catch (AxisFault axisFault) {
            throw SoapSecurityException.format("Axis fault during trust client API invocation", axisFault);
        }
        catch (TrustException trustException) {
            throw SoapSecurityException.format("Trust Exception during the trust client API invocation", trustException);
        }
        object = new HashMap();
        object.put("CONFIG_CONTEXT", configurationContext);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("Sandesha2UnreliableMessage", "true");
        hashMap.put("com.ibm.ws.wssecurity.sc.bootstrapProperty", new Boolean(true));
        if (bl) {
            hashMap.put("com.ibm.ws.wssecurity.sc.bootstrapAndAppPolicyConfig", wSSGeneratorConfig);
        }
        this.copySessionAffinityPropertiesToMap(messageContext, hashMap);
        object.put("axis2_messagecontext_propertymap", hashMap);
        object.put("STS_Conf", sTSConfigImpl);
        object.put("RSTTemplate", rSTTemplateImpl);
        PolicySetConfiguration policySetConfiguration = Axis2Util.getPolicySetConfig(messageContext);
        try {
            Object object4;
            Object object5;
            STSRequestorFactory sTSRequestorFactory = new STSRequestorFactory();
            ServiceClient serviceClient = (ServiceClient)sTSRequestorFactory.init((Map)object);
            AxisService axisService = serviceClient.getAxisService();
            if (axisService != null) {
                axisService.addParameter(new Parameter("WASAxis2PolicySet", policySetConfiguration));
                axisService.addParameter(new Parameter("Sandesha2UnreliableMessage", "true"));
            }
            byte[] byArray = sTSRequestorFactory.getEntropyKey();
            byte[] byArray2 = null;
            String string9 = null;
            String string10 = null;
            String string11 = null;
            String string12 = null;
            String string13 = null;
            Date date = null;
            Date date2 = null;
            OMElement oMElement2 = null;
            IRequestSecurityTokenResponseCollection iRequestSecurityTokenResponseCollection = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "About to call Trust client with Renew request.");
            }
            try {
                iRequestSecurityTokenResponseCollection = sTSRequestorFactory.renew(serviceClient);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Trust client Renew is successful.");
                }
            }
            catch (TrustException trustException) {
                throw SoapSecurityException.format("security.wssecurity.WSTrustCallbackHandler.renewSCT", trustException);
            }
            catch (Exception exception) {
                throw SoapSecurityException.format("security.wssecurity.WSTrustCallbackHandler.renewSCT", exception);
            }
            Iterator<IRequestSecurityTokenResponse> iterator = iRequestSecurityTokenResponseCollection.getRSTRCollection();
            if (iterator.hasNext()) {
                object5 = iterator.next();
                byArray2 = object5.getSecret();
                object4 = "Lifetime";
                IRequestedSecurityToken iRequestedSecurityToken = object5.getRequestedSecurityToken();
                string12 = object5.getTokenCreated();
                string13 = object5.getTokenExpires();
                if (string12 == null) {
                    Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.getSCTLifetime");
                    throw SoapSecurityException.format("security.wssecurity.SCTGenerateLoginModule.getSCTLifetime");
                }
                date = WSTrustCallbackHandler.parseDateTime(string12);
                if (string13 == null) {
                    Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.getSCTLifetime");
                    throw SoapSecurityException.format("security.wssecurity.SCTGenerateLoginModule.getSCTLifetime");
                }
                date2 = WSTrustCallbackHandler.parseDateTime(string13);
                object4 = "KeySize";
                String string14 = null;
                OMElement oMElement3 = (OMElement)object5.getTokenElement((String)object4);
                if (oMElement3 != null) {
                    string14 = oMElement3.getText();
                    n2 = new Integer(string14);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Key Size from the RSTR = " + n2);
                    }
                }
                if ((oMElement3 = (OMElement)object5.getTokenElement((String)(object4 = "Renewing"))) != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Renewing element from the RSTR looks like: " + DOMUtils.toString(oMElement3));
                    }
                    string5 = oMElement3.getAttributeValue(new QName("", "OK"));
                    string4 = oMElement3.getAttributeValue(new QName("", "Allow"));
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Renew properties of the token, isRenewable =  " + string4 + ", renewableAfterExpiration = " + string5);
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No Renewing information in the RSTR element. ");
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Renew properties of the token, isRenewable =  " + string4 + ", renewableAfterExpiration = " + string5);
                    }
                }
                object4 = "SecurityContextToken";
                oMElement2 = (OMElement)iRequestedSecurityToken.getTokenElement((String)object4);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "sct element from the RSTR looks like: " + DOMUtils.toString(oMElement2));
                }
                if (oMElement2 != null) {
                    OMElement oMElement4 = DOMUtils.getChildElement(oMElement2, com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC, "Identifier");
                    string9 = DOMUtils.getStringValue(oMElement4);
                    QName qName = IdUtils.getInstance().getIdAttributeName(oMElement2);
                    if (qName != null) {
                        string10 = oMElement2.getAttributeValue(qName);
                    }
                    if ((oMElement4 = DOMUtils.getChildElement(oMElement2, com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC, "Instance")) != null) {
                        string11 = DOMUtils.getStringValue(oMElement4);
                    }
                }
            }
            sCT2 = new SCT(string9);
            if (sCT != null) {
                object5 = (SCT)SecureConversationCacheHelper.getSecurityContextTokenFromCacheByUUID(string9);
                object4 = ((SCT)object5).getInstances();
                for (int i = 0; i < ((String[])object4).length; ++i) {
                    sCT2.setKeyHistoryEntry(((SCT)object5).getKeyHistoryEntry(object4[i]));
                }
            }
            object5 = null;
            object5 = new SCT.KeyHistoryEntry(string11, byArray, byArray2, date, date2, SCT.SCTState.RENEWED);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RSTR returns with Requested Security Token: uuid = " + string9 + ", id = " + string10 + ", created = " + date.toString() + ", expires = " + date2.toString() + ", and instance = " + string11);
            }
            sCT2.setKeyHistoryEntry((SCT.KeyHistoryEntry)object5);
            sCT2.setKeySize(n2);
            sCT2.setId(string10);
            sCT2.setTokenID(string10);
            sCT2.setReferenceURI("#" + string10);
            sCT2.setUsedForSigAndEnc(true);
            sCT2.setXML(new OMStructure(oMElement2));
            if (string4 != null) {
                sCT2.setRenewable(Boolean.valueOf(string4));
            }
            if (string5 != null) {
                sCT2.setRenewableAfterExpiration(Boolean.valueOf(string5));
            }
            sCT2.setIssuer(string2);
            sCT2.setClientID(sCT.getClientID());
            sCTWrapper = this.createSCTWrapper(sCT2, string11);
            sCTWrapper.setSCT(sCT2);
            sCTWrapper.setXML(new OMStructure(oMElement2));
        }
        catch (SoapSecurityException soapSecurityException) {
            Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.issueSCT", new Object[]{soapSecurityException});
            throw soapSecurityException;
        }
        catch (Exception exception) {
            Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.issueSCT", new Object[]{exception});
            throw SoapSecurityException.format("security.wssecurity.SCTGenerateLoginModule.issueSCT", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "requestSCToken()");
        }
        return sCTWrapper;
    }

    private SCTWrapper cancelSCToken(WSSGeneratorConfig wSSGeneratorConfig, SCT sCT) throws SoapSecurityException {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cancelSCToken()");
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        string = com.ibm.ws.wssecurity.common.Constants.NS_SOAP;
        string2 = com.ibm.ws.wssecurity.common.Constants.NS_WSADDRS[0];
        string3 = sCT.getIssuer();
        ConfigurationContext configurationContext = this.getConfigurationContext(string3);
        SCTWrapper sCTWrapper = new SCTWrapper();
        boolean bl = false;
        if (tc.isDebugEnabled()) {
            if (!configurationContext.getAxisConfiguration().getEngagedModules().isEmpty()) {
                object2 = configurationContext.getAxisConfiguration().getEngagedModules().iterator();
                while (object2.hasNext()) {
                    Tr.debug(tc, "Engaged Module = ", object2.next());
                }
            }
            if (wSSGeneratorConfig == null) {
                Tr.debug(tc, "Null security generator config to new message context");
            } else {
                Tr.debug(tc, "Valid security generator config to new message context");
            }
        }
        if (wSSGeneratorConfig != null && ((PrivateGeneratorConfig)wSSGeneratorConfig).getBootstrapGeneratorConfig() != null && ((PrivateGeneratorConfig)wSSGeneratorConfig).getBootstrapConsumerConfig() != null) {
            bl = true;
        }
        object2 = "http://www.w3.org/2005/08/addressing/anonymous";
        RSTTemplateImpl rSTTemplateImpl = new RSTTemplateImpl();
        rSTTemplateImpl.set("TokenType", "http://schemas.xmlsoap.org/ws/2005/02/sc/sct");
        rSTTemplateImpl.set("RequestType", "http://schemas.xmlsoap.org/ws/2005/02/trust/Cancel");
        OMElement oMElement = ((OMStructure)sCT.getXML()).getNode();
        rSTTemplateImpl.setCancelTarget(oMElement);
        STSConfigImpl sTSConfigImpl = null;
        try {
            sTSConfigImpl = new STSConfigImpl();
            object = SecurityUIDGenerator.createUID();
            sTSConfigImpl.set("MESSAGE_ID", (String)object);
            sTSConfigImpl.set("MESSAGE_REPLYTO", (String)object2);
            sTSConfigImpl.set("MESSAGE_TO", string3);
            sTSConfigImpl.set("MESSAGE_ACTION", "http://schemas.xmlsoap.org/ws/2005/02/trust/RST/Cancel");
            sTSConfigImpl.set("soap_level", string);
            sTSConfigImpl.set("addressing_level", string2);
            sTSConfigImpl.set("CONTEXT_URI", "http://www.ibm.com/login/");
            sTSConfigImpl.set("STS_NAME", "SSI");
        }
        catch (AxisFault axisFault) {
            throw SoapSecurityException.format("Axis fault during trust client API invocation", axisFault);
        }
        catch (TrustException trustException) {
            throw SoapSecurityException.format("Trust Exception during the trust client API invocation", trustException);
        }
        object = new HashMap();
        object.put("CONFIG_CONTEXT", configurationContext);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("Sandesha2UnreliableMessage", "true");
        hashMap.put("com.ibm.ws.wssecurity.sc.bootstrapProperty", new Boolean(true));
        if (bl) {
            hashMap.put("com.ibm.ws.wssecurity.sc.bootstrapAndAppPolicyConfig", wSSGeneratorConfig);
            if (wSSGeneratorConfig instanceof PrivateGeneratorConfig) {
                hashMap.put("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey", ((PrivateGeneratorConfig)wSSGeneratorConfig).getBootstrapConsumerConfig());
            }
        }
        hashMap.put("com.ibm.ws.wssecurity.sc.SCT.Cancel", new Boolean(true));
        hashMap.put(Constants.WSSECURITY_SECURECONVERSATION_IDENTIFIER, sCT.getIdentifier());
        object.put("axis2_messagecontext_propertymap", hashMap);
        object.put("STS_Conf", sTSConfigImpl);
        object.put("RSTTemplate", rSTTemplateImpl);
        try {
            STSRequestorFactory sTSRequestorFactory = new STSRequestorFactory();
            ServiceClient serviceClient = (ServiceClient)sTSRequestorFactory.init((Map)object);
            if (serviceClient != null && serviceClient.getAxisService() != null) {
                serviceClient.getAxisService().addParameter(new Parameter("Sandesha2UnreliableMessage", "true"));
            }
            IRequestSecurityTokenResponseCollection iRequestSecurityTokenResponseCollection = sTSRequestorFactory.cancel(serviceClient);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Trust client Issue is successful.");
            }
            Iterator<IRequestSecurityTokenResponse> iterator = iRequestSecurityTokenResponseCollection.getRSTRCollection();
            while (iterator.hasNext()) {
                IRequestSecurityTokenResponse iRequestSecurityTokenResponse = iterator.next();
                OMElement oMElement2 = (OMElement)iRequestSecurityTokenResponse.getTokenElement("RequestedTokenCancelled");
                if (oMElement2 != null && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cancel Element:" + ((Object)oMElement2).toString());
                }
                Boolean bl2 = iRequestSecurityTokenResponse.isTokenCancelled();
                if (tc.isDebugEnabled() && bl2.booleanValue()) {
                    Tr.debug(tc, "Token Successfully Cancelled");
                }
                sCT.cancel();
                SecureConversationCacheHelper.invalidateCache(sCT.getUUID());
                SecureConversationCacheHelper.invalidateCache(sCT.getClientID());
                sCTWrapper.setSCT(sCT);
            }
        }
        catch (Exception exception) {
            Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.issueSCT", new Object[]{exception});
            throw SoapSecurityException.format("security.wssecurity.SCTGenerateLoginModule.issueSCT", exception);
        }
        return sCTWrapper;
    }

    private void copySessionAffinityPropertiesToMap(MessageContext messageContext, Map map) {
        Object object = messageContext.getProperty("Cookie");
        if (object != null) {
            map.put("Cookie", object);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Copied Cookie property to innerMap: " + object.toString());
            }
        }
        if ((object = messageContext.getProperty("Location")) != null) {
            map.put("Location", object);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Copied Location property to innerMap: " + object.toString());
            }
        }
        if ((object = messageContext.getProperty("javax.xml.ws.session.maintain")) != null) {
            map.put("javax.xml.ws.session.maintain", object);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Copied javax.xml.ws.session.maintain property to innerMap: " + object.toString());
            }
        }
    }

    private void copySessionAffinityPropertiesFromMap(MessageContext messageContext, Map map) {
        ServiceContext serviceContext;
        Object object = messageContext.getProperty("Cookie");
        if (object == null) {
            object = map.get("Cookie");
            if (object != null) {
                messageContext.setProperty("Cookie", object);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Copied Cookie property to MessageContext: " + object.toString());
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cookie property already in MessageContext: " + object.toString());
        }
        if ((object = messageContext.getProperty("Location")) == null) {
            object = map.get("Location");
            if (object != null) {
                messageContext.setProperty("Location", object);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Copied Location property to MessageContext: " + object.toString());
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Location property already in MessageContext: " + object.toString());
        }
        if ((serviceContext = messageContext.getServiceContext()) != null) {
            object = serviceContext.getProperty("Cookie");
            if (object == null) {
                object = map.get("Cookie");
                if (object != null) {
                    serviceContext.setProperty("Cookie", object);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Copied Cookie property to ServiceContext: " + object.toString());
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cookie property already in ServiceContext: " + object.toString());
            }
            if ((object = serviceContext.getProperty("Location")) == null) {
                object = map.get("Location");
                if (object != null) {
                    serviceContext.setProperty("Location", object);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Copied Location property to ServiceContext: " + object.toString());
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Location property already in ServiceContext: " + object.toString());
            }
        }
    }

    private ConfigurationContext getConfigurationContext(String string) throws SoapSecurityException {
        ConfigurationContext configurationContext = null;
        ClientConfigurationFactory clientConfigurationFactory = ClientConfigurationFactory.newInstance();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ClientConfigurationFactory.newInstance(): " + clientConfigurationFactory);
        }
        if (clientConfigurationFactory == null) {
            Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.getClientConfigurationFactory");
            throw SoapSecurityException.format("security.wssecurity.SCTGenerateLoginModule.getClientConfigurationFactory");
        }
        configurationContext = clientConfigurationFactory.getClientConfigurationContext();
        if (configurationContext == null) {
            Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.getConfigurationContext");
            throw SoapSecurityException.format("security.wssecurity.SCTGenerateLoginModule.getConfigurationContext");
        }
        AxisConfiguration axisConfiguration = configurationContext.getAxisConfiguration();
        if (axisConfiguration == null) {
            Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.getAxisConfiguration");
            throw SoapSecurityException.format("security.wssecurity.SCTGenerateLoginModule.getAxisConfiguration");
        }
        try {
            AxisService axisService = axisConfiguration.getService(string);
            if (axisService == null) {
                AxisService axisService2 = new AxisService(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "AxisService: " + axisService2);
                }
                if (axisService2 == null) {
                    Tr.warning(tc, "security.wssecurity.SCTGenerateLoginModule.getAxisService", new Object[]{string});
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "creating an empty AxisService.");
                    }
                    if ((axisService2 = new AxisService()) == null) {
                        Tr.error(tc, "UNABLE TO CREATE EMPTY AxisService");
                    }
                }
                axisConfiguration.addService(axisService2);
                clientConfigurationFactory.completeAxis2Configuration(axisService2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ccf.completeAxis2Configuration(): " + clientConfigurationFactory);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found Target axisService from AxisConfiguration.");
            }
        }
        catch (Exception exception) {
            Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.getAxisConfiguration");
            throw SoapSecurityException.format("security.wssecurity.SCTGenerateLoginModule.getAxisConfiguration", exception);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ccf.completeAxis2Configuration(): " + clientConfigurationFactory);
        }
        return configurationContext;
    }

    public String searchInstanceList(SCT sCT) {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "searchInstanceList(SCT sctoken)");
        }
        String string = null;
        Date date = new Date();
        String[] stringArray = sCT.getInstances();
        if (stringArray == null || stringArray.length == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "searchInstanceList(SCT sctoken): no key instance.");
            }
            return null;
        }
        int n2 = stringArray.length;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Instances in the list = " + n2);
        }
        Date date2 = sCT.getCreation(stringArray[n2 - 1]);
        string = stringArray[n2 - 1];
        if (n2 == 1) {
            return string;
        }
        int n3 = 0;
        for (n = 0; n < n2 - 1; ++n) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "instance:" + stringArray[n] + "  creation time:" + sCT.getCreation(stringArray[n]));
            }
            if (!sCT.getCreation(stringArray[n]).after(date2) && (!sCT.getCreation(stringArray[n]).equals(date2) || !sCT.getExpiration(stringArray[n]).after(sCT.getExpiration(string)))) continue;
            string = stringArray[n];
            n3 = n;
            date2 = sCT.getCreation(stringArray[n]);
        }
        if (date2.after(date)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "searchInstanceList(SCT sctoken):" + string);
            }
            return string;
        }
        string = null;
        n3 = stringArray.length + 1;
        for (n = 0; n < stringArray.length; ++n) {
            if (!sCT.getExpiration(stringArray[n]).after(date)) continue;
            string = stringArray[n];
            n3 = n;
            date = sCT.getExpiration(stringArray[n]);
        }
        if (n3 != stringArray.length + 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning valid instance  = " + string + "and it is at = " + n3);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Returning non valid instance  = " + string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "searchInstanceList(SCT sctoken)");
        }
        return string;
    }

    private String searchExistingInstance(SCT sCT) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "searchExistingInstance(SCT sctoken).");
        }
        if (sCT == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "searchExistingInstance(SCT sctoken): no SCT.");
            }
            return null;
        }
        String string = this.searchInstanceList(sCT);
        String[] stringArray = sCT.getInstances();
        if (stringArray == null || stringArray.length < 2) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "searchExistingInstance(SCT sctoken): no more than 1 key instance.");
            }
            return string;
        }
        int n = stringArray.length;
        String string2 = null;
        Date date = new Date();
        Date date2 = new Date();
        long l = date.getTime() + cushion * 3L / 5L;
        String string3 = string;
        date2 = sCT.getCreation(string3);
        for (int i = 0; i < n; ++i) {
            string2 = stringArray[i];
            if (sCT.getExpiration(string2).getTime() > l) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Valid old Instance:" + string2, "created at " + sCT.getCreation(string2));
                }
                if (!sCT.getCreation(string2).before(date2)) continue;
                string3 = string2;
                date2 = sCT.getCreation(string3);
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Instance expired:" + string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "searchExistingInstance(SCT sctoken) = " + string3);
        }
        return string3;
    }

    public static final Date parseDateTime(String string) {
        if (string == null) {
            return null;
        }
        try {
            Date date = UTC.parse(string);
            return date;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean isCancelInProgress(MessageContext messageContext) {
        if (messageContext == null) {
            return false;
        }
        boolean bl = false;
        try {
            bl = Axis2Util.isServiceProvider(messageContext);
        }
        catch (Exception exception) {
            return false;
        }
        if (bl) {
            String string;
            String string2 = messageContext.getWSAAction();
            if (string2 == null) {
                string2 = messageContext.getSoapAction();
            }
            if ((string = STSPolicySetUtil.mapTrustAction(string2)) != null && string.equals("cancel")) {
                return true;
            }
        } else {
            OperationContext operationContext = messageContext.getOperationContext();
            if (operationContext == null) {
                operationContext = (OperationContext)messageContext.getProperty("unverifiedOperationContext");
            }
            Object object = null;
            if (operationContext != null) {
                Map.Entry entry;
                MessageContext messageContext2;
                HashMap hashMap = operationContext.getMessageContexts();
                Set set = hashMap.entrySet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext() && (object = (messageContext2 = (MessageContext)(entry = iterator.next()).getValue()).getProperty("com.ibm.ws.wssecurity.sc.SCT.Cancel")) == null) {
                }
            }
            if (object != null && object instanceof Boolean && ((Boolean)object).booleanValue()) {
                return true;
            }
        }
        return false;
    }

    public SCTWrapper createSCTWrapper(SCT sCT, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSCTWrapper(SCT sctoken, String instance)");
        }
        String[] stringArray = sCT.getInstances();
        SCT.KeyHistoryEntry[] keyHistoryEntryArray = new SCT.KeyHistoryEntry[stringArray.length];
        SCTWrapper sCTWrapper = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Instances in the list = " + stringArray.length);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            keyHistoryEntryArray[i] = sCT.getKeyHistoryEntry(stringArray[i]);
        }
        sCTWrapper = new SCTWrapper(sCT.getUUID(), keyHistoryEntryArray, sCT.getId(), string);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSCTWrapper(SCT sctoken, String instance) returns SCTWrapper object, instance = " + sCTWrapper != null ? sCTWrapper.getCurrentInstance() : null);
        }
        return sCTWrapper;
    }

    private static synchronized boolean hasBeenRequested(String string) {
        boolean bl = false;
        if (WSTrustCallbackHandler.getClientIDMap().containsKey(string)) {
            bl = true;
            Vector vector = (Vector)WSTrustCallbackHandler.getClientIDMap().get(string);
            Thread thread = Thread.currentThread();
            vector.add(thread);
            WSTrustCallbackHandler.getClientIDMap().put(string, vector);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "This client has requested an SCT.");
            }
        } else {
            Vector vector = new Vector();
            WSTrustCallbackHandler.getClientIDMap().put(string, vector);
        }
        return bl;
    }

    private static synchronized void wakeupOtherRequests(String string) {
        if (WSTrustCallbackHandler.getClientIDMap().containsKey(string)) {
            try {
                final Vector vector = (Vector)WSTrustCallbackHandler.getClientIDMap().get(string);
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            while (!vector.isEmpty()) {
                                Thread thread = (Thread)vector.lastElement();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Interrupt sleeping Thread:" + thread.getName());
                                }
                                thread.interrupt();
                                vector.remove(thread);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return null;
                    }
                });
                WSTrustCallbackHandler.getClientIDMap().remove(string);
            }
            catch (Exception exception) {
                WSTrustCallbackHandler.getClientIDMap().remove(string);
            }
        }
    }

    private static synchronized Map getClientIDMap() {
        return clientIDMap;
    }
}

