/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.impl.auth.callback;

import com.ibm.ws.wssecurity.impl.auth.callback.WSRealmNameCallbackImpl;
import com.ibm.ws.wssecurity.impl.auth.callback.WSStdinLoginPrompt;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class WSStdinCallbackHandlerImpl
implements CallbackHandler {
    private static final TraceComponent tc = Tr.register(WSStdinCallbackHandlerImpl.class, null, "com.ibm.ejs.resources.security");
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String realmNamePrompt = "Realm Name";
    private static int stdinRetry = 0;
    private String userName = "";
    private String password = "";
    private String realmName = "";
    private String userNamePrompt = "";
    private String passwordPrompt = "";
    private boolean passwordEcho = false;

    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        Object object;
        int n;
        int n2 = 0;
        if (callbackArray == null || (n2 = callbackArray.length) == 0) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "handle(callbacks = \"{ }\")");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handle(callbacks)");
            }
            return;
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{ ");
            for (int i = 0; i < n2; ++i) {
                stringBuffer.append(callbackArray[i].getClass().getName());
                if (i >= n2 - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(" }");
            Tr.entry(tc, "handle(callbacks = \"" + stringBuffer.toString() + "\")");
        }
        for (n = 0; n < n2; ++n) {
            Callback callback = callbackArray[n];
            if (callback instanceof NameCallback) {
                this.userNamePrompt = ((NameCallback)callback).getPrompt();
                this.userName = ((NameCallback)callback).getDefaultName();
                continue;
            }
            if (callback instanceof PasswordCallback) {
                this.passwordPrompt = ((PasswordCallback)callback).getPrompt();
                this.passwordEcho = ((PasswordCallback)callback).isEchoOn();
                continue;
            }
            if (!(callback instanceof WSRealmNameCallbackImpl)) continue;
            this.realmName = ((WSRealmNameCallbackImpl)callback).getRealmName();
            if (this.realmName != null && !this.realmName.equals("")) continue;
            this.realmName = ((WSRealmNameCallbackImpl)callback).getDefaultRealmName();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Realm Name: " + this.realmName);
        }
        String[] stringArray = null;
        try {
            if (stdinRetry < 1) {
                System.out.print("Realm Name: " + this.realmName + NEW_LINE);
                System.out.flush();
                object = new WSStdinLoginPrompt(this.userNamePrompt, this.passwordPrompt);
                stringArray = ((WSStdinLoginPrompt)object).getUidAndPassword();
                if (stringArray != null) {
                    this.password = stringArray[1];
                    this.userName = stringArray[0];
                    stdinRetry = 0;
                } else {
                    ++stdinRetry;
                    this.userName = null;
                    this.password = null;
                }
            } else {
                stdinRetry = 0;
                this.userName = null;
                this.password = null;
            }
        }
        catch (Exception exception) {
            Tr.error(tc, "security.jaas.SystemInputError", new Object[]{exception});
        }
        for (n = 0; n < n2; ++n) {
            object = callbackArray[n];
            if (object instanceof NameCallback) {
                ((NameCallback)object).setName(this.userName);
                continue;
            }
            if (object instanceof PasswordCallback) {
                ((PasswordCallback)object).setPassword(this.password == null ? new char[]{} : this.password.toCharArray());
                continue;
            }
            throw new UnsupportedCallbackException((Callback)object, "Unsupported callback");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handle(callbacks)");
        }
    }
}

