/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.impl.auth.callback;

import com.ibm.ws.wssecurity.impl.auth.callback.TrustedIdentityCallback;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.KeyInfo;
import com.ibm.wsspi.wssecurity.core.config.CallbackHandlerConfig;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrustedIdentityCallbackHandler
implements CallbackHandler {
    private static final TraceComponent tc = Tr.register(TrustedIdentityCallbackHandler.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private final Set<String> identityList = new HashSet<String>();

    public TrustedIdentityCallbackHandler(Map<Object, Object> map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TrustedIdentityCallbackHandler(Map properties)");
        }
        CallbackHandlerConfig callbackHandlerConfig = (CallbackHandlerConfig)map.get("com.ibm.wsspi.wssecurity.impl.config.callbackHandler.configKey");
        Map<Object, Object> map2 = callbackHandlerConfig.getProperties();
        for (Object object : map2.keySet()) {
            if (!(object instanceof String) || !((String)object).startsWith("trustedId_")) continue;
            String string = (String)map2.get(object);
            String string2 = KeyInfo.X509Data.encodeDName(string);
            if (string2 == null || string2.length() == 0) {
                this.identityList.add(string);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Added the identity [" + string + "].");
                continue;
            }
            this.identityList.add(string2);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Added the identity [" + string2 + "].");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "TrustedIdentityCallbackHandler(Map properties)");
        }
    }

    @Override
    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handle(Callback[] callbacks)");
        }
        if (callbackArray == null || callbackArray.length == 0) {
            throw new UnsupportedCallbackException(null, "There is no callback.");
        }
        for (int i = 0; i < callbackArray.length; ++i) {
            Callback callback = callbackArray[i];
            if (!(callback instanceof TrustedIdentityCallback)) continue;
            TrustedIdentityCallback trustedIdentityCallback = (TrustedIdentityCallback)callback;
            trustedIdentityCallback.setIdentityList(this.identityList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handle(Callback[]) returns Set[" + this.identityList + "]");
        }
    }
}

