/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.impl.auth.callback;

import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wssecurity.impl.auth.callback.STSRulesCallback;
import com.ibm.ws.wssecurity.trust.server.sts.STSCallbackHandler;
import com.ibm.ws.wssecurity.trust.server.sts.Util.STSConfigUtil;
import com.ibm.ws.wssecurity.trust.server.sts.Util.STSUriUtil;
import com.ibm.ws.wssecurity.trust.server.sts.ext.NoEntriesFoundException;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.DefaultIssuerRule;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.IdentityList;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.IssuerRule;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.STSTargetMap;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.Target;
import com.ibm.xmlns.prod.websphere._200608.securitytokenservice.targets.TokenTypeRule;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class STSDefaultCallbackHandler
implements STSCallbackHandler {
    private URI appliesTo;
    private URI issuer;
    private URI tokenType;
    private SecurityToken token;
    private final String FFDC_ID_1 = "FFDC-1";
    private static final TraceComponent tc = Tr.register(STSDefaultCallbackHandler.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public void setAppliesTo(URI uRI) {
        this.appliesTo = uRI;
    }

    public URI getAppliesTo() {
        return this.appliesTo;
    }

    public void setIssuer(URI uRI) {
        this.issuer = uRI;
    }

    public URI getIssuer() {
        return this.issuer;
    }

    public void setTokenType(URI uRI) {
        this.tokenType = uRI;
    }

    public URI getTokenType() {
        return this.tokenType;
    }

    public void setToken(SecurityToken securityToken) {
        this.token = securityToken;
    }

    public SecurityToken getToken() {
        return this.token;
    }

    public void handle(Callback[] callbackArray) throws UnsupportedCallbackException {
        String string = "handle";
        STSDefaultCallbackHandler.trEntry(string);
        for (Callback callback : callbackArray) {
            if (!(callback instanceof STSRulesCallback)) continue;
            STSDefaultCallbackHandler.trDebug("Handling instance of STSRulesCallback.");
            STSRulesCallback sTSRulesCallback = (STSRulesCallback)callback;
            try {
                sTSRulesCallback.setToken(this.token);
                sTSRulesCallback.setRules(this.extractRules());
                sTSRulesCallback.setSuccessful(true);
                STSDefaultCallbackHandler.trDebug("Succesfully extracted rules from the configuration.");
            }
            catch (NoEntriesFoundException noEntriesFoundException) {
                sTSRulesCallback.setSuccessful(true);
                STSDefaultCallbackHandler.trDebug("No rules found in the configuration.");
            }
            catch (NoSuchElementException noSuchElementException) {
                sTSRulesCallback.setSuccessful(false);
                STSDefaultCallbackHandler.trDebug("Failed to extract rules from the configuration.");
            }
        }
        STSDefaultCallbackHandler.trExit(string);
    }

    private IdentityList extractRules() throws NoSuchElementException, NoEntriesFoundException {
        String string;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        String string2 = "extractRules";
        STSDefaultCallbackHandler.trEntry(string2);
        if (this.appliesTo == null) {
            STSDefaultCallbackHandler.trDebug("Callback's appliesTo was not set.");
            STSDefaultCallbackHandler.trExit(string2);
            return null;
        }
        if (this.tokenType == null) {
            STSDefaultCallbackHandler.trDebug("Callback's tokenType was not set.");
            STSDefaultCallbackHandler.trExit(string2);
            return null;
        }
        if (this.issuer == null) {
            STSDefaultCallbackHandler.trDebug("Callback's issuer is null: attempting to extract default rule.");
        } else {
            STSDefaultCallbackHandler.trDebug("Attempting to extract rule.");
        }
        STSTargetMap sTSTargetMap = null;
        try {
            sTSTargetMap = STSConfigUtil.getSTSTargetMap();
        }
        catch (SoapSecurityException soapSecurityException) {
            FFDCFilter.processException((Throwable)soapSecurityException, "STSDefaultCallbackHandler.extractRules", "FFDC-1", this);
            Tr.error(tc, "wssecurity.config.s03");
            throw new NoEntriesFoundException("Failed to get the STS target configuration.");
        }
        List<Target> list = sTSTargetMap.getTarget();
        Iterator<Target> iterator = list.iterator();
        Target target = null;
        STSDefaultCallbackHandler.trDebug("Searching Targets for specified AppliesTo: " + this.appliesTo);
        while (iterator.hasNext()) {
            object5 = iterator.next();
            object4 = ((Target)object5).getAppliesTo();
            if (object4 == null) {
                STSDefaultCallbackHandler.trDebug("Configuration contains a Target with a null AppliesTo.");
                continue;
            }
            if (STSUriUtil.URICompare((String)object4, this.appliesTo.toString()) != 0) continue;
            STSDefaultCallbackHandler.trDebug("Target found.");
            target = object5;
            break;
        }
        if (target == null) {
            STSDefaultCallbackHandler.trDebug("No Target matching the specified AppliesTo was found in the configuration.");
            throw new NoSuchElementException("Target not found.");
        }
        object5 = null;
        object4 = target.getDefaultIssuerRule();
        List<IssuerRule> list2 = target.getIssuerRule();
        if (object4 == null && (list2 == null || list2.size() == 0)) {
            STSDefaultCallbackHandler.trDebug("No Issuer Rules found in the configuration, trust authentication NOT configured.");
            STSDefaultCallbackHandler.trExit(string2);
            throw new NoEntriesFoundException("Issuer Rules not found.");
        }
        if (this.issuer == null) {
            STSDefaultCallbackHandler.trDebug("Searching for TokenTypeRules under DefaultIssuerRule.");
            if (object4 == null) {
                STSDefaultCallbackHandler.trDebug("No rule exists for a null issuer for this endpoint: " + target.getAppliesTo());
                STSDefaultCallbackHandler.trExit(string2);
                throw new NoSuchElementException("DefaultIssuerRule not found.");
            }
            object5 = ((DefaultIssuerRule)object4).getTokenTypeRule();
        } else {
            STSDefaultCallbackHandler.trDebug("Searching for TokenTypeRules under IssuerRules for Issuer: " + this.issuer);
            if (list2 == null || list2.size() == 0) {
                STSDefaultCallbackHandler.trDebug("No issuer rule exists for a this endpoint: " + target.getAppliesTo());
                STSDefaultCallbackHandler.trExit(string2);
                throw new NoSuchElementException("IssuerRule not found.");
            }
            object3 = list2.iterator();
            object2 = null;
            while (object3.hasNext()) {
                object = object3.next();
                string = ((IssuerRule)object).getIssuerURI();
                if (string == null) {
                    STSDefaultCallbackHandler.trDebug("Configuration contains an IssuerRule with a null IssuerURI.");
                    continue;
                }
                if (!string.equals(this.issuer.toString())) continue;
                STSDefaultCallbackHandler.trDebug("IssuerRule found.");
                object2 = object;
                break;
            }
            if (object2 == null) {
                STSDefaultCallbackHandler.trDebug("No IssuerRule matching the specified IssuerURI was found in the configuration.");
                STSDefaultCallbackHandler.trExit(string2);
                throw new NoSuchElementException("IssuerRule not found.");
            }
            object5 = ((IssuerRule)object2).getTokenTypeRule();
        }
        if (object5 == null || object5.size() == 0) {
            STSDefaultCallbackHandler.trDebug("No TokenTypeRules were found under the IssuerRules/DefaultIssuerRule, trust authentication NOT configured.");
            STSDefaultCallbackHandler.trExit(string2);
            throw new NoEntriesFoundException("TokenTypeRules not found.");
        }
        object3 = null;
        object2 = object5.iterator();
        STSDefaultCallbackHandler.trDebug("Searching through TokenTypeRules for TokenType: " + this.tokenType);
        while (object2.hasNext()) {
            object = (TokenTypeRule)object2.next();
            string = ((TokenTypeRule)object).getRequiredTokenTypeURI();
            if (string == null) {
                STSDefaultCallbackHandler.trDebug("Configuration contains a TokenTypeRule with a null RequiredTokenTypeURI.");
                continue;
            }
            if (!string.equals(this.tokenType.toString())) continue;
            STSDefaultCallbackHandler.trDebug("TokenTypeRule found.");
            object3 = object;
            break;
        }
        if (object3 == null) {
            STSDefaultCallbackHandler.trDebug("No TokenTypeRule matching the specified TokenType was found in the configuration.");
            STSDefaultCallbackHandler.trExit(string2);
            throw new NoSuchElementException("TokenTypeRule not found.");
        }
        object = ((TokenTypeRule)object3).getIdentityList();
        if (object == null) {
            STSDefaultCallbackHandler.trDebug("No IdentityList was found under the matching TokenTypeRule.");
            STSDefaultCallbackHandler.trExit(string2);
            throw new NoEntriesFoundException("IdentityList not found, trust authentication NOT configured.");
        }
        STSDefaultCallbackHandler.trDebug("IdentityList successfully extracted!");
        STSDefaultCallbackHandler.trExit(string2);
        return object;
    }

    private static void trEntry(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
    }

    private static void trExit(String string) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    private static void trDebug(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string);
        }
    }
}

