/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.impl.auth.callback;

import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.websphere.wssecurity.callbackhandler.SCTGenerateCallback;
import com.ibm.websphere.wssecurity.callbackhandler.UNTGenerateCallback;
import com.ibm.ws.wssecurity.impl.auth.callback.WSCredTokenCallbackImpl;
import com.ibm.ws.wssecurity.util.ConfigConstants;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.config.CallbackHandlerConfig;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonPromptCallbackHandler
implements CallbackHandler {
    private static final TraceComponent tc = Tr.register(NonPromptCallbackHandler.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private String _username = "";
    private char[] _password = null;
    private CallbackHandlerConfig _config = null;
    private boolean identityAssertion;
    private boolean runAsSubject;
    private boolean sendRealm;
    private boolean nonce;
    private boolean createdTimestamp;
    private static final String[] TRUE_VALUES = new String[]{"yes", "on", "true", "1"};

    public NonPromptCallbackHandler() {
    }

    public NonPromptCallbackHandler(Map<Object, Object> map) {
        CallbackHandlerConfig callbackHandlerConfig = (CallbackHandlerConfig)map.get("com.ibm.wsspi.wssecurity.impl.config.callbackHandler.configKey");
        if (callbackHandlerConfig != null) {
            this._username = callbackHandlerConfig.getUserId();
            this._password = callbackHandlerConfig.getUserPassword();
            Object object = callbackHandlerConfig.getProperties().get(Constants.WSSECURITY_USE_IDASSERTION);
            if (object != null) {
                this.identityAssertion = NonPromptCallbackHandler.isTrue(object.toString());
            }
            if ((object = callbackHandlerConfig.getProperties().get(Constants.WSSECURITY_USE_RUNASIDENTITY)) != null) {
                this.runAsSubject = NonPromptCallbackHandler.isTrue(object.toString());
            }
            if ((object = callbackHandlerConfig.getProperties().get("com.ibm.wsspi.wssecurity.token.IDAssertion.sendRealm")) != null) {
                this.sendRealm = NonPromptCallbackHandler.isTrue(object.toString());
            }
            if ((object = callbackHandlerConfig.getProperties().get(Constants.WSSECURITY_ADD_NONCE)) != null) {
                this.nonce = NonPromptCallbackHandler.isTrue(object.toString());
            }
            if ((object = callbackHandlerConfig.getProperties().get(Constants.WSSECURITY_ADD_TIMESTAMP)) != null) {
                this.createdTimestamp = NonPromptCallbackHandler.isTrue(object.toString());
            }
        }
    }

    public static boolean isTrue(String string) {
        boolean bl = false;
        if (string != null) {
            string = string.trim();
            for (int i = 0; i < TRUE_VALUES.length; ++i) {
                if (!TRUE_VALUES[i].equalsIgnoreCase(string)) continue;
                return true;
            }
        }
        return bl;
    }

    public NonPromptCallbackHandler(String string, char[] cArray, Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "NonPromptCallbackHandler(String, char[], Map)", new Object[]{"Default user: " + string});
        }
        this._username = string;
        this._password = cArray;
        if (map == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WARNING: The properties parameter is null.");
            }
            this._config = null;
        } else {
            this._config = (CallbackHandlerConfig)map.get("com.ibm.wsspi.wssecurity.impl.config.callbackHandler.configKey");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "CallbackHandlerConfig [" + this._config + "].");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "NonPromptCallbackHandler(String, char[], Map)");
        }
    }

    @Override
    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handle(Callback[] callbacks)");
        }
        int n = 0;
        if (callbackArray == null || (n = callbackArray.length) == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "handle(callbacks = \"{ }\")");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handle(Callback[] callbacks)");
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{ ");
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(callbackArray[i].getClass().getName());
                if (i >= n - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(" }");
            Tr.debug(tc, "handle(callbacks = \"" + stringBuffer.toString() + "\")");
        }
        for (int i = 0; i < n; ++i) {
            Callback callback = callbackArray[i];
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(this._username);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                ((PasswordCallback)callback).setPassword(this._password);
                continue;
            }
            if (callbackArray[i] instanceof PropertyCallback || callback instanceof WSCredTokenCallbackImpl || callback instanceof SCTGenerateCallback) continue;
            if (callback instanceof UNTGenerateCallback) {
                ((UNTGenerateCallback)callback).setUsedIdentityAssertion(this.identityAssertion);
                ((UNTGenerateCallback)callback).setUsedRunAsSubject(this.runAsSubject);
                ((UNTGenerateCallback)callback).setSentRelm(this.sendRealm);
                ((UNTGenerateCallback)callback).setNonce(this.nonce);
                ((UNTGenerateCallback)callback).setCreatedTimestamp(this.createdTimestamp);
                continue;
            }
            throw new UnsupportedCallbackException(callback, ConfigConstants.getMessage("security.wssecurity.WSEC0153E"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handle(Callback[] callbacks)");
        }
    }
}

