/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.handler.token;

import com.ibm.ws.wssecurity.handler.token.ByteArray;
import com.ibm.ws.wssecurity.handler.token.DistNonceCache;
import com.ibm.ws.wssecurity.handler.token.NonceCache;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManagerFactory;
import com.ibm.ws.wssecurity.token.NonceManager;
import com.ibm.ws.wssecurity.util.SecurityUIDGenerator;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.io.ByteArrayOutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.Security;

public class WSNonceManagerImpl
implements NonceManager {
    private static final TraceComponent tc = Tr.register(WSNonceManagerImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String clsName = WSNonceManagerImpl.class.getName();
    private static final String comp = "security.wssecurity";
    private static final String DEFAULT_JCE_PROVIDER = "DEFAULT_JCE_PROVIDER";
    private static final String IBMJCE = "IBMJCE";
    private static final String IBMSEC_RANDOM = "IBMSecureRandom";
    private static final String NONCE_CACHE_SIZE_KEY = "com.ibm.websphere.wssecurity.util.nonceCacheSize";
    private static final String NONCE_LENGTH_KEY = "com.ibm.websphere.wssecurity.util.nonceLength";
    private SecureRandom _random = null;
    private NonceCache _cache = null;
    private DistNonceCache _distCache = null;
    private int _nonceLength = 128;
    private static boolean _inWebSphere = WSSContextManagerFactory.getInstance().runInWebSphere();

    public WSNonceManagerImpl(String string, int n, int n2, int n3, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSNonceManagerImpl(String cacheName[" + string + "]," + "int cacheSize[" + n + "]," + "int cacheTimeout[" + n2 + "]," + "int nonceLength[" + n3 + "]," + "boolean cacheDistributed[" + bl + "])");
        }
        String string2 = System.getProperty(NONCE_CACHE_SIZE_KEY);
        int n4 = n;
        if (string2 != null && (string2 = string2.trim()).length() != 0) {
            try {
                int n5 = Integer.parseInt(string2);
                if (n5 <= 16) {
                    Tr.warning(tc, "security.wssecurity.WSEC0124W", new Object[]{string2, new Integer(16), new Integer(n)});
                    n4 = n;
                } else {
                    n4 = n5;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Nonce cache size from system property (com.ibm.websphere.wssecurity.util.nonceCacheSize) = " + n4);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                Tr.processException((Throwable)numberFormatException, WSNonceManagerImpl.class.getName() + ".WSNonceManagerImpl", "89", this);
                Tr.warning(tc, "security.wssecurity.WSEC5190W", new Object[]{NONCE_CACHE_SIZE_KEY, string2, new Integer(n)});
                n4 = n;
            }
        }
        if (string == null || string.length() == 0) {
            string = "NonceDistributionCacheMap";
        }
        if (_inWebSphere) {
            this._distCache = new DistNonceCache(string, n4, n2, true, bl);
        } else {
            this._cache = new NonceCache(string, n4, n2, true, bl);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Server process: enabled NonceCache");
        }
        this._nonceLength = n3;
        String string3 = System.getProperty(NONCE_LENGTH_KEY);
        if (string3 != null && (string3 = string3.trim()).length() != 0) {
            try {
                int n6 = Integer.parseInt(string3);
                if (n6 <= 16) {
                    Tr.warning(tc, "security.wssecurity.WSEC0127W", new Object[]{string3, new Integer(16), new Integer(n3)});
                    this._nonceLength = n3;
                } else {
                    this._nonceLength = n6;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Nonce length from system property (com.ibm.websphere.wssecurity.util.nonceLength) = " + this._nonceLength);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                Tr.processException((Throwable)numberFormatException, WSNonceManagerImpl.class.getName() + ".WSNonceManagerImpl", "124", this);
                Tr.warning(tc, "security.wssecurity.WSEC5190W", new Object[]{NONCE_LENGTH_KEY, string3, new Integer(n3)});
                this._nonceLength = n3;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Nonce length = " + this._nonceLength);
        }
        this.initSecureRandom();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSNonceManagerImpl(String cacheName, int cacheSize, int cacheTimeout,int nonceLength, boolean cacheDistributed)");
        }
    }

    public boolean validate(byte[] byArray) throws SoapSecurityException {
        Object object;
        block11: {
            block10: {
                block9: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "validate");
                    }
                    if (byArray == null || byArray.length == 0) {
                        Tr.error(tc, "security.wssecurity.WSEC0121E");
                        throw SoapSecurityException.format("security.wssecurity.WSEC0121E");
                    }
                    if (this._cache != null) break block9;
                    if (!_inWebSphere) break block10;
                }
                if (this._distCache != null) break block11;
                if (!_inWebSphere) break block11;
            }
            String string = ".WSEC0122E";
            Tr.error(tc, comp + string);
            throw SoapSecurityException.format(comp + string);
        }
        if (tc.isDebugEnabled()) {
            object = new ByteArrayOutputStream();
            ((ByteArrayOutputStream)object).write(byArray, 0, byArray.length);
            Tr.debug(tc, "validating ", ((ByteArrayOutputStream)object).toString());
        }
        object = new ByteArray(byArray);
        boolean bl = false;
        if (_inWebSphere) {
            bl = !this._distCache.contains(object);
        } else {
            boolean bl2 = bl = !this._cache.contains(object);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate returns " + bl);
        }
        return bl;
    }

    public byte[] generate() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generate()");
        }
        byte[] byArray = null;
        if (this._random != null) {
            byArray = new byte[this._nonceLength];
            this._random.nextBytes(byArray);
            if (tc.isEntryEnabled()) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byteArrayOutputStream.write(byArray, 0, byArray.length);
                Tr.exit(tc, "generate", byteArrayOutputStream.toString());
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No random number generator");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "generate returns null");
            }
        }
        return byArray;
    }

    private void initSecureRandom() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initSecureRandom()");
        }
        String string = Security.getProperty(DEFAULT_JCE_PROVIDER);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "JCE Default Provider is " + string);
        }
        if (string == null || string.length() == 0) {
            string = IBMJCE;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "JCE Default Provider is null, force to use: " + string);
            }
        }
        try {
            this._random = SecureRandom.getInstance(IBMSEC_RANDOM, string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            String string2 = "security.wssecurity.WSEC5195E";
            Tr.warning(tc, string2, new Object[]{IBMSEC_RANDOM, string, noSuchAlgorithmException});
        }
        catch (NoSuchProviderException noSuchProviderException) {
            String string3 = "security.wssecurity.WSEC5195E";
            Tr.warning(tc, string3, new Object[]{IBMSEC_RANDOM, string, noSuchProviderException});
        }
        byte[] byArray = new byte[this._nonceLength];
        this._random.nextBytes(byArray);
        this._random.setSeed(SecurityUIDGenerator.createUID().getBytes());
        this._random.nextBytes(byArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initSecureRandom()");
        }
    }

    public String toString() {
        return clsName;
    }
}

