/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.handler.token;

import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.ws.wssecurity.impl.auth.callback.BinaryTokenCallback;
import com.ibm.ws.wssecurity.impl.auth.callback.WSCredTokenCallbackImpl;
import com.ibm.ws.wssecurity.impl.auth.callback.XMLTokenReceiverCallback;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;

public final class WSDefaultTokenCallbackHandler
implements CallbackHandler {
    private String username = null;
    private char[] password = null;
    private byte[] tokenBytes = null;
    private OMElement xmlToken = null;
    private OMDocument message = null;
    private Map properties = null;
    private static final TraceComponent tc = Tr.register(WSDefaultTokenCallbackHandler.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public WSDefaultTokenCallbackHandler(String string, char[] cArray, byte[] byArray, OMElement oMElement, OMDocument oMDocument, Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSDefaultTokenCallbackHandler");
        }
        this.username = string;
        this.password = cArray;
        this.tokenBytes = byArray;
        this.xmlToken = oMElement;
        this.message = oMDocument;
        this.properties = map;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSDefaultTokenCallbackHandler");
        }
    }

    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handle");
        }
        for (int i = 0; i < callbackArray.length; ++i) {
            if (callbackArray[i] instanceof NameCallback) {
                ((NameCallback)callbackArray[i]).setName(this.username);
                continue;
            }
            if (callbackArray[i] instanceof PasswordCallback) {
                ((PasswordCallback)callbackArray[i]).setPassword(this.password);
                continue;
            }
            if (callbackArray[i] instanceof BinaryTokenCallback) {
                ((BinaryTokenCallback)callbackArray[i]).setCredToken(this.tokenBytes);
                continue;
            }
            if (callbackArray[i] instanceof WSCredTokenCallbackImpl) {
                ((WSCredTokenCallbackImpl)callbackArray[i]).setCredToken(this.tokenBytes);
                continue;
            }
            if (callbackArray[i] instanceof XMLTokenReceiverCallback) {
                XMLTokenReceiverCallback xMLTokenReceiverCallback = (XMLTokenReceiverCallback)callbackArray[i];
                xMLTokenReceiverCallback.setXMLToken(this.xmlToken);
                xMLTokenReceiverCallback.setSOAPMessage(this.message);
                continue;
            }
            if (callbackArray[i] instanceof PropertyCallback) {
                ((PropertyCallback)callbackArray[i]).setProperties(this.properties);
                continue;
            }
            Tr.error(tc, "security.wssecurity.unsupport.callback", new Object[]{this.getClass().getName(), callbackArray[i]});
            throw new UnsupportedCallbackException(callbackArray[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exit");
        }
    }
}

