/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.handler.token;

import com.ibm.ws.wssecurity.handler.token.CertCache;
import com.ibm.ws.wssecurity.token.CertCacheManager;
import com.ibm.ws.wssecurity.util.ConfigConstants;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.security.cert.Certificate;

public class WSCertCacheManagerImpl
implements CertCacheManager {
    private static final TraceComponent tc = Tr.register(WSCertCacheManagerImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSCertCacheManagerImpl.class.getName();
    private CertCache _cache = null;

    public WSCertCacheManagerImpl(String string, int n, int n2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSCertCacheManagerImpl(String cacheName[" + string + "]," + "int cacheSize[" + n + "]," + "int cacheTimeout[" + n2 + "])");
        }
        int n3 = ConfigConstants.validCertCacheSize(n);
        int n4 = ConfigConstants.validCertCacheTimeout(n2);
        if (string == null || string.length() == 0) {
            string = "WSSCertCache";
        }
        this._cache = new CertCache(string, n3, n4 * 1000, true, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSCertCacheManagerImpl(String cacheName, int cacheSize, int cacheTimeout)");
        }
    }

    public Certificate getCachedCert(String string) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCachedCert(String key[" + string + "])");
        }
        Certificate certificate = null;
        if (string == null || string.length() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The specified key is null or zero length.");
            }
        } else if (this._cache == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The certificate cache is null.");
            }
        } else {
            Object object = this._cache.get(string);
            if (object == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "There is no object linked with the specified key [" + string + "].");
                }
            } else if (object instanceof Certificate) {
                certificate = (Certificate)object;
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "There is an object linked with the specified key [" + string + "].  But it's not the Certificate object: " + object.getClass().getName());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCachedCert(String key) returns Certificate[" + certificate + "]");
        }
        return certificate;
    }

    public void cacheCert(String string, Certificate certificate) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cacheCert(String key[" + string + "]," + "Certificate cert[" + certificate + "]");
        }
        if (string == null || string.length() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The specified key is null or zero length.");
            }
        } else if (certificate == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The specified certificate is null.");
            }
        } else if (this._cache == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The certificate cache is null.");
            }
        } else {
            this._cache.put(string, certificate);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cacheCert(String key, Token token");
        }
    }
}

