/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.handler.token;

import com.ibm.ws.wssecurity.handler.token.TokenCache;
import com.ibm.ws.wssecurity.token.PropagationToken;
import com.ibm.ws.wssecurity.token.TokenCacheManager;
import com.ibm.ws.wssecurity.util.ConfigConstants;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;

public class TokenCacheManagerImpl
implements TokenCacheManager {
    private static final TraceComponent tc = Tr.register(TokenCacheManagerImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = TokenCacheManagerImpl.class.getName();
    private TokenCache _cache = null;
    private long _cushion = 0L;

    public TokenCacheManagerImpl(String string, int n, int n2, long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TokenCacheManagerImpl(String cacheName[" + string + "]," + "int cacheSize[" + n + "]," + "int cacheTimeout[" + n2 + "]" + "long cushion[" + l + "])");
        }
        int n3 = ConfigConstants.validTokenCacheSize(n);
        int n4 = ConfigConstants.validTokenCacheTimeout(n2);
        if (string == null || string.length() == 0) {
            string = "WSSTokenCache";
        }
        this._cache = new TokenCache(string, n3, n4 * 1000, true, false);
        this._cushion = ConfigConstants.validTokenCushion(l);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "TokenCacheManagerImpl(String cacheName, int cacheSize, int cacheTimeout)");
        }
    }

    public PropagationToken getCachedToken(String string) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCachedToken(String key[" + string + "])");
        }
        PropagationToken propagationToken = null;
        if (string == null || string.length() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The specified key is null or zero length.");
            }
        } else if (this._cache == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The token cache is null.");
            }
        } else {
            Object object = this._cache.get(string);
            if (object == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "There is no object linked with the specified key [" + string + "].");
                }
            } else if (object instanceof PropagationToken) {
                propagationToken = (PropagationToken)object;
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "There is an object linked with the specified key [" + string + "].  But it's not the Token object: " + object.getClass().getName());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCachedToken(String key) returns Token[" + propagationToken + "]");
        }
        return propagationToken;
    }

    public void cacheToken(String string, PropagationToken propagationToken) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cacheToken(String key[" + string + "]," + "PropagationToken token[" + propagationToken + "]");
        }
        if (string == null || string.length() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The specified key is null or zero length.");
            }
        } else if (propagationToken == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The specified token is null.");
            }
        } else if (this._cache == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The token cache is null.");
            }
        } else {
            this._cache.put(string, propagationToken);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cacheToken(String key, PropagationToken token");
        }
    }

    public long getCushion() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCushion()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCushion() returns " + this._cushion);
        }
        return this._cushion;
    }
}

