/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.handler.token;

import com.ibm.ws.wssecurity.handler.token.CacheEntry;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.timer.AlarmListener;
import com.ibm.ws.wssecurity.util.timer.AlarmManager;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public abstract class Cache
implements AlarmListener {
    protected static final TraceComponent tc = Tr.register(Cache.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    protected Hashtable _primaryTable;
    protected Hashtable _secondaryTable;
    protected Hashtable _tertiaryTable;
    protected int _minSize = 0;
    protected boolean _wipeCache;
    protected Alarm _defaultAlarm;
    private int entryLimit = Integer.MAX_VALUE;

    public Cache(String string, int n, long l, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Cache(String cacheName[" + string + "]," + "int size[" + n + "]," + "int timeout[" + l + "]," + "boolean wipeCache[" + bl + "]," + "boolean cacheDistributed[" + bl2 + "]");
        }
        this._defaultAlarm = new Alarm(l);
        this._primaryTable = new Hashtable(n);
        this._secondaryTable = new Hashtable(n);
        this._tertiaryTable = new Hashtable(n);
        this._minSize = n;
        this._wipeCache = bl;
        this.addAlarmListener(this, l);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Cache(String cacheName, int size, int timeout, boolean wipeCache, boolean cacheDistributed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object object) {
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "contains");
            serializable = new StringBuffer("Key = ");
            ((StringBuffer)serializable).append(object.toString());
            ((StringBuffer)serializable).append(", key class is ");
            ((StringBuffer)serializable).append(object.getClass().getName());
            Tr.debug(tc, ((StringBuffer)serializable).toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get", object);
        }
        serializable = this._primaryTable;
        CacheEntry cacheEntry = (CacheEntry)this._primaryTable.get(object);
        if (cacheEntry == null) {
            serializable = this._secondaryTable;
            cacheEntry = (CacheEntry)this._secondaryTable.get(object);
            if (cacheEntry == null) {
                serializable = this._tertiaryTable;
                cacheEntry = (CacheEntry)this._tertiaryTable.get(object);
            }
            if (cacheEntry == null) {
                serializable = null;
            }
        }
        if (serializable != null && serializable != this._primaryTable) {
            this._primaryTable.put(object, cacheEntry);
            ((Hashtable)serializable).remove(object);
        }
        if (serializable == null) {
            Hashtable hashtable = this._primaryTable;
            synchronized (hashtable) {
                cacheEntry = (CacheEntry)this._primaryTable.get(object);
                if (cacheEntry == null) {
                    cacheEntry = new CacheEntry();
                    this._primaryTable.put(object, cacheEntry);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get", cacheEntry.getValue());
        }
        return cacheEntry.getValue();
    }

    public void remove(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "remove", object);
        }
        this._primaryTable.remove(object);
        this._secondaryTable.remove(object);
        this._tertiaryTable.remove(object);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "remove");
        }
    }

    public void insert(Object object, Object object2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "insert", new Object[]{object, object2});
        }
        CacheEntry cacheEntry = new CacheEntry(object, object2);
        this._primaryTable.put(object, cacheEntry);
        if (this.isEvictionRequired()) {
            this.evictStaleEntries();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "insert");
        }
    }

    protected boolean isEvictionRequired() {
        int n;
        if (this.entryLimit == 0) {
            return false;
        }
        boolean bl = false;
        if (this.entryLimit != Integer.MAX_VALUE && (n = this._primaryTable.size() + this._secondaryTable.size() + this._tertiaryTable.size()) > this.entryLimit && this._tertiaryTable.size() > this.entryLimit / 10) {
            bl = true;
        }
        return bl;
    }

    protected void evictStaleEntries() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "evictStaleEntries");
        }
        Hashtable hashtable = this._tertiaryTable;
        this._tertiaryTable = this._secondaryTable;
        this._secondaryTable = this._primaryTable;
        this._primaryTable = new Hashtable(this._minSize > this._secondaryTable.size() ? this._minSize : this._secondaryTable.size());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "evictStaleEntries");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearAllEntries() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clearAllEntries");
        }
        Hashtable hashtable = this._primaryTable;
        synchronized (hashtable) {
            this._primaryTable.clear();
            this._secondaryTable.clear();
            this.evictStaleEntries();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clearAllEntries");
        }
    }

    protected void mark() {
        if (this._wipeCache) {
            this._tertiaryTable.clear();
        } else {
            this._tertiaryTable.putAll(this._secondaryTable);
        }
        this._secondaryTable = this._primaryTable;
        this._primaryTable = new Hashtable(this._minSize > this._secondaryTable.size() ? this._minSize : this._secondaryTable.size() + 100);
    }

    public void alarm(Object object) {
        long l = System.currentTimeMillis();
        this.mark();
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
            stringBuffer.append(" Time elapsed cleaning cache: ");
            stringBuffer.append(System.currentTimeMillis() - l);
            stringBuffer.append(" milliseconds, Primary cache size: ");
            stringBuffer.append(this._primaryTable.size());
            stringBuffer.append(", Secondary cache size: ");
            stringBuffer.append(this._secondaryTable.size());
            stringBuffer.append(", Tertiary cache size: ");
            stringBuffer.append(this._tertiaryTable.size());
            Tr.debug(tc, stringBuffer.toString());
        }
    }

    private void addAlarmListener(AlarmListener alarmListener, long l) {
        if (l == this._defaultAlarm.getTimeout()) {
            this._defaultAlarm.addAlarmListener(alarmListener);
        } else {
            Alarm alarm = new Alarm(l);
            alarm.addAlarmListener(alarmListener);
        }
    }

    private class Alarm
    implements AlarmListener {
        private Vector alarms = new Vector();
        private long timeout;

        public void addAlarmListener(AlarmListener alarmListener) {
            this.alarms.addElement(alarmListener);
        }

        public Alarm(long l) {
            this.timeout = l / 2L;
            this.alarm(null);
        }

        public void alarm(Object object) {
            for (int i = 0; i < this.alarms.size(); ++i) {
                ((AlarmListener)this.alarms.elementAt(i)).alarm(object);
            }
            AlarmManager.create(this.timeout, this);
        }

        public long getTimeout() {
            return this.timeout * 2L;
        }
    }
}

