/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.handler;

import com.ibm.ws.wssecurity.core.WSSGenerator;
import com.ibm.ws.wssecurity.platform.auth.SecureConversationCacheHelper;
import com.ibm.ws.wssecurity.util.Axis2Util;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import javax.xml.namespace.QName;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;

public class WSSecurityInFaultHandler
extends AbstractHandler {
    private static final TraceComponent tc = Tr.register(WSSecurityInFaultHandler.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSecurityInFaultHandler.class.getName();

    public Handler.InvocationResponse invoke(MessageContext messageContext) throws AxisFault {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(MessageContext msgContext)" + messageContext);
        }
        boolean bl = false;
        try {
            String string;
            bl = Axis2Util.isServiceProvider(messageContext);
            if (!bl && (string = this.getFaultLocalName(messageContext)) != null) {
                if (string.compareTo(ConfigUtil.getMessage("security.wssecurity.SCTConsumeLoginModule.invalidSCT02")) == 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalidating SCT entry in the client cache.");
                    }
                    SecureConversationCacheHelper.invalidateCache(messageContext);
                } else if ("FailedAuthentication".equals(string)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalidating UNToken entry in the client cache.");
                    }
                    WSSGenerator.removeClientCacheUsernameTokenKeyFromMessage(messageContext);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(MessageContext msgContext)" + messageContext);
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private String getFaultLocalName(MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFaultLocalName(MessageContext msgContext)");
        }
        SOAPEnvelope sOAPEnvelope = messageContext.getEnvelope();
        SOAPFault sOAPFault = sOAPEnvelope.getBody().getFault();
        QName qName = null;
        String string = null;
        if (sOAPFault != null) {
            qName = sOAPFault.getCode().getValue().getTextAsQName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "fault details = " + sOAPFault.getCode().getValue().getText());
                Tr.debug(tc, "localPart = " + qName.getLocalPart());
                Tr.debug(tc, "namespace = " + qName.getNamespaceURI());
            }
            if (sOAPFault.getCode().getSubCode() != null) {
                qName = sOAPFault.getCode().getSubCode().getValue().getTextAsQName();
                if (sOAPFault.getCode().getSubCode().getSubCode() != null) {
                    qName = sOAPFault.getCode().getSubCode().getSubCode().getValue().getTextAsQName();
                }
            }
        }
        if (qName != null) {
            string = qName.getLocalPart();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFaultLocalName(MessageContext msgContext) returns result = " + string);
        }
        return string;
    }
}

