/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.handler;

import com.ibm.ws.wssecurity.platform.util.WSSSelfManagedData;
import com.ibm.ws.wssecurity.platform.util.WSSSelfManagedDataFactory;
import com.ibm.ws.wssecurity.util.PlatformContextUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.Constants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import javax.security.auth.Subject;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.SelfManagedDataManager;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;

public abstract class WSSecurityGlobalHandler
extends AbstractHandler
implements Handler,
SelfManagedDataManager {
    protected boolean inboundHandler;
    private static final TraceComponent tc = Tr.register(WSSecurityGlobalHandler.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    protected static WSSSelfManagedData selfMgrData = WSSSelfManagedDataFactory.getInstance();

    public abstract Handler.InvocationResponse invoke(MessageContext var1) throws AxisFault;

    public ByteArrayOutputStream serializeSelfManagedData(MessageContext messageContext) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "serializeSelfManagedData");
        }
        if (!WSSecurityGlobalHandler.isWebSphereServerProcess()) {
            return null;
        }
        HashMap<String, Subject> hashMap = new HashMap<String, Subject>();
        String string = Constants.WSSECURITY_TOKEN_WSSSUBJECT;
        Subject subject = (Subject)messageContext.getSelfManagedData(this.getClass(), 1);
        if (subject != null) {
            hashMap.put(string, subject);
        }
        byte[] byArray = selfMgrData.getSerializedSelfManagedData(hashMap);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        int n = byArray.length;
        dataOutputStream.write(byArray, 0, n);
        dataOutputStream.close();
        byteArrayOutputStream.close();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "serializeSelfManagedData");
        }
        return byteArrayOutputStream;
    }

    public void deserializeSelfManagedData(ByteArrayInputStream byteArrayInputStream, MessageContext messageContext) throws IOException {
        Object object;
        byte[] byArray;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "deserializeSelfManagedData");
            }
            if (!WSSecurityGlobalHandler.isWebSphereServerProcess()) {
                return;
            }
            byArray = null;
            try {
                object = new ObjectInputStream(byteArrayInputStream);
                byArray = (byte[])((ObjectInputStream)object).readObject();
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "enable to deserialize self managed data", exception);
            }
        }
        if (byArray == null || byArray.length == 0) {
            return;
        }
        object = selfMgrData.getDeserializedSelfManagedData(byArray);
        if (object == null || object.size() == 0) {
            return;
        }
        Object v = object.get(Constants.WSSECURITY_TOKEN_WSSSUBJECT);
        if (v != null && v instanceof Subject) {
            messageContext.setSelfManagedData(this.getClass(), 1, v);
            messageContext.setProperty(Constants.WSSECURITY_TOKEN_WSSSUBJECT, (Subject)v);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deserializeSelfManagedData");
        }
    }

    public void restoreTransientData(MessageContext messageContext) {
    }

    protected void setSelfManagedData(MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSelfManagedData");
        }
        if (!WSSecurityGlobalHandler.isWebSphereServerProcess()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setSelfManagedData. Not an WebSphere Server Process.");
            }
            return;
        }
        Subject subject = (Subject)messageContext.getProperty(Constants.WSSECURITY_TOKEN_WSSSUBJECT);
        if (subject != null) {
            messageContext.setSelfManagedData(this.getClass(), 1, subject);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSelfManagedData");
        }
    }

    protected static boolean isWebSphereServerProcess() {
        return PlatformContextUtil.isWebSphereServerProcess();
    }
}

