/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.handler;

import com.ibm.websphere.wssecurity.wssapi.token.UsernameToken;
import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.wssecurity.core.WSSGenerator;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManager;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManagerFactory;
import com.ibm.ws.wssecurity.util.Axis2Util;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.WSSecurityFactoryBuilder;
import com.ibm.ws.wssecurity.wssapi.token.impl.TokenFactory;
import com.ibm.ws.wssecurity.wssapi.token.impl.TokenFactoryFactory;
import com.ibm.ws.wssecurity.wssapi.token.impl.UsernameTokenImpl;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSecurityGeneratorBase
extends WSSGenerator {
    private static final TraceComponent tc = Tr.register(WSSecurityGeneratorBase.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSecurityGeneratorBase.class.getName();
    private final ThreadLocal _threadStore = new ThreadLocal();
    private static Map _globalObjectCache = new HashMap();
    private boolean _initialized = false;
    private static String _factoryKey = (String)WSSecurityFactoryBuilder.getImplClassName("com.ibm.ws.wssecurity.platform.UsernameToken");
    private static TokenFactory _UNTtokenFactory = TokenFactoryFactory.getTokenFactory(_factoryKey);

    public void init() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init()");
        }
        if (!this._initialized) {
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            super.init(hashMap);
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init()");
        }
    }

    public void invoke(MessageContext messageContext, WSSGeneratorConfig wSSGeneratorConfig) throws AxisFault {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(MessageContext mcontext[" + messageContext + "]," + "WSSGeneratorConfig config[" + wSSGeneratorConfig + "])");
        }
        MessageContext messageContext2 = messageContext;
        boolean bl = false;
        try {
            bl = Axis2Util.isServiceProvider(messageContext2);
        }
        catch (Exception exception) {
            throw AxisFault.makeFault(exception);
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        hashMap.put("com.ibm.wsspi.wssecurity.core.messageContext", messageContext);
        hashMap.put("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey", wSSGeneratorConfig);
        try {
            super.invoke(null, null, hashMap);
            if (tc.isDebugEnabled()) {
                SOAPEnvelope sOAPEnvelope = messageContext2.getEnvelope();
                OMDocument oMDocument = DOMUtil.getOwnerDocument(sOAPEnvelope);
                if (oMDocument != null) {
                    Tr.debug(tc, "The message processed by: " + (bl ? "server side" : "client side") + " " + this.getClass().getName() + " : " + DOMUtils.toString(oMDocument.getOMDocumentElement()));
                } else {
                    Tr.debug(tc, "No SOAPEnvelope found!");
                }
            }
        }
        catch (SoapSecurityException soapSecurityException) {
            Tr.processException((Throwable)soapSecurityException, clsName + ".invoke", "111", this);
            Tr.error(tc, "security.wssecurity.WSSConsumer.s23", soapSecurityException);
            AxisFault axisFault = AxisFault.makeFault(soapSecurityException);
            if (bl) {
                if (soapSecurityException.getFaultCode() != null) {
                    axisFault.setFaultCode(soapSecurityException.getFaultCode());
                } else {
                    axisFault.setFaultCode(new QName(Constants.NS_SOAP, "Server.securityException"));
                }
            } else {
                axisFault.setFaultCode(new QName(Constants.NS_SOAP, "Client.securityException"));
            }
            throw axisFault;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(MessageContext mcontext,WSSGeneratorConfig config)");
        }
    }

    @Override
    public void retrieveCachedInformation(MessageContext messageContext, Map<Object, Object> map) throws SoapSecurityException {
        Object object;
        Object object2;
        WSSGeneratorConfig wSSGeneratorConfig;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "retrieveCachedInformation(MessageContext context, Map contextMap)");
        }
        if ((wSSGeneratorConfig = (WSSGeneratorConfig)map.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey")).getShouldCacheUsernameTokens()) {
            object2 = messageContext;
            object = this.getClientCacheUsernameTokenKeyFromMessage((MessageContext)object2);
            if (object != null && object instanceof UsernameToken) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Retrieved username token found [" + object + "].");
                }
                messageContext.setProperty("com.ibm.wsspi.wssecurity.username.basicAuthToken", object);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Retrieved username token not found.");
            }
        }
        if ((object2 = this.getInitialSenderId()) != null && ((String)object2).length() > 0) {
            object = (UsernameTokenImpl)AccessController.doPrivileged(new PrivilegedAction((String)object2){
                final /* synthetic */ String val$initialSenderId;
                {
                    this.val$initialSenderId = string;
                }

                public Object run() {
                    UsernameTokenImpl usernameTokenImpl = (UsernameTokenImpl)_UNTtokenFactory.getToken(true);
                    usernameTokenImpl.setUsername(this.val$initialSenderId);
                    return usernameTokenImpl;
                }
            });
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Retrieved identifier of initial sender found [" + object + "].");
            }
            messageContext.setProperty("com.ibm.wsspi.wssecurity.username.initialSenderId", object);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Retrieved identifier of initial sender not found.");
        }
        object = this.getInitialSenderCert();
        if (object != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Retrieved cert of initial sender found [" + object + "].");
            }
            messageContext.setProperty("com.ibm.wsspi.wssecurity.username.initialSenderCert", object);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Retrieved cert of initial sender not found.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "retrieveCachedInformation(MessageContext context, Map contextMap)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getObject(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObject(Object key[" + object + "])");
        }
        Object var2_2 = null;
        if (object != null && (var2_2 = this.getThreadStore().get(object)) == null) {
            Map map = _globalObjectCache;
            synchronized (map) {
                var2_2 = _globalObjectCache.get(object);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObject(Object key) " + (var2_2 == null ? "not found" : "found"));
        }
        return var2_2;
    }

    private Map getThreadStore() {
        HashMap hashMap = (HashMap)this._threadStore.get();
        if (hashMap == null) {
            hashMap = new HashMap();
            this._threadStore.set(hashMap);
        }
        return hashMap;
    }

    private String getInitialSenderId() throws SoapSecurityException {
        Iterator<Principal> iterator;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInitialSenderId()");
        }
        Subject subject = (Subject)WSSContextManagerFactory.getInstance().get("com.ibm.wsspi.wssecurity.username.initialSenderId");
        String string = null;
        if (subject != null && (iterator = subject.getPrincipals().iterator()).hasNext()) {
            string = iterator.next().getName();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInitialSenderId() returns String[" + string + "]");
        }
        return string;
    }

    private X509Certificate getInitialSenderCert() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInitialSenderCert()");
        }
        X509Certificate x509Certificate = null;
        WSSContextManager wSSContextManager = WSSContextManagerFactory.getInstance();
        if (wSSContextManager == null) {
            Tr.error(tc, "security.wssecurity.ctxmgr.isnull");
            throw SoapSecurityException.format("security.wssecurity.ctxmgr.isnull");
        }
        x509Certificate = (X509Certificate)wSSContextManager.get("com.ibm.wsspi.wssecurity.username.initialSenderCert");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Initial Sender Cert", x509Certificate);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInitialSenderCert() returns X509Certificate[" + x509Certificate + "]");
        }
        return x509Certificate;
    }
}

