/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.handler;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.wssecurity.core.WSSConsumer;
import com.ibm.ws.wssecurity.util.Axis2Util;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;

public class WSSecurityConsumerBase
extends WSSConsumer {
    private static final TraceComponent tc = Tr.register(WSSecurityConsumerBase.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSecurityConsumerBase.class.getName();
    private boolean _initialized = false;

    public void init() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init()");
        }
        if (!this._initialized) {
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            super.init(hashMap);
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init()");
        }
    }

    public void invoke(MessageContext messageContext, WSSConsumerConfig wSSConsumerConfig) throws AxisFault {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(MessageContext mcontext[" + messageContext + "]," + "WSSConsumerConfig config[" + wSSConsumerConfig + "])");
        }
        MessageContext messageContext2 = messageContext;
        boolean bl = false;
        try {
            bl = Axis2Util.isServiceProvider(messageContext2);
        }
        catch (Exception exception) {
            throw AxisFault.makeFault(exception);
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        hashMap.put("com.ibm.wsspi.wssecurity.core.messageContext", messageContext);
        hashMap.put("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey", wSSConsumerConfig);
        try {
            super.invoke(null, hashMap);
            if (tc.isDebugEnabled()) {
                SOAPEnvelope sOAPEnvelope = messageContext2.getEnvelope();
                OMDocument oMDocument = DOMUtil.getOwnerDocument(sOAPEnvelope);
                if (oMDocument != null) {
                    Tr.debug(tc, "The message processed by: " + (bl ? "server side" : "client side") + " " + this.getClass().getName() + " : " + DOMUtils.toString(oMDocument.getOMDocumentElement()));
                } else {
                    Tr.debug(tc, "No SOAPEnvelope found!");
                }
            }
        }
        catch (SoapSecurityException soapSecurityException) {
            Tr.processException((Throwable)soapSecurityException, clsName + ".invoke", "94", this);
            Tr.error(tc, "security.wssecurity.WSSConsumer.s23", soapSecurityException);
            AxisFault axisFault = AxisFault.makeFault(soapSecurityException);
            if (bl) {
                if (ConfigUtil.shouldUseStandardFaultCodes(hashMap)) {
                    QName qName = soapSecurityException.getFaultCode();
                    if (qName == null) {
                        qName = (QName)hashMap.get("com.ibm.ws.wssecurity.sc.FaultCode");
                    }
                    if (qName != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Fault Code = " + qName.toString());
                        }
                        messageContext.setProperty("com.ibm.ws.wssecurity.sc.FaultCode", qName);
                        axisFault.setFaultCode(qName);
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Fault Code = NULL");
                        }
                        axisFault.setFaultCode(new QName(Constants.NS_SOAP, "Server.securityException"));
                    }
                } else if (soapSecurityException.getFaultCode() != null) {
                    axisFault.setFaultCode(soapSecurityException.getFaultCode());
                } else {
                    axisFault.setFaultCode(new QName(Constants.NS_SOAP, "Server.securityException"));
                }
            } else {
                axisFault.setFaultCode(new QName(Constants.NS_SOAP, "Client.securityException"));
            }
            throw axisFault;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(WSSMessageContext mcontext,WSSConsumerConfig config)");
        }
    }
}

