/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.handler;

import com.ibm.ws.policyset.runtime.BindingLoader;
import com.ibm.ws.policyset.runtime.DefaultBinding;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.policyset.runtime.VariableExpander;
import com.ibm.ws.wssecurity.confimpl.PrivateConsumerConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateGeneratorConfig;
import com.ibm.ws.wssecurity.core.WSSecurityDefaultConfiguration;
import com.ibm.ws.wssecurity.handler.Constants;
import com.ibm.ws.wssecurity.handler.PolicyInboundConfig;
import com.ibm.ws.wssecurity.handler.PolicyOutboundConfig;
import com.ibm.ws.wssecurity.platform.util.ConfigHelperFactory;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SecurityBindings;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.xmlsoap.schemas.ws._2004._09.policy.Policy;

public class WSSecurityBindingLoaderImpl
implements BindingLoader {
    private boolean ndEnvironment = false;
    private static final TraceComponent tc = Tr.register(WSSecurityBindingLoaderImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSecurityBindingLoaderImpl.class.getName();
    private static JAXBContext jaxbContext = null;

    public void init(Map map) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map properties)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map properties)");
        }
    }

    private static synchronized JAXBContext getJAXBContext() throws JAXBException {
        if (jaxbContext != null) {
            return jaxbContext;
        }
        final ClassLoader classLoader = WSSecurityBindingLoaderImpl.class.getClassLoader();
        try {
            jaxbContext = (JAXBContext)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws JAXBException {
                    return JAXBContext.newInstance("com.ibm.xmlns.prod.websphere._200608.ws_securitybinding", classLoader);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception received from JAXB. Unable to load PolicySet: " + throwable);
            }
            if (throwable instanceof JAXBException) {
                throw (JAXBException)throwable;
            }
            throw new JAXBException(throwable.getMessage());
        }
        return jaxbContext;
    }

    public void loadDefault(ClassLoader classLoader, VariableExpander variableExpander, InputStream inputStream, DefaultBinding defaultBinding) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadDefault(ClassLoader sysCL, VariableExpander vm, InputStream defaultBindingStream, DefaultBinding defaultBinding): ", new Object[]{classLoader, variableExpander, inputStream, defaultBinding});
        }
        SecurityBindings securityBindings = null;
        WSSecurityDefaultConfiguration wSSecurityDefaultConfiguration = new WSSecurityDefaultConfiguration();
        JAXBContext jAXBContext = null;
        try {
            jAXBContext = WSSecurityBindingLoaderImpl.getJAXBContext();
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught in loadDefault() while getting JAXBContext for Default Bindings");
            }
            Tr.processException((Throwable)exception, clsName + ".loadDefault", "%C", this);
            throw SoapSecurityException.format("security.wssecurity.WSSecurityBindingLoaderImpl.s01", exception);
        }
        if (jAXBContext != null) {
            try {
                Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
                if (inputStream != null) {
                    securityBindings = (SecurityBindings)unmarshaller.unmarshal(inputStream);
                }
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught in loadDefault() while unmarshalling.  Error while loading PolicySet Default Bindings");
                }
                Tr.processException((Throwable)exception, clsName + ".loadDefault", "%C", this);
                throw SoapSecurityException.format("security.wssecurity.WSSecurityBindingLoaderImpl.s01", exception);
            }
            finally {
                inputStream.close();
            }
            if (securityBindings == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No WSSecurity Default Bindings were found.");
                }
                throw SoapSecurityException.format("security.wssecurity.WSSecurityBindingLoaderImpl.s03");
            }
        } else {
            Tr.error(tc, "security.wssecurity.WSSecurityBindingLoaderImpl.s02");
            throw SoapSecurityException.format("security.wssecurity.WSSecurityBindingLoaderImpl.s02");
        }
        ConfigHelperFactory.getInstance().loadConfig(this.ndEnvironment, variableExpander, wSSecurityDefaultConfiguration, securityBindings, defaultBinding);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadDefault(ClassLoader sysCL, VariableExpander vm, String defaultBindingPathname, DefaultBinding defaultBinding)");
        }
    }

    public void loadCustom(ClassLoader classLoader, ClassLoader classLoader2, VariableExpander variableExpander, InputStream inputStream, DefaultBinding defaultBinding, PolicySetConfiguration policySetConfiguration) throws Exception {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadCustom(ClassLoader appCL, ClassLoader sysCL, VariableExpander vm, String appBindingPathname, DefaultBinding defaultBinding, PolicySetConfiguration psConfig): ", new Object[]{classLoader, classLoader2, variableExpander, inputStream, defaultBinding, policySetConfiguration});
        }
        WSSecurityDefaultConfiguration wSSecurityDefaultConfiguration = null;
        String string = null;
        Policy policy = null;
        if (policySetConfiguration == null) {
            Tr.error(tc, "security.wssecurity.WSSecurityBindingLoaderImpl.s08");
            throw SoapSecurityException.format("security.wssecurity.WSSecurityBindingLoaderImpl.s08");
        }
        if (defaultBinding != null) {
            object2 = defaultBinding.getDefaultBinding(Constants.WS_SECURITY_DEFAULT_BINDING_KEY);
            if (object2 != null) {
                if (object2 instanceof WSSecurityDefaultConfiguration) {
                    wSSecurityDefaultConfiguration = (WSSecurityDefaultConfiguration)object2;
                } else if (object2 instanceof Exception) {
                    if (tc.isDebugEnabled()) {
                        object = (Exception)object2;
                        Tr.debug(tc, "Exception retrieved from getDefaultBinding: " + object);
                    }
                } else if (tc.isDebugEnabled()) {
                    object = "Unexpected object type found for WSSecurityDefaultConfiguration. Found " + object2.getClass().getName() + ". Expected " + Policy.class.getName() + ".";
                    Tr.debug(tc, (String)object);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No default bindings found.");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Default  bindings [" + wSSecurityDefaultConfiguration + "]");
            }
        }
        try {
            Object object3;
            object2 = WSSecurityBindingLoaderImpl.getJAXBContext();
            if (object2 == null) {
                Tr.error(tc, "security.wssecurity.WSSecurityBindingLoaderImpl.s06");
                throw SoapSecurityException.format("security.wssecurity.WSSecurityBindingLoaderImpl.s06");
            }
            object = null;
            final Unmarshaller unmarshaller = ((JAXBContext)object2).createUnmarshaller();
            if (inputStream != null) {
                object3 = inputStream;
                try {
                    object = (SecurityBindings)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>((InputStream)object3){
                        final /* synthetic */ InputStream val$bindingInputStream;
                        {
                            this.val$bindingInputStream = inputStream;
                        }

                        @Override
                        public Object run() throws JAXBException {
                            return (SecurityBindings)unmarshaller.unmarshal(this.val$bindingInputStream);
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Throwable throwable = privilegedActionException.getCause();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception received from Unmarshaller. Unable to load PolicySet: " + throwable);
                    }
                    if (throwable instanceof JAXBException) {
                        throw (JAXBException)throwable;
                    }
                    throw new JAXBException(throwable.getMessage());
                }
                finally {
                    ((InputStream)object3).close();
                    inputStream.close();
                }
            }
            if (object == null) {
                if (wSSecurityDefaultConfiguration == null) {
                    Tr.error(tc, "security.wssecurity.WSSecurityBindingLoaderImpl.s07");
                    throw SoapSecurityException.format("security.wssecurity.WSSecurityBindingLoaderImpl.s07");
                }
                Tr.warning(tc, "security.wssecurity.WSSecurityBindingLoaderImpl.s09");
            }
            if ((object3 = policySetConfiguration.getPolicyTypeConfiguration(Constants.WS_SECURITY_POLICY_JAXBOBJECT_KEY)) != null) {
                if (!(object3 instanceof Policy)) {
                    if (object3 instanceof Exception) {
                        Exception exception = (Exception)object3;
                        Tr.processException((Throwable)exception, clsName + ".loadCustom", "%C", this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception retrieved from PolicyTypeLoader: " + exception);
                        }
                        throw SoapSecurityException.format("security.wssecurity.WSSecurityBindingLoaderImpl.s11", exception);
                    }
                    Tr.error(tc, "security.wssecurity.WSSecurityBindingLoaderImpl.s10", new Object[]{Policy.class.getName(), object3.getClass().getName()});
                    throw SoapSecurityException.format("security.wssecurity.WSSecurityBindingLoaderImpl.s10", Policy.class.getName(), object3.getClass().getName());
                }
            } else {
                Tr.error(tc, "security.wssecurity.WSSecurityBindingLoaderImpl.s08");
                throw SoapSecurityException.format("security.wssecurity.WSSecurityBindingLoaderImpl.s08");
            }
            policy = (Policy)object3;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found WSSecurity JAXB Policy Object" + policy + "\"");
            }
            if ((object3 = policySetConfiguration.getPolicyTypeConfiguration(Constants.POLICY_SET_ATTACHMENT_TYPE)) != null) {
                if (!(object3 instanceof String)) {
                    Tr.error(tc, "security.wssecurity.WSSecurityBindingLoaderImpl.s12", new Object[]{object3.getClass().getName()});
                    throw SoapSecurityException.format("security.wssecurity.WSSecurityBindingLoaderImpl.s12", object3.getClass().getName());
                }
            } else {
                Tr.error(tc, "security.wssecurity.WSSecurityBindingLoaderImpl.s13");
                throw SoapSecurityException.format("security.wssecurity.WSSecurityBindingLoaderImpl.s13");
            }
            string = (String)object3;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found policy set attachment type: \"" + string + "\"");
            }
            boolean bl = false;
            boolean bl2 = false;
            if (Constants.CLIENT_ATTACHMENT.equals(string)) {
                bl2 = true;
                bl = false;
            } else if (Constants.SERVER_ATTACHMENT.equals(string)) {
                bl2 = false;
                bl = true;
            } else if (Constants.TRUST_SERVICE_ATTACHMENT.equals(string)) {
                bl2 = false;
                bl = true;
            } else {
                Tr.error(tc, "security.wssecurity.WSSecurityBindingLoaderImpl.s12", new Object[]{string});
                throw SoapSecurityException.format("security.wssecurity.WSSecurityBindingLoaderImpl.s12", string);
            }
            if (tc.isDebugEnabled()) {
                if (bl2) {
                    Tr.debug(tc, "Outbound message is a request.");
                } else {
                    Tr.debug(tc, "Outbound message is a response.");
                }
                if (bl) {
                    Tr.debug(tc, "Inbound message is a request.");
                } else {
                    Tr.debug(tc, "Inbound message is a response.");
                }
            }
            PolicyInboundConfig policyInboundConfig = null;
            policyInboundConfig = new PolicyInboundConfig((SecurityBindings)object, policy, bl, classLoader, wSSecurityDefaultConfiguration);
            policySetConfiguration.setPolicyTypeBinding(PrivateConsumerConfig.class, policyInboundConfig);
            PolicyOutboundConfig policyOutboundConfig = null;
            policyOutboundConfig = new PolicyOutboundConfig((SecurityBindings)object, policy, bl2, classLoader, wSSecurityDefaultConfiguration);
            policySetConfiguration.setPolicyTypeBinding(PrivateGeneratorConfig.class, policyOutboundConfig);
        }
        catch (SoapSecurityException soapSecurityException) {
            Tr.processException((Throwable)soapSecurityException, clsName + ".loadCustom", "%C", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught in loadCustom().  Error while loading PolicySet Bindings");
            }
            policySetConfiguration.setPolicyTypeBinding(PrivateConsumerConfig.class, soapSecurityException);
            policySetConfiguration.setPolicyTypeBinding(PrivateGeneratorConfig.class, soapSecurityException);
            throw soapSecurityException;
        }
        catch (Exception exception) {
            Tr.processException((Throwable)exception, clsName + ".loadCustom", "%C", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught in loadCustom().  Error while loading PolicySet Bindings");
            }
            object = SoapSecurityException.format("security.wssecurity.WSSecurityBindingLoaderImpl.s05", exception);
            policySetConfiguration.setPolicyTypeBinding(PrivateConsumerConfig.class, object);
            policySetConfiguration.setPolicyTypeBinding(PrivateGeneratorConfig.class, object);
            throw object;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadCustom(ClassLoader appCL, ClassLoader sysCL, VariableExpander vm, String appBindingPathname, DefaultBinding defaultBinding, PolicySetConfiguration psConfig)");
        }
    }

    public String getType() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getType()");
        }
        String string = Constants.WS_SECURITY_POLICY_TYPE_NAME;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getType() returns \"" + string + "\"");
        }
        return string;
    }

    public void destroy() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy()");
        }
    }
}

