/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.handler;

import com.ibm.ws.policyset.runtime.VariableExpanderFactory;
import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.config.KeyInfoContentConsumerConfig;
import com.ibm.ws.wssecurity.config.ReferencePartConfig;
import com.ibm.ws.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateCommonConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateConsumerConfig;
import com.ibm.ws.wssecurity.core.CertManagerFactory;
import com.ibm.ws.wssecurity.core.NonceManagerFactory;
import com.ibm.ws.wssecurity.core.WSSFactory;
import com.ibm.ws.wssecurity.core.WSSecurityDefaultConfiguration;
import com.ibm.ws.wssecurity.core.token.TokenConsumerComponent;
import com.ibm.ws.wssecurity.handler.PolicyConfigUtil;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoContentConsumerComponent;
import com.ibm.ws.wssecurity.platform.util.PasswordUtilFactory;
import com.ibm.ws.wssecurity.token.CertCacheManager;
import com.ibm.ws.wssecurity.token.NonceManager;
import com.ibm.ws.wssecurity.util.ConfigConstants;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.KeyStoreManager;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.Configuration;
import com.ibm.wsspi.wssecurity.core.config.TokenConsumerConfig;
import com.ibm.xmlns.prod.websphere._200605.ws_securitypolicy_ext.WssCustomToken;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.CRL;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.CollectionCertStores;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.DataEncryptionKeyInfo;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.KeyEncryptionKeyInfo;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.LdapCertStores;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SecurityBinding;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SecurityBindings;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SecurityInboundBindingConfig;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SigningInfo;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.SigningPartReference;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.TokenConsumer;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.Transform;
import com.ibm.xmlns.prod.websphere._200608.ws_securitybinding.X509Certificates;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.LDAPCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.HeaderType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.NestedPolicyType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.SePartsType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.SecureConversationTokenType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.SerElementsType;
import org.oasis_open.docs.ws_sx.ws_securitypolicy._200512.TokenAssertionType;
import org.w3c.dom.Element;
import org.xmlsoap.schemas.ws._2004._09.policy.OperatorContentType;
import org.xmlsoap.schemas.ws._2004._09.policy.Policy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyInboundConfig
extends PrivateConsumerConfig {
    private Map<String, TokenConsumerConfig> nameToken;
    private Map<String, String> encryptionAlgorithms;
    private Map<String, String> keyEncryptionAlgorithms;
    private Map<String, String> asymmetricSignatureAlgorithms;
    private Map<String, String> symmetricSignatureAlgorithms;
    private Map<String, String> canonicalizationAlgorithms;
    private Map<String, String> transformAlgorithms;
    private Map<String, String> digestAlgorithms;
    private String asymmetricSignatureAlgorithm = null;
    private String symmetricSignatureAlgorithm = null;
    private String digestAlgorithm = null;
    private String transformAlgorithm = null;
    private String canonicalizationAlgorithm = null;
    private String encryptionAlgorithm = null;
    private String keyEncryptionAlgorithm = null;
    private String algorithmSuite = null;
    private static final TraceComponent tc = Tr.register(PolicyInboundConfig.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = PolicyInboundConfig.class.getName();
    private static SecurityBindings securityBindings;
    private SecurityBinding securityBinding = null;
    private String origin = "non-ws-security";

    public PolicyInboundConfig(SecurityBindings securityBindings, Policy policy, boolean bl, ClassLoader classLoader, WSSecurityDefaultConfiguration wSSecurityDefaultConfiguration) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "security.wssecurity.PolicyInboundConfig.s01", new Object[]{securityBindings, policy, bl, classLoader, wSSecurityDefaultConfiguration});
        }
        SecurityInboundBindingConfig securityInboundBindingConfig = null;
        if (securityBindings != null) {
            PolicyInboundConfig.securityBindings = securityBindings;
            List<SecurityBinding> list = PolicyInboundConfig.securityBindings.getSecurityBinding();
            for (int i = 0; i < list.size(); ++i) {
                this.securityBinding = list.get(i);
                if (!this.securityBinding.getName().equals("application")) continue;
                securityInboundBindingConfig = this.securityBinding.getSecurityInboundBindingConfig();
            }
        } else {
            if (wSSecurityDefaultConfiguration == null) {
                throw new SoapSecurityException("security.wssecurity.PolicyInboundConfig.s02");
            }
            Tr.warning(tc, "No Application Bindings found, will use Default Bindings");
        }
        this.init(securityInboundBindingConfig, policy, bl, classLoader, wSSecurityDefaultConfiguration);
        this.origin = "ws-security";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "security.wssecurity.PolicyInboundConfig.s01", new Object[]{securityBindings, policy, bl, classLoader});
        }
    }

    public PolicyInboundConfig(SecurityInboundBindingConfig securityInboundBindingConfig, Policy policy, boolean bl, ClassLoader classLoader, WSSecurityDefaultConfiguration wSSecurityDefaultConfiguration) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "PolicyInboundConfig(SecurityInboundBindingConfig binding, Policy policyRoot, boolean isRequest, ClassLoader appClassLoader,WSSecurityDefaultConfiguration defaultConfiguration):", new Object[]{securityInboundBindingConfig, policy, bl, classLoader});
        }
        if (securityInboundBindingConfig == null && wSSecurityDefaultConfiguration == null) {
            throw new SoapSecurityException("security.wssecurity.PolicyInboundConfig.s02");
        }
        this.init(securityInboundBindingConfig, policy, bl, classLoader, wSSecurityDefaultConfiguration);
        this.origin = "ws-security";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "PolicyInboundConfig(SecurityInboundBindingConfig binding, Policy policyRoot, boolean isRequest, ClassLoader appClassLoader,WSSecurityDefaultConfiguration defaultConfiguration)", new Object[]{securityInboundBindingConfig, policy, bl, classLoader});
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    protected final void init(SecurityInboundBindingConfig var1_1, Policy var2_2, boolean var3_3, ClassLoader var4_4, WSSecurityDefaultConfiguration var5_5) throws SoapSecurityException {
        block347: {
            if (PolicyInboundConfig.tc.isEntryEnabled()) {
                Tr.entry(PolicyInboundConfig.tc, "init(SecurityInboundBindingConfig binding, Policy policyRoot, String actorURI, boolean isRequest,ClassLoader appClassLoader,WSSecurityDefaultConfiguration defaultConfiguration):", new Object[]{var1_1, var2_2, var3_3, var4_4});
            }
            var6_6 = null;
            var7_7 = 0;
            var8_8 = 0;
            var9_9 = 0;
            var12_10 = null;
            var24_11 = new HashMap<K, V>();
            var25_12 = new HashMap<K, V>();
            var26_13 = new HashMap<String, TokenConsumerConfig>();
            var27_14 = WSSFactory.getInstance("soap");
            var28_15 = new HashMap<Object, Object>();
            var29_16 = new HashMap<String, PrivateConsumerConfig.KeyInfoContentConsumerConfImpl>();
            var30_17 = new HashMap<List<TokenConsumer>, PrivateCommonConfig.ReferencePartConfImpl>();
            var31_18 = new HashMap<List<TokenConsumer>, PrivateCommonConfig.ReferencePartConfImpl>();
            this.nameToken = new HashMap<String, TokenConsumerConfig>();
            this.encryptionAlgorithms = new HashMap<String, String>();
            this.keyEncryptionAlgorithms = new HashMap<String, String>();
            this.asymmetricSignatureAlgorithms = new HashMap<String, String>();
            this.symmetricSignatureAlgorithms = new HashMap<String, String>();
            this.canonicalizationAlgorithms = new HashMap<String, String>();
            this.transformAlgorithms = new HashMap<String, String>();
            this.digestAlgorithms = new HashMap<String, String>();
            var32_19 = new ArrayList<List<TokenConsumer>>();
            var33_20 = new ArrayList<List<TokenConsumer>>();
            var34_21 = null;
            this._initiatorTokens = new HashMap<K, V>();
            this._recipientTokens = new HashMap<K, V>();
            this._initiatorSignatureTokens = new HashMap<K, V>();
            this._recipientSignatureTokens = new HashMap<K, V>();
            this._initiatorEncryptionTokens = new HashMap<K, V>();
            this._recipientEncryptionTokens = new HashMap<K, V>();
            var35_22 = var1_1 == null;
            this._request = var3_3;
            this._timestampRequired = false;
            this._layout = "Lax";
            var36_23 = VariableExpanderFactory.getVariableExpander();
            this.processPrivateConfig(DOMUtils.getPrivateConfig());
            if (this._properties == null) {
                this._properties = new HashMap<K, V>();
            }
            var37_24 = null;
            var38_25 = null;
            if (this.securityBinding != null) {
                var39_26 = this.securityBinding.getParameters();
                if (var39_26 != null && (var37_24 = ConfigConstants.getProperties(var39_26, var36_23)) != null) {
                    this._properties.putAll(var37_24);
                }
                if (var1_1 != null && (var40_29 /* !! */  = var1_1.getProperties()) != null && (var38_25 = ConfigConstants.getProperties(var40_29 /* !! */ , var36_23)) != null) {
                    this._properties.putAll(var38_25);
                }
            }
            if (var1_1 != null) {
                if (var1_1.getActor() != null) {
                    var39_26 = var1_1.getActor().trim();
                    if (var39_26.length() != 0) {
                        try {
                            new URI((String)var39_26);
                        }
                        catch (URISyntaxException var40_30) {
                            throw new SoapSecurityException("security.wssecurity.PolicyInboundConfig.s05", var40_30);
                        }
                        this._myActor = var39_26;
                    }
                } else {
                    this._myActor = null;
                }
            }
            if (var2_2 == null) break block347;
            var39_26 = var2_2.getPolicyOrAllOrExactlyOne();
            var40_29 /* !! */  = null;
            if (var39_26 == null) break block347;
            for (var41_31 = 0; var41_31 < var39_26.size(); ++var41_31) {
                block348: {
                    var40_29 /* !! */  = var39_26.get(var41_31);
                    if (!(var40_29 /* !! */  instanceof Policy)) break block348;
                    var42_36 = (Policy)var40_29 /* !! */ ;
                    var43_38 = var42_36.getId();
                    var44_39 = false;
                    var44_39 = this.retrieveAssertions((String)var43_38, var3_3);
                    if (!var44_39) continue;
                    var45_42 = var42_36.getPolicyOrAllOrExactlyOne();
                    for (var46_43 = 0; var46_43 < var45_42.size(); ++var46_43) {
                        block350: {
                            block351: {
                                block349: {
                                    var40_29 /* !! */  = var45_42.get(var46_43);
                                    if (!(var40_29 /* !! */  instanceof JAXBElement)) continue;
                                    var47_46 = (JAXBElement)var40_29 /* !! */ ;
                                    var48_55 /* !! */  = var47_46.getName();
                                    if (PolicyConfigUtil.signedPartsQName.equals(var48_55 /* !! */ )) {
                                        this._verificationRequired = true;
                                        var49_56 = 0;
                                        if (var31_18.containsKey(var43_38)) {
                                            var19_34 = (PrivateCommonConfig.ReferencePartConfImpl)var31_18.get(var43_38);
                                            var49_56 = 1;
                                        } else {
                                            var19_34 = new PrivateCommonConfig.ReferencePartConfImpl();
                                        }
                                        var19_34._oneOfIntegralParts = true;
                                        var50_64 = (SePartsType)var47_46.getValue();
                                        var51_66 = var50_64.getBody();
                                        if (var51_66 != null) {
                                            var18_33 = new PrivateCommonConfig.PartConfImpl();
                                            var18_33._dialect = Constants.DIALECT_WAS;
                                            var18_33._keyword = "body";
                                            var19_34._parts.add(var18_33);
                                        }
                                        if ((var52_74 = var50_64.getHeader()) != null) {
                                            for (var53_75 = 0; var53_75 < var52_74.size(); ++var53_75) {
                                                var54_87 = (HeaderType)var52_74.get(var53_75);
                                                var18_33 = new PrivateCommonConfig.PartConfImpl();
                                                var18_33._dialect = Constants.DIALECT_HEADER;
                                                var55_94 = var54_87.getName();
                                                if (var55_94 != null) {
                                                    var18_33._headerName = var55_94.getLocalPart();
                                                }
                                                var18_33._headerNamespace = var54_87.getNamespace();
                                                var19_34._parts.add(var18_33);
                                            }
                                        }
                                        if (var49_56 != 0) continue;
                                        var19_34._order = 0;
                                        this._requiredIntegralParts.add(var19_34);
                                        if (var43_38 == null || var43_38.length() == 0) {
                                            throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s21");
                                        }
                                        if (var31_18.containsKey(var43_38) && PolicyInboundConfig.tc.isDebugEnabled()) {
                                            Tr.debug(PolicyInboundConfig.tc, "WARNING: required integrity [" + var43_38 + "] is overwritten.");
                                        }
                                        if (PolicyInboundConfig.tc.isDebugEnabled()) {
                                            Tr.debug(PolicyInboundConfig.tc, "Adding required integrity: " + var43_38);
                                        }
                                        var31_18.put((List<TokenConsumer>)var43_38, var19_34);
                                        var32_19.add((List<TokenConsumer>)var43_38);
                                        continue;
                                    }
                                    if (PolicyConfigUtil.encryptedPartsQName.equals(var48_55 /* !! */ )) {
                                        this._decryptionRequired = true;
                                        var49_56 = 0;
                                        if (var30_17.containsKey(var43_38)) {
                                            var19_34 = (PrivateCommonConfig.ReferencePartConfImpl)var30_17.get(var43_38);
                                            var49_56 = 1;
                                        } else {
                                            var19_34 = new PrivateCommonConfig.ReferencePartConfImpl();
                                        }
                                        var50_64 = (SePartsType)var47_46.getValue();
                                        var51_66 = var50_64.getBody();
                                        if (var51_66 != null) {
                                            var18_33 = new PrivateCommonConfig.PartConfImpl();
                                            var18_33._dialect = Constants.DIALECT_WAS;
                                            var18_33._keyword = "bodycontent";
                                            var19_34._parts.add(var18_33);
                                        }
                                        if ((var52_74 = var50_64.getHeader()) != null) {
                                            for (var53_75 = 0; var53_75 < var52_74.size(); ++var53_75) {
                                                var54_87 = (HeaderType)var52_74.get(var53_75);
                                                var18_33 = new PrivateCommonConfig.PartConfImpl();
                                                var18_33._dialect = Constants.DIALECT_HEADER;
                                                var55_94 = var54_87.getName();
                                                if (var55_94 != null) {
                                                    var18_33._headerName = var55_94.getLocalPart();
                                                }
                                                var18_33._headerNamespace = var54_87.getNamespace();
                                                var19_34._parts.add(var18_33);
                                            }
                                        }
                                        if (var49_56 != 0) continue;
                                        var19_34._order = 0;
                                        this._requiredConfidentialParts.add(var19_34);
                                        if (var43_38 == null || var43_38.length() == 0) {
                                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s21");
                                        }
                                        if (var30_17.containsKey(var6_6) && PolicyInboundConfig.tc.isDebugEnabled()) {
                                            Tr.debug(PolicyInboundConfig.tc, "WARNING: required confidentiality [" + var43_38 + "] is overwritten.");
                                        }
                                        if (PolicyInboundConfig.tc.isDebugEnabled()) {
                                            Tr.debug(PolicyInboundConfig.tc, "Adding required confidentiality: " + var43_38);
                                        }
                                        var30_17.put((List<TokenConsumer>)var43_38, var19_34);
                                        var33_20.add((List<TokenConsumer>)var43_38);
                                        continue;
                                    }
                                    if (!PolicyConfigUtil.signedElementsQName.equals(var48_55 /* !! */ )) break block349;
                                    this._verificationRequired = true;
                                    var49_56 = 0;
                                    if (var31_18.containsKey(var43_38)) {
                                        var19_34 = (PrivateCommonConfig.ReferencePartConfImpl)var31_18.get(var43_38);
                                        var49_56 = 1;
                                    } else {
                                        var19_34 = new PrivateCommonConfig.ReferencePartConfImpl();
                                    }
                                    var19_34._oneOfIntegralParts = true;
                                    var50_64 = (SerElementsType)var47_46.getValue();
                                    var51_66 = var50_64.getXPath();
                                    if (var51_66 == null) continue;
                                    var52_74 = new HashMap<Map<Object, Object>, List<SigningPartReference>>();
                                    for (var53_75 = 0; var53_75 < var51_66.size(); ++var53_75) {
                                        var18_33 = new PrivateCommonConfig.PartConfImpl();
                                        var54_87 = null;
                                        var55_94 = (String)var51_66.get(var53_75);
                                        var54_87 = PolicyConfigUtil.getKeywordForXPathExpression((String)var55_94, true);
                                        if (var54_87 == null) ** GOTO lbl204
                                        if (!var52_74.containsKey(var54_87)) {
                                            if (PolicyInboundConfig.tc.isDebugEnabled()) {
                                                Tr.debug(PolicyInboundConfig.tc, "PERF: Using keyword: " + (String)var54_87);
                                            }
                                            var18_33._dialect = Constants.DIALECT_WAS;
                                            var18_33._keyword = var54_87;
                                            var52_74.put(var54_87, var55_94);
                                        } else {
                                            var56_95 = (String)var52_74.get(var54_87);
                                            if (var56_95.equals(var55_94)) {
                                                if (PolicyInboundConfig.tc.isDebugEnabled()) {
                                                    Tr.debug(PolicyInboundConfig.tc, "Duplicate xpath element in signedElements will be ignored: " + (String)var55_94);
                                                }
                                                Tr.warning(PolicyInboundConfig.tc, "Duplicate xpath element in signedElements will be ignored: " + (String)var55_94);
                                                continue;
                                            }
                                            if (!PolicyInboundConfig.tc.isDebugEnabled()) continue;
                                            Tr.debug(PolicyInboundConfig.tc, "xpath elements with values [" + (String)var56_95 + "] and [" + (String)var55_94 + "] reference the same message part, so the message part will only be signed once.");
                                            continue;
lbl204:
                                            // 1 sources

                                            if (PolicyInboundConfig.tc.isDebugEnabled()) {
                                                Tr.debug(PolicyInboundConfig.tc, "PERF: Using XPath: " + (String)var55_94);
                                            }
                                            var18_33._dialect = Constants.DIALECT_XPATH;
                                            var18_33._keyword = var55_94;
                                        }
                                        var19_34._parts.add(var18_33);
                                    }
                                    if (var49_56 != 0) continue;
                                    var19_34._order = 0;
                                    this._requiredIntegralParts.add(var19_34);
                                    if (var43_38 == null || var43_38.length() == 0) {
                                        throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s21");
                                    }
                                    if (var31_18.containsKey(var43_38) && PolicyInboundConfig.tc.isDebugEnabled()) {
                                        Tr.debug(PolicyInboundConfig.tc, "WARNING: required integrity [" + var43_38 + "] is overwritten.");
                                    }
                                    if (PolicyInboundConfig.tc.isDebugEnabled()) {
                                        Tr.debug(PolicyInboundConfig.tc, "Adding required integrity: " + var43_38);
                                    }
                                    var31_18.put((List<TokenConsumer>)var43_38, var19_34);
                                    var32_19.add((List<TokenConsumer>)var43_38);
                                    continue;
                                }
                                if (!PolicyConfigUtil.encryptedElementsQName.equals(var48_55 /* !! */ )) break block350;
                                this._decryptionRequired = true;
                                var49_56 = 0;
                                if (var30_17.containsKey(var43_38)) {
                                    var19_34 = (PrivateCommonConfig.ReferencePartConfImpl)var30_17.get(var43_38);
                                    var49_56 = 1;
                                } else {
                                    var19_34 = new PrivateCommonConfig.ReferencePartConfImpl();
                                }
                                var50_64 = (SerElementsType)var47_46.getValue();
                                var51_66 = var50_64.getXPath();
                                if (var51_66 == null) break block351;
                                var52_74 = new HashMap<K, V>();
                                for (var53_75 = 0; var53_75 < var51_66.size(); ++var53_75) {
                                    var18_33 = new PrivateCommonConfig.PartConfImpl();
                                    var54_87 = null;
                                    var55_94 = (String)var51_66.get(var53_75);
                                    var54_87 = PolicyConfigUtil.getKeywordForXPathExpression((String)var55_94, false);
                                    if (var54_87 == null) ** GOTO lbl262
                                    if (!var52_74.containsKey(var54_87)) {
                                        if (PolicyInboundConfig.tc.isDebugEnabled()) {
                                            Tr.debug(PolicyInboundConfig.tc, "PERF: Using keyword: " + (String)var54_87);
                                        }
                                        var18_33._dialect = Constants.DIALECT_WAS;
                                        var18_33._keyword = var54_87;
                                        var52_74.put(var54_87, var55_94);
                                    } else {
                                        var56_95 = (String)var52_74.get(var54_87);
                                        if (var56_95.equals(var55_94)) {
                                            if (PolicyInboundConfig.tc.isDebugEnabled()) {
                                                Tr.debug(PolicyInboundConfig.tc, "Duplicate xpath element in encryptedElements will be ignored: " + (String)var55_94);
                                            }
                                            Tr.warning(PolicyInboundConfig.tc, "Duplicate xpath element in encryptedElements will be ignored: " + (String)var55_94);
                                            continue;
                                        }
                                        if (!PolicyInboundConfig.tc.isDebugEnabled()) continue;
                                        Tr.debug(PolicyInboundConfig.tc, "xpath elements with values [" + (String)var56_95 + "] and [" + (String)var55_94 + "] reference the same message part, so the message part will only be encrypted once.");
                                        continue;
lbl262:
                                        // 1 sources

                                        if (PolicyInboundConfig.tc.isDebugEnabled()) {
                                            Tr.debug(PolicyInboundConfig.tc, "PERF: Using XPath: " + (String)var55_94);
                                        }
                                        var18_33._dialect = Constants.DIALECT_XPATH;
                                        var18_33._keyword = var55_94;
                                    }
                                    var19_34._parts.add(var18_33);
                                }
                            }
                            if (var49_56 != 0) continue;
                            var19_34._order = 0;
                            this._requiredConfidentialParts.add(var19_34);
                            if (var43_38 == null || var43_38.length() == 0) {
                                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s21");
                            }
                            if (var30_17.containsKey(var6_6) && PolicyInboundConfig.tc.isDebugEnabled()) {
                                Tr.debug(PolicyInboundConfig.tc, "WARNING: required confidentiality [" + var43_38 + "] is overwritten.");
                            }
                            if (PolicyInboundConfig.tc.isDebugEnabled()) {
                                Tr.debug(PolicyInboundConfig.tc, "Adding required confidentiality: " + var43_38);
                            }
                            var30_17.put((List<TokenConsumer>)var43_38, var19_34);
                            var33_20.add((List<TokenConsumer>)var43_38);
                            continue;
                        }
                        throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s06", new String[]{var48_55 /* !! */ .toString()}));
                    }
                    continue;
                }
                if (var40_29 /* !! */  instanceof JAXBElement) {
                    var42_37 = false;
                    var43_38 = (JAXBElement)var40_29 /* !! */ ;
                    var44_40 = var43_38.getName();
                    if (PolicyConfigUtil.asymmetricBindingQName.equals(var44_40)) {
                        this._symmetricBinding = false;
                        var45_42 = (NestedPolicyType)var43_38.getValue();
                        var46_44 = var45_42.getPolicy().getPolicyOrAllOrExactlyOne();
                        for (var47_47 = 0; var47_47 < var46_44.size(); ++var47_47) {
                            var48_55 /* !! */  = var46_44.get(var47_47);
                            if (var48_55 /* !! */  instanceof Element) {
                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s07", new String[]{var48_55 /* !! */ .toString()}));
                            }
                            if (!(var48_55 /* !! */  instanceof JAXBElement)) continue;
                            var49_57 = (JAXBElement)var48_55 /* !! */ ;
                            var50_64 = var49_57.getName().getLocalPart();
                            if ("InitiatorToken".equals(var50_64)) {
                                if (!this._initiatorEncryptionTokens.isEmpty()) {
                                    Tr.error(PolicyInboundConfig.tc, "Initiator Token assertion found when an Initiator Encryption Token assertion was already defined.");
                                    throw new SoapSecurityException("security.wssecurity.PolicyInboundConfig.s08");
                                }
                                if (!this._initiatorSignatureTokens.isEmpty()) {
                                    Tr.error(PolicyInboundConfig.tc, "Initiator Token assertion found when an Initiator Signature Token assertion was already defined.");
                                    throw new SoapSecurityException("security.wssecurity.PolicyInbounConfig.s09");
                                }
                                var34_21 = this.getTokenTypeAssertion(var49_57);
                                if (var34_21 != null) {
                                    this._initiatorTokens.put(var34_21._tokenType.getLocalPart(), var34_21);
                                    this._initiatorSignatureTokens.put(var34_21._tokenType.getLocalPart(), var34_21);
                                    this._initiatorEncryptionTokens.put(var34_21._tokenType.getLocalPart(), var34_21);
                                }
                                if (!PolicyInboundConfig.tc.isDebugEnabled()) continue;
                                Tr.debug(PolicyInboundConfig.tc, "The policy has processed InitiatorToken");
                                continue;
                            }
                            if ("RecipientToken".equals(var50_64)) {
                                if (!this._recipientEncryptionTokens.isEmpty()) {
                                    Tr.error(PolicyInboundConfig.tc, "Recipient Token assertion found when a Recipient Encryption Token assertion was already defined.");
                                    throw new SoapSecurityException("security.wssecurity.PolicyInboundConfig.s10");
                                }
                                if (!this._recipientSignatureTokens.isEmpty()) {
                                    Tr.error(PolicyInboundConfig.tc, "Recipient Token assertion found when a Recipient Signature Token assertion was already defined.");
                                    throw new SoapSecurityException("security.wssecurity.PolicyInboundConfig.s11");
                                }
                                var34_21 = this.getTokenTypeAssertion(var49_57);
                                if (var34_21 != null) {
                                    this._recipientTokens.put(var34_21._tokenType.getLocalPart(), var34_21);
                                    this._recipientSignatureTokens.put(var34_21._tokenType.getLocalPart(), var34_21);
                                    this._recipientEncryptionTokens.put(var34_21._tokenType.getLocalPart(), var34_21);
                                }
                                if (!PolicyInboundConfig.tc.isDebugEnabled()) continue;
                                Tr.debug(PolicyInboundConfig.tc, "The policy has processed RecipientToken");
                                continue;
                            }
                            if ("InitiatorSignatureToken".equals(var50_64)) {
                                if (!this._initiatorTokens.isEmpty()) {
                                    Tr.error(PolicyInboundConfig.tc, "Initiator Signature Token assertion found when an Initiator Token assertion was already defined.");
                                    throw new SoapSecurityException("security.wssecurity.PolicyInboundConfig.s12");
                                }
                                var34_21 = this.getTokenTypeAssertion(var49_57);
                                if (var34_21 != null) {
                                    this._initiatorSignatureTokens.put(var34_21._tokenType.getLocalPart(), var34_21);
                                }
                                if (!PolicyInboundConfig.tc.isDebugEnabled()) continue;
                                Tr.debug(PolicyInboundConfig.tc, "The policy has processed InitiatorSignatureToken");
                                continue;
                            }
                            if ("RecipientSignatureToken".equals(var50_64)) {
                                if (!this._recipientTokens.isEmpty()) {
                                    Tr.error(PolicyInboundConfig.tc, "Recipient Signature Token assertion found when a Recipient Token assertion was already defined.");
                                    throw new SoapSecurityException("security.wssecurity.PolicyInboundConfig.s13");
                                }
                                var34_21 = this.getTokenTypeAssertion(var49_57);
                                if (var34_21 != null) {
                                    this._recipientSignatureTokens.put(var34_21._tokenType.getLocalPart(), var34_21);
                                }
                                if (!PolicyInboundConfig.tc.isDebugEnabled()) continue;
                                Tr.debug(PolicyInboundConfig.tc, "The policy has processed RecipientSignatureToken");
                                continue;
                            }
                            if ("InitiatorEncryptionToken".equals(var50_64)) {
                                if (!this._initiatorTokens.isEmpty()) {
                                    Tr.error(PolicyInboundConfig.tc, "Initiator Encryption Token assertion found when an Initiator Token assertion was already defined.");
                                    throw new SoapSecurityException("security.wssecurity.PolicyInboundConfig.s14");
                                }
                                var34_21 = this.getTokenTypeAssertion(var49_57);
                                if (var34_21 != null) {
                                    this._initiatorEncryptionTokens.put(var34_21._tokenType.getLocalPart(), var34_21);
                                }
                                if (!PolicyInboundConfig.tc.isDebugEnabled()) continue;
                                Tr.debug(PolicyInboundConfig.tc, "The policy has processed InitiatorEncryptionToken");
                                continue;
                            }
                            if ("RecipientEncryptionToken".equals(var50_64)) {
                                if (!this._recipientTokens.isEmpty()) {
                                    Tr.error(PolicyInboundConfig.tc, "Recipient Encryption Token assertion found when a Recipient Token assertion was already defined.");
                                    throw new SoapSecurityException("security.wssecurity.PolicyInboundConfig.s15");
                                }
                                var34_21 = this.getTokenTypeAssertion(var49_57);
                                if (var34_21 != null) {
                                    this._recipientEncryptionTokens.put(var34_21._tokenType.getLocalPart(), var34_21);
                                }
                                if (!PolicyInboundConfig.tc.isDebugEnabled()) continue;
                                Tr.debug(PolicyInboundConfig.tc, "The policy has processed RecipientEncryptionToken");
                                continue;
                            }
                            if (PolicyConfigUtil.algorithmSuiteQName.getLocalPart().equals(var50_64)) {
                                this.algorithmSuiteAssertion(var49_57, var44_40);
                                continue;
                            }
                            if (PolicyConfigUtil.layoutQName.getLocalPart().equals(var50_64)) {
                                var51_66 = this.layoutAssertion(var49_57);
                                if (var51_66 != null) {
                                    this._layout = var51_66;
                                }
                                if (!PolicyInboundConfig.tc.isDebugEnabled()) continue;
                                Tr.debug(PolicyInboundConfig.tc, "The policy has processed Layout");
                                continue;
                            }
                            if (PolicyConfigUtil.wssIncludeTimestampQName.getLocalPart().equals(var50_64)) {
                                this._timestampRequired = true;
                                if (!PolicyInboundConfig.tc.isDebugEnabled()) continue;
                                Tr.debug(PolicyInboundConfig.tc, "The policy has processed IncludeTimestamp");
                                continue;
                            }
                            throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s07", new String[]{var50_64}));
                        }
                        continue;
                    }
                    if (PolicyConfigUtil.symmetricBindingQName.equals(var44_40)) {
                        this._symmetricBinding = true;
                        var45_42 = (NestedPolicyType)var43_38.getValue();
                        var46_44 = var45_42.getPolicy().getPolicyOrAllOrExactlyOne();
                        for (var47_48 = 0; var47_48 < var46_44.size(); ++var47_48) {
                            var48_55 /* !! */  = var46_44.get(var47_48);
                            if (var48_55 /* !! */  instanceof Element) {
                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s16", new String[]{var48_55 /* !! */ .toString()}));
                            }
                            if (!(var48_55 /* !! */  instanceof JAXBElement)) continue;
                            var49_58 = (JAXBElement)var48_55 /* !! */ ;
                            var50_64 = var49_58.getName().getLocalPart();
                            if ("EncryptionToken".equals(var50_64)) {
                                if (this._symmetricProtectionTokenAssertion != null) {
                                    Tr.error(PolicyInboundConfig.tc, "Encryption Token assertion found when a protection token assertion was already defined.");
                                    throw new SoapSecurityException("security.wssecurityEncryption Token assertion found when a protection token assertion was already defined.");
                                }
                                this._symmetricEncryptionTokenAssertion = this.getTokenTypeAssertion(var49_58);
                                if (!PolicyInboundConfig.tc.isDebugEnabled()) continue;
                                Tr.debug(PolicyInboundConfig.tc, "The policy has processed EncryptionToken");
                                continue;
                            }
                            if ("SignatureToken".equals(var50_64)) {
                                if (this._symmetricProtectionTokenAssertion != null) {
                                    Tr.error(PolicyInboundConfig.tc, "Signature Token assertion found when a protection token assertion was already defined.");
                                    throw new SoapSecurityException("security.wssecuritySignature Token assertion found when a protection token assertion was already defined.");
                                }
                                this._symmetricSignatureTokenAssertion = this.getTokenTypeAssertion(var49_58);
                                if (!PolicyInboundConfig.tc.isDebugEnabled()) continue;
                                Tr.debug(PolicyInboundConfig.tc, "The policy has processed SignatureToken");
                                continue;
                            }
                            if ("ProtectionToken".equals(var50_64)) {
                                if (this._symmetricEncryptionTokenAssertion != null || this._symmetricSignatureTokenAssertion != null) {
                                    Tr.error(PolicyInboundConfig.tc, "Encryption Token assertion found when a protection token assertion was already defined.");
                                    throw new SoapSecurityException("security.wssecurityEncryption Token assertion found when a protection token assertion was already defined.");
                                }
                                this._symmetricProtectionTokenAssertion = this.getTokenTypeAssertion(var49_58);
                                this._symmetricEncryptionTokenAssertion = this.getTokenTypeAssertion(var49_58);
                                this._symmetricSignatureTokenAssertion = this.getTokenTypeAssertion(var49_58);
                                if (!PolicyInboundConfig.tc.isDebugEnabled()) continue;
                                Tr.debug(PolicyInboundConfig.tc, "The policy has processed ProtectionToken");
                                continue;
                            }
                            if (PolicyConfigUtil.algorithmSuiteQName.getLocalPart().equals(var50_64)) {
                                this.algorithmSuiteAssertion(var49_58, var44_40);
                                continue;
                            }
                            if (PolicyConfigUtil.layoutQName.getLocalPart().equals(var50_64)) {
                                var51_66 = this.layoutAssertion(var49_58);
                                if (var51_66 != null) {
                                    this._layout = var51_66;
                                }
                                if (!PolicyInboundConfig.tc.isDebugEnabled()) continue;
                                Tr.debug(PolicyInboundConfig.tc, "The policy has processed Layout");
                                continue;
                            }
                            if (PolicyConfigUtil.wssIncludeTimestampQName.getLocalPart().equals(var50_64)) {
                                this._timestampRequired = true;
                                if (!PolicyInboundConfig.tc.isDebugEnabled()) continue;
                                Tr.debug(PolicyInboundConfig.tc, "The policy has processed the IncludeTimestamp");
                                continue;
                            }
                            throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s16", new String[]{var50_64}));
                        }
                        continue;
                    }
                    if (PolicyConfigUtil.supportingTokenQName.equals(var44_40)) {
                        var45_42 = (NestedPolicyType)var43_38.getValue();
                        var46_44 = var45_42.getPolicy();
                        var47_49 = var46_44.getId();
                        var42_37 = this.retrieveAssertions(var47_49, var3_3);
                        if (!var42_37) continue;
                        this._tokenRequired = true;
                        var48_55 /* !! */  = var46_44.getPolicyOrAllOrExactlyOne();
                        for (var49_56 = 0; var49_56 < var48_55 /* !! */ .size(); ++var49_56) {
                            var50_64 = var48_55 /* !! */ .get(var49_56);
                            if (var50_64 instanceof Element) {
                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s17", new String[]{var50_64.toString()}));
                            }
                            if (!(var50_64 instanceof JAXBElement)) continue;
                            var23_35 = new PrivateConsumerConfig.TokenConsumerConfImpl();
                            var51_66 = (JAXBElement)var50_64;
                            var52_74 = var51_66.getName().getLocalPart();
                            var34_21 = this.getTokenTypeAssertion((JAXBElement)var51_66);
                            if (var34_21 != null) {
                                var23_35._type = var34_21._tokenType;
                            }
                            this._requiredSecurityTokens.add(var23_35);
                            if (var47_49 == null || var47_49.length() == 0) {
                                throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s23");
                            }
                            if (this.nameToken.containsKey(var47_49) && PolicyInboundConfig.tc.isDebugEnabled()) {
                                Tr.debug(PolicyInboundConfig.tc, "WARNING: required security token [" + var47_49 + "] is overwritten.");
                            }
                            if (PolicyInboundConfig.tc.isDebugEnabled()) {
                                Tr.debug(PolicyInboundConfig.tc, "Adding required security token: " + var47_49);
                            }
                            this.nameToken.put(var47_49, var23_35);
                        }
                        continue;
                    }
                    if (PolicyConfigUtil.wss10QName.equals(var44_40)) {
                        var45_42 = (NestedPolicyType)var43_38.getValue();
                        var46_44 = var45_42.getPolicy().getPolicyOrAllOrExactlyOne();
                        for (var47_50 = 0; var47_50 < var46_44.size(); ++var47_50) {
                            var48_55 /* !! */  = var46_44.get(var47_50);
                            if (var48_55 /* !! */  instanceof Element) {
                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s18", new String[]{var48_55 /* !! */ .toString()}));
                            }
                            if (!(var48_55 /* !! */  instanceof JAXBElement) || "MustSupportRefKeyIdentifier".equals(var50_64 = (var49_59 = (JAXBElement)var48_55 /* !! */ ).getName().getLocalPart()) || "MustSupportRefIssuerSerial".equals(var50_64) || "MustSupportRefExternalURI".equals(var50_64) || "MustSupportRefEmbeddedToken".equals(var50_64)) continue;
                            Tr.debug(PolicyInboundConfig.tc, "The policy assertion" + (String)var50_64 + "is not a valid wss10 QName assertion");
                            throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s18", new String[]{var50_64}));
                        }
                        continue;
                    }
                    if (PolicyConfigUtil.wss11QName.equals(var44_40)) {
                        var45_42 = (NestedPolicyType)var43_38.getValue();
                        var46_44 = var45_42.getPolicy().getPolicyOrAllOrExactlyOne();
                        for (var47_51 = 0; var47_51 < var46_44.size(); ++var47_51) {
                            var48_55 /* !! */  = var46_44.get(var47_51);
                            if (var48_55 /* !! */  instanceof Element) {
                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s19", new String[]{var48_55 /* !! */ .toString()}));
                            }
                            if (!(var48_55 /* !! */  instanceof JAXBElement) || "MustSupportRefKeyIdentifier".equals(var50_64 = (var49_60 = (JAXBElement)var48_55 /* !! */ ).getName().getLocalPart()) || "MustSupportRefIssuerSerial".equals(var50_64) || "MustSupportRefExternalURI".equals(var50_64) || "MustSupportRefEmbeddedToken".equals(var50_64) || "MustSupportRefThumbprint".equals(var50_64) || "MustSupportRefEncryptedKey".equals(var50_64)) continue;
                            if ("RequireSignatureConfirmation".equals(var50_64)) {
                                this._signatureConfirmationRequired = true;
                                continue;
                            }
                            throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s19", new String[]{var50_64}));
                        }
                        continue;
                    }
                    if (PolicyConfigUtil.trust10QName.equals(var44_40)) {
                        var45_42 = (NestedPolicyType)var43_38.getValue();
                        var46_44 = var45_42.getPolicy().getPolicyOrAllOrExactlyOne();
                        for (var47_52 = 0; var47_52 < var46_44.size(); ++var47_52) {
                            var48_55 /* !! */  = var46_44.get(var47_52);
                            if (var48_55 /* !! */  instanceof Element) {
                                throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s20", new String[]{var48_55 /* !! */ .toString()}));
                            }
                            if (!(var48_55 /* !! */  instanceof JAXBElement) || "MustSupportClientChallenge".equals(var50_64 = (var49_61 = (JAXBElement)var48_55 /* !! */ ).getName().getLocalPart()) || "MustSupportServerChallenge".equals(var50_64) || "MustSupportRefExternalURI".equals(var50_64) || "RequireClientEntropy".equals(var50_64) || "RequireServerEntropy".equals(var50_64) || "MustSupportIssuedTokens".equals(var50_64)) continue;
                            throw new SoapSecurityException(ConfigUtil.getMessage("security.wssecurity.PolicyInboundConfig.s20", new String[]{var50_64}));
                        }
                        continue;
                    }
                    Tr.debug(PolicyInboundConfig.tc, "JAXBElement not handled yet: " + var44_40);
                    throw new SoapSecurityException("The Policy assertion" + var44_40 + "is not a supported QName Assertion");
                }
                throw new SoapSecurityException("security.wssecurity.PrivateGeneratorConfig.Child[" + var41_31 + "] is NOT a JAXBElement object.");
            }
            for (var41_31 = 0; var41_31 < var33_20.size(); ++var41_31) {
                this.encryptionAlgorithms.put((String)var33_20.get(var41_31), this.encryptionAlgorithm);
                this.keyEncryptionAlgorithms.put((String)var33_20.get(var41_31), this.keyEncryptionAlgorithm);
                this.digestAlgorithms.put((String)var33_20.get(var41_31), this.digestAlgorithm);
                this.transformAlgorithms.put((String)var33_20.get(var41_31), this.transformAlgorithm);
                this.canonicalizationAlgorithms.put((String)var33_20.get(var41_31), this.canonicalizationAlgorithm);
            }
            for (var41_31 = 0; var41_31 < var32_19.size(); ++var41_31) {
                if (this._symmetricBinding) {
                    this.symmetricSignatureAlgorithms.put((String)var32_19.get(var41_31), this.symmetricSignatureAlgorithm);
                } else {
                    this.asymmetricSignatureAlgorithms.put((String)var32_19.get(var41_31), this.asymmetricSignatureAlgorithm);
                }
                this.digestAlgorithms.put((String)var32_19.get(var41_31), this.digestAlgorithm);
                this.transformAlgorithms.put((String)var32_19.get(var41_31), this.transformAlgorithm);
                this.canonicalizationAlgorithms.put((String)var32_19.get(var41_31), this.canonicalizationAlgorithm);
            }
        }
        if (this._timestampRequired) {
            var22_107 = new PrivateConsumerConfig.TimestampConsumerConfImpl();
            var22_107._actor = this._myActor != null ? this._myActor : null;
            if (this._layout.equals("LaxTsFirst")) {
                var22_107._properties.put(com.ibm.wsspi.wssecurity.core.Constants.WSSECURITY_TIMESTAMP_DIALECT, Constants.DIALECT_WAS);
                var22_107._properties.put(com.ibm.wsspi.wssecurity.core.Constants.WSSECURITY_TIMESTAMP_KEYWORD, "SecurityFirst");
            }
            if (this._layout.equals("LaxTsLast")) {
                var22_107._properties.put(com.ibm.wsspi.wssecurity.core.Constants.WSSECURITY_TIMESTAMP_DIALECT, Constants.DIALECT_WAS);
                var22_107._properties.put(com.ibm.wsspi.wssecurity.core.Constants.WSSECURITY_TIMESTAMP_KEYWORD, "SecurityLast");
            }
            if (PolicyInboundConfig.tc.isDebugEnabled()) {
                Tr.debug(PolicyInboundConfig.tc, "Adding timestamp: " + this._timestampRequired);
            }
            this._timestampConsumer = var22_107;
        }
        try {
            this._nonceManager = (NonceManager)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws SoapSecurityException {
                    return NonceManagerFactory.getInstance();
                }
            });
        }
        catch (PrivilegedActionException var39_27) {
            var40_29 /* !! */  = var39_27.getCause();
            if (var40_29 /* !! */  instanceof SoapSecurityException) {
                throw (SoapSecurityException)var40_29 /* !! */ ;
            }
            throw new SoapSecurityException(var40_29 /* !! */ .getMessage());
        }
        if (PolicyInboundConfig.tc.isDebugEnabled()) {
            Tr.debug(PolicyInboundConfig.tc, "NonceManager = " + this._nonceManager);
        }
        try {
            this._certManager = (CertCacheManager)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws SoapSecurityException {
                    return CertManagerFactory.getInstance();
                }
            });
        }
        catch (PrivilegedActionException var39_28) {
            var40_29 /* !! */  = var39_28.getCause();
            if (var40_29 /* !! */  instanceof SoapSecurityException) {
                throw (SoapSecurityException)var40_29 /* !! */ ;
            }
            throw new SoapSecurityException(var40_29 /* !! */ .getMessage());
        }
        if (PolicyInboundConfig.tc.isDebugEnabled()) {
            Tr.debug(PolicyInboundConfig.tc, "CertManager = " + this._certManager);
        }
        this._allowedSignatureMethods.addAll(PolicyConfigUtil.getAllowedAlgorithms(1));
        this._allowedDigestMethods.addAll(PolicyConfigUtil.getAllowedAlgorithms(2));
        this._allowedDataEncryptionMethods.addAll(PolicyConfigUtil.getAllowedAlgorithms(3));
        this._allowedKeyEncryptionMethods.addAll(PolicyConfigUtil.getAllowedAlgorithms(7));
        if (var5_5 != null && (var39_26 = var5_5.getHardwareConfigName()) != null && var39_26.length() != 0) {
            this._properties.put("HWCONFIG", var39_26);
            if (PolicyInboundConfig.tc.isDebugEnabled()) {
                Tr.debug(PolicyInboundConfig.tc, "Hardware Acceleration is Enabled " + (String)var39_26);
            }
            this._properties.put("com.ibm.ws.wssecurity.handler.OffloadAllCryptography", var5_5.getUseOffloadAllCrypto());
            if (PolicyInboundConfig.tc.isDebugEnabled()) {
                Tr.debug(PolicyInboundConfig.tc, "Hardware Acceleration is Enabled :" + (String)var39_26 + ", OFFLOAD_ALL_CRYPTO is: " + var5_5.getUseOffloadAllCrypto());
            }
            this._properties.put("com.ibm.ws.wssecurity.handler.hardwareCacheSize", new Integer(var5_5.getHardwareCacheSize()));
            if (PolicyInboundConfig.tc.isDebugEnabled()) {
                Tr.debug(PolicyInboundConfig.tc, "Hardware cache size = " + var5_5.getHardwareCacheSize());
            }
            this._properties.put("com.ibm.ws.wssecurity.handler.OffloadRSAPublicKeyCryptography", new Boolean(var5_5.getOffloadRSAPublicKeyCrypto()));
            if (PolicyInboundConfig.tc.isDebugEnabled()) {
                Tr.debug(PolicyInboundConfig.tc, "Offload RSA Public Key crypto = " + var5_5.getOffloadRSAPublicKeyCrypto());
            }
        }
        if (!var35_22 && (var39_26 = var1_1.getConsumerbindingref()) != null && "DEFAULT".equals(var6_6 = ConfigUtil.trim(var39_26.getReference()))) {
            var35_22 = true;
        }
        if (var35_22) {
            Tr.warning(PolicyInboundConfig.tc, "security.wssecurity.WSSecurityBindingLoaderImpl.s09");
            if (PolicyInboundConfig.tc.isDebugEnabled()) {
                Tr.debug(PolicyInboundConfig.tc, "Using default binding...");
            }
            if (var5_5 == null) {
                Tr.warning(PolicyInboundConfig.tc, "security.wssecurity.PrivateGeneratorConfig.s25");
            } else {
                var39_26 = var5_5.getDefaultConsumerBinding();
                if (var39_26 != null) {
                    this.initDefaultConfig((WSSConsumerConfig)var39_26, this.nameToken, var3_3);
                }
            }
            this.validate(true, this.nameToken);
            if (PolicyInboundConfig.tc.isEntryEnabled()) {
                Tr.exit(PolicyInboundConfig.tc, "init(SecurityInboundBindingConfig binding, Policy policyRoot, String actorURI, boolean isRequest,ClassLoader appClassLoader)");
            }
            return;
        }
        var39_26 = var1_1.getCertStoreList();
        var40_29 /* !! */  = var1_1.getEncryptionInfo();
        var41_32 = var1_1.getKeyInfo();
        var42_36 = var1_1.getSigningInfo();
        var43_38 = var1_1.getTokenConsumer();
        var44_41 = var1_1.getCaller();
        var45_42 = var1_1.getTrustAnchor();
        var46_45 = new ArrayList<PrivateCommonConfig.PartConfImpl>();
        if (PolicyInboundConfig.tc.isDebugEnabled()) {
            var47_53 = var37_24 == null ? "null" : var37_24.toString();
            var48_55 /* !! */  = var38_25 == null ? "null" : var38_25.toString();
            Tr.debug(PolicyInboundConfig.tc, "Policy Inbound Binding (CertStoreList, EncryptionInfos, KeyInfos,  SigningInfos, TokenConsumers, TrustAnchors, Parameters, Property):", new Object[]{var39_26, var40_29 /* !! */ , var41_32, var42_36, var43_38, var45_42, var47_53, var48_55 /* !! */ });
        }
        this._useStandardFaultCodes = ConfigUtil.getIsTrueProperty(this._properties, com.ibm.wsspi.wssecurity.core.Constants.USE_STANDARD_FAULTCODES);
        var47_54 = 0;
        var48_55 /* !! */  = (String)this._properties.get(com.ibm.wsspi.wssecurity.core.Constants.WSSECURITY_TIMESTAMP_TIMEOUT);
        if (var48_55 /* !! */  != null) {
            if ((var48_55 /* !! */  = var48_55 /* !! */ .trim()).length() != 0) {
                try {
                    var49_56 = Integer.parseInt((String)var48_55 /* !! */ );
                    var47_54 = ConfigConstants.validTimestampTimeout(var49_56);
                }
                catch (NumberFormatException var49_62) {
                    Tr.processException((Throwable)var49_62, this.getClass().getName() + ".init", "1313", this);
                    Tr.warning(PolicyInboundConfig.tc, "security.wssecurity.WSEC0144W", new Object[]{var48_55 /* !! */ , new Integer(600)});
                    var47_54 = 600;
                }
            }
        } else {
            var47_54 = 600;
        }
        var49_63 = 0;
        var48_55 /* !! */  = (String)this._properties.get(com.ibm.wsspi.wssecurity.core.Constants.WSSECURITY_TIMESTAMP_MAX_AGE);
        var49_63 = var48_55 /* !! */  != null ? ConfigConstants.processTimestampMaxAge((String)var48_55 /* !! */ , var47_54) : 300;
        this._timestampMaxAge = var49_63;
        var50_65 = 0;
        var48_55 /* !! */  = (String)this._properties.get(com.ibm.wsspi.wssecurity.core.Constants.WSSECURITY_TIMESTAMP_CLOCK_SKEW);
        var50_65 = var48_55 /* !! */  != null ? ConfigConstants.processTimestampClockSkew((String)var48_55 /* !! */ , this._timestampMaxAge) : 180;
        this._timestampClockSkew = var50_65;
        if (PolicyInboundConfig.tc.isDebugEnabled()) {
            Tr.debug(PolicyInboundConfig.tc, "timestamp.maxAge = " + this._timestampMaxAge * 1000 + " ms, " + "timestamp.clockSkew = " + this._timestampClockSkew * 1000 + " ms");
        }
        if (this._timestampRequired && this._timestampConsumer != null) {
            var22_107 = this._timestampConsumer;
            var22_107._timestampMaxAge = this._timestampMaxAge;
            var22_107._timestampClockSkew = this._timestampClockSkew;
        }
        if ((var48_55 /* !! */  = (String)this._properties.get(com.ibm.wsspi.wssecurity.core.Constants.WSSECURITY_NONCE_CACHE_TIMEOUT)) != null) {
            if ((var48_55 /* !! */  = var48_55 /* !! */ .trim()).length() != 0) {
                try {
                    var51_67 = Integer.parseInt((String)var48_55 /* !! */ );
                    var47_54 = ConfigConstants.validNonceCacheTimeout(var51_67);
                }
                catch (NumberFormatException var51_68) {
                    Tr.processException((Throwable)var51_68, this.getClass().getName() + ".init", "1375", this);
                    Tr.warning(PolicyInboundConfig.tc, "security.wssecurity.WSEC0115W", new Object[]{var48_55 /* !! */ , new Integer(600)});
                    var47_54 = 600;
                }
            }
        } else {
            var47_54 = 600;
        }
        var49_63 = 0;
        var48_55 /* !! */  = (String)this._properties.get(com.ibm.wsspi.wssecurity.core.Constants.WSSECURITY_NONCE_MAX_AGE);
        var49_63 = var48_55 /* !! */  != null ? ConfigConstants.processNonceMaxAge((String)var48_55 /* !! */ , var47_54) : 300;
        var50_65 = 0;
        var48_55 /* !! */  = (String)this._properties.get(com.ibm.wsspi.wssecurity.core.Constants.WSSECURITY_NONCE_CLOCK_SKEW);
        var50_65 = var48_55 /* !! */  != null ? ConfigConstants.processNonceClockSkew((String)var48_55 /* !! */ , var49_63) : 0;
        if (PolicyInboundConfig.tc.isDebugEnabled()) {
            Tr.debug(PolicyInboundConfig.tc, "nonce.maxAge = " + var49_63 * 1000 + " ms, " + "nonce.clockSkew = " + var50_65 * 1000 + " ms");
        }
        if (var40_29 /* !! */  != null) {
            var7_7 = var40_29 /* !! */ .size();
            for (var51_70 = 0; var51_70 < var7_7; ++var51_70) {
                var52_74 = var40_29 /* !! */ .get(var51_70);
                var53_77 = var52_74.getProperties();
                var54_87 = ConfigConstants.getProperties(var53_77, var36_23);
                this._properties.putAll(var54_87);
                var55_94 = var52_74.getEncryptionPartReference();
                if (var55_94 == null || (var6_6 = ConfigUtil.trim(var55_94.getReference())) == null || var6_6.length() <= 0) continue;
                var56_95 = (PrivateCommonConfig.ReferencePartConfImpl)var30_17.get(var6_6);
                if (var56_95 == null) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", var6_6);
                }
                var57_108 = var55_94.getTimestamp();
                if (var57_108 != null) {
                    var58_110 = var56_95.getParts();
                    var59_120 = var58_110.iterator();
                    while (var59_120.hasNext()) {
                        var60_127 /* !! */  = (PrivateCommonConfig.PartConfImpl)var59_120.next();
                        var61_130 = new PrivateCommonConfig.PartConfImpl();
                        var61_130.copyAttributesForTimestamp((PrivateCommonConfig.PartConfImpl)var60_127 /* !! */ );
                        var46_45.add(var61_130);
                    }
                }
                if ((var58_110 = var55_94.getNonce()) != null) {
                    var59_120 = var56_95.getParts();
                    var60_127 /* !! */  = var59_120.iterator();
                    while (var60_127 /* !! */ .hasNext()) {
                        var61_130 = (PrivateCommonConfig.PartConfImpl)var60_127 /* !! */ .next();
                        var62_144 = new PrivateCommonConfig.PartConfImpl();
                        var62_144.copyAttributesForNonce(var61_130);
                        var46_45.add((PrivateCommonConfig.PartConfImpl)var62_144);
                    }
                }
                for (var59_119 = 0; var59_119 < var46_45.size(); ++var59_119) {
                    var56_95._parts.add((ReferencePartConfig.PartConfig)var46_45.get(var59_119));
                }
                var46_45.clear();
            }
        }
        if (var42_36 != null) {
            var7_7 = var42_36.size();
            for (var51_71 = 0; var51_71 < var7_7; ++var51_71) {
                var52_74 = (SigningInfo)var42_36.get(var51_71);
                var53_78 = var52_74.getProperties();
                var54_87 = ConfigConstants.getProperties(var53_78, var36_23);
                this._properties.putAll(var54_87);
                var55_94 = var52_74.getSigningPartReference();
                if (var55_94 == null) continue;
                var8_8 = var55_94.size();
                for (var56_97 = 0; var56_97 < var8_8; ++var56_97) {
                    var57_108 = (SigningPartReference)var55_94.get(var56_97);
                    var6_6 = ConfigUtil.trim(var57_108.getReference());
                    if (var6_6 == null || var6_6.length() <= 0) continue;
                    var58_110 = (PrivateCommonConfig.ReferencePartConfImpl)var31_18.get(var6_6);
                    if (var58_110 == null) {
                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", var6_6);
                    }
                    if (PolicyInboundConfig.tc.isDebugEnabled()) {
                        Tr.debug(PolicyInboundConfig.tc, "Got the part reference: " + var6_6);
                    }
                    if ((var59_121 = var57_108.getTimestamp()) != null) {
                        var60_127 /* !! */  = var58_110.getParts();
                        for (List<KeyInfoContentConsumerConfig> var62_144 : var60_127 /* !! */ ) {
                            var63_146 = new PrivateCommonConfig.PartConfImpl();
                            var63_146.copyAttributesForTimestamp((PrivateCommonConfig.PartConfImpl)var62_144);
                            var46_45.add((PrivateCommonConfig.PartConfImpl)var63_146);
                        }
                    }
                    if ((var60_127 /* !! */  = var57_108.getNonce()) != null) {
                        var61_133 = var58_110.getParts();
                        var62_144 = var61_133.iterator();
                        while (var62_144.hasNext()) {
                            var63_146 = (PrivateCommonConfig.PartConfImpl)var62_144.next();
                            var64_149 = new PrivateCommonConfig.PartConfImpl();
                            var64_149.copyAttributesForNonce((PrivateCommonConfig.PartConfImpl)var63_146);
                            var46_45.add((PrivateCommonConfig.PartConfImpl)var64_149);
                        }
                    }
                    for (var61_134 = 0; var61_134 < var46_45.size(); ++var61_134) {
                        var58_110._parts.add((ReferencePartConfig.PartConfig)var46_45.get(var61_134));
                    }
                    var46_45.clear();
                }
            }
        }
        if (var44_41 != null) {
            var7_7 = var44_41.size();
            for (var51_72 = 0; var51_72 < var7_7; ++var51_72) {
                this._loginRequired = true;
                var52_74 = var44_41.get(var51_72);
                if (var52_74 == null) continue;
                var10_150 = new PrivateConsumerConfig.CallerConfImpl();
                var53_79 = var52_74.getCallerIdentity();
                if (var53_79 != null) {
                    var54_87 = ConfigUtil.trim(var53_79.getUri());
                    if (var54_87 == null) {
                        var54_87 = "";
                    }
                    var55_94 = ConfigUtil.trim(var53_79.getLocalName());
                    var10_150._callerIdentity = new QName((String)var54_87, (String)var55_94);
                }
                if ((var54_87 = var52_74.getTrustedIdentity()) != null) {
                    var10_150._identityAssertion = true;
                    var55_94 = ConfigUtil.trim(var54_87.getLocalName());
                    if (var55_94 != null && var55_94.length() > 0) {
                        var56_98 = ConfigUtil.trim(var54_87.getUri());
                        if (var56_98 == null) {
                            var56_98 = "";
                        }
                        var10_150._trustedIdentity = new QName((String)var56_98, (String)var55_94);
                    } else {
                        var10_150._anyTrustedIdentity = true;
                    }
                }
                if ((var55_94 = var52_74.getRequiredSigningPartReference()) != null && (var6_6 = ConfigUtil.trim(var55_94.getReference())) != null && var6_6.length() > 0) {
                    var10_150._requiredSigningPartReference = (PrivateCommonConfig.ReferencePartConfImpl)var31_18.get(var6_6);
                    if (var10_150._requiredSigningPartReference == null) {
                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", var6_6);
                    }
                    if (PolicyInboundConfig.tc.isDebugEnabled()) {
                        Tr.debug(PolicyInboundConfig.tc, "Got the signing part reference: " + var6_6);
                    }
                }
                if ((var56_98 = var52_74.getJAASConfig()) == null) {
                    throw SoapSecurityException.format("security.wssecurity.WSEC6834E", var10_150.toString());
                }
                var10_150._jaasConfig = ConfigUtil.trim(var56_98.getConfigName());
                ConfigConstants.getProperties(var10_150._jaasConfigProperties, var56_98.getProperties(), var36_23);
                var57_108 = var52_74.getCallbackHandler();
                if (var57_108 != null) {
                    var12_10 = new PrivateCommonConfig.CallbackHandlerConfImpl();
                    var12_10._className = ConfigUtil.trim(var57_108.getClassname());
                    if (!this._defaultCallbackHandlers.contains(var12_10._className)) {
                        this._userDefinedComponentsUsed = true;
                    }
                    ConfigConstants.getProperties(var12_10._properties, var57_108.getProperties(), var36_23);
                    var10_150._callbackHandler = var12_10;
                    if (PolicyInboundConfig.tc.isDebugEnabled()) {
                        Tr.debug(PolicyInboundConfig.tc, "Adding the callback handler: " + var12_10.getClassName());
                    }
                }
                this._callers.add(var10_150);
                if (!PolicyInboundConfig.tc.isDebugEnabled()) continue;
                Tr.debug(PolicyInboundConfig.tc, "Adding caller: " + var10_150);
            }
        }
        var51_73 = new HashMap<String, TokenConsumerConfig>(this.nameToken);
        var26_13.putAll(var51_73);
        if (var43_38 != null) {
            var52_74 = null;
            var7_7 = var43_38.size();
            for (var53_80 = 0; var53_80 < var7_7; ++var53_80) {
                var54_87 = var43_38.get(var53_80);
                var55_94 = var54_87.getValueType();
                if (var55_94 == null) {
                    throw new SoapSecurityException("The valueType field for the token consumer named " + var54_87.getName() + " is missing");
                }
                var56_99 = new QName(ConfigUtil.trim(var55_94.getUri()), ConfigUtil.trim(var55_94.getLocalName()));
                var57_108 = var54_87.getSecurityTokenReference();
                var23_35 = null;
                if (var57_108 != null && (var52_74 = ConfigUtil.trim(var57_108.getReference())) != null && var52_74.length() > 0) {
                    var23_35 = (PrivateConsumerConfig.TokenConsumerConfImpl)var51_73.get(var52_74);
                    if (var23_35 == null) {
                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", (String)var52_74);
                    }
                    if (!var23_35.getType().equals(var56_99)) {
                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s30", var23_35.getType().toString(), var56_99.toString());
                    }
                    if (PolicyInboundConfig.tc.isDebugEnabled()) {
                        Tr.debug(PolicyInboundConfig.tc, "Got the part reference: " + (String)var52_74);
                    }
                }
                if (var23_35 == null) {
                    var23_35 = new PrivateConsumerConfig.TokenConsumerConfImpl();
                    var23_35._type = var56_99;
                }
                var23_35._className = ConfigUtil.trim(var54_87.getClassname());
                if (!this._defaultTokenConsumers.contains(var23_35._className)) {
                    this._userDefinedComponentsUsed = true;
                }
                var58_112 = false;
                var59_122 = var54_87.getCallbackHandler();
                if (var59_122 != null) {
                    var12_10 = new PrivateCommonConfig.CallbackHandlerConfImpl();
                    var12_10._className = ConfigUtil.trim(var59_122.getClassname());
                    if (!this._defaultCallbackHandlers.contains(var12_10._className)) {
                        this._userDefinedComponentsUsed = true;
                    }
                    if ((var60_127 /* !! */  = var59_122.getKeyStore()) != null) {
                        var14_151 = new PrivateCommonConfig.KeyStoreConfImpl();
                        var14_151._type = ConfigUtil.trim(var60_127 /* !! */ .getType());
                        var14_151._path = var36_23.expand(ConfigUtil.trim(var60_127 /* !! */ .getPath()));
                        var14_151._password = PasswordUtilFactory.getInstance().passwordDecode(ConfigUtil.trim(var60_127 /* !! */ .getStorepass()));
                        var14_151._ksRef = ConfigUtil.trim(var60_127 /* !! */ .getKeyStoreRef());
                        var12_10._keyStore = var14_151;
                        if (var14_151._ksRef != null && var14_151._ksRef.length() != 0) {
                            var23_35._properties.put("com.ibm.ws.wssecurity.config.keystore.consumerkeyStoreRef", var14_151._ksRef);
                        }
                    }
                    if ((var61_135 = var59_122.getKey()) != null) {
                        var15_152 = new PrivateCommonConfig.KeyInformationConfImpl();
                        var15_152._alias = ConfigUtil.trim(var61_135.getAlias());
                        var15_152._keypass = PasswordUtilFactory.getInstance().passwordDecode(ConfigUtil.trim(var61_135.getKeypass()));
                        var15_152._name = ConfigUtil.trim(var61_135.getName());
                        var12_10._keyInformation = var15_152;
                    }
                    if ((var62_144 = var59_122.getCertPathSettings()) != null) {
                        var63_146 = var62_144.getTrustAnyCertificate();
                        if (var63_146 != null) {
                            var12_10._trustAnyCertificate = true;
                        } else {
                            var64_149 = var62_144.getTrustAnchorRef();
                            var65_153 = var62_144.getCertStoreRef();
                            if (var64_149 != null || var65_153 != null) {
                                if (var64_149 != null) {
                                    var6_6 = ConfigUtil.trim(var64_149.getReference());
                                    if (PolicyInboundConfig.tc.isDebugEnabled()) {
                                        Tr.debug(PolicyInboundConfig.tc, "TrustAnchorRef = " + var6_6);
                                    }
                                    for (var66_155 = 0; var66_155 < var45_42.size(); ++var66_155) {
                                        var67_156 = var45_42.get(var66_155);
                                        if (var6_6 == null || !var6_6.equals(ConfigUtil.trim(var67_156.getName()))) continue;
                                        var60_127 /* !! */  = var67_156.getKeyStore();
                                        if (var60_127 /* !! */  != null) {
                                            var14_151 = new PrivateCommonConfig.KeyStoreConfImpl();
                                            var14_151._type = ConfigUtil.trim(var60_127 /* !! */ .getType());
                                            var14_151._path = var36_23.expand(ConfigUtil.trim(var60_127 /* !! */ .getPath()));
                                            var14_151._password = PasswordUtilFactory.getInstance().passwordDecode(ConfigUtil.trim(var60_127 /* !! */ .getStorepass()));
                                            var14_151._ksRef = ConfigUtil.trim(var60_127 /* !! */ .getKeyStoreRef());
                                            var12_10._trustAnchor = var14_151;
                                        }
                                        var58_112 = true;
                                        break;
                                    }
                                    if (PolicyInboundConfig.tc.isDebugEnabled()) {
                                        Tr.debug(PolicyInboundConfig.tc, "(from application binding) Keystore for TrustAnchor: " + var6_6 + " = " + var12_10._trustAnchor + ": Found = " + var58_112);
                                    }
                                    if (!var58_112) {
                                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", var6_6);
                                    }
                                }
                                if (var12_10._trustAnchor == null) {
                                    throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s32");
                                }
                                var66_154 = KeyStoreManager.getInstance();
                                var14_151 = var12_10._trustAnchor;
                                var67_156 = var14_151._password == null ? null : var14_151._password.toCharArray();
                                var68_157 = var66_154.getKeyStore(var14_151._path, var14_151._type, (char[])var67_156, var14_151._ksRef);
                                if (var14_151._ksRef != null && var14_151._ksRef.length() != 0) {
                                    var23_35._properties.put("com.ibm.ws.wssecurity.config.keystore.consumerkeyStoreRef", var14_151._ksRef);
                                    if (PolicyInboundConfig.tc.isDebugEnabled()) {
                                        Tr.debug(PolicyInboundConfig.tc, "Added key store name to token config = " + var14_151._ksRef);
                                    }
                                }
                                var69_158 = null;
                                var70_159 = null;
                                try {
                                    var71_160 = new X509CertSelector();
                                    var69_158 = new PKIXBuilderParameters(var68_157, (CertSelector)var71_160);
                                    var69_158.setDate(null);
                                }
                                catch (InvalidAlgorithmParameterException var71_161) {
                                    var72_165 = "security.wssecurity.WSSecurityDefaultConsumerConfig.s03";
                                    Tr.error(PolicyInboundConfig.tc, var72_165, new Object[]{var69_158.toString() == null ? "" : var69_158.toString()});
                                    throw SoapSecurityException.format(var72_165, var69_158.toString() == null ? "" : var69_158.toString(), (Throwable)var71_161);
                                }
                                catch (KeyStoreException var71_162) {
                                    var72_166 = "security.wssecurity.WSSecurityDefaultConsumerConfig.s01";
                                    Tr.processException((Throwable)var71_162, PolicyInboundConfig.clsName + ".init", "1783", this);
                                    Tr.error(PolicyInboundConfig.tc, var72_166, var71_162.toString());
                                    throw SoapSecurityException.format(var72_166, var71_162);
                                }
                                if (var65_153 != null) {
                                    var6_6 = ConfigUtil.trim(var65_153.getReference());
                                    if (PolicyInboundConfig.tc.isDebugEnabled()) {
                                        Tr.debug(PolicyInboundConfig.tc, "CertStoreRef = " + var6_6);
                                    }
                                    var71_163 = false;
                                    if (var39_26 != null) {
                                        var72_164 = false;
                                        var73_167 = false;
                                        var74_168 = var39_26.getLdapCertStoresOrCollectionCertStores();
                                        var8_8 = var74_168.size();
                                        if (var8_8 > 0) {
                                            var75_169 = var74_168.get(0);
                                            if (var75_169 instanceof CollectionCertStores) {
                                                var73_167 = true;
                                            } else if (var75_169 instanceof LdapCertStores) {
                                                var72_164 = true;
                                            }
                                        }
                                        if (var73_167) {
                                            for (var75_170 = 0; var75_170 < var8_8; ++var75_170) {
                                                var76_172 = (CollectionCertStores)var74_168.get(var75_170);
                                                if (PolicyInboundConfig.tc.isDebugEnabled()) {
                                                    Tr.debug(PolicyInboundConfig.tc, "collectionCertStores.get(" + var75_170 + ") = " + var76_172.getName());
                                                }
                                                if (var6_6 == null || !var6_6.equals(ConfigUtil.trim(var76_172.getName()))) continue;
                                                var70_159 = Security.getProvider(ConfigUtil.trim(var76_172.getProvider()));
                                                var77_173 = new HashMap<K, V>();
                                                var78_174 = new HashSet<E>();
                                                var79_175 = var76_172.getX509CertificatesOrCRL();
                                                var9_9 = var79_175.size();
                                                for (var80_178 = 0; var80_178 < var9_9; ++var80_178) {
                                                    var81_180 = "";
                                                    var82_181 = (CertificateFactory)var77_173.get(var81_180);
                                                    if (var82_181 == null) {
                                                        var82_181 = ConfigUtil.createCertificateFactory((String)var81_180);
                                                        var77_173.put(var81_180, var82_181);
                                                    }
                                                    if ((var83_185 = var79_175.get(var80_178)) instanceof X509Certificates) {
                                                        var84_188 = (X509Certificates)var83_185;
                                                        var85_189 = var36_23.expand(ConfigUtil.trim(var84_188.getPath()));
                                                        var86_190 = new File(var85_189);
                                                        var87_191 = null;
                                                        var88_192 = var82_181;
                                                        try {
                                                            var87_191 = (X509Certificate)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>((CertificateFactory)var88_192){
                                                                final /* synthetic */ CertificateFactory val$certFactory;
                                                                {
                                                                    this.val$certFactory = certificateFactory;
                                                                }

                                                                @Override
                                                                public Object run() throws SoapSecurityException {
                                                                    return ConfigUtil.getX509Certificate(var86_190, this.val$certFactory);
                                                                }
                                                            });
                                                        }
                                                        catch (PrivilegedActionException var89_193) {
                                                            var90_194 = var89_193.getCause();
                                                            if (var90_194 instanceof SoapSecurityException) {
                                                                throw (SoapSecurityException)var90_194;
                                                            }
                                                            throw new SoapSecurityException(var90_194.getMessage());
                                                        }
                                                        var78_174.add(var87_191);
                                                        if (!PolicyInboundConfig.tc.isDebugEnabled()) continue;
                                                        Tr.debug(PolicyInboundConfig.tc, "Adding the X509 Certificate: " + var85_189);
                                                        continue;
                                                    }
                                                    if (!(var83_185 instanceof CRL)) continue;
                                                    var84_188 = (CRL)var83_185;
                                                    var85_189 = var36_23.expand(ConfigUtil.trim(var84_188.getPath()));
                                                    var86_190 = new File(var85_189);
                                                    var78_174.add(ConfigUtil.getX509CRL(var86_190, (CertificateFactory)var82_181));
                                                    if (!PolicyInboundConfig.tc.isDebugEnabled()) continue;
                                                    Tr.debug(PolicyInboundConfig.tc, "Adding the X509 CRL: " + var85_189);
                                                }
                                                var80_177 = "Collection";
                                                var81_180 = null;
                                                try {
                                                    var81_180 = new CollectionCertStoreParameters((Collection<?>)var78_174);
                                                    var82_181 = null;
                                                    var82_181 = var70_159 == null ? CertStore.getInstance(var80_177, (CertStoreParameters)var81_180) : CertStore.getInstance(var80_177, (CertStoreParameters)var81_180, var70_159);
                                                    var69_158.addCertStore((CertStore)var82_181);
                                                    if (PolicyInboundConfig.tc.isDebugEnabled()) {
                                                        Tr.debug(PolicyInboundConfig.tc, "Found CertStore for " + var6_6);
                                                    }
                                                    var71_163 = true;
                                                    break;
                                                }
                                                catch (NoSuchAlgorithmException var82_182) {
                                                    Tr.error(PolicyInboundConfig.tc, "security.wssecurity.WSSecurityDefaultConsumerConfig.s02", new Object[]{var80_177, var82_182});
                                                    throw SoapSecurityException.format("security.wssecurity.WSSecurityDefaultConsumerConfig.s02", var80_177, var82_182.toString());
                                                }
                                                catch (InvalidAlgorithmParameterException var82_183) {
                                                    var83_185 = "security.wssecurity.WSSecurityDefaultConsumerConfig.s03";
                                                    Tr.error(PolicyInboundConfig.tc, (String)var83_185, new Object[]{var81_180.toString() == null ? "" : var81_180.toString()});
                                                    throw SoapSecurityException.format((String)var83_185, var81_180.toString() == null ? "" : var81_180.toString(), (Throwable)var82_183);
                                                }
                                                catch (Throwable var82_184) {
                                                    var83_185 = "security.wssecurity.load.collectioncertstore.failed";
                                                    Tr.error(PolicyInboundConfig.tc, (String)var83_185, new String[]{var76_172.getName(), var82_184.getMessage()});
                                                    throw SoapSecurityException.format((String)var83_185, new String[]{var76_172.getName(), var82_184.getMessage()}, var82_184);
                                                }
                                            }
                                        }
                                        if (var72_164 && !var71_163) {
                                            for (var75_171 = 0; var75_171 < var8_8; ++var75_171) {
                                                var76_172 = (LdapCertStores)var74_168.get(var75_171);
                                                if (PolicyInboundConfig.tc.isDebugEnabled()) {
                                                    Tr.debug(PolicyInboundConfig.tc, "ldapCertStores.get(" + var75_171 + ") = " + var76_172.getName());
                                                }
                                                if (var6_6 == null || !var6_6.equals(ConfigUtil.trim(var76_172.getName()))) continue;
                                                var77_173 = var76_172.getLdapServer();
                                                var78_174 = ConfigUtil.trim(var77_173.getHost());
                                                try {
                                                    var79_176 = Integer.parseInt(var77_173.getPort());
                                                }
                                                catch (NumberFormatException var80_179) {
                                                    var81_180 = "security.wssecurity.PolicyInboundConfig.s21";
                                                    var82_181 = var77_173.getPort();
                                                    Tr.processException((Throwable)var80_179, PolicyInboundConfig.clsName + ".init", "1925", this);
                                                    Tr.error(PolicyInboundConfig.tc, (String)var81_180, var82_181);
                                                    throw SoapSecurityException.format((String)var81_180, (String)var82_181, (Throwable)var80_179);
                                                }
                                                var80_177 = "LDAP";
                                                var70_159 = Security.getProvider(ConfigUtil.trim(var76_172.getProvider()));
                                                var82_181 = new LDAPCertStoreParameters((String)var78_174, var79_176);
                                                try {
                                                    var81_180 = var70_159 == null ? CertStore.getInstance(var80_177, (CertStoreParameters)var82_181) : CertStore.getInstance(var80_177, (CertStoreParameters)var82_181, var70_159);
                                                }
                                                catch (NoSuchAlgorithmException var83_186) {
                                                    Tr.error(PolicyInboundConfig.tc, "security.wssecurity.WSSecurityDefaultConsumerConfig.s02", new Object[]{var80_177, var83_186});
                                                    throw SoapSecurityException.format("security.wssecurity.WSSecurityDefaultConsumerConfig.s02", var80_177, var83_186.toString());
                                                }
                                                catch (InvalidAlgorithmParameterException var83_187) {
                                                    var84_188 = "security.wssecurity.WSSecurityDefaultConsumerConfig.s03";
                                                    Tr.processException((Throwable)var83_187, PolicyInboundConfig.clsName + ".init", "1945", this);
                                                    Tr.error(PolicyInboundConfig.tc, (String)var84_188, var82_181.toString());
                                                    throw SoapSecurityException.format((String)var84_188, var82_181.toString());
                                                }
                                                var69_158.addCertStore((CertStore)var81_180);
                                                if (PolicyInboundConfig.tc.isDebugEnabled()) {
                                                    Tr.debug(PolicyInboundConfig.tc, "Found CertStore for " + var6_6);
                                                }
                                                var71_163 = true;
                                                break;
                                            }
                                        }
                                    }
                                }
                                var12_10._provider = var70_159;
                                var12_10._pkixBuilderParams = var69_158;
                            }
                        }
                    }
                    if (var3_3 && (var63_146 = var59_122.getBasicAuth()) != null) {
                        var6_6 = ConfigUtil.trim(var63_146.getUserid());
                        if (var6_6 != null && var6_6.length() > 0) {
                            var12_10._userId = var6_6;
                        }
                        if ((var6_6 = PasswordUtilFactory.getInstance().passwordDecode(ConfigUtil.trim(var63_146.getPassword()))) != null && var6_6.length() > 0) {
                            var12_10._userPassword = var6_6.toCharArray();
                        }
                    }
                    ConfigConstants.getProperties(var12_10._properties, var59_122.getProperties(), var36_23);
                    var23_35._callbackHandler = var12_10;
                    if (PolicyInboundConfig.tc.isDebugEnabled()) {
                        Tr.debug(PolicyInboundConfig.tc, "Adding the callback handler: " + var12_10.getClassName());
                    }
                }
                if ((var60_127 /* !! */  = var54_87.getJAASConfig()) == null) {
                    throw new SoapSecurityException("The jaasConfig in the binding not defined ");
                }
                var23_35._jaasConfig = ConfigUtil.trim(var60_127 /* !! */ .getConfigName());
                if (!this._defaultJAASConfigs.contains(var23_35._jaasConfig)) {
                    this._userDefinedComponentsUsed = true;
                }
                ConfigConstants.getProperties(var23_35._jaasConfigProperties, var60_127 /* !! */ .getProperties(), var36_23);
                ConfigConstants.getProperties(var23_35._properties, var54_87.getProperties(), var36_23);
                if (PolicyInboundConfig.tc.isDebugEnabled()) {
                    Tr.debug(PolicyInboundConfig.tc, "init(): Storing the following, maxAge = " + var49_63 + ", clockSkew = " + var50_65);
                }
                var23_35._properties.put(com.ibm.wsspi.wssecurity.core.Constants.WSSECURITY_NONCE_MAX_AGE, new Integer(var49_63));
                var23_35._properties.put(com.ibm.wsspi.wssecurity.core.Constants.WSSECURITY_NONCE_CLOCK_SKEW, new Integer(var50_65));
                if (this._symmetricProtectionTokenAssertion != null && this._symmetricProtectionTokenAssertion._requireImplicitDerivedKeys) {
                    var23_35.getProperties().put("RequiredImpliedDerivedKeys", this._symmetricProtectionTokenAssertion._requireImplicitDerivedKeys);
                    if (PolicyInboundConfig.tc.isDebugEnabled()) {
                        Tr.debug(PolicyInboundConfig.tc, "Added token config property for implicit derived keys");
                    }
                }
                var28_15.clear();
                var28_15.put("com.ibm.ws.wssecurity.impl.core.wssfactory.type", "com.ibm.ws.wssecurity.impl.core.wssfactory.custom");
                var28_15.put("com.ibm.ws.wssecurity.impl.core.wssfactory.classname", var23_35._className);
                if (var4_4 != null) {
                    var28_15.put("com.ibm.ws.wssecurity.impl.core.wssfactory.classloader", var4_4);
                }
                var61_136 = new HashMap<Object, Object>();
                try {
                    var23_35._instance = (TokenConsumerComponent)var27_14.createConsumer(var28_15, var61_136);
                }
                catch (SoapSecurityException var62_145) {
                    Tr.warning(PolicyInboundConfig.tc, "security.wssecurity.Instantiate", new Object[]{var23_35._className});
                }
                this._tokenConsumers.add(var23_35);
                var26_13.remove(var52_74);
                var6_6 = ConfigUtil.trim(var54_87.getName());
                if (var6_6 == null || var6_6.length() == 0) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s26");
                }
                if (this.nameToken.containsKey(var6_6) && PolicyInboundConfig.tc.isDebugEnabled()) {
                    Tr.debug(PolicyInboundConfig.tc, "WARNING: token consumer [" + var6_6 + "] is overwritten.");
                }
                if (PolicyInboundConfig.tc.isDebugEnabled()) {
                    Tr.debug(PolicyInboundConfig.tc, "Adding token consumer: " + var6_6);
                }
                this.nameToken.put(var6_6, var23_35);
                var23_35._name = var6_6;
            }
        }
        var52_74 = new ArrayList<E>();
        if (var41_32 != null) {
            var7_7 = var41_32.size();
            for (var53_81 = 0; var53_81 < var7_7; ++var53_81) {
                var54_87 = var41_32.get(var53_81);
                var17_195 = new PrivateConsumerConfig.KeyInfoContentConsumerConfImpl();
                var17_195._className = ConfigUtil.trim(var54_87.getClassname());
                if (!this._defaultKeyInfoContentConsumers.contains(var17_195._className)) {
                    this._userDefinedComponentsUsed = true;
                }
                if ((var55_94 = var54_87.getTokenReference()) != null && (var6_6 = ConfigUtil.trim(var55_94.getReference())) != null && var6_6.length() > 0) {
                    var17_195._tokenConsumer = (PrivateConsumerConfig.TokenConsumerConfImpl)this.nameToken.get(var6_6);
                    if (var17_195._tokenConsumer == null) {
                        throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", var6_6);
                    }
                    if (PolicyInboundConfig.tc.isDebugEnabled()) {
                        Tr.debug(PolicyInboundConfig.tc, "Got the token reference: " + var6_6);
                    }
                    var23_35 = var17_195._tokenConsumer;
                    var56_100 = (String)var23_35._properties.get("com.ibm.ws.wssecurity.config.keystore.consumerkeyStoreRef");
                    if (var56_100 != null && ConfigUtil.isHWKeyStore(var56_100)) {
                        var17_195._properties.put("com.ibm.ws.wssecurity.config.keystore.consumerkeyStoreRef", var56_100);
                        if (PolicyInboundConfig.tc.isDebugEnabled()) {
                            Tr.debug(PolicyInboundConfig.tc, "Hardware KeyStore is selected: " + var56_100);
                        }
                    }
                }
                ConfigConstants.getProperties(var17_195._properties, var54_87.getProperties(), var36_23);
                var28_15.clear();
                var28_15.put("com.ibm.ws.wssecurity.impl.core.wssfactory.type", "com.ibm.ws.wssecurity.impl.core.wssfactory.custom");
                var28_15.put("com.ibm.ws.wssecurity.impl.core.wssfactory.classname", var17_195._className);
                if (var17_195._className == null || var17_195._className.length() == 0) {
                    throw SoapSecurityException.format("security.wssecurity.WSSFactorySOAPImpl.s03");
                }
                if (PolicyInboundConfig.tc.isDebugEnabled()) {
                    Tr.debug(PolicyInboundConfig.tc, "KeyInfoContentConsumer classname = " + var17_195._className);
                }
                if (this._defaultKeyInfoContentConsumers.contains(var17_195._className)) {
                    var28_15.put("com.ibm.ws.wssecurity.impl.core.wssfactory.classloader", this.getClass().getClassLoader());
                } else if (var4_4 != null) {
                    var28_15.put("com.ibm.ws.wssecurity.impl.core.wssfactory.classloader", var4_4);
                }
                if (PolicyInboundConfig.tc.isDebugEnabled()) {
                    Tr.debug(PolicyInboundConfig.tc, "ClassLoader used = " + var28_15.get("com.ibm.ws.wssecurity.impl.core.wssfactory.classloader"));
                }
                var56_101 = new HashMap<Object, Object>();
                try {
                    var17_195._instance = (KeyInfoContentConsumerComponent)var27_14.createConsumer(var28_15, var56_101);
                }
                catch (SoapSecurityException var57_109) {
                    Tr.warning(PolicyInboundConfig.tc, "security.wssecurity.Instantiate", new Object[]{var17_195._className});
                }
                var52_74.add(var17_195);
                var6_6 = ConfigUtil.trim(var54_87.getName());
                if (var6_6 == null || var6_6.length() == 0) {
                    throw SoapSecurityException.format("security.wssecurity.PrivateGeneratorConfig.s28");
                }
                if (var29_16.containsKey(var6_6) && PolicyInboundConfig.tc.isDebugEnabled()) {
                    Tr.debug(PolicyInboundConfig.tc, "WARNING: key info [" + var6_6 + "] is overwritten.");
                }
                if (PolicyInboundConfig.tc.isDebugEnabled()) {
                    Tr.debug(PolicyInboundConfig.tc, "Adding key info: " + var6_6);
                }
                var29_16.put(var6_6, var17_195);
            }
        }
        var25_12.putAll(var30_17);
        if (var40_29 /* !! */  != null) {
            var7_7 = var40_29 /* !! */ .size();
            var53_82 = null;
            for (var54_88 = 0; var54_88 < var7_7; ++var54_88) {
                var55_94 = var40_29 /* !! */ .get(var54_88);
                var13_197 = new PrivateConsumerConfig.EncryptionConsumerConfImpl();
                var56_102 = null;
                var57_108 = null;
                var16_198 = new PrivateConsumerConfig.KeyInfoConsumerConfImpl();
                var58_113 = false;
                var59_123 = var55_94.getEncryptionPartReference();
                if (var59_123 != null) {
                    var53_82 = ConfigUtil.trim(var59_123.getReference());
                    if (var53_82 != null && var53_82.length() > 0) {
                        var13_197._reference = (PrivateCommonConfig.ReferencePartConfImpl)var30_17.get(var53_82);
                        var16_198._contentConsumers = new ArrayList<KeyInfoContentConsumerConfig>();
                        if (var13_197._reference == null) {
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", var53_82);
                        }
                        var13_197._reference.getBindings().add(var13_197);
                        if (PolicyInboundConfig.tc.isDebugEnabled()) {
                            Tr.debug(PolicyInboundConfig.tc, "Got the part reference: " + var53_82);
                        }
                        if (this.encryptionAlgorithms.containsKey(var53_82)) {
                            var56_102 = this.encryptionAlgorithms.get(var53_82);
                            var57_108 = this.keyEncryptionAlgorithms.get(var53_82);
                        } else if (PolicyInboundConfig.tc.isDebugEnabled()) {
                            Tr.debug(PolicyInboundConfig.tc, "WARNING: PartReference part [" + var53_82 + "] on EncryptionInfo does not match a label on EncryptedParts from Policy. Cannot retrieve encryption algorithms from Policy.");
                        }
                    } else if (PolicyInboundConfig.tc.isDebugEnabled()) {
                        Tr.debug(PolicyInboundConfig.tc, "WARNING: PartReference part on EncryptionInfo is null or empty. Cannot retrieve encryption algorithms from Policy.");
                    }
                    var60_127 /* !! */  = var59_123.getDataEncryptionKeyInfo();
                    if (var60_127 /* !! */  != null && var60_127 /* !! */ .size() > 0 && (var6_6 = ConfigUtil.trim((var61_137 = (DataEncryptionKeyInfo)var60_127 /* !! */ .get(0)).getReference())) != null && var6_6.length() > 0) {
                        var58_113 = true;
                        var17_195 = (PrivateConsumerConfig.KeyInfoContentConsumerConfImpl)var29_16.get(var6_6);
                        if (var17_195 == null) {
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", var6_6);
                        }
                        var23_35 = var17_195._tokenConsumer;
                        if (var23_35 != null) {
                            var23_35._usedForDecryption = true;
                        }
                        var16_198._contentConsumers.add(var17_195);
                        if (PolicyInboundConfig.tc.isDebugEnabled()) {
                            Tr.debug(PolicyInboundConfig.tc, "Got the key info reference: " + var6_6);
                        }
                    }
                } else if (PolicyInboundConfig.tc.isDebugEnabled()) {
                    Tr.debug(PolicyInboundConfig.tc, "WARNING: PartReference not found on EncryptionInfo. PartReference is required in order to retrieve the encryption algorithms from Policy.");
                }
                var11_196 = new PrivateCommonConfig.AlgorithmConfImpl();
                var11_196._algorithm = var56_102;
                var13_197._dataEncryptionMethod = var11_196;
                var60_127 /* !! */  = var55_94.getKeyEncryptionKeyInfo();
                if (var60_127 /* !! */  == null || var60_127 /* !! */ .size() == 0) {
                    if (!var58_113) {
                        var16_198._contentConsumers = var52_74;
                        var8_8 = var52_74.size();
                        for (var61_138 = 0; var61_138 < var8_8; ++var61_138) {
                            var17_195 = (PrivateConsumerConfig.KeyInfoContentConsumerConfImpl)var52_74.get(var61_138);
                            var23_35 = var17_195._tokenConsumer;
                            if (var23_35 == null) continue;
                            var23_35._usedForDecryption = true;
                        }
                    }
                } else {
                    var11_196 = new PrivateCommonConfig.AlgorithmConfImpl();
                    var11_196._algorithm = var57_108;
                    var13_197._keyEncryptionMethod = var11_196;
                    var16_198._contentConsumers = new ArrayList<KeyInfoContentConsumerConfig>();
                    var8_8 = var60_127 /* !! */ .size();
                    for (var61_139 = 0; var61_139 < var8_8; ++var61_139) {
                        var62_144 = (KeyEncryptionKeyInfo)var60_127 /* !! */ .get(var61_139);
                        var6_6 = ConfigUtil.trim(var62_144.getReference());
                        if (var6_6 == null || var6_6.length() <= 0) continue;
                        var17_195 = (PrivateConsumerConfig.KeyInfoContentConsumerConfImpl)var29_16.get(var6_6);
                        if (var17_195 == null) {
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", var6_6);
                        }
                        var23_35 = var17_195._tokenConsumer;
                        if (var23_35 != null) {
                            var23_35._usedForDecryption = true;
                        }
                        var16_198._contentConsumers.add(var17_195);
                        if (!PolicyInboundConfig.tc.isDebugEnabled()) continue;
                        Tr.debug(PolicyInboundConfig.tc, "Got the key info reference: " + var6_6);
                    }
                }
                var13_197._encryptionKeyInfo = var16_198;
                ConfigConstants.getProperties(var13_197._properties, var55_94.getProperties(), var36_23);
                this._encryptionConsumers.add(var13_197);
                var25_12.remove(var53_82);
                if (!PolicyInboundConfig.tc.isDebugEnabled()) continue;
                Tr.debug(PolicyInboundConfig.tc, "Adding encryption consumer.");
            }
        }
        var24_11.putAll(var31_18);
        if (var42_36 != null) {
            var7_7 = var42_36.size();
            var53_83 = null;
            for (var54_90 = 0; var54_90 < var7_7; ++var54_90) {
                var55_94 = (SigningInfo)var42_36.get(var54_90);
                var20_199 = new PrivateConsumerConfig.SignatureConsumerConfImpl();
                var56_103 = null;
                var57_108 = null;
                var58_114 = null;
                var59_124 = var55_94.getSigningPartReference();
                if (var59_124 != null) {
                    var8_8 = var59_124.size();
                    for (var60_128 = 0; var60_128 < var8_8; ++var60_128) {
                        var61_140 = var59_124.get(var60_128);
                        var21_200 = new PrivateCommonConfig.SigningReferenceConfImpl();
                        var53_83 = ConfigUtil.trim(var61_140.getReference());
                        if (var53_83 != null && var53_83.length() > 0) {
                            var21_200._reference = (PrivateCommonConfig.ReferencePartConfImpl)var31_18.get(var53_83);
                            if (var21_200._reference == null) {
                                throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", var53_83);
                            }
                            var21_200._reference.getBindings().add(var20_199);
                            if (PolicyInboundConfig.tc.isDebugEnabled()) {
                                Tr.debug(PolicyInboundConfig.tc, "Got the part reference: " + var53_83);
                            }
                        }
                        if (this.digestAlgorithms.containsKey(var53_83)) {
                            var56_103 = this.digestAlgorithms.get(var53_83);
                            var57_108 = this.canonicalizationAlgorithms.get(var53_83);
                            var58_114 = this._symmetricBinding ? this.symmetricSignatureAlgorithms.get(var53_83) : this.asymmetricSignatureAlgorithms.get(var53_83);
                        } else if (PolicyInboundConfig.tc.isDebugEnabled()) {
                            Tr.debug(PolicyInboundConfig.tc, "WARNING: PartReference part [" + var53_83 + "] on SigningInfo does not match a label on SignedParts from Policy. Cannot retrieve signature algorithms from Policy.");
                        }
                        var11_196 = new PrivateCommonConfig.AlgorithmConfImpl();
                        var11_196._algorithm = var56_103;
                        var21_200._digestMethod = var11_196;
                        var62_144 = var61_140.getTransform();
                        if (var62_144 != null) {
                            var9_9 = var62_144.size();
                            for (var63_148 = 0; var63_148 < var9_9; ++var63_148) {
                                var64_149 = (Transform)var62_144.get(var63_148);
                                if (var64_149 == null) continue;
                                var11_196 = new PrivateCommonConfig.AlgorithmConfImpl();
                                var11_196._algorithm = ConfigUtil.trim(var64_149.getAlgorithm());
                                ConfigConstants.getProperties(var11_196._properties, var64_149.getProperties(), var36_23);
                                var21_200._transforms.add(var11_196);
                            }
                        }
                        var20_199._references.add(var21_200);
                    }
                } else if (PolicyInboundConfig.tc.isDebugEnabled()) {
                    Tr.debug(PolicyInboundConfig.tc, "WARNING: PartReference not found on SigningInfo. PartReference is required in order to retrieve the signature algorithms from Policy.");
                }
                var11_196 = new PrivateCommonConfig.AlgorithmConfImpl();
                var11_196._algorithm = var57_108;
                var20_199._canonicalizationMethod = var11_196;
                var11_196 = new PrivateCommonConfig.AlgorithmConfImpl();
                var11_196._algorithm = var58_114;
                var20_199._signatureMethod = var11_196;
                var16_198 = new PrivateConsumerConfig.KeyInfoConsumerConfImpl();
                var60_127 /* !! */  = var55_94.getSigningKeyInfo();
                if (var60_127 /* !! */  == null || var60_127 /* !! */ .size() == 0) {
                    var16_198._contentConsumers = var52_74;
                    var8_8 = var52_74.size();
                    for (var61_141 = 0; var61_141 < var8_8; ++var61_141) {
                        var17_195 = (PrivateConsumerConfig.KeyInfoContentConsumerConfImpl)var52_74.get(var61_141);
                        var23_35 = var17_195._tokenConsumer;
                        if (var23_35 == null) continue;
                        var23_35._usedForVerification = true;
                    }
                } else {
                    var16_198._contentConsumers = new ArrayList<KeyInfoContentConsumerConfig>();
                    var8_8 = var60_127 /* !! */ .size();
                    for (var61_141 = 0; var61_141 < var8_8; ++var61_141) {
                        var62_144 = var60_127 /* !! */ .get(var61_141);
                        var6_6 = ConfigUtil.trim(var62_144.getReference());
                        if (var6_6 == null || var6_6.length() <= 0) continue;
                        var17_195 = (PrivateConsumerConfig.KeyInfoContentConsumerConfImpl)var29_16.get(var6_6);
                        if (var17_195 == null) {
                            throw SoapSecurityException.format("security.wssecurity.PrivateConsumerConfig.s31", var6_6);
                        }
                        var23_35 = var17_195._tokenConsumer;
                        if (var23_35 != null) {
                            var23_35._usedForVerification = true;
                        }
                        var16_198._contentConsumers.add(var17_195);
                        if (!PolicyInboundConfig.tc.isDebugEnabled()) continue;
                        Tr.debug(PolicyInboundConfig.tc, "Got the key info reference: " + var6_6);
                    }
                }
                var20_199._signingKeyInfo = var16_198;
                ConfigConstants.getProperties(var20_199._properties, var55_94.getProperties(), var36_23);
                this._signatureConsumers.add(var20_199);
                var24_11.remove(var53_83);
                if (!PolicyInboundConfig.tc.isDebugEnabled()) continue;
                Tr.debug(PolicyInboundConfig.tc, "Adding signature consumer.");
            }
        }
        if (!var25_12.isEmpty() && var5_5 != null) {
            Tr.warning(PolicyInboundConfig.tc, "security.wssecurity.WSSecurityBindingLoaderImpl.s09");
            if (PolicyInboundConfig.tc.isDebugEnabled()) {
                Tr.debug(PolicyInboundConfig.tc, "Missing encryption information in custom bindings is being filled in with encryption information from default bindings.");
            }
            var53_84 = var25_12.values();
            var54_91 = var53_84.iterator();
            var55_94 = null;
            var56_104 = null;
            while (var54_91.hasNext()) {
                var57_108 = (PrivateCommonConfig.ReferencePartConfImpl)var54_91.next();
                var58_115 = var5_5.getDefaultConsumerBinding();
                var59_125 = var58_115.getEncryptionConsumers();
                for (PrivateConsumerConfig.EncryptionConsumerConfImpl var56_104 : var59_125) {
                    if (!this.encryptionConsumerTokenMatch(var56_104, var3_3)) continue;
                    var13_197 = new PrivateConsumerConfig.EncryptionConsumerConfImpl();
                    var13_197._reference = var57_108;
                    var13_197._reference.getBindings().add(var13_197);
                    var11_196 = new PrivateCommonConfig.AlgorithmConfImpl();
                    var11_196._algorithm = this.encryptionAlgorithm;
                    var13_197._dataEncryptionMethod = var11_196;
                    if (var56_104._isKeyDecryption) {
                        var11_196 = new PrivateCommonConfig.AlgorithmConfImpl();
                        var11_196._algorithm = this.keyEncryptionAlgorithm;
                        var13_197._keyEncryptionMethod = var11_196;
                    }
                    var13_197._encryptionKeyInfo = var56_104._encryptionKeyInfo;
                    var13_197._properties.putAll(var56_104.getProperties());
                    this._encryptionConsumers.add(var13_197);
                    var60_127 /* !! */  = var13_197._encryptionKeyInfo.getContentConsumers();
                    if (var60_127 /* !! */  == null) continue;
                    for (List<KeyInfoContentConsumerConfig> var62_144 : var60_127 /* !! */ ) {
                        if (!(var62_144 instanceof PrivateConsumerConfig.KeyInfoContentConsumerConfImpl) || (var64_149 = (PrivateConsumerConfig.TokenConsumerConfImpl)(var63_147 = (PrivateConsumerConfig.KeyInfoContentConsumerConfImpl)var62_144).getTokenConsumer()) == null) continue;
                        this._tokenConsumers.add(var64_149);
                    }
                }
            }
        }
        if (!var24_11.isEmpty() && var5_5 != null) {
            Tr.warning(PolicyInboundConfig.tc, "security.wssecurity.WSSecurityBindingLoaderImpl.s09");
            if (PolicyInboundConfig.tc.isDebugEnabled()) {
                Tr.debug(PolicyInboundConfig.tc, "Missing signature information in custom bindings is being filled in with signature information from default bindings.");
            }
            var53_85 = var24_11.values();
            var54_92 = var53_85.iterator();
            var55_94 = null;
            var56_105 = null;
            var57_108 = null;
            var58_116 = null;
            while (var54_92.hasNext()) {
                var59_126 = (PrivateCommonConfig.ReferencePartConfImpl)var54_92.next();
                var60_127 /* !! */  = var5_5.getDefaultConsumerBinding();
                var61_143 = var60_127 /* !! */ .getSignatureConsumers();
                for (Object var57_108 : var61_143) {
                    if (!this.signatureConsumerTokenMatch((PrivateConsumerConfig.SignatureConsumerConfImpl)var57_108, var3_3)) continue;
                    var20_199 = new PrivateConsumerConfig.SignatureConsumerConfImpl();
                    for (PrivateCommonConfig.SigningReferenceConfImpl var58_116 : var57_108._references) {
                        if (var59_126 != null) {
                            var21_200 = new PrivateCommonConfig.SigningReferenceConfImpl();
                            var21_200._reference = var59_126;
                            var21_200._reference.getBindings().add(var20_199);
                            var11_196 = new PrivateCommonConfig.AlgorithmConfImpl();
                            var11_196._algorithm = this.digestAlgorithm;
                            var21_200._digestMethod = var11_196;
                            var21_200._transforms.addAll(var58_116._transforms);
                            var20_199._references.add(var21_200);
                        }
                        var11_196 = new PrivateCommonConfig.AlgorithmConfImpl();
                        var11_196._algorithm = this.canonicalizationAlgorithm;
                        var20_199._canonicalizationMethod = var11_196;
                        var11_196 = new PrivateCommonConfig.AlgorithmConfImpl();
                        var11_196._algorithm = this._symmetricBinding != false ? this.symmetricSignatureAlgorithm : this.asymmetricSignatureAlgorithm;
                        var20_199._signatureMethod = var11_196;
                        var20_199._signingKeyInfo = var57_108._signingKeyInfo;
                        var20_199._properties.putAll(var57_108._properties);
                        this._signatureConsumers.add(var20_199);
                        var62_144 = var20_199._signingKeyInfo.getContentConsumers();
                        if (var62_144 == null) continue;
                        for (Object var64_149 : var62_144) {
                            if (!(var64_149 instanceof PrivateConsumerConfig.KeyInfoContentConsumerConfImpl) || (var66_154 = (PrivateConsumerConfig.TokenConsumerConfImpl)(var65_153 = (PrivateConsumerConfig.KeyInfoContentConsumerConfImpl)var64_149).getTokenConsumer()) == null) continue;
                            this._tokenConsumers.add(var66_154);
                        }
                    }
                }
            }
        }
        var53_86 = false;
        if (!var26_13.isEmpty() && var5_5 != null) {
            Tr.warning(PolicyInboundConfig.tc, "security.wssecurity.WSSecurityBindingLoaderImpl.s09");
            if (PolicyInboundConfig.tc.isDebugEnabled()) {
                Tr.debug(PolicyInboundConfig.tc, "Missing supporting tokens in custom bindings is being filled in with supporting tokens information from default bindings.");
            }
            var54_93 = new HashMap<QName, PrivateConsumerConfig.TokenConsumerConfImpl>();
            var55_94 = null;
            var56_106 = null;
            for (V var58_117 : var26_13.values()) {
                if (!(var58_117 instanceof PrivateConsumerConfig.TokenConsumerConfImpl)) continue;
                var23_35 = (PrivateConsumerConfig.TokenConsumerConfImpl)var58_117;
                var54_93.put(var23_35.getType(), var23_35);
                if (!PolicyInboundConfig.tc.isDebugEnabled()) continue;
                Tr.debug(PolicyInboundConfig.tc, "Missing token consumer for unboundNameToken with Type[" + var23_35.getType() + "] and Name[" + var23_35._name + "].");
            }
            var55_94 = var5_5.getDefaultConsumerBinding().getTokenConsumers();
            var57_108 = var55_94.iterator();
            while (var57_108.hasNext()) {
                var58_118 = new PrivateConsumerConfig.TokenConsumerConfImpl((PrivateConsumerConfig.TokenConsumerConfImpl)var57_108.next());
                if (PolicyInboundConfig.tc.isDebugEnabled()) {
                    Tr.debug(PolicyInboundConfig.tc, "Found token consumer from default bindings with Type[" + var58_118.getType() + "] and Name[" + var58_118._name + "].");
                }
                if ((var56_106 = (PrivateConsumerConfig.TokenConsumerConfImpl)var54_93.get(var58_118.getType())) == null) continue;
                this._tokenConsumers.add(var58_118);
                var53_86 = true;
                if (!PolicyInboundConfig.tc.isDebugEnabled()) continue;
                Tr.debug(PolicyInboundConfig.tc, "Added token consumer from default bindings with Type[" + var58_118.getType() + "] and Name[" + var58_118._name + "] to token consumers.");
            }
        }
        this.validate(false, var53_86, null);
        if (PolicyInboundConfig.tc.isEntryEnabled()) {
            Tr.exit(PolicyInboundConfig.tc, "init(SecurityInboundBindingConfig binding, Policy policyRoot, String actorURI, boolean isRequest, ClassLoader appClassLoader,WSSecurityDefaultConfiguration defaultConfiguration)");
        }
    }

    private final void initDefaultConfig(WSSConsumerConfig wSSConsumerConfig, Map<String, TokenConsumerConfig> map, boolean bl) throws SoapSecurityException {
        TokenConsumerConfig tokenConsumerConfig;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initDefaultConfig(WSSConsumerConfig, Map):", new Object[]{wSSConsumerConfig, map});
        }
        HashMap<QName, PrivateConsumerConfig.TokenConsumerConfImpl> hashMap = new HashMap<QName, PrivateConsumerConfig.TokenConsumerConfImpl>();
        PrivateConsumerConfig.EncryptionConsumerConfImpl encryptionConsumerConfImpl = null;
        PrivateConsumerConfig.SignatureConsumerConfImpl signatureConsumerConfImpl = null;
        Object signingReferenceConfImpl3 = null;
        PrivateConsumerConfig.EncryptionConsumerConfImpl encryptionConsumerConfImpl2 = null;
        PrivateConsumerConfig.SignatureConsumerConfImpl signatureConsumerConfImpl2 = null;
        PrivateCommonConfig.SigningReferenceConfImpl signingReferenceConfImpl = null;
        PrivateConsumerConfig.TokenConsumerConfImpl tokenConsumerConfImpl = null;
        PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl = null;
        Iterator<Configuration> iterator = map.values().iterator();
        if (tc.isDebugEnabled() && iterator.hasNext()) {
            Tr.debug(tc, "Setting up token consumer information from default bindings.");
        }
        while (iterator.hasNext()) {
            tokenConsumerConfig = iterator.next();
            if (!(tokenConsumerConfig instanceof PrivateConsumerConfig.TokenConsumerConfImpl)) continue;
            tokenConsumerConfImpl = (PrivateConsumerConfig.TokenConsumerConfImpl)tokenConsumerConfig;
            hashMap.put(tokenConsumerConfImpl.getType(), tokenConsumerConfImpl);
        }
        Set<Configuration> set = wSSConsumerConfig.getTokenConsumers();
        iterator = set.iterator();
        while (iterator.hasNext()) {
            tokenConsumerConfig = new PrivateConsumerConfig.TokenConsumerConfImpl((PrivateConsumerConfig.TokenConsumerConfImpl)iterator.next());
            this._tokenConsumers.add(tokenConsumerConfig);
        }
        set = wSSConsumerConfig.getEncryptionConsumers();
        iterator = set.iterator();
        if (tc.isDebugEnabled() && iterator.hasNext()) {
            Tr.debug(tc, "Setting up encryption consumption information from default bindings.");
        }
        while (iterator.hasNext()) {
            encryptionConsumerConfImpl = (PrivateConsumerConfig.EncryptionConsumerConfImpl)iterator.next();
            if (!this.encryptionConsumerTokenMatch(encryptionConsumerConfImpl, bl)) continue;
            Iterator<Object> iterator2 = this._requiredConfidentialParts.iterator();
            while (iterator2.hasNext()) {
                encryptionConsumerConfImpl2 = new PrivateConsumerConfig.EncryptionConsumerConfImpl();
                encryptionConsumerConfImpl2._reference = (PrivateCommonConfig.ReferencePartConfImpl)iterator2.next();
                encryptionConsumerConfImpl2._reference.getBindings().add(encryptionConsumerConfImpl2);
                algorithmConfImpl = new PrivateCommonConfig.AlgorithmConfImpl();
                algorithmConfImpl._algorithm = this.encryptionAlgorithm;
                encryptionConsumerConfImpl2._dataEncryptionMethod = algorithmConfImpl;
                if (encryptionConsumerConfImpl._isKeyDecryption) {
                    algorithmConfImpl = new PrivateCommonConfig.AlgorithmConfImpl();
                    algorithmConfImpl._algorithm = this.keyEncryptionAlgorithm;
                    encryptionConsumerConfImpl2._keyEncryptionMethod = algorithmConfImpl;
                }
                encryptionConsumerConfImpl2._encryptionKeyInfo = encryptionConsumerConfImpl._encryptionKeyInfo;
                encryptionConsumerConfImpl2._properties.putAll(encryptionConsumerConfImpl.getProperties());
                this._encryptionConsumers.add(encryptionConsumerConfImpl2);
            }
        }
        set = wSSConsumerConfig.getSignatureConsumers();
        iterator = set.iterator();
        if (tc.isDebugEnabled() && iterator.hasNext()) {
            Tr.debug(tc, "Settting up signature consumption information from default bindings.");
        }
        while (iterator.hasNext()) {
            signatureConsumerConfImpl = (PrivateConsumerConfig.SignatureConsumerConfImpl)iterator.next();
            if (!this.signatureConsumerTokenMatch(signatureConsumerConfImpl, bl)) continue;
            signatureConsumerConfImpl2 = new PrivateConsumerConfig.SignatureConsumerConfImpl();
            for (PrivateCommonConfig.SigningReferenceConfImpl signingReferenceConfImpl2 : signatureConsumerConfImpl._references) {
                if (this._requiredIntegralParts.isEmpty()) continue;
                Iterator iterator3 = this._requiredIntegralParts.iterator();
                while (iterator3.hasNext()) {
                    signingReferenceConfImpl = new PrivateCommonConfig.SigningReferenceConfImpl();
                    signingReferenceConfImpl._reference = (PrivateCommonConfig.ReferencePartConfImpl)iterator3.next();
                    signingReferenceConfImpl._reference.getBindings().add(signatureConsumerConfImpl2);
                    algorithmConfImpl = new PrivateCommonConfig.AlgorithmConfImpl();
                    algorithmConfImpl._algorithm = this.digestAlgorithm;
                    signingReferenceConfImpl._digestMethod = algorithmConfImpl;
                    signingReferenceConfImpl._transforms.addAll(signingReferenceConfImpl2._transforms);
                    signatureConsumerConfImpl2._references.add(signingReferenceConfImpl);
                }
                algorithmConfImpl = new PrivateCommonConfig.AlgorithmConfImpl();
                algorithmConfImpl._algorithm = this.canonicalizationAlgorithm;
                signatureConsumerConfImpl2._canonicalizationMethod = algorithmConfImpl;
                algorithmConfImpl = new PrivateCommonConfig.AlgorithmConfImpl();
                algorithmConfImpl._algorithm = this._symmetricBinding ? this.symmetricSignatureAlgorithm : this.asymmetricSignatureAlgorithm;
                signatureConsumerConfImpl2._signatureMethod = algorithmConfImpl;
                signatureConsumerConfImpl2._signingKeyInfo = signatureConsumerConfImpl._signingKeyInfo;
                signatureConsumerConfImpl2._properties.putAll(signatureConsumerConfImpl._properties);
                this._signatureConsumers.add(signatureConsumerConfImpl2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initDefaultConfig(WSSConsumerConfig, Map)");
        }
    }

    final String getOrigin() {
        return this.origin;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean encryptionConsumerTokenMatch(PrivateConsumerConfig.EncryptionConsumerConfImpl encryptionConsumerConfImpl, boolean bl) throws SoapSecurityException {
        Object object;
        QName qName = null;
        boolean bl2 = false;
        if (encryptionConsumerConfImpl.getEncryptionKeyInfo() == null) throw new SoapSecurityException("No EncryptionKeyInfo found in encryptionConsumerConfig = " + encryptionConsumerConfImpl);
        List<KeyInfoContentConsumerConfig> list = encryptionConsumerConfImpl.getEncryptionKeyInfo().getContentConsumers();
        if (list == null) throw new SoapSecurityException("No contentConsumers found in EncryptionKeyInfo = " + encryptionConsumerConfImpl.getEncryptionKeyInfo());
        Iterator<KeyInfoContentConsumerConfig> iterator = list.iterator();
        if (iterator.hasNext()) {
            object = (PrivateConsumerConfig.KeyInfoContentConsumerConfImpl)iterator.next();
            qName = ((PrivateConsumerConfig.KeyInfoContentConsumerConfImpl)object).getTokenConsumer().getType();
        }
        if (qName == null) return bl2;
        object = qName.getLocalPart();
        if (this._symmetricBinding) {
            if (this._symmetricProtectionTokenAssertion != null) {
                if (!this._symmetricProtectionTokenAssertion.getTokentType().getLocalPart().equals(object)) return false;
                return true;
            }
            if (this._symmetricEncryptionTokenAssertion == null) return bl2;
            if (!this._symmetricProtectionTokenAssertion.getTokentType().getLocalPart().equals(object)) return false;
            return true;
        }
        if (bl) {
            if (!this._recipientTokens.isEmpty()) {
                if (this._recipientTokens.get(object) == null) return false;
                return true;
            }
            if (this._recipientEncryptionTokens.isEmpty()) return bl2;
            if (this._recipientEncryptionTokens.get(object) == null) return false;
            return true;
        }
        if (!this._initiatorTokens.isEmpty()) {
            if (this._initiatorTokens.get(object) == null) return false;
            return true;
        }
        if (this._initiatorEncryptionTokens.isEmpty()) return bl2;
        if (this._initiatorEncryptionTokens.get(object) == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean signatureConsumerTokenMatch(PrivateConsumerConfig.SignatureConsumerConfImpl signatureConsumerConfImpl, boolean bl) throws SoapSecurityException {
        Object object;
        QName qName = null;
        boolean bl2 = false;
        if (signatureConsumerConfImpl.getSigningKeyInfo() == null) throw new SoapSecurityException("No EncryptionKeyInfo found in encryptionConsumerConfig = " + signatureConsumerConfImpl);
        List<KeyInfoContentConsumerConfig> list = signatureConsumerConfImpl.getSigningKeyInfo().getContentConsumers();
        if (list == null) throw new SoapSecurityException("No contentConsumers found in EncryptionKeyInfo = " + signatureConsumerConfImpl.getSigningKeyInfo());
        Iterator<KeyInfoContentConsumerConfig> iterator = list.iterator();
        if (iterator.hasNext()) {
            object = (PrivateConsumerConfig.KeyInfoContentConsumerConfImpl)iterator.next();
            qName = ((PrivateConsumerConfig.KeyInfoContentConsumerConfImpl)object).getTokenConsumer().getType();
        }
        if (qName == null) return bl2;
        object = qName.getLocalPart();
        if (this._symmetricBinding) {
            if (this._symmetricProtectionTokenAssertion != null) {
                if (!this._symmetricProtectionTokenAssertion.getTokentType().getLocalPart().equals(object)) return false;
                return true;
            }
            if (this._symmetricEncryptionTokenAssertion == null) return bl2;
            if (!this._symmetricProtectionTokenAssertion.getTokentType().getLocalPart().equals(object)) return false;
            return true;
        }
        if (bl) {
            if (!this._initiatorTokens.isEmpty()) {
                if (this._initiatorTokens.get(object) == null) return false;
                return true;
            }
            if (this._initiatorSignatureTokens.isEmpty()) return bl2;
            if (this._initiatorSignatureTokens.get(object) == null) return false;
            return true;
        }
        if (!this._recipientTokens.isEmpty()) {
            if (this._recipientTokens.get(object) == null) return false;
            return true;
        }
        if (this._recipientSignatureTokens.isEmpty()) return bl2;
        if (this._recipientSignatureTokens.get(object) == null) return false;
        return true;
    }

    private PrivateCommonConfig.TokenAssertion tokenAssertion(String string, List list) throws SoapSecurityException {
        PrivateCommonConfig.TokenAssertion tokenAssertion = null;
        if (string.equals("X509Token")) {
            tokenAssertion = new PrivateCommonConfig.TokenAssertion();
            if (list != null && list.size() != 0) {
                for (int i = 0; i < list.size(); ++i) {
                    Object e = list.get(i);
                    if (e instanceof Element) {
                        throw new SoapSecurityException("The policy assertion" + e + "is not a valid X509TOKEN assertion");
                    }
                    if (!(e instanceof JAXBElement)) continue;
                    JAXBElement jAXBElement = (JAXBElement)e;
                    String string2 = jAXBElement.getName().getLocalPart();
                    if ("RequireDerivedKeys".equals(string2)) {
                        tokenAssertion._requireDerivedKeys = true;
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "the policy assertion for X509TOKEN has added RequireDerivedKeys");
                        continue;
                    }
                    if ("RequireImplicitDerivedKeys".equals(string2)) {
                        tokenAssertion._requireImplicitDerivedKeys = true;
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "the policy assertion for X509TOKEN has added RequireImplicitDerivedKeys");
                        continue;
                    }
                    if ("RequireExplicitDerivedKeys".equals(string2)) {
                        tokenAssertion._requireExplicitDerivedKeys = true;
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "the policy assertion for X509TOKEN has added RequireExplicitDerivedKeys");
                        continue;
                    }
                    if ("WssX509V3Token10".equals(string2)) {
                        tokenAssertion._tokenType = Constants.X509V3_OLD;
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "the policy assertion for X509TOKEN has added WssX509V3Token10");
                        continue;
                    }
                    if ("WssX509Pkcs7Token10".equals(string2)) {
                        tokenAssertion._tokenType = Constants.PKCS7;
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "the policy assertion for X509TOKEN has added WssX509Pkcs7Token10");
                        continue;
                    }
                    if ("WssX509PkiPathV1Token10".equals(string2)) {
                        tokenAssertion._tokenType = Constants.PKI_PATH;
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "the policy assertion for X509TOKEN has added WSS_X509_PKI_PATH_V1_TOKEN10");
                        continue;
                    }
                    if ("WssX509V1Token11".equals(string2)) {
                        tokenAssertion._tokenType = Constants.X509V3_11_V1;
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "the policy assertion for X509TOKEN has added WssX509V1Token11");
                        continue;
                    }
                    if ("WssX509V3Token11".equals(string2)) {
                        tokenAssertion._tokenType = Constants.X509V3_11_V3;
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "the policy assertion for X509TOKEN has added WssX509V3Token11");
                        continue;
                    }
                    if ("WssX509Pkcs7Token11".equals(string2)) {
                        tokenAssertion._tokenType = Constants.PKCS711;
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "the policy assertion for X509TOKEN has added WssX509Pkcs7Token11");
                        continue;
                    }
                    if ("WssX509PkiPathV1Token11".equals(string2)) {
                        tokenAssertion._tokenType = Constants.PKI_PATH11;
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "the policy assertion for X509TOKEN has added WssX509PkiPathV1Token11");
                        continue;
                    }
                    if ("RequireKeyIdentifierReference".equals(string2)) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "the policy assertion for X509TOKEN has added RequireKeyIdentifierReference");
                        continue;
                    }
                    if ("RequireIssuerSerialReference".equals(string2)) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "the policy assertion for X509TOKEN has added RequireIssuerSerialReference");
                        continue;
                    }
                    if ("RequireEmbeddedTokenReference".equals(string2)) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "the policy assertion for X509TOKEN has added RequireEmbeddedTokenReference");
                        continue;
                    }
                    if (!"RequireThumbprintReference".equals(string2) || !tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "the policy assertion for X509TOKEN has added RequireThumbprintReference");
                }
            }
        } else if (string.equals("UsernameToken")) {
            tokenAssertion = new PrivateCommonConfig.TokenAssertion();
            if (list != null && list.size() != 0) {
                for (int i = 0; i < list.size(); ++i) {
                    Object e = list.get(i);
                    if (e instanceof Element) {
                        throw new SoapSecurityException("The policy assertion" + e + "is not a valid USERNAMETOKEN assertion");
                    }
                    if (!(e instanceof JAXBElement)) continue;
                    JAXBElement jAXBElement = (JAXBElement)e;
                    String string3 = jAXBElement.getName().getLocalPart();
                    if ("RequireDerivedKeys".equals(string3)) {
                        tokenAssertion._requireDerivedKeys = true;
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "the policy assertion for USERNAMETOKEN has added RequireDerivedKeys");
                        continue;
                    }
                    if ("RequireImplicitDerivedKeys".equals(string3)) {
                        tokenAssertion._requireImplicitDerivedKeys = true;
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "the policy assertion for USERNAMETOKEN has added RequireImplicitDerivedKeys");
                        continue;
                    }
                    if ("RequireExplicitDerivedKeys".equals(string3)) {
                        tokenAssertion._requireExplicitDerivedKeys = true;
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "the policy assertion for USERNAMETOKEN has added RequireExplicitDerivedKeys");
                        continue;
                    }
                    if ("WssUsernameToken10".equals(string3)) {
                        if (tokenAssertion._tokenType != null) {
                            Tr.error(tc, "UsernameToken Profile 1.0 assertion found when UsernameToken 1.1  was already defined.");
                            throw new SoapSecurityException("security.wssecurityUsernameToken Profile 1.0 assertion found when UsernameToken 1.1  was already defined.");
                        }
                        tokenAssertion._tokenType = Constants.UNTOKEN;
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "the policy assertion for USERNAMETOKEN has added WssUsernameToken10");
                        continue;
                    }
                    if (!"WssUsernameToken11".equals(string3)) continue;
                    if (tokenAssertion._tokenType != null) {
                        Tr.error(tc, "UsernameToken Profile 1.1 assertion found when UsernameToken 1.0  was already defined.");
                        throw new SoapSecurityException("security.wssecurityUsernameToken Profile 1.1 assertion found when UsernameToken 1.0  was already defined.");
                    }
                    tokenAssertion._tokenType = Constants.UNTOKEN_11;
                    Tr.debug(tc, "WssUsernameToken11");
                }
            }
        } else if (string.equals("SecureConversationToken")) {
            tokenAssertion = new PrivateCommonConfig.TokenAssertion();
            if (list != null && list.size() != 0) {
                for (int i = 0; i < list.size(); ++i) {
                    Object e = list.get(i);
                    if (e instanceof Element) {
                        throw new SoapSecurityException("The policy assertion" + e + "is not a valid SECURECONVERSATIONTOKEN assertion");
                    }
                    if (!(e instanceof JAXBElement)) continue;
                    JAXBElement jAXBElement = (JAXBElement)e;
                    String string4 = jAXBElement.getName().getLocalPart();
                    if ("RequireDerivedKeys".equals(string4)) {
                        tokenAssertion._requireDerivedKeys = true;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "the policy assertion for SECURECONVERSATIONTOKEN has added RequireDerivedKeys");
                        }
                    } else if ("RequireImplicitDerivedKeys".equals(string4)) {
                        tokenAssertion._requireImplicitDerivedKeys = true;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "the policy assertion for SECURECONVERSATIONTOKEN has added RequireDerivedKeys");
                        }
                    } else if ("RequireExplicitDerivedKeys".equals(string4)) {
                        tokenAssertion._requireExplicitDerivedKeys = true;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "the policy assertion for SECURECONVERSATIONTOKEN has added RequireDerivedKeys");
                        }
                    } else if ("RequireExternalUriReference".equals(string4)) {
                        tokenAssertion._requireExplicitDerivedKeys = true;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "the policy assertion for SECURECONVERSATIONTOKEN has added RequireExternalUriReference");
                        }
                    } else if ("SC200502SecurityContextToken".equals(string4)) {
                        tokenAssertion._tokenType = Constants.SC_200502;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "the policy assertion for SECURECONVERSATIONTOKEN has added SC200502SecurityContextToken");
                        }
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "the policy assertion for SECURECONVERSATIONTOKEN ");
                }
            }
        } else if (string.equals("LTPAToken")) {
            tokenAssertion = new PrivateCommonConfig.TokenAssertion();
            tokenAssertion._tokenType = Constants.LTPA_TOKEN;
        } else if (string.equals("LTPAPropagationToken")) {
            tokenAssertion = new PrivateCommonConfig.TokenAssertion();
            tokenAssertion._tokenType = Constants.LTPA_TOKEN_PROPAGATION;
        } else if (string.equals("CustomToken")) {
            tokenAssertion = new PrivateCommonConfig.TokenAssertion();
            if (list != null && list.size() != 0) {
                for (int i = 0; i < list.size(); ++i) {
                    Object e = list.get(i);
                    if (!(e instanceof WssCustomToken)) continue;
                    WssCustomToken wssCustomToken = null;
                    wssCustomToken = (WssCustomToken)e;
                    String string5 = wssCustomToken.getUri();
                    String string6 = wssCustomToken.getLocalname();
                    tokenAssertion._tokenType = new QName(string5, string6);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "the policy assertion for CustomToken");
                }
            }
        } else {
            tokenAssertion = null;
            Tr.warning(tc, "security.wssecurity.PolicyInOutboundConfig.s01", new String[]{string});
        }
        return tokenAssertion;
    }

    private PrivateCommonConfig.TokenAssertion getTokenTypeAssertion(JAXBElement jAXBElement) throws SoapSecurityException {
        Object object;
        List<Object> list;
        OperatorContentType operatorContentType = null;
        Object t = jAXBElement.getValue();
        NestedPolicyType nestedPolicyType = null;
        TokenAssertionType tokenAssertionType = null;
        Policy policy = null;
        List<Object> list2 = null;
        PrivateCommonConfig.TokenAssertion tokenAssertion = null;
        if (t instanceof NestedPolicyType) {
            nestedPolicyType = (NestedPolicyType)jAXBElement.getValue();
            if (nestedPolicyType.getPolicy() != null) {
                policy = nestedPolicyType.getPolicy();
                list2 = policy.getPolicyOrAllOrExactlyOne();
            } else {
                list2 = nestedPolicyType.getAny();
            }
        } else if (t instanceof TokenAssertionType) {
            tokenAssertionType = (TokenAssertionType)jAXBElement.getValue();
            String string = jAXBElement.getName().getLocalPart();
            if (tokenAssertionType.getAny() != null) {
                list = tokenAssertionType.getAny();
                if (list != null && list.size() > 0) {
                    operatorContentType = (Policy)list.get(0);
                }
                if (operatorContentType != null) {
                    object = operatorContentType.getPolicyOrAllOrExactlyOne();
                    tokenAssertion = this.tokenAssertion(string, (List)object);
                }
            }
            if (string.equals("LTPAToken") || string.equals("LTPAPropagationToken")) {
                tokenAssertion = this.tokenAssertion(string, list2);
            }
        }
        if (list2 != null) {
            for (int i = 0; i < list2.size(); ++i) {
                List<Object> list3;
                Object object2;
                list = list2.get(i);
                if (list instanceof Element) {
                    throw new SoapSecurityException("The policy assertion" + list + "is not a valid SecureConversationToken QName assertion");
                }
                if (!(list instanceof JAXBElement)) continue;
                object = (JAXBElement)((Object)list);
                String string = ((JAXBElement)object).getName().getLocalPart();
                if (string.equals("SecureConversationToken")) {
                    object2 = (SecureConversationTokenType)((JAXBElement)object).getValue();
                    list3 = ((SecureConversationTokenType)object2).getAny();
                    if (list3 != null && list3.size() > 0) {
                        operatorContentType = (Policy)list3.get(0);
                    }
                } else {
                    object2 = (TokenAssertionType)((JAXBElement)object).getValue();
                    list3 = ((TokenAssertionType)object2).getAny();
                    if (list3 != null && list3.size() > 0) {
                        operatorContentType = (Policy)list3.get(0);
                    }
                }
                if (operatorContentType == null) continue;
                object2 = operatorContentType.getPolicyOrAllOrExactlyOne();
                tokenAssertion = this.tokenAssertion(string, (List)object2);
            }
        }
        return tokenAssertion;
    }

    private void algorithmSuiteAssertion(JAXBElement jAXBElement, QName qName) throws SoapSecurityException {
        this._symmetricBinding = PolicyConfigUtil.symmetricBindingQName.equals(qName);
        this.transformAlgorithm = "http://www.w3.org/2001/10/xml-exc-c14n#";
        this.canonicalizationAlgorithm = "http://www.w3.org/2001/10/xml-exc-c14n#";
        NestedPolicyType nestedPolicyType = (NestedPolicyType)jAXBElement.getValue();
        Policy policy = nestedPolicyType.getPolicy();
        List<Object> list = policy.getPolicyOrAllOrExactlyOne();
        Object object = null;
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                object = list.get(i);
                if (object instanceof Element) {
                    throw new SoapSecurityException("The policy assertion" + object + "is not a valid SecureConversationToken QName assertion");
                }
                if (!(object instanceof JAXBElement)) continue;
                JAXBElement jAXBElement2 = (JAXBElement)object;
                QName qName2 = jAXBElement2.getName();
                String string = qName2.getLocalPart();
                if (PolicyConfigUtil.isValidAlgorithmSuite(string)) {
                    if (this._symmetricBinding) {
                        this.algorithmSuite = string;
                        this.symmetricSignatureAlgorithm = PolicyConfigUtil.getAlgorithm(string, 0);
                    } else {
                        this.asymmetricSignatureAlgorithm = PolicyConfigUtil.getAlgorithm(string, 1);
                    }
                    this.digestAlgorithm = PolicyConfigUtil.getAlgorithm(string, 2);
                    this.encryptionAlgorithm = PolicyConfigUtil.getAlgorithm(string, 3);
                    this.keyEncryptionAlgorithm = PolicyConfigUtil.getAlgorithm(string, 5);
                    continue;
                }
                if ("InclusiveC14N".equals(string)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found C14N inclusive");
                    }
                    this.transformAlgorithm = "http://www.w3.org/2001/10/xml-c14n#";
                    this.canonicalizationAlgorithm = "http://www.w3.org/2001/10/xml-c14n#";
                    continue;
                }
                if ("SOAPNormalization10".equals(string)) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Found SOAPNormalization10");
                    continue;
                }
                if ("STRTransform10".equals(string)) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Found STRT10");
                    continue;
                }
                if ("XPath10".equals(string)) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Found XPATH10");
                    continue;
                }
                if ("XPath20".equals(string)) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Found STRT10");
                    continue;
                }
                if ("AbsXPath".equals(string)) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Found ABSXPATH");
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "WARNING: invalid algorithm suite [" + string + "] specified on EncryptedParts .");
            }
        }
    }

    private String layoutAssertion(JAXBElement jAXBElement) throws SoapSecurityException {
        String string = null;
        NestedPolicyType nestedPolicyType = (NestedPolicyType)jAXBElement.getValue();
        Policy policy = nestedPolicyType.getPolicy();
        List<Object> list = policy.getPolicyOrAllOrExactlyOne();
        Object object = null;
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                object = list.get(i);
                if (object instanceof Element) {
                    throw new SoapSecurityException("The policy assertion" + object + "is not a valid SecureConversationToken QName assertion");
                }
                if (!(object instanceof JAXBElement)) continue;
                JAXBElement jAXBElement2 = (JAXBElement)object;
                QName qName = jAXBElement2.getName();
                String string2 = qName.getLocalPart();
                if ("Strict".equals(string2)) {
                    string = "Strict";
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Found Strict");
                    continue;
                }
                if ("Lax".equals(string2)) {
                    string = "Lax";
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Found Lax");
                    continue;
                }
                if ("LaxTsFirst".equals(string2)) {
                    string = "LaxTsFirst";
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Found LaxTsFirst");
                    continue;
                }
                if ("LaxTsLast".equals(string2)) {
                    string = "LaxTsLast";
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Found LaxTsLast");
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "WARNING: invalid layout [" + string2 + "] specified.");
            }
        }
        return string;
    }

    private boolean retrieveAssertions(String string, boolean bl) {
        boolean bl2 = false;
        if (string == null) {
            bl2 = false;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No wsu:Id for Policy element found; ignoring.");
            }
        } else if (string.startsWith("request:") && bl) {
            bl2 = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Matching inbound request wsu:Id found: " + string);
            }
        } else if (string.startsWith("response:") && !bl) {
            bl2 = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Matching inbound response wsu:Id found: " + string);
            }
        } else {
            bl2 = false;
            if (tc.isDebugEnabled()) {
                if (bl) {
                    Tr.debug(tc, "wsu:Id found not applicable for inbound request messages: " + string);
                } else {
                    Tr.debug(tc, "wsu:Id found not applicable for inbound response messages: " + string);
                }
            }
        }
        return bl2;
    }

    public String getAlgorithmSuite() {
        return this.algorithmSuite;
    }
}

