/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.handler;

import com.ibm.ws.wssecurity.util.ConfidentialDialectElementSelector;
import com.ibm.ws.wssecurity.util.IntegralDialectElementSelector;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyConfigUtil {
    protected static String policyNS = "http://schemas.xmlsoap.org/ws/2004/09/policy";
    protected static final String secPolicyNS = "http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512";
    protected static QName policyQName = new QName(policyNS, "Policy");
    protected static QName signedPartsQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "SignedParts");
    protected static QName signedElementsQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "SignedElements");
    protected static QName encryptedPartsQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "EncryptedParts");
    protected static QName encryptedElementsQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "EncryptedElements");
    protected static QName asymmetricBindingQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "AsymmetricBinding");
    protected static QName symmetricBindingQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "SymmetricBinding");
    protected static QName algorithmSuiteQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "AlgorithmSuite");
    protected static QName wss10QName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "Wss10");
    protected static QName wss11QName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "Wss11");
    protected static QName trust10QName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "Trust10");
    protected static QName supportingTokenQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "SupportingTokens");
    protected static QName signedSupportingTokenQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "SignedSupportingTokens");
    protected static QName layoutQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "Layout");
    protected static QName usernameTokenQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "UsernameToken");
    protected static QName wssUsernameToken10QName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "WssUsernameToken10");
    protected static QName wssUsernameToken11QName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "WssUsernameToken11");
    protected static QName wssIncludeTimestampQName = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", "IncludeTimestamp");
    protected static String xmiNS = "http://schema.omg.org/spec/XMI/1.0";
    protected static QName xmiLabelQName = new QName(xmiNS, "label");
    protected static final String requestIdentifier = "request:";
    protected static final String responseIdentifier = "response:";
    protected static final String algorithmHmacSha1 = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
    protected static final String algorithmRsaSha1 = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    protected static final String algorithmSha1 = "http://www.w3.org/2000/09/xmldsig#sha1";
    protected static final String algorithmSha256 = "http://www.w3.org/2001/04/xmlenc#sha256";
    protected static final String algorithmSha512 = "http://www.w3.org/2001/04/xmlenc#sha512";
    protected static final String algorithmAes128 = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
    protected static final String algorithmAes192 = "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
    protected static final String algorithmAes256 = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
    protected static final String algorithmTripleDes = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
    protected static final String algorithmKwAes128 = "http://www.w3.org/2001/04/xmlenc#kw-aes128-cbc";
    protected static final String algorithmKwAes192 = "http://www.w3.org/2001/04/xmlenc#kw-aes192-cbc";
    protected static final String algorithmKwAes256 = "http://www.w3.org/2001/04/xmlenc#kw-aes256-cbc";
    protected static final String algorithmKwTripleDes = "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
    protected static final String algorithmKwRsaOaep = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
    protected static final String algorithmKwRsa15 = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
    protected static final String algorithmPSha1 = "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1";
    protected static final String algorithmPSha1L128 = "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1";
    protected static final String algorithmPSha1L192 = "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1";
    protected static final String algorithmPSha1L256 = "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1";
    protected static final String algorithmXPath = "http://www.w3.org/TR/1999/REC-xpath-19991116";
    protected static final String algorithmXPath20 = "http://www.w3.org/2002/06/xmldsig-filter2";
    protected static final String algorithmC14n = "http://www.w3.org/2001/10/xml-c14n#";
    protected static final String algorithmExC14n = "http://www.w3.org/2001/10/xml-exc-c14n#";
    protected static final String algorithmSNT = "http://www.w3.org/TR/soap12-n11n";
    protected static final String algorithmSTRT10 = "http://docs.oasis-open.org/wss/2004/xx/oasis-2004xx-wss-soap-message-security-1.0#STR-Transform";
    protected static final String BASIC256 = "Basic256";
    protected static final String BASIC192 = "Basic192";
    protected static final String BASIC128 = "Basic128";
    protected static final String TRIPLEDES = "TripleDes";
    protected static final String BASIC256_RSA15 = "Basic256Rsa15";
    protected static final String BASIC192_RSA15 = "Basic192Rsa15";
    protected static final String BASIC128_RSA15 = "Basic128Rsa15";
    protected static final String TRIPLEDES_RSA15 = "TripleDesRsa15";
    protected static final String BASIC256_SHA256 = "Basic256Sha256";
    protected static final String BASIC192_SHA256 = "Basic192Sha256";
    protected static final String BASIC128_SHA256 = "Basic128Sha256";
    protected static final String TRIPLEDES_SHA256 = "TripleDesSha256";
    protected static final String BASIC256_SHA256_RSA15 = "Basic256Sha256Rsa15";
    protected static final String BASIC192_SHA256_RSA15 = "Basic192Sha256Rsa15";
    protected static final String BASIC128_SHA256_RSA15 = "Basic128Sha256Rsa15";
    protected static final String TRIPLEDES_SHA256_RSA15 = "TripleDesSha256Rsa15";
    protected static final String INCLUSIVE_C14N = "InclusiveC14N";
    protected static final String SOAP_NORMALIZATION10 = "SOAPNormalization10";
    protected static final String STRTRANSFORM10 = "STRTransform10";
    protected static final String XPATH10 = "XPath10";
    protected static final String XPATH20 = "XPath20";
    protected static final String ABSXPATH = "AbsXPath";
    protected static final String RECIPIENT_TOKEN = "RecipientToken";
    protected static final String INITIATOR_TOKEN = "InitiatorToken";
    protected static final String INITIATOR_SIGNATURE_TOKEN = "InitiatorSignatureToken";
    protected static final String RECIPIENT_SIGNATURE_TOKEN = "RecipientSignatureToken";
    protected static final String INITIATOR_ENCRYPTION_TOKEN = "InitiatorEncryptionToken";
    protected static final String RECIPIENT_ENCRYPTION_TOKEN = "RecipientEncryptionToken";
    protected static final String ENCRYPTION_TOKEN = "EncryptionToken";
    protected static final String SIGNATURE_TOKEN = "SignatureToken";
    protected static final String PROTECTION_TOKEN = "ProtectionToken";
    protected static final String STRICT = "Strict";
    protected static final String LAX = "Lax";
    protected static final String LAX_TS_FIRST = "LaxTsFirst";
    protected static final String LAX_TS_LAST = "LaxTsLast";
    protected static final String MUST_SUPPORT_REF_KEY_IDENTIFIER = "MustSupportRefKeyIdentifier";
    protected static final String MUST_SUPPORT_REF_KEY_ISSUER_SERIAL = "MustSupportRefIssuerSerial";
    protected static final String MUST_SUPPORT_REF_EXTERNAL_URI = "MustSupportRefExternalURI";
    protected static final String MUST_SUPPORT_REF_EMBEDDED_TOKEN = "MustSupportRefEmbeddedToken";
    protected static final String MUST_SUPPORT_REF_THUMBPRINT = "MustSupportRefThumbprint";
    protected static final String MUST_SUPPORT_REF_ENCRYPTED_KEY = "MustSupportRefEncryptedKey";
    protected static final String REQUIRE_SIGNATURE_CONFIRMATION = "RequireSignatureConfirmation";
    protected static final String MUST_SUPPORT_CLIENT_CHALLENGE = "MustSupportClientChallenge";
    protected static final String MUST_SUPPORT_SERVER_CHALLENGE = "MustSupportServerChallenge";
    protected static final String REQUIRE_CLIENT_ENTROPY = "RequireClientEntropy";
    protected static final String REQUIRE_SERVER_ENTROPY = "RequireServerEntropy";
    protected static final String MUST_SUPPORT_ISSUED_TOKENS = "MustSupportIssuedTokens";
    protected static final String REQUIRE_DERIVED_KEYS = "RequireDerivedKeys";
    protected static final String REQUIRE_IMPLICIT_DERIVED_KEYS = "RequireImplicitDerivedKeys";
    protected static final String REQUIRE_EXPLICIT_DERIVED_KEYS = "RequireExplicitDerivedKeys";
    protected static final String REQUIRE_KEY_IDENTIFIER_REFERENCE = "RequireKeyIdentifierReference";
    protected static final String REQUIRE_ISSUER_SERIAL_REFERENCE = "RequireIssuerSerialReference";
    protected static final String REQUIRE_EMBEDDED_TOKEN_REFERENCE = "RequireEmbeddedTokenReference";
    protected static final String REQUIRE_THUMBPRINT_REFERENCE = "RequireThumbprintReference";
    protected static final String WSS_X509V3_TOKEN10 = "WssX509V3Token10";
    protected static final String WSS_X509_PKCS7_TOKEN10 = "WssX509Pkcs7Token10";
    protected static final String WSS_X509_PKI_PATH_V1_TOKEN10 = "WssX509PkiPathV1Token10";
    protected static final String WSS_X509V1_TOKEN11 = "WssX509V1Token11";
    protected static final String WSS_X509V3_TOKEN11 = "WssX509V3Token11";
    protected static final String WSS_X509_PKCS7_TOKEN11 = "WssX509Pkcs7Token11";
    protected static final String WSS_X509_PKI_PATH_V1_TOKEN11 = "WssX509PkiPathV1Token11";
    protected static final String WSS_USERNAME_TOKEN10 = "WssUsernameToken10";
    protected static final String WSS_USERNAME_TOKEN11 = "WssUsernameToken11";
    protected static final String REQUIRE_EXTERNAL_URI_REFERENCE = "RequireExternalUriReference";
    protected static final String SC200502_SECURITY_CONTEXT_TOKEN = "SC200502SecurityContextToken";
    protected static final String BOOTSTRAP_POLICY = "BootstrapPolicy";
    protected static final String WSS_CUSTOM_TOKEN = "WssCustomToken";
    protected static final String USERNAME_TOKEN = "UsernameToken";
    protected static final String X509TOKEN = "X509Token";
    protected static final String SECURE_CONVERSATION_TOKEN = "SecureConversationToken";
    protected static final String CUSTOM_TOKEN = "CustomToken";
    protected static final String LTPA_TOKEN = "LTPAToken";
    protected static final String LTPA_PROPAGATION_TOKEN = "LTPAPropagationToken";
    protected static final int SYMMETRIC_KEY_SIGNATURE_ALGORITHM = 0;
    protected static final int ASYMMETRIC_KEY_SIGNATURE_ALGORITHM = 1;
    protected static final int DIGEST_ALGORITHM = 2;
    protected static final int ENCRYPTION_ALGORITHM = 3;
    protected static final int SYMMETRIC_KEY_WRAP_ALGORITHM = 4;
    protected static final int ASYMMETRIC_KEY_WRAP_ALGORITHM = 5;
    protected static final int COMPUTED_KEY_ALGORITHM = 6;
    protected static final int ENCRYPTION_KEY_DERIVATION_ALGORITHM = 7;
    protected static final int SIGNATURE_KEY_DERIVATION_ALGORITHM = 8;
    protected static final String WS_SEC = "ws-security";
    protected static final String NON_WS_SEC = "non-ws-security";
    protected static final String TIMESTAMP_XPATH_11 = "/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd' and local-name()='Timestamp']";
    protected static final String SIGNATURE_XPATH_11 = "/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://www.w3.org/2000/09/xmldsig#' and local-name()='Signature']";
    protected static final String USERNAMETOKEN_XPATH_11 = "/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='UsernameToken']";
    protected static final String SIGCONF_XPATH_11 = "/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Envelope']/*[namespace-uri()='http://schemas.xmlsoap.org/soap/envelope/' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd' and local-name()='SignatureConfirmation']";
    protected static final String TIMESTAMP_XPATH_12 = "/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Envelope']/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd' and local-name()='Timestamp']";
    protected static final String SIGNATURE_XPATH_12 = "/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Envelope']/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://www.w3.org/2000/09/xmldsig#' and local-name()='Signature']";
    protected static final String USERNAMETOKEN_XPATH_12 = "/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Envelope']/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='UsernameToken']";
    protected static final String SIGCONF_XPATH_12 = "/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Envelope']/*[namespace-uri()='http://www.w3.org/2003/05/soap-envelope' and local-name()='Header']/*[namespace-uri()='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd' and local-name()='Security']/*[namespace-uri()='http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd' and local-name()='SignatureConfirmation']";
    private static final TraceComponent tc = Tr.register(PolicyConfigUtil.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    protected static Set<String> getAllowedAlgorithms(int n) {
        HashSet<String> hashSet = new HashSet<String>();
        switch (n) {
            case 0: {
                hashSet.add(algorithmRsaSha1);
                hashSet.add(algorithmHmacSha1);
                break;
            }
            case 1: {
                hashSet.add(algorithmHmacSha1);
                hashSet.add(algorithmRsaSha1);
                break;
            }
            case 2: {
                hashSet.add(algorithmSha256);
                hashSet.add(algorithmSha1);
                break;
            }
            case 3: {
                hashSet.add(algorithmAes256);
                hashSet.add(algorithmAes192);
                hashSet.add(algorithmAes128);
                hashSet.add(algorithmTripleDes);
                break;
            }
            case 7: {
                hashSet.add("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1");
                hashSet.add("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1");
                hashSet.add("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1");
                break;
            }
            case 5: {
                hashSet.add(algorithmKwRsa15);
                hashSet.add(algorithmKwRsaOaep);
                hashSet.add("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1");
                break;
            }
            case 4: {
                hashSet.add(algorithmKwAes256);
                hashSet.add(algorithmKwAes192);
                hashSet.add(algorithmKwAes128);
                hashSet.add(algorithmKwTripleDes);
            }
        }
        return hashSet;
    }

    protected static boolean isValidAlgorithmSuite(String string) {
        boolean bl = false;
        if (string.equals(BASIC256) || string.equals(BASIC192) || string.equals(BASIC128) || string.equals(TRIPLEDES) || string.equals(BASIC256_RSA15) || string.equals(BASIC192_RSA15) || string.equals(BASIC128_RSA15) || string.equals(TRIPLEDES_RSA15) || string.equals(BASIC256_SHA256) || string.equals(BASIC192_SHA256) || string.equals(BASIC128_SHA256) || string.equals(TRIPLEDES_SHA256) || string.equals(BASIC256_SHA256_RSA15) || string.equals(BASIC192_SHA256_RSA15) || string.equals(BASIC128_SHA256_RSA15) || string.equals(TRIPLEDES_SHA256_RSA15)) {
            bl = true;
        }
        return bl;
    }

    protected static String getAlgorithm(String string, int n) {
        String string2 = null;
        switch (n) {
            case 0: {
                string2 = algorithmHmacSha1;
                break;
            }
            case 1: {
                string2 = algorithmRsaSha1;
                break;
            }
            case 6: {
                string2 = "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1";
                break;
            }
            case 2: {
                if (string.contains("Sha256")) {
                    string2 = algorithmSha256;
                    break;
                }
                string2 = algorithmSha1;
                break;
            }
            case 3: {
                if (string.contains(BASIC256)) {
                    string2 = algorithmAes256;
                    break;
                }
                if (string.contains(BASIC192)) {
                    string2 = algorithmAes192;
                    break;
                }
                if (string.contains(BASIC128)) {
                    string2 = algorithmAes128;
                    break;
                }
                string2 = algorithmTripleDes;
                break;
            }
            case 4: {
                if (string.contains(BASIC256)) {
                    string2 = algorithmKwAes256;
                    break;
                }
                if (string.contains(BASIC192)) {
                    string2 = algorithmKwAes192;
                    break;
                }
                if (string.contains(BASIC128)) {
                    string2 = algorithmKwAes128;
                    break;
                }
                string2 = algorithmKwTripleDes;
                break;
            }
            case 5: {
                if (string.contains("Rsa15")) {
                    string2 = algorithmKwRsa15;
                    break;
                }
                string2 = algorithmKwRsaOaep;
                break;
            }
            case 7: {
                if (string.contains(BASIC256)) {
                    string2 = "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1";
                    break;
                }
                if (string.contains(BASIC128)) {
                    string2 = "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1";
                    break;
                }
                string2 = "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1";
                break;
            }
            case 8: {
                string2 = string.contains(BASIC128) ? "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1" : "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1";
            }
        }
        return string2;
    }

    public static String getMinimumSymmetricKeyLength(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMinimumSymmetricKeyLength(algorithmSuite " + string + " )");
        }
        String string2 = "128";
        if (string.contains(BASIC256)) {
            string2 = "256";
        } else if (string.contains(BASIC192)) {
            string2 = "192";
        } else if (string.contains(BASIC128)) {
            string2 = "128";
        } else if (string.contains(TRIPLEDES)) {
            string2 = "192";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMinimumSymmetricKeyLength(algorithmSuite " + string + " )" + ", returns keyLength = " + string2);
        }
        return string2;
    }

    public static String getKeywordForXPathExpression(String string, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeywordForXPathExpression(String xpathExpression " + string + ", boolean signedParts " + bl + " )");
        }
        String string2 = null;
        if (bl) {
            if (TIMESTAMP_XPATH_11.equals(string) || TIMESTAMP_XPATH_12.equals(string)) {
                string2 = IntegralDialectElementSelector.WASDIALECTS[1];
            }
        } else if (SIGNATURE_XPATH_11.equals(string) || SIGNATURE_XPATH_12.equals(string)) {
            string2 = ConfidentialDialectElementSelector.WASDIALECTS[3];
        } else if (USERNAMETOKEN_XPATH_11.equals(string) || USERNAMETOKEN_XPATH_12.equals(string)) {
            string2 = ConfidentialDialectElementSelector.WASDIALECTS[1];
        } else if (TIMESTAMP_XPATH_11.equals(string) || TIMESTAMP_XPATH_12.equals(string)) {
            string2 = ConfidentialDialectElementSelector.WASDIALECTS[5];
        } else if (SIGCONF_XPATH_11.equals(string) || SIGCONF_XPATH_12.equals(string)) {
            string2 = ConfidentialDialectElementSelector.WASDIALECTS[6];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeywordForXPathExpression(String xpathExpression, boolean signedParts), returns keyword = " + string2);
        }
        return string2;
    }
}

