/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.filter.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class NamespaceStack {
    private static final TraceComponent tc = Tr.register(NamespaceStack.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    public static final String XMLNS = "http://www.w3.org/XML/1998/namespace";
    private static final int INIT = 10;
    private int max = 10;
    private int startSize;
    private int size = this.startSize = 3;
    private String[] pre = new String[10];
    private String[] uri = new String[10];
    private static final int CONTEXT_INIT = 10;
    private int contextMax = 10;
    private int contextSize = 0;
    private int[] context = new int[10];

    public NamespaceStack() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "NamespaceStack");
        }
        this.pre[0] = "xml";
        this.uri[0] = XMLNS;
        this.pre[1] = "xmlns";
        this.uri[1] = "http://www.w3.org/2000/xmlns/";
        this.pre[2] = "";
        this.uri[2] = "";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "NamespaceStack", this);
        }
    }

    public void reset() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reset", this);
        }
        this.size = this.startSize;
        this.contextSize = 0;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reset");
        }
    }

    public void clear() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clear", this);
        }
        for (int i = this.startSize; i < this.size; ++i) {
            this.pre[i] = null;
            this.uri[i] = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clear");
        }
    }

    public void pushContext() {
        this.context[this.contextSize] = this.size;
        ++this.contextSize;
        if (this.contextSize == this.contextMax) {
            this.contextMax *= 2;
            int[] nArray = new int[this.contextMax];
            System.arraycopy(this.context, 0, nArray, 0, this.contextSize);
            this.context = nArray;
        }
    }

    public void popContext() {
        --this.contextSize;
        if (this.contextSize < 0) {
            this.contextSize = 0;
        }
        this.size = this.context[this.contextSize];
    }

    public boolean declarePrefix(String string, String string2) {
        this.pre[this.size] = string;
        this.uri[this.size] = string2;
        ++this.size;
        if (this.size == this.max) {
            this.max *= 2;
            String[] stringArray = new String[this.max];
            System.arraycopy(this.pre, 0, stringArray, 0, this.size);
            this.pre = stringArray;
            String[] stringArray2 = new String[this.max];
            System.arraycopy(this.uri, 0, stringArray2, 0, this.size);
            this.uri = stringArray2;
        }
        return true;
    }

    public String getURI(String string) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (!this.pre[i].equals(string)) continue;
            return this.uri[i];
        }
        return null;
    }

    public Iterator getPrefixes() {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = this.size - 1; i >= 0; --i) {
            hashSet.add(this.pre[i]);
        }
        return hashSet.iterator();
    }

    public Map getMap() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMap", this);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < this.size; ++i) {
            hashMap.put(this.pre[i], this.uri[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMap", hashMap);
        }
        return hashMap;
    }

    public Map getCurrentActiveDeclMap() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCurrentActiveDeclMap", this);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        boolean bl = false;
        for (int i = this.size - 1; i > this.startSize - 1; --i) {
            if ("".equals(this.pre[i])) {
                if (bl) continue;
                bl = true;
                if ("".equals(this.uri[i])) continue;
                hashMap.put(this.pre[i], this.uri[i]);
            }
            if (hashMap.containsKey(this.pre[i])) continue;
            hashMap.put(this.pre[i], this.uri[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCurrentActiveDeclMap", hashMap);
        }
        return hashMap;
    }
}

