/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.filter.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MultiByteArrayInputStream
extends InputStream {
    private static final TraceComponent tc = Tr.register(MultiByteArrayInputStream.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    public static final byte[] EMPTYBYTEARRAY = new byte[0];
    protected byte[] currentBuf;
    protected byte[][] multiBuf;
    protected int bufPos;
    protected int currentPos;
    protected int currentCount;
    protected int totalCount;
    protected int passedCount;
    protected boolean isClosed;
    protected int mark = 0;
    protected byte[] markBuf;

    public MultiByteArrayInputStream(byte[][] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "MultiByteArrayInputStream", byArray);
        }
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (byArray.length == 0) {
            this.isClosed = true;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "MultiByteArrayInputStream, but.length==0");
            }
            return;
        }
        this.passedCount = 0;
        this.totalCount = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == null) {
                byArray[i] = EMPTYBYTEARRAY;
            }
            this.totalCount += byArray[i].length;
        }
        if (this.totalCount == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "MultiByteArrayInputStream, totalCount == 0");
            }
            return;
        }
        this.bufPos = 0;
        this.multiBuf = byArray;
        this.currentBuf = byArray[0];
        this.currentPos = 0;
        this.currentCount = byArray[0].length;
        this.isClosed = false;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "MultiByteArrayInputStream", this);
        }
    }

    public MultiByteArrayInputStream(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "MultiByteArrayInputStream", byArray);
        }
        this.currentBuf = byArray;
        this.currentPos = 0;
        this.currentCount = byArray.length;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "MultiByteArrayInputStream", this);
        }
    }

    public MultiByteArrayInputStream(byte[] byArray, int n, int n2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "MultiByteArrayInputStream", new Object[]{byArray, new Integer(n), new Integer(n2)});
        }
        this.currentBuf = byArray;
        this.currentPos = n;
        this.currentCount = Math.min(n + n2, byArray.length);
        this.mark = n;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "MultiByteArrayInputStream", this);
        }
    }

    public synchronized int read() {
        if (this.currentPos < this.currentCount) {
            return this.currentBuf[this.currentPos++] & 0xFF;
        }
        if (this.bufPos + 1 < this.multiBuf.length) {
            this.nextBuf();
            return this.read();
        }
        return -1;
    }

    private void nextBuf() {
        this.passedCount += this.currentBuf.length;
        ++this.bufPos;
        if (this.bufPos >= this.multiBuf.length) {
            return;
        }
        this.currentBuf = this.multiBuf[this.bufPos];
        this.currentPos = 0;
        this.currentCount = this.currentBuf.length;
        if (this.multiBuf[this.bufPos].length == 0) {
            this.nextBuf();
        }
    }

    public synchronized int read(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 <= 0) {
            return 0;
        }
        if (this.isClosed) {
            return -1;
        }
        int n3 = this.totalCount - this.passedCount - this.currentPos;
        if (n3 <= 0) {
            this.isClosed = true;
            return -1;
        }
        if (n3 < n2) {
            n2 = n3;
        }
        n3 = n2;
        while (this.bufPos < this.multiBuf.length) {
            if (this.currentCount == 0) {
                this.nextBuf();
                continue;
            }
            if (this.currentPos + n2 <= this.currentCount) {
                System.arraycopy(this.currentBuf, this.currentPos, byArray, n, n2);
                this.currentPos += n2;
                break;
            }
            int n4 = this.currentCount - this.currentPos;
            System.arraycopy(this.currentBuf, this.currentPos, byArray, n, n4);
            n += n4;
            n2 -= n4;
            if (this.bufPos + 1 < this.multiBuf.length) {
                this.nextBuf();
                continue;
            }
            ++this.bufPos;
        }
        return n3;
    }

    public synchronized long skip(long l) {
        if ((long)this.currentPos + l > (long)this.currentCount) {
            l = this.currentCount - this.currentPos;
        }
        if (l < 0L) {
            return 0L;
        }
        this.currentPos = (int)((long)this.currentPos + l);
        return l;
    }

    public synchronized int available() {
        return 0;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int n) {
        this.mark = this.currentPos;
    }

    public synchronized void reset() {
        this.bufPos = 0;
        this.passedCount = 0;
        this.currentBuf = this.multiBuf[0];
        this.currentPos = 0;
        this.currentCount = this.currentBuf.length;
    }

    public void close() throws IOException {
        this.isClosed = true;
    }

    public static void main(String[] stringArray) {
        byte[] byArray = new byte[10];
        for (int i = 0; i < 10; ++i) {
            byArray[i] = (byte)(i + 11);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        byte[] byArray2 = new byte[10];
        byteArrayInputStream.read();
        byteArrayInputStream.read(byArray2, 0, 5);
        for (int i = 0; i < 5; ++i) {
            System.out.println(" " + byArray2[i]);
        }
    }
}

