/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.filter.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class C14NWriter {
    private static final TraceComponent tc = Tr.register(C14NWriter.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    public static final String C14NBUFFERSIZE_KEY = "c14nbuffersize";
    private static final byte SP = 32;
    private static final byte QUOT = 34;
    private static final byte SLASH = 47;
    private static final byte COLON = 58;
    private static final byte LT = 60;
    private static final byte EQ = 61;
    private static final byte GT = 62;
    private static final byte QM = 63;
    private static final byte[] SP_XMLNS = new byte[]{32, 120, 109, 108, 110, 115};
    private static final byte[] ESC_TAB = new byte[]{38, 35, 120, 57, 59};
    private static final byte[] ESC_LF = new byte[]{38, 35, 120, 65, 59};
    private static final byte[] ESC_CR = new byte[]{38, 35, 120, 68, 59};
    private static final byte[] ESC_QUOT = new byte[]{38, 113, 117, 111, 116, 59};
    private static final byte[] ESC_AMP = new byte[]{38, 97, 109, 112, 59};
    private static final byte[] ESC_LT = new byte[]{38, 108, 116, 59};
    private static final byte[] ESC_GT = new byte[]{38, 103, 116, 59};
    private static final byte[][] textTab = new byte[][]{null, null, null, null, null, null, null, null, null, null, null, null, null, ESC_CR, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, ESC_AMP, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, ESC_LT, null, ESC_GT, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
    private static final byte[][] attrTab = new byte[][]{null, null, null, null, null, null, null, null, null, ESC_TAB, ESC_LF, null, null, ESC_CR, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, ESC_QUOT, null, null, null, ESC_AMP, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, ESC_LT, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
    private static int INIT_SIZE = 2048;
    private static int INIT_STACK_SIZE = 16;
    private boolean mode = true;
    public static final boolean MODE_DIGEST = true;
    public static final boolean MODE_BYTEARRAY = false;
    private byte[] out = new byte[INIT_SIZE];
    private int size = 0;
    private int max = INIT_SIZE;
    private MessageDigest digester;
    private byte[] digestValue = null;
    private int depth = 0;
    private int stackMax = INIT_STACK_SIZE;
    private int[] startTagOpenPosStack = new int[INIT_SIZE];
    private int[] qnameLengthStack = new int[INIT_SIZE];

    public static void setINIT_SIZE(int n) {
        if (n > 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "set initial c14n buffer size = " + n);
            }
            INIT_SIZE = n;
        }
    }

    public C14NWriter() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "C14NWriter");
        }
        try {
            this.digester = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "C14NWriter", this);
        }
    }

    public void reset() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reset", this);
        }
        this.digester.reset();
        this.digestValue = null;
        this.size = 0;
        this.mode = true;
        this.depth = 0;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reset");
        }
    }

    public void writeStartTagOpen(String string, String string2) throws IOException {
        int n;
        int n2;
        int n3;
        ++this.depth;
        if (this.depth >= this.stackMax) {
            this.expandStack();
        }
        if ((n3 = this.size + (n2 = string.length()) + (n = string2.length()) + 3) >= this.max) {
            this.expandArray(n3);
        }
        this.out[this.size++] = 60;
        this.startTagOpenPosStack[this.depth] = this.size;
        if (n2 != 0) {
            this.write(string, n2);
            this.out[this.size++] = 58;
        }
        this.write(string2, n);
        this.qnameLengthStack[this.depth] = this.size - this.startTagOpenPosStack[this.depth];
    }

    public void writeNamespaceDeclaration(String string, String string2) throws IOException {
        int n;
        int n2 = string.length();
        int n3 = this.size + n2 + (n = string2.length()) + 11;
        if (n3 >= this.max) {
            this.expandArray(n3);
        }
        for (int i = 0; i < SP_XMLNS.length; ++i) {
            this.out[this.size++] = SP_XMLNS[i];
        }
        if (n2 != 0) {
            this.out[this.size++] = 58;
            this.write(string, n2);
        }
        this.out[this.size++] = 61;
        this.out[this.size++] = 34;
        this.write(string2, n);
        this.out[this.size++] = 34;
    }

    public void writeAttribute(String string, String string2, String string3) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        if (string == null) {
            string = "";
        }
        if ((n4 = this.size + (n3 = string.length()) + (n2 = string2.length()) + (n = string3.length()) + 6) >= this.max) {
            this.expandArray(n4);
        }
        this.out[this.size++] = 32;
        if (n3 != 0) {
            this.write(string, n3);
            this.out[this.size++] = 58;
        }
        this.write(string2, n2);
        this.out[this.size++] = 61;
        this.out[this.size++] = 34;
        this.writeWithCharEsc(string3, n, attrTab);
        this.out[this.size++] = 34;
    }

    public void writeStartTagClose() throws IOException {
        int n = this.size + 1;
        if (n >= this.max) {
            this.expandArray(n);
        }
        this.out[this.size++] = 62;
    }

    public void writeText(String string) throws IOException {
        int n = string.length();
        int n2 = this.size + n;
        if (n2 >= this.max) {
            this.expandArray(n2);
        }
        this.writeWithCharEsc(string, n, textTab);
    }

    public boolean writeEndTagByUsingCache() throws IOException {
        boolean bl = false;
        int n = this.size + this.qnameLengthStack[this.depth] + 3;
        if (n >= this.max) {
            this.expandArray(n);
        }
        int n2 = this.startTagOpenPosStack[this.depth];
        int n3 = this.qnameLengthStack[this.depth];
        if (n2 >= 0 && n3 >= 0) {
            this.out[this.size++] = 60;
            this.out[this.size++] = 47;
            System.arraycopy(this.out, n2, this.out, this.size, n3);
            this.size += n3;
            this.out[this.size++] = 62;
            --this.depth;
            bl = true;
        }
        return bl;
    }

    public void writeEndTag(String string, String string2) throws IOException {
        int n;
        int n2 = string.length();
        int n3 = this.size + n2 + (n = string2.length()) + 4;
        if (n3 >= this.max) {
            this.expandArray(n3);
        }
        this.out[this.size++] = 60;
        this.out[this.size++] = 47;
        if (n2 != 0) {
            this.write(string, n2);
            this.out[this.size++] = 58;
        }
        this.write(string2, n);
        this.out[this.size++] = 62;
        --this.depth;
    }

    public void writePI(String string, String string2) throws IOException {
        int n;
        int n2 = string.length();
        int n3 = 0;
        if (string2 != null) {
            string2 = string2.trim();
            n3 = string2.length();
        }
        if ((n = this.size + n2 + n3 + 5) > this.max) {
            this.expandArray(n);
        }
        this.out[this.size++] = 60;
        this.out[this.size++] = 63;
        this.write(string, n2);
        if (n3 > 0) {
            this.out[this.size++] = 32;
            this.write(string2, n3);
        }
        this.out[this.size++] = 63;
        this.out[this.size++] = 62;
    }

    private void write(String string, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if ('\u0000' >= c || c >= '\u007f') {
                this.writeUTF8(string, i);
                return;
            }
            this.out[this.size++] = (byte)c;
        }
    }

    private void writeUTF8(String string, int n) throws IOException {
        byte[] byArray = string.substring(n).getBytes("UTF8");
        int n2 = this.size + byArray.length;
        if (n2 >= this.max) {
            this.expandArray(n2);
        }
        for (int i = 0; i < byArray.length; ++i) {
            this.out[this.size++] = byArray[i];
        }
    }

    private void writeWithCharEsc(String string, int n, byte[][] byArray) throws IOException {
        int n2;
        try {
            for (n2 = 0; n2 < n; ++n2) {
                char c = string.charAt(n2);
                byte[] byArray2 = byArray[c];
                if (byArray2 == null) {
                    this.out[this.size++] = (byte)c;
                    continue;
                }
                int n3 = this.size + byArray2.length;
                if (n3 >= this.max) {
                    this.expandArray(n3);
                }
                System.arraycopy(byArray2, 0, this.out, this.size, byArray2.length);
                this.size += byArray2.length;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.writeUTF8WithCharEsc(string, n2, byArray);
        }
    }

    private void writeUTF8WithCharEsc(String string, int n, byte[][] byArray) throws IOException {
        byte[] byArray2 = string.substring(n).getBytes("UTF8");
        int n2 = this.size + byArray2.length;
        if (n2 >= this.max) {
            this.expandArray(n2);
        }
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray2[i] > 0) {
                byte[] byArray3 = byArray[byArray2[i]];
                if (byArray3 == null) {
                    this.out[this.size++] = byArray2[i];
                    continue;
                }
                System.arraycopy(byArray3, 0, this.out, this.size, byArray3.length);
                this.size += byArray3.length;
                continue;
            }
            this.out[this.size++] = byArray2[i];
        }
    }

    public void setMode(boolean bl) {
        this.mode = bl;
    }

    public byte[] toByteArray() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "toByteArray", this);
        }
        byte[] byArray = new byte[this.size];
        System.arraycopy(this.out, 0, byArray, 0, this.size);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "toByteArray", byArray);
        }
        return byArray;
    }

    public byte[] toDigestByteArray() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "toDigestByteArray", this);
        }
        if (this.digestValue == null) {
            this.digester.update(this.out, 0, this.size);
            this.digestValue = this.digester.digest();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "toDigestByteArray", this.digestValue);
        }
        return this.digestValue;
    }

    private void expandArray(int n) {
        if (this.mode) {
            this.digester.update(this.out, 0, this.size);
            this.size = 0;
            for (int i = 0; i <= this.depth; ++i) {
                this.startTagOpenPosStack[i] = -1;
            }
            if (n > this.out.length) {
                this.expandArray0(n);
            }
        } else {
            this.expandArray0(n);
        }
    }

    private void expandArray0(int n) {
        this.max = this.max * 2 > n ? this.max * 2 : n * 2;
        byte[] byArray = new byte[this.max];
        System.arraycopy(this.out, 0, byArray, 0, this.size);
        this.out = byArray;
    }

    private void expandStack() {
        int n = this.stackMax * 2;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        System.arraycopy(this.startTagOpenPosStack, 0, nArray, 0, this.stackMax);
        System.arraycopy(this.qnameLengthStack, 0, nArray2, 0, this.stackMax);
        this.stackMax = n;
    }
}

