/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.filter.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;

public class AttributeSortedSet {
    private static final TraceComponent tc = Tr.register(AttributeSortedSet.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final int INIT = 10;
    private int[] attrIndex = new int[10];
    private String[] attrNsUri = new String[10];
    private String[] attrLocal = new String[10];
    private int max = 10;
    private int size = 0;

    public void reset(int n) {
        this.size = 0;
        if (n > this.max) {
            this.expandArray(n);
        }
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.attrNsUri[i] = null;
            this.attrLocal[i] = null;
        }
    }

    private void expandArray(int n) {
        this.max = n > this.max ? n : (this.max *= 2);
        int[] nArray = new int[this.max];
        String[] stringArray = new String[this.max];
        String[] stringArray2 = new String[this.max];
        System.arraycopy(this.attrIndex, 0, nArray, 0, this.size);
        System.arraycopy(this.attrNsUri, 0, stringArray, 0, this.size);
        System.arraycopy(this.attrLocal, 0, stringArray2, 0, this.size);
        this.attrIndex = nArray;
        this.attrNsUri = stringArray;
        this.attrLocal = stringArray2;
    }

    public void add(int n, String string, String string2) {
        int n2;
        int n3;
        for (n3 = 0; n3 < this.size && (n2 = this.attrNsUri[n3].compareTo(string)) <= 0 && (n2 != 0 || this.attrLocal[n3].compareTo(string2) <= 0); ++n3) {
        }
        for (n2 = this.size; n2 > n3; --n2) {
            this.attrIndex[n2] = this.attrIndex[n2 - 1];
            this.attrNsUri[n2] = this.attrNsUri[n2 - 1];
            this.attrLocal[n2] = this.attrLocal[n2 - 1];
        }
        this.attrIndex[n3] = n;
        this.attrNsUri[n3] = string;
        this.attrLocal[n3] = string2;
        ++this.size;
        if (this.size >= this.max) {
            this.expandArray(this.max * 2);
        }
    }

    public int getSize() {
        return this.size;
    }

    public int getSortedIndex(int n) {
        if (n >= this.size) {
            return -1;
        }
        return this.attrIndex[n];
    }

    public String getNsUri(int n) {
        if (n >= this.size) {
            return null;
        }
        return this.attrNsUri[n];
    }

    public String getLocal(int n) {
        if (n >= this.size) {
            return null;
        }
        return this.attrLocal[n];
    }
}

