/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.filter;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.wssecurity.filter.FilterBase;
import com.ibm.ws.wssecurity.filter.util.AttributeSortedSet;
import com.ibm.ws.wssecurity.filter.util.C14NWriter;
import com.ibm.ws.wssecurity.filter.util.NamespaceStack;
import com.ibm.ws.wssecurity.filter.util.StringSequentialSortedSet;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.context.MessageContext;

public class BodyC14NFilter
extends FilterBase {
    private static final TraceComponent tc = Tr.register(BodyC14NFilter.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    public static final String BODY_CONTENT_C14N_RESULT = "com.ibm.ws.wssecurity.filter.BodyC14NFilter.BODY_CONTENT_C14N_RESULT";
    private static final String DEFAULT_NAMESPACE_PREFIX = "";
    private static final String EMPTY_NAMESPACE_URI = "";
    private static final String[] ZERO_ARRAY = new String[0];
    private static final byte[] ZERO_ARRAY_BYTE = new byte[0];
    private String c14nMethod = null;
    private String digestAlgorithm = null;
    private String signatureAlgorithm = null;
    private Set<String> inclusiveNamespacesPrefixList = new HashSet<String>();
    private int c14nDepth = 0;
    private String bodyPrefix = null;
    private byte[] bodyC14NBytes = null;
    protected C14NWriter writer = new C14NWriter();
    private NamespaceStack nsRendered = new NamespaceStack();
    private AttributeSortedSet attrSortedSet = new AttributeSortedSet();
    private StringSequentialSortedSet tobeRenderedSet = new StringSequentialSortedSet();
    private int inclNsMode = 0;
    public static final int INCL_NS_NO_PREFIXE = 0;
    public static final int INCL_NS_ALL_PREFIXES = 1;

    public BodyC14NFilter() {
    }

    public BodyC14NFilter(XMLStreamReader xMLStreamReader) {
        this();
        this.reader = xMLStreamReader;
    }

    public void setInclNsMode(int n) {
        this.inclNsMode = n;
    }

    public int getInclNsMode() {
        return this.inclNsMode;
    }

    public String getInclNsPrefixListAsString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.inclusiveNamespacesPrefixList) {
            if (string == null || string.length() == 0) {
                string = "#default";
            }
            stringBuffer.append(string);
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public byte[] getBodyC14NBytes() {
        return this.bodyC14NBytes;
    }

    public XMLStreamReader init(XMLStreamReader xMLStreamReader, MessageContext messageContext, OMElement oMElement, int n) {
        this.inclNsMode = n;
        return this.init(xMLStreamReader, messageContext, oMElement);
    }

    public XMLStreamReader init(XMLStreamReader xMLStreamReader, MessageContext messageContext, OMElement oMElement) {
        XMLStreamReader xMLStreamReader2 = super.init(xMLStreamReader, messageContext);
        try {
            int n;
            String string;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            String string2;
            this.writer.setMode(false);
            OMNamespace oMNamespace = oMElement.getNamespace();
            this.bodyPrefix = oMNamespace.getPrefix();
            if (this.bodyPrefix == null) {
                this.bodyPrefix = "";
            }
            if ((string2 = oMNamespace.getNamespaceURI()) == null) {
                string2 = "";
            }
            this.writer.writeStartTagOpen(this.bodyPrefix, oMElement.getLocalName());
            this.tobeRenderedSet.add(this.bodyPrefix, string2);
            int n2 = 0;
            Iterator iterator = oMElement.getAllAttributes();
            while (iterator.hasNext()) {
                object4 = (OMAttribute)iterator.next();
                object3 = object4.getLocalName();
                object2 = object4.getNamespace();
                object = "";
                string = "";
                if (object2 != null) {
                    object = object2.getPrefix();
                    if (object == null) {
                        object = "";
                    }
                    if ((string = object2.getNamespaceURI()) == null) {
                        string = "";
                    }
                }
                this.attrSortedSet.add(n2, string, (String)object3);
                this.tobeRenderedSet.add((String)object, string);
                ++n2;
            }
            if (this.inclNsMode == 1) {
                object4 = (OMElement)oMElement.getParent();
                object3 = object4.getAllDeclaredNamespaces();
                while (object3.hasNext()) {
                    object2 = (OMNamespace)object3.next();
                    object = "";
                    string = "";
                    if (object2 != null) {
                        object = object2.getPrefix();
                        if (object == null) {
                            object = "";
                        }
                        if ((string = object2.getNamespaceURI()) == null) {
                            string = "";
                        }
                    }
                    this.tobeRenderedSet.add((String)object, string);
                    this.inclusiveNamespacesPrefixList.add((String)object);
                }
                object2 = oMElement.getAllDeclaredNamespaces();
                while (object2.hasNext()) {
                    object = (OMNamespace)object2.next();
                    string = "";
                    String string3 = "";
                    if (object != null) {
                        string = object.getPrefix();
                        if (string == null) {
                            string = "";
                        }
                        if ((string3 = object.getNamespaceURI()) == null) {
                            string3 = "";
                        }
                    }
                    this.tobeRenderedSet.add(string, string3);
                    this.inclusiveNamespacesPrefixList.add(string);
                }
            }
            int n3 = this.tobeRenderedSet.getSize();
            for (n = 0; n < n3; ++n) {
                object2 = this.tobeRenderedSet.getPrefix(n);
                object = this.tobeRenderedSet.getNsUri(n);
                this.writer.writeNamespaceDeclaration((String)object2, (String)object);
                this.nsRendered.declarePrefix((String)object2, (String)object);
            }
            this.tobeRenderedSet.reset();
            for (n = 0; n < n2; ++n) {
                object2 = oMElement.getAttribute(new QName(this.attrSortedSet.getNsUri(n), this.attrSortedSet.getLocal(n)));
                object = object2.getNamespace();
                string = "";
                if (object != null && (string = object.getPrefix()) == null) {
                    string = "";
                }
                this.writer.writeAttribute(string, object2.getLocalName(), object2.getAttributeValue());
            }
            this.writer.writeStartTagClose();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return xMLStreamReader2;
    }

    public void reset() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reset", this);
        }
        super.reset();
        this.inclusiveNamespacesPrefixList.clear();
        this.c14nMethod = null;
        this.digestAlgorithm = null;
        this.signatureAlgorithm = null;
        this.c14nDepth = 0;
        this.writer.reset();
        this.nsRendered.reset();
        this.attrSortedSet.reset(0);
        this.tobeRenderedSet.reset();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reset");
        }
    }

    public void setC14nMethod(String string) {
        this.c14nMethod = string;
    }

    public void setDigestAlgorithm(String string) {
        this.digestAlgorithm = string;
    }

    public int next() throws XMLStreamException {
        int n = this.reader.next();
        try {
            this.c14n(n);
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
        return n;
    }

    private void c14n(int n) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "c14n");
        }
        switch (n) {
            case 1: {
                int n2;
                String string;
                String string2;
                String string3;
                int n3;
                String string4;
                ++this.c14nDepth;
                this.nsRendered.pushContext();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "[C14N] START_ELEMENT=" + this.reader.getLocalName());
                }
                if ((string4 = this.reader.getPrefix()) == null) {
                    string4 = "";
                }
                this.writer.writeStartTagOpen(string4, this.reader.getLocalName());
                if (this.inclusiveNamespacesPrefixList.isEmpty() || !this.inclusiveNamespacesPrefixList.contains(string4)) {
                    String string5;
                    String string6 = this.reader.getNamespaceURI();
                    if (string6 == null) {
                        string6 = "";
                    }
                    if ((string5 = this.nsRendered.getURI(string4)) == null) {
                        this.tobeRenderedSet.add(string4, string6);
                    } else if (!string5.equals(string6)) {
                        this.tobeRenderedSet.add(string4, string6);
                    }
                }
                if ((n3 = this.reader.getAttributeCount()) > 0) {
                    this.attrSortedSet.reset(n3);
                    for (int i = 0; i < n3; ++i) {
                        String string7 = this.reader.getAttributeLocalName(i);
                        string3 = this.reader.getAttributePrefix(i);
                        string2 = this.reader.getAttributeNamespace(i);
                        if (string2 == null) {
                            string2 = "";
                        }
                        this.attrSortedSet.add(i, string2, string7);
                        if (string3 == null || !this.inclusiveNamespacesPrefixList.isEmpty() && this.inclusiveNamespacesPrefixList.contains(string3)) continue;
                        string = this.nsRendered.getURI(string3);
                        if (string == null) {
                            this.tobeRenderedSet.add(string3, string2);
                            continue;
                        }
                        if (string.equals(string2)) continue;
                        this.tobeRenderedSet.add(string3, string2);
                    }
                }
                if (!this.inclusiveNamespacesPrefixList.isEmpty()) {
                    int n4 = this.reader.getNamespaceCount();
                    for (int i = 0; i < n4; ++i) {
                        string3 = this.reader.getNamespacePrefix(i);
                        if (string3 == null) {
                            string3 = "";
                        }
                        if (this.inclNsMode == 1) {
                            this.inclusiveNamespacesPrefixList.add(string3);
                        }
                        if (!this.inclusiveNamespacesPrefixList.contains(string3)) continue;
                        string2 = this.reader.getNamespaceURI(i);
                        if (string2 == null) {
                            string2 = "";
                        }
                        if ((string = this.nsRendered.getURI(string3)) == null) {
                            this.tobeRenderedSet.add(string3, string2);
                            continue;
                        }
                        if (string.equals(string2)) continue;
                        this.tobeRenderedSet.add(string3, string2);
                    }
                }
                if ((n2 = this.tobeRenderedSet.getSize()) > 0) {
                    for (int i = 0; i < n2; ++i) {
                        string3 = this.tobeRenderedSet.getPrefix(i);
                        string2 = this.tobeRenderedSet.getNsUri(i);
                        this.writer.writeNamespaceDeclaration(string3, string2);
                        this.nsRendered.declarePrefix(string3, string2);
                    }
                    this.tobeRenderedSet.reset();
                }
                for (int i = 0; i < n3; ++i) {
                    int n5 = this.attrSortedSet.getSortedIndex(i);
                    string2 = this.reader.getAttributeValue(n5);
                    this.writer.writeAttribute(this.reader.getAttributePrefix(n5), this.attrSortedSet.getLocal(i), string2);
                }
                this.writer.writeStartTagClose();
                break;
            }
            case 2: {
                String string = this.reader.getPrefix();
                if (string == null) {
                    string = "";
                }
                this.writer.writeEndTag(string, this.reader.getLocalName());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "[C14N] END_ELEMENT=" + this.reader.getLocalName());
                }
                this.nsRendered.popContext();
                --this.c14nDepth;
                if (this.c14nDepth != 0) break;
                this.writer.writeEndTag(this.bodyPrefix, "Body");
                this.bodyC14NBytes = this.writer.toByteArray();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "[C14N] bodyC14NBytes = " + new String(this.bodyC14NBytes, "UTF8"));
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "[C14N] inclusiveNamespacesPrefixList = " + this.inclusiveNamespacesPrefixList);
                }
                this.remove();
                break;
            }
            case 3: {
                this.writer.writePI(this.reader.getPITarget(), this.reader.getPIData());
                break;
            }
            case 4: {
                this.writer.writeText(this.reader.getText());
                break;
            }
            case 12: {
                this.writer.writeText(this.reader.getText());
                break;
            }
            case 5: {
                break;
            }
            case 9: {
                break;
            }
            case 6: {
                this.writer.writeText(this.reader.getText());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "c14n");
        }
    }
}

