/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.enc;

import com.ibm.ws.wssecurity.common.WSSAlgorithmFactory;
import com.ibm.ws.wssecurity.config.AlgorithmConfig;
import com.ibm.ws.wssecurity.config.EncryptionGeneratorConfig;
import com.ibm.ws.wssecurity.config.KeyInfoGeneratorConfig;
import com.ibm.ws.wssecurity.config.ReferencePartConfig;
import com.ibm.ws.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.wssecurity.core.RequestMessagePool;
import com.ibm.ws.wssecurity.core.WSSGeneratorComponent;
import com.ibm.ws.wssecurity.dsig.SignatureGenerator;
import com.ibm.ws.wssecurity.enc.PartList;
import com.ibm.ws.wssecurity.token.NonceManager;
import com.ibm.ws.wssecurity.util.ConfidentialDialectElementSelector;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.NamespaceUtil;
import com.ibm.ws.wssecurity.util.QNameHeaderSelector;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.xml.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import com.ibm.ws.wssecurity.xml.xss4j.enc.EncryptionContext;
import com.ibm.ws.wssecurity.xml.xss4j.enc.ResourceShower;
import com.ibm.ws.wssecurity.xml.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.CipherData;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.CipherValue;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.DataReference;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedData;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedHeader;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedKey;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptionMethod;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.KeyInfo;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.ReferenceList;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.Type;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.llom.OMSourcedElementImpl;
import org.apache.axiom.soap.impl.llom.soap11.SOAP11BodyImpl;
import org.apache.axiom.soap.impl.llom.soap12.SOAP12BodyImpl;
import org.apache.axis2.context.MessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncryptionGenerator
implements WSSGeneratorComponent {
    private static final TraceComponent tc = Tr.register(EncryptionGenerator.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = EncryptionGenerator.class.getName();
    private IdUtils _idResolver = null;
    private Map<Object, Object> _selectors = null;
    private boolean _initialized = false;
    private static Class PKCS11ExceptionClass = null;
    private static Method getCodeMethod = null;

    private static void _checkForPKCS11ExceptionClass() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                block4: {
                    try {
                        PKCS11ExceptionClass = Class.forName("com.ibm.pkcs11.PKCS11Exception");
                        getCodeMethod = PKCS11ExceptionClass.getMethod("getCode", new Class[0]);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (tc.isEventEnabled()) {
                            Tr.debug(tc, "com.ibm.pkcs11.PKCS11Exception not found, so not running IBM SDK");
                        }
                    }
                    catch (Throwable throwable) {
                        if (!tc.isEventEnabled()) break block4;
                        Tr.debug(tc, "Unexpected exception looking for com.ibm.pkcs11.PKCS11Exception" + throwable);
                    }
                }
                return null;
            }
        });
        if (tc.isEventEnabled()) {
            Tr.debug(tc, "PKCS11ExceptionClass: " + PKCS11ExceptionClass + " getCodeMethod: " + getCodeMethod);
        }
    }

    @Override
    public void init(Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._selectors = map;
            this._idResolver = (IdUtils)map.get("com.ibm.ws.wssecurity.util.selector.IDResolver");
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    @Override
    public void invoke(OMDocument oMDocument, OMElement oMElement, Map<Object, Object> map) throws SoapSecurityException {
        Type type;
        Object object;
        Provider provider;
        Object object2;
        Class<QNameHeaderSelector> clazz;
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(OMDocument doc[" + DOMUtils.getDisplayName(oMDocument) + "]," + "OMElement parent[" + DOMUtils.getDisplayName(oMElement) + "]," + "Map context)");
        }
        OMFactory oMFactory = oMDocument.getOMDocumentElement().getOMFactory();
        Object object3 = map.get("com.ibm.ws.wssecurity.constants.soapVersion");
        int n = 0;
        if (object3 != null && object3 instanceof Integer) {
            n = (Integer)object3;
        }
        String string2 = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[2][n];
        object3 = map.get("com.ibm.ws.wssecurity.constants.wssVersion");
        int n2 = 0;
        if (object3 != null && object3 instanceof Integer) {
            n2 = (Integer)object3;
        }
        String string3 = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[0][n2];
        String string4 = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[1][n2];
        if (oMElement == null) {
            throw SoapSecurityException.format("security.wssecurity.EncryptionGenerator.s15");
        }
        String string5 = oMElement.getLocalName();
        String string6 = string = oMElement.getNamespace() == null ? null : oMElement.getNamespace().getName();
        if (NamespaceUtil.isWsse(string) != n2 || !"Security".equals(string5)) {
            throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s03", DOMUtils.getQualifiedName(oMElement), "Security");
        }
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        if (n == 1) {
            string8 = oMElement.getAttributeValue(com.ibm.ws.wssecurity.common.Constants.SOAP12_ROLE_Q);
            string9 = oMElement.getAttributeValue(com.ibm.ws.wssecurity.common.Constants.SOAP12_MU_Q);
            string10 = oMElement.getAttributeValue(com.ibm.ws.wssecurity.common.Constants.SOAP12_RELAY_Q);
        } else if (n == 0) {
            string7 = oMElement.getAttributeValue(com.ibm.ws.wssecurity.common.Constants.SOAP11_ACTOR_Q);
            string9 = oMElement.getAttributeValue(com.ibm.ws.wssecurity.common.Constants.SOAP11_MU_Q);
        }
        map.put("com.ibm.ws.wssecurity.constants.mustUnderstandAttr", string9);
        map.put("com.ibm.ws.wssecurity.constants.actorAttr", string7);
        map.put("com.ibm.ws.wssecurity.constants.roleAttr", string8);
        map.put("com.ibm.ws.wssecurity.constants.relayAttr", string10);
        WSSGeneratorConfig wSSGeneratorConfig = (WSSGeneratorConfig)map.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
        EncryptionGeneratorConfig encryptionGeneratorConfig = (EncryptionGeneratorConfig)map.remove("com.ibm.ws.wssecurity.impl.config.encryptionGenerator.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "EncryptionGeneratorConfig [" + encryptionGeneratorConfig + "].");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Examining encrypting parts.");
        }
        boolean bl = false;
        boolean bl2 = false;
        HashSet<ReferencePartConfig.PartConfig> hashSet = new HashSet<ReferencePartConfig.PartConfig>();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(map);
        hashMap.put(NonceManager.class, wSSGeneratorConfig.getNonceManager());
        hashMap.put("com.ibm.ws.wssecurity.util.selector.IDResolver", this._idResolver);
        PartList partList = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<ArrayList<OMNode>> arrayList2 = new ArrayList<ArrayList<OMNode>>();
        ArrayList<ArrayList<OMNode>> arrayList3 = new ArrayList<ArrayList<OMNode>>();
        ArrayList<OMNode> arrayList4 = new ArrayList<OMNode>();
        ReferencePartConfig referencePartConfig = encryptionGeneratorConfig.getReference();
        Map<Object, Object> map2 = encryptionGeneratorConfig.getProperties();
        boolean bl3 = false;
        String string11 = (String)map2.get(Constants.ENCRYPTED_HEADER_GENERATE_WSS10);
        if (string11 != null && string11.length() != 0 && string11.equalsIgnoreCase("true")) {
            bl3 = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Property com.ibm.wsspi.wssecurity.encryptedHeader.generate.WSS1.0 specified as true.");
            }
        }
        boolean bl4 = false;
        string11 = (String)map2.get(Constants.ENCRYPTED_HEADER_GENERATE_WSS11_PRE_FP13);
        if (string11 != null && string11.length() != 0 && string11.equalsIgnoreCase("true")) {
            bl4 = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Property com.ibm.wsspi.wssecurity.encryptedHeader.generate.WSS1.1.pre.fp13 specified as true.");
            }
        }
        boolean bl5 = false;
        if (referencePartConfig != null && referencePartConfig.getParts() != null && referencePartConfig.getParts().iterator() != null) {
            for (ReferencePartConfig.PartConfig partConfig : referencePartConfig.getParts()) {
                if (partConfig.isTimestamp() || partConfig.isNonce()) {
                    bl2 = true;
                    hashSet.add(partConfig);
                    continue;
                }
                String string12 = partConfig.getDialect();
                String string13 = partConfig.getKeyword();
                clazz = ConfidentialDialectElementSelector.class;
                boolean bl6 = false;
                if (string12.equals(com.ibm.ws.wssecurity.common.Constants.DIALECT_HEADER)) {
                    bl5 = true;
                    bl6 = true;
                    hashMap.put("com.ibm.ws.wssecurity.util.selector.headername", partConfig.getHeaderName());
                    hashMap.put("com.ibm.ws.wssecurity.util.selector.headernamespace", partConfig.getHeaderNamespace());
                    if (string7 != null) {
                        hashMap.put("com.ibm.ws.wssecurity.util.selector.actorOrRole", string7);
                    } else {
                        hashMap.put("com.ibm.ws.wssecurity.util.selector.actorOrRole", string8);
                    }
                    clazz = QNameHeaderSelector.class;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Looking for header to encrypt with header name [" + partConfig.getHeaderName() + " and header namspace [" + partConfig.getHeaderNamespace() + "]");
                    }
                }
                if ((partList = (PartList)SignatureGenerator.getMessagePart(oMDocument, string12, string13, "encryption_mode", this._selectors, clazz, hashMap)) == null || partList.size() <= 0) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, partList.size() + " parts found.");
                }
                if (bl6 && !bl3) {
                    arrayList3.add(partList);
                } else {
                    arrayList2.add(partList);
                }
                for (int i = 0; i < partList.size(); ++i) {
                    arrayList4.add(partList.get(i));
                    boolean bl7 = false;
                    while (!bl7) {
                        object2 = IdUtils.getInstance().makeUniqueId("wssecurity_encryption_id_");
                        if (arrayList.contains(object2)) continue;
                        arrayList.add((String)object2);
                        bl7 = true;
                    }
                    bl = true;
                }
            }
        }
        if (!bl) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "invoke(Document doc, Element parent, Map context)");
            }
            return;
        }
        if (bl5 && !bl4 && !bl3) {
            map.put("com.ibm.ws.wssecurity.constants.soapNsForAttr", string2);
            map.put("com.ibm.ws.wssecurity.constants.wsuNsForAttr", string4);
            clazz = DOMUtils.getNamespacePrefix(oMElement, string2);
            if (clazz == null || ((String)((Object)clazz)).length() <= 0) {
                clazz = "env";
                map.put("com.ibm.ws.wssecurity.constants.soapNsPrefixForAttrDecl", "true");
            }
            map.put("com.ibm.ws.wssecurity.constants.soapNsPrefixForAttr", clazz);
            clazz = DOMUtils.getNamespacePrefix(oMElement, string4);
            if (clazz == null || ((String)((Object)clazz)).length() <= 0) {
                clazz = "wsu";
                map.put("com.ibm.ws.wssecurity.constants.wsuNsPrefixForAttrDecl", "true");
            }
            map.put("com.ibm.ws.wssecurity.constants.wsuNsPrefixForAttr", clazz);
            clazz = DOMUtils.getNamespacePrefix(oMElement, com.ibm.ws.wssecurity.common.Constants.NS_WSSE11);
            if (clazz == null || ((String)((Object)clazz)).length() <= 0) {
                clazz = "wsse11";
                map.put("com.ibm.ws.wssecurity.constants.wsse11NsPrefixForAttrDecl", "true");
            }
            map.put("com.ibm.ws.wssecurity.constants.wsse11NsPrefixForAttr", clazz);
        }
        clazz = new HashMap();
        EncryptionContext encryptionContext = new EncryptionContext();
        String string14 = null;
        AlgorithmConfig algorithmConfig = encryptionGeneratorConfig.getKeyEncryptionMethod();
        if (algorithmConfig != null) {
            string14 = algorithmConfig.getAlgorithm();
        }
        encryptionContext.setEncAlgorithm(string14);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Encryption Algorithm : " + string14);
        }
        object2 = wSSGeneratorConfig.getAlgorithmFactory();
        encryptionContext.setAlgorithmFactory((AlgorithmFactory)object2);
        Map<Object, Object> map3 = wSSGeneratorConfig.getProperties();
        encryptionContext.setHWConfigName((String)map3.get("HWCONFIG"));
        String string15 = (String)map3.get("com.ibm.ws.wssecurity.handler.OffloadAllCryptography");
        encryptionContext.setOffload((Boolean)map3.get("com.ibm.ws.wssecurity.handler.OffloadRSAPublicKeyCryptography"));
        if (encryptionContext.shouldChangeProvider()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "HARDWARE Acceleration enabled, Key Store Name is: " + encryptionContext.getHWConfigName());
            }
            if ((provider = ConfigUtil.getHWCryptoProviderInstance(encryptionContext.getHWConfigName())) == null) {
                Tr.audit(tc, "Failure to get Hardware crypto provider instance to use hardware acceleration, continue processing.");
            } else {
                object = (Integer)map3.get("com.ibm.ws.wssecurity.handler.hardwareCacheSize");
                encryptionContext.setHWAccelerationProvider(provider, (Integer)object);
                encryptionContext.setCryptoOffloadProperty(string15);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "HW crypto provider instance for HW Acceleration" + provider.getName());
                }
            }
        }
        encryptionContext.setHWKeyStoreName((String)map2.get("com.ibm.ws.wssecurity.config.keystore.keyStoreRef"));
        if (encryptionContext.useHWKeyStore()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "HARDWARE Key Store Name is: " + encryptionContext.getHWKeyStoreName());
            }
            if ((provider = ConfigUtil.getHWCryptoProviderInstance(encryptionContext.getHWKeyStoreName())) == null) {
                Tr.audit(tc, "Failure to get Hardware crypto provider instance to use hardware keystore, continue processing.");
            } else {
                encryptionContext.setHWKeyStoreProvider(provider);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "HW crypto provider instance for the HW KeyStore" + provider.getName());
                }
            }
        }
        boolean bl8 = false;
        object = (String)map2.get(Constants.WSSECURITY_MTOM_OPTIMIZE_ENCRYPTED_DATA);
        if (object != null && ((String)object).length() != 0 && ((String)object).equalsIgnoreCase("true")) {
            bl8 = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "MTOM optimize property was specified for EncryptionInfo");
            }
        }
        encryptionContext.setMTOMOptimize(bl8);
        if (tc.isDebugEnabled()) {
            encryptionContext.setResourceShower(ShowerImpl.getInstance());
        }
        String string16 = null;
        if (encryptionGeneratorConfig.getKeyEncryptionMethod() != null) {
            string16 = encryptionGeneratorConfig.getKeyEncryptionMethod().getAlgorithm();
        }
        String string17 = null;
        string17 = encryptionGeneratorConfig.getDataEncryptionMethod().getAlgorithm();
        map.put("com.ibm.ws.wssecurity.keyinfo.keyAlgorithm", string17);
        boolean bl9 = string16 != null && string16.length() > 0;
        EncryptedData encryptedData = EncryptionGenerator.createEncryptedData(encryptionGeneratorConfig, oMFactory, !bl9 && wSSGeneratorConfig.isUserDefinedComponentsUsed(), (WSSAlgorithmFactory)object2);
        OMElement oMElement2 = null;
        Key key = null;
        if (bl9) {
            type = EncryptionGenerator.createEncryptedKey(encryptionGeneratorConfig, arrayList, (WSSAlgorithmFactory)object2, oMFactory, string2, string3, string4, wSSGeneratorConfig.isUserDefinedComponentsUsed());
            try {
                oMElement2 = ((EncryptedKey)type).createElement(oMFactory, true);
                oMElement2 = SignatureGenerator.insertElement(oMElement, oMElement2, string4, map);
            }
            catch (StructureException structureException) {
                Tr.processException(structureException, clsName + ".invoke", "322");
                throw SoapSecurityException.format("security.wssecurity.EncryptionGenerator.s01", new String[]{"EncryptedKey", structureException.getMessage()}, (Throwable)structureException);
            }
            Key key2 = SignatureGenerator.callKeyInfoGenerator(encryptionGeneratorConfig.getEncryptionKeyInfo(), "EncryptingKey", clazz, this._selectors, oMDocument, oMElement2, map);
            if (map.get("com.ibm.ws.wssecurity.handler.GlobalSecurityHandler.targetEndpointAddress") != null) {
                String string18 = map.get("com.ibm.ws.wssecurity.handler.GlobalSecurityHandler.targetEndpointAddress").toString();
                if (encryptionGeneratorConfig != null) {
                    string18 = string18 + encryptionGeneratorConfig.hashCode();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The target End point address = " + map.get("com.ibm.ws.wssecurity.handler.GlobalSecurityHandler.targetEndpointAddress").toString());
                }
                encryptionContext.setEndpointReference(string18);
            }
            key = EncryptionGenerator.generateKey(encryptionContext, encryptedData, oMFactory, key2);
            EncryptionGenerator.encryptKey(encryptionContext, oMElement2, oMDocument, key, key2);
            DOMUtils.getOneChildElement(oMElement2, com.ibm.ws.wssecurity.common.Constants.NS_ENC, "ReferenceList");
        } else {
            type = EncryptionGenerator.createReferenceList(arrayList, string2, string3, string4);
            try {
                oMElement2 = ((ReferenceList)type).createElement(oMFactory, true);
                oMElement2 = SignatureGenerator.insertElement(oMElement, oMElement2, string4, map);
            }
            catch (StructureException structureException) {
                Tr.processException(structureException, clsName + ".invoke", "355");
                throw SoapSecurityException.format("security.wssecurity.EncryptionGenerator.s01", new String[]{"ReferenceList", structureException.getMessage()}, (Throwable)structureException);
            }
            key = null;
        }
        if (bl2) {
            type = arrayList4.toArray();
            for (ReferencePartConfig.PartConfig partConfig : hashSet) {
                partList = (PartList)SignatureGenerator.getNoncePart(oMDocument, (Object[])type, partConfig, "encryption_mode", this._selectors, ConfidentialDialectElementSelector.class, hashMap);
            }
        }
        EncryptionGenerator.encrypt(encryptionGeneratorConfig.getEncryptionKeyInfo(), clazz, this._selectors, oMDocument, map, encryptionGeneratorConfig.remainSignatureAfterEncryption(), arrayList2, arrayList, arrayList3, encryptionContext, oMElement2, encryptedData, key, wSSGeneratorConfig.isUserDefinedComponentsUsed());
        map.remove("com.ibm.ws.wssecurity.constants.mustUnderstandAttr");
        map.remove("com.ibm.ws.wssecurity.constants.actorAttr");
        map.remove("com.ibm.ws.wssecurity.constants.roleAttr");
        map.remove("com.ibm.ws.wssecurity.constants.relayAttr");
        if (bl5 && !bl4 && !bl3) {
            map.remove("com.ibm.ws.wssecurity.constants.soapNsForAttr");
            map.remove("com.ibm.ws.wssecurity.constants.soapNsPrefixForAttr");
            map.remove("com.ibm.ws.wssecurity.constants.soapNsPrefixForAttrDecl");
            map.remove("com.ibm.ws.wssecurity.constants.wsuNsForAttr");
            map.remove("com.ibm.ws.wssecurity.constants.wsuNsPrefixForAttr");
            map.remove("com.ibm.ws.wssecurity.constants.wsuNsPrefixForAttrDecl");
            map.remove("com.ibm.ws.wssecurity.constants.wsse11NsPrefixForAttr");
            map.remove("com.ibm.ws.wssecurity.constants.wsse11NsPrefixForAttrDecl");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(OMDocument doc, OMElement parent, Map context)");
        }
    }

    private static EncryptedKey createEncryptedKey(EncryptionGeneratorConfig encryptionGeneratorConfig, List<String> list, WSSAlgorithmFactory wSSAlgorithmFactory, OMFactory oMFactory, String string, String string2, String string3, boolean bl) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createEncryptedKey(EncryptionGeneratorConfig config,List ids[" + list + "]," + "WSSAlgorithmFactory factory[" + wSSAlgorithmFactory + "]," + "OMFactory doc[" + oMFactory + "]," + "String nsSoap[" + string + "]," + "String nsWsse[" + string2 + "]," + "String nsWsu[" + string3 + "]," + "boolean userDefinedComponentsUsed[" + bl + "])");
        }
        EncryptedKey encryptedKey = new EncryptedKey();
        encryptedKey.setEncryptionMethod(EncryptionGenerator.createEncryptionMethod(encryptionGeneratorConfig.getKeyEncryptionMethod(), wSSAlgorithmFactory));
        if (bl) {
            encryptedKey.setKeyInfo(EncryptionGenerator.createKeyInfo(oMFactory));
        }
        encryptedKey.setCipherData(EncryptionGenerator.createCipherData());
        encryptedKey.setReferenceList(EncryptionGenerator.createReferenceList(list, string, string2, string3));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createEncryptedKey(EncryptionGeneratorConfig config,List ids,WSSAlgorithmFactory factory,OMFactory doc,String nsSoap,String nsWsse,String nsWsu,boolean userDefinedComponentsUsed) returns EncryptedKey[" + encryptedKey + "]");
        }
        return encryptedKey;
    }

    private static EncryptionMethod createEncryptionMethod(AlgorithmConfig algorithmConfig, WSSAlgorithmFactory wSSAlgorithmFactory) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setEncryptionMethod(AlgorithmConfig aconfig[" + algorithmConfig + "]," + "WSSAlgorithmFactory factory[" + wSSAlgorithmFactory + "])");
        }
        EncryptionMethod encryptionMethod = new EncryptionMethod();
        encryptionMethod.setAlgorithm(algorithmConfig.getAlgorithm());
        try {
            AlgorithmParameterSpec algorithmParameterSpec = wSSAlgorithmFactory.convertParameter(algorithmConfig.getAlgorithm(), algorithmConfig.getProperties());
            if (algorithmParameterSpec != null) {
                encryptionMethod.setParameterSpec(wSSAlgorithmFactory, algorithmParameterSpec);
            }
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            Tr.processException(invalidAlgorithmParameterException, clsName + ".createEncryptionMethod", "493");
            Tr.error(tc, "security.wssecurity.EncryptionGenerator.s14", new Object[]{invalidAlgorithmParameterException});
            throw SoapSecurityException.format("security.wssecurity.EncryptionGenerator.s14", new String[]{invalidAlgorithmParameterException.getMessage()}, (Throwable)invalidAlgorithmParameterException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Tr.processException(noSuchAlgorithmException, clsName + ".createEncryptionMethod", "497");
            Tr.error(tc, "security.wssecurity.EncryptionGenerator.s14", new Object[]{noSuchAlgorithmException});
            throw SoapSecurityException.format("security.wssecurity.EncryptionGenerator.s14", new String[]{noSuchAlgorithmException.getMessage()}, (Throwable)noSuchAlgorithmException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setEncryptionMethod(AlgorithmConfig aconfig,WSSAlgorithmFactory factory) returns EncryptionMethod[" + encryptionMethod + "]");
        }
        return encryptionMethod;
    }

    private static KeyInfo createKeyInfo(OMFactory oMFactory) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createKeyInfo(OMFactory factory[" + oMFactory + "])");
        }
        KeyInfo keyInfo = new KeyInfo();
        keyInfo.addElement(oMFactory.createOMElement("dummy", "", ""));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createKeyInfo(Document doc) returns KeyInfo[" + keyInfo + "]");
        }
        return keyInfo;
    }

    private static CipherData createCipherData() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCipherData()");
        }
        CipherValue cipherValue = new CipherValue();
        CipherData cipherData = new CipherData();
        cipherData.setCipherValue(cipherValue);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCipherData() returns CipherData[" + cipherData + "]");
        }
        return cipherData;
    }

    private static ReferenceList createReferenceList(List<String> list, String string, String string2, String string3) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createReferenceList(List ids[" + list + "]," + "String nsSoap[" + string + "]," + "String nsWsse[" + string2 + "]," + "String nsWsu[" + string3 + "])");
        }
        ReferenceList referenceList = new ReferenceList();
        for (String string4 : list) {
            DataReference dataReference = new DataReference();
            dataReference.setURI("#" + string4);
            referenceList.addDataReference(dataReference);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createReferenceList(List ids,Document doc,String nsSoap,String nsWsse,String nsWsu) returns ReferenceList[" + referenceList + "]");
        }
        return referenceList;
    }

    private static EncryptedData createEncryptedData(EncryptionGeneratorConfig encryptionGeneratorConfig, OMFactory oMFactory, boolean bl, WSSAlgorithmFactory wSSAlgorithmFactory) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createEncryptedData(EncryptionGeneratorConfig config,OMFactory doc[" + oMFactory + "]," + "boolean createKeyInfo[" + bl + "]," + "WSSAlgorithmFactory factory[" + wSSAlgorithmFactory + "])");
        }
        EncryptedData encryptedData = new EncryptedData();
        encryptedData.setEncryptionMethod(EncryptionGenerator.createEncryptionMethod(encryptionGeneratorConfig.getDataEncryptionMethod(), wSSAlgorithmFactory));
        if (bl) {
            encryptedData.setKeyInfo(EncryptionGenerator.createKeyInfo(oMFactory));
        }
        encryptedData.setCipherData(EncryptionGenerator.createCipherData());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createEncryptedData(EncryptionGeneratorConfig config,Document doc,boolean createKeyInfo,WSSAlgorithmFactory factory) returns EncryptedData[" + encryptedData + "]");
        }
        return encryptedData;
    }

    private static Key generateKey(EncryptionContext encryptionContext, EncryptedData encryptedData, OMFactory oMFactory, Key key) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateKey(EncryptionContext econtext[" + encryptionContext + "]," + "EncryptedData ed[" + encryptedData + "]," + "OMFactory factory[" + oMFactory + "]," + "Key kek[" + key + "])");
        }
        Key key2 = null;
        try {
            encryptionContext.setEncryptedType(encryptedData.createElement(oMFactory, true), null, null, null);
            key2 = encryptionContext.generateKey();
        }
        catch (Exception exception) {
            Tr.processException(exception, clsName + ".generateKey", "638");
            Tr.error(tc, "security.wssecurity.EncryptionGenerator.s11", new Object[]{exception});
            throw SoapSecurityException.format("security.wssecurity.EncryptionGenerator.s11", new String[]{exception.getMessage()}, (Throwable)exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateKey(EncryptionContext econtext,EncryptedData ed,OMFactory factory,Key kek) returns Key[" + key2 + "]");
        }
        return key2;
    }

    private static void encrypt(KeyInfoGeneratorConfig keyInfoGeneratorConfig, Map<Object, Object> map, Map<Object, Object> map2, OMDocument oMDocument, Map<Object, Object> map3, boolean bl, List<ArrayList<OMNode>> list, List<String> list2, List<ArrayList<OMNode>> list3, EncryptionContext encryptionContext, OMElement oMElement, EncryptedData encryptedData, Key key, boolean bl2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encrypt(KeyInfoGeneratorConfig config,Map type,Map properties,OMDocument doc[" + DOMUtils.getDisplayName(oMDocument) + "]," + "Map context," + "boolean sigAfterEnc," + "List pList[" + list + "]," + "List idList[" + list2 + "]," + "List hList[" + list3 + "]," + "EncryptionContext econtext[" + encryptionContext + "]," + "OMElement einfo[" + DOMUtils.getDisplayName(oMElement) + "]," + "EncryptedData ed[" + encryptedData + "]," + "Key dek[" + key + "], " + "boolean userDefinedComponentsUsed[" + bl2 + "])");
        }
        OMFactory oMFactory = oMDocument.getOMDocumentElement().getOMFactory();
        if (key == null && bl2) {
            encryptedData.setKeyInfo(EncryptionGenerator.createKeyInfo(oMFactory));
        }
        MessageContext messageContext = (MessageContext)map3.get("com.ibm.wsspi.wssecurity.core.messageContext");
        RequestMessagePool.addDocument(map3, oMDocument, list, list3, bl);
        try {
            String string;
            String string2;
            Object object;
            Object object2;
            Object object3;
            String string3;
            Object object4;
            String string4;
            int n = list2.size() - 1;
            for (PartList object52 : list) {
                for (int string5 = 0; string5 < object52.getLength(); ++string5) {
                    string4 = object52.getType();
                    object4 = (OMElement)object52.item(string5);
                    string3 = list2.get(n--);
                    encryptedData.setId(string3);
                    encryptedData.setType(string4);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "plist: el is of type " + object4.getClass().getName());
                    }
                    object3 = null;
                    if ((object4 instanceof SOAP11BodyImpl || object4 instanceof SOAP12BodyImpl) && (object2 = object4.getFirstOMChild()) != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "child: el is of type " + object2.getClass().getName());
                        }
                        if (object2 instanceof OMSourcedElementImpl) {
                            if (messageContext != null) {
                                object3 = (byte[])messageContext.getProperty("com.ibm.ws.wssecurity.filter.BodyC14NFilter.BODY_CONTENT_C14N_RESULT");
                                messageContext.setProperty("com.ibm.ws.wssecurity.filter.BodyC14NFilter.BODY_CONTENT_C14N_RESULT", null);
                            }
                            if (object3 == null || ((String)object3).length == 0) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Could not retrieve C14N body content byte[] from MessageContext; using OMSourcedElement");
                                }
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Retrieved C14N body content byte[] from MessageContext");
                            }
                        }
                    }
                    if (object3 != null && ((String)object3).length > 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Setting byte[] to EncryptionContext");
                        }
                        encryptionContext.setData((byte[])object3);
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Setting OMElement to EncryptionContext");
                        }
                        encryptionContext.setData((OMElement)object4);
                    }
                    object2 = encryptedData.createElement(oMFactory, true);
                    if (key == null) {
                        object = SignatureGenerator.callKeyInfoGenerator(keyInfoGeneratorConfig, "EncryptingKey", map, map2, oMDocument, (OMElement)object2, map3);
                        encryptionContext.setKey((Key)object);
                    } else {
                        encryptionContext.setKey(key);
                    }
                    encryptionContext.setEncryptedType((OMElement)object2, null, null, null);
                    encryptionContext.encrypt();
                    if (object3 != null && ((Object)object3).length > 0) {
                        encryptionContext.replace((OMElement)object4);
                    } else {
                        encryptionContext.replace();
                    }
                    RequestMessagePool.addElement(map3, (OMElement)object4, encryptionContext.getEncryptedTypeAsElement(), oMElement);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Encrypted part with id[" + string3 + "] for part with name[" + object4.getLocalName() + "] and namespace[" + object4.getNamespace().getNamespaceURI() + "]");
                }
            }
            String string5 = (String)map3.get("com.ibm.ws.wssecurity.constants.mustUnderstandAttr");
            String string6 = (String)map3.get("com.ibm.ws.wssecurity.constants.actorAttr");
            string4 = (String)map3.get("com.ibm.ws.wssecurity.constants.roleAttr");
            object4 = (String)map3.get("com.ibm.ws.wssecurity.constants.relayAttr");
            string3 = (String)map3.get("com.ibm.ws.wssecurity.constants.soapNsForAttr");
            object3 = (String)map3.get("com.ibm.ws.wssecurity.constants.wsuNsForAttr");
            object2 = (String)map3.get("com.ibm.ws.wssecurity.constants.soapNsPrefixForAttr");
            object = (String)map3.get("com.ibm.ws.wssecurity.constants.wsuNsPrefixForAttr");
            String string7 = (String)map3.get("com.ibm.ws.wssecurity.constants.wsse11NsPrefixForAttr");
            EncryptedHeader encryptedHeader = new EncryptedHeader();
            encryptedHeader.setMustUnderstand(string5);
            encryptedHeader.setActor(string6);
            encryptedHeader.setRole(string4);
            encryptedHeader.setRelay((String)object4);
            encryptedHeader.setSoapNs(string3);
            encryptedHeader.setWsuNs((String)object3);
            encryptedHeader.setSoapNsPrefix((String)object2);
            encryptedHeader.setWsuNsPrefix((String)object);
            encryptedHeader.setWsse11NsPrefix(string7);
            encryptedHeader.initFromEncryptedData(encryptedData);
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            String string8 = (String)map3.get("com.ibm.ws.wssecurity.constants.soapNsPrefixForAttrDecl");
            if (string8 != null && string8.length() != 0 && string8.equalsIgnoreCase("true")) {
                bl3 = true;
            }
            if ((string2 = (String)map3.get("com.ibm.ws.wssecurity.constants.wsuNsPrefixForAttrDecl")) != null && string2.length() != 0 && string2.equalsIgnoreCase("true")) {
                bl4 = true;
            }
            if ((string = (String)map3.get("com.ibm.ws.wssecurity.constants.wsse11NsPrefixForAttrDecl")) != null && string.length() != 0 && string.equalsIgnoreCase("true")) {
                bl5 = true;
            }
            for (PartList partList : list3) {
                for (int i = 0; i < partList.getLength(); ++i) {
                    String string9 = partList.getType();
                    OMElement oMElement2 = (OMElement)partList.item(i);
                    String string10 = list2.get(n--);
                    encryptedHeader.setId(string10);
                    encryptedHeader.setType(string9);
                    encryptionContext.setData(oMElement2);
                    OMElement oMElement3 = encryptedHeader.createElement(oMFactory, true, bl3, bl4, bl5);
                    if (key == null) {
                        OMElement oMElement4 = oMElement3.getFirstElement();
                        Key key2 = SignatureGenerator.callKeyInfoGenerator(keyInfoGeneratorConfig, "EncryptingKey", map, map2, oMDocument, oMElement4, map3);
                        encryptionContext.setKey(key2);
                    } else {
                        encryptionContext.setKey(key);
                    }
                    encryptionContext.setEncryptedType(oMElement3, null, null, null);
                    encryptionContext.encrypt();
                    encryptionContext.replace();
                    RequestMessagePool.addElement(map3, oMElement2, encryptionContext.getEncryptedTypeAsElement(), oMElement);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "EncryptedHeader with id[" + string10 + "] for header with name[" + oMElement2.getLocalName() + "] and namespace[" + oMElement2.getNamespace().getNamespaceURI() + "]");
                }
            }
        }
        catch (Exception exception) {
            Tr.processException(exception, clsName + ".encrypt", "730");
            Tr.error(tc, "security.wssecurity.EncryptionGenerator.s12", new Object[]{exception});
            throw SoapSecurityException.format("security.wssecurity.EncryptionGenerator.s12", new String[]{exception.getMessage()}, (Throwable)exception);
        }
        finally {
            encryptionContext.clearLocalProviderMap();
            if (encryptionContext.isHWAccelerationProvider()) {
                ConfigUtil.returnHWCryptoProviderInstance(encryptionContext.getHWConfigName(), encryptionContext.getHWAccelerationProvider());
            }
            if (encryptionContext.isHWKeyStoreProvider()) {
                ConfigUtil.returnHWCryptoProviderInstance(encryptionContext.getHWKeyStoreName(), encryptionContext.getHWKeyStoreProvider());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encrypt(KeyInfoGeneratorConfig config,Map type,Map properties,OMDocument doc,Map context,boolean sigAfterEnc,List pList,List idList,List hList,EncryptionContext econtext,OMElement einfo,EncryptedData ed,Document doc,Key dek, boolean userDefinedComponentsUsed)");
        }
    }

    private static void encryptKey(EncryptionContext encryptionContext, OMElement oMElement, OMDocument oMDocument, Key key, Key key2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encryptKey(EncryptionContext econtext[" + encryptionContext + "]," + "OMElement ed[" + oMElement + "]," + "OMDocument doc[" + DOMUtils.getDisplayName(oMDocument) + "]," + "Key dek[" + key + "]," + "Key kek[" + key2 + "])");
        }
        try {
            encryptionContext.setData(key);
            encryptionContext.setEncryptedType(oMElement, null, null, null);
            if (encryptionContext.isHWAccelerationProvider()) {
                encryptionContext.setHWKeyFromCache((PublicKey)key2);
            } else {
                encryptionContext.setKey(key2);
            }
            encryptionContext.encrypt();
        }
        catch (Exception exception) {
            if (PKCS11ExceptionClass != null && getCodeMethod != null) {
                if (PKCS11ExceptionClass.isInstance(exception)) {
                    Tr.debug(tc, "e is instance of PKCS11Excpetion");
                    Object object = null;
                    try {
                        object = getCodeMethod.invoke((Object)PKCS11ExceptionClass, new Object[0]);
                        Tr.debug(tc, "retObj: " + object);
                    }
                    catch (Exception exception2) {
                        Tr.processException(exception, clsName + ".encryptKey", "1097");
                        Tr.error(tc, "security.wssecurity.EncryptionGenerator.s13", new Object[]{exception});
                        throw SoapSecurityException.format("security.wssecurity.EncryptionGenerator.s13", new String[]{exception.getMessage()}, (Throwable)exception);
                    }
                    if (object != null) {
                        String string = object.toString();
                        Tr.error(tc, "Encrypting the key fails with PKCS11Exception and error code = " + string);
                        Tr.processException(exception, clsName + ".encryptKeyPKCS11", "1093");
                        throw new SoapSecurityException("Encrypting the key for data encryption fails with exception " + exception.getMessage() + " and error code = " + string, exception);
                    }
                }
                Tr.processException(exception, clsName + ".encryptKey", "1097");
                Tr.error(tc, "security.wssecurity.EncryptionGenerator.s13", new Object[]{exception});
                throw SoapSecurityException.format("security.wssecurity.EncryptionGenerator.s13", new String[]{exception.getMessage()}, (Throwable)exception);
            }
            Tr.processException(exception, clsName + ".encryptKey", "1097");
            Tr.error(tc, "security.wssecurity.EncryptionGenerator.s13", new Object[]{exception});
            throw SoapSecurityException.format("security.wssecurity.EncryptionGenerator.s13", new String[]{exception.getMessage()}, (Throwable)exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encryptKey(EncryptionContext econtext,OMElement ed,OMDocument doc,Key dek,Key kek)");
        }
    }

    static {
        EncryptionGenerator._checkForPKCS11ExceptionClass();
    }

    private static class ShowerImpl
    implements ResourceShower {
        private static ShowerImpl _instance = new ShowerImpl();

        private ShowerImpl() {
        }

        private static ShowerImpl getInstance() {
            return _instance;
        }

        public void showEncryptedResource(byte[] byArray, Object object, OMElement oMElement) {
            String string = null;
            try {
                string = EncryptedData.isOfType(oMElement) || EncryptedHeader.isOfType(oMElement) ? new String(byArray, "UTF-8") : Base64.encode(byArray);
            }
            catch (Exception exception) {
                Tr.debug(tc, "WARNING: An exception occured while the content is encoded with [UTF-8].");
            }
            if (EncryptedData.isOfType(oMElement) || EncryptedHeader.isOfType(oMElement)) {
                Tr.debug(tc, "ResourceShower logs encrypt-" + oMElement.getAttributeValue(new QName("", "Id")) + ": " + string);
            } else {
                Tr.debug(tc, "ResourceShower logs encrypt-EncryptedKey: " + string);
            }
        }
    }
}

