/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.enc;

import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.common.Result;
import com.ibm.ws.wssecurity.common.ResultPool;
import com.ibm.ws.wssecurity.common.WSSAlgorithmFactory;
import com.ibm.ws.wssecurity.config.AlgorithmConfig;
import com.ibm.ws.wssecurity.config.EncryptionConsumerConfig;
import com.ibm.ws.wssecurity.config.KeyInfoContentConsumerConfig;
import com.ibm.ws.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.wssecurity.core.ResultMessagePool;
import com.ibm.ws.wssecurity.core.WSSConsumerComponent;
import com.ibm.ws.wssecurity.dsig.SignatureConsumer;
import com.ibm.ws.wssecurity.enc.DecryptionResult;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoResult;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.NonceUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.KeyInfo;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import com.ibm.ws.wssecurity.xml.xss4j.enc.DecryptionContext;
import com.ibm.ws.wssecurity.xml.xss4j.enc.ResourceShower;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.DataReference;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedData;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedHeader;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedKey;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.KeyReference;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.ReferenceList;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.ReferenceType;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.security.AccessController;
import java.security.Key;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncryptionConsumer
implements WSSConsumerComponent {
    private static final TraceComponent tc = Tr.register(EncryptionConsumer.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = EncryptionConsumer.class.getName();
    private static final QName ALGORITHM_Q = new QName("", "Algorithm");
    private IdUtils _idResolver = null;
    private Map<Object, Object> _selectors = null;
    private boolean _initialized = false;

    @Override
    public void init(Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._selectors = map;
            this._idResolver = (IdUtils)map.get("com.ibm.ws.wssecurity.util.selector.IDResolver");
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    @Override
    public void invoke(OMNode oMNode, Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(OMNode target[" + DOMUtils.getDisplayName(oMNode) + "]," + "Map context)");
        }
        int n = 0;
        OMElement oMElement = null;
        if (oMNode == null) {
            throw SoapSecurityException.format("security.wssecurity.EncryptionConsumer.s13");
        }
        if (oMNode.getType() == 1) {
            oMElement = (OMElement)oMNode;
            String string = oMElement.getNamespace() == null ? null : oMElement.getNamespace().getNamespaceURI();
            String string2 = oMElement.getLocalName();
            n = string == null ? 0 : string.hashCode() * 31;
            if (oMNode.getType() != 1 || (n += string2 == null ? 0 : string2.hashCode()) != Constants.HASH_ENC_ENCRYPTEDKEY && n != Constants.HASH_ENC_REFERENCELIST) {
                throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s03", DOMUtils.getQualifiedName(oMNode));
            }
        } else {
            throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s03", DOMUtils.getQualifiedName(oMNode));
        }
        Object object = map.get("com.ibm.ws.wssecurity.constants.wssVersion");
        int n2 = 0;
        if (object != null && object instanceof Integer) {
            n2 = (Integer)object;
        }
        String string = Constants.NAMESPACES[0][n2];
        String string3 = Constants.NAMESPACES[1][n2];
        WSSConsumerConfig wSSConsumerConfig = (WSSConsumerConfig)map.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
        EncryptionConsumerConfig encryptionConsumerConfig = (EncryptionConsumerConfig)map.remove("com.ibm.ws.wssecurity.impl.config.encryptionConsumer.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "EncryptionConsumerConfig [" + encryptionConsumerConfig + "].");
        }
        if (EncryptedKey.isOfType(oMElement)) {
            EncryptionConsumer.checkEncryptedKey(oMElement, encryptionConsumerConfig);
        } else {
            EncryptionConsumer.checkReferenceList(oMElement, encryptionConsumerConfig);
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        OMDocument oMDocument = DOMUtil.getOwnerDocument(oMElement);
        String string4 = null;
        string4 = encryptionConsumerConfig.getDataEncryptionMethod().getAlgorithm();
        map.put("com.ibm.ws.wssecurity.keyinfo.keyAlgorithm", string4);
        DecryptionResult decryptionResult = EncryptionConsumer.decrypt(oMElement, encryptionConsumerConfig, this._idResolver, oMDocument, wSSConsumerConfig, hashMap, this._selectors, string, string3, map);
        EncryptionConsumer.setDecryptionResult(decryptionResult, map);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(OMNode target, Map context)");
        }
    }

    private static void checkEncryptedKey(OMElement oMElement, EncryptionConsumerConfig encryptionConsumerConfig) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkEncryptedKey(OMElement enckey[" + DOMUtils.getDisplayName(oMElement) + "]," + "EncryptionConsumerConfig config)");
        }
        int n = 0;
        OMElement oMElement2 = DOMUtils.getFirstElement(oMElement);
        while (oMElement2 != null) {
            String string = oMElement2.getNamespace() == null ? null : oMElement2.getNamespace().getNamespaceURI();
            String string2 = oMElement2.getLocalName();
            n = string == null ? 0 : string.hashCode() * 31;
            if ((n += string2 == null ? 0 : string2.hashCode()) == Constants.HASH_ENC_ENCRYPTIONMETHOD) {
                String string3 = oMElement2.getAttributeValue(ALGORITHM_Q);
                if (encryptionConsumerConfig.getKeyEncryptionMethod() == null || !encryptionConsumerConfig.getKeyEncryptionMethod().getAlgorithm().equals(string3)) {
                    throw SoapSecurityException.format(Constants.UNSUPPORTED_ALGORITHM, "security.wssecurity.PrivateConsumerConfig.s15", string3);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string2 + " [" + string3 + "] is OK.");
                }
            } else if (n == Constants.HASH_ENC_REFERENCELIST) {
                EncryptionConsumer.checkReferenceList(oMElement2, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string2 + " is OK.");
                }
            } else if (n == Constants.HASH_ENC_CIPHERDATA) {
                EncryptionConsumer.checkCipherData(oMElement2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string2 + " is OK.");
                }
            } else if (n == Constants.HASH_DS_KEYINFO) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string2 + " is OK.");
                }
            } else if (n == Constants.HASH_ENC_CARRIEDKEYNAME || n == Constants.HASH_ENC_ENCRYPTIONPROPS) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string2 + " is OK. But this consumer ignores it.");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.warning(tc, "security.wssecurity.WSEC6833W", new Object[]{DOMUtils.getQualifiedName(oMElement2), DOMUtils.getQualifiedName(oMElement)});
            }
            oMElement2 = DOMUtils.getNextElement(oMElement2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkEncryptedKey(OMElement enckey, EncryptionConsumerConfig config)");
        }
    }

    private static void checkReferenceList(OMElement oMElement, EncryptionConsumerConfig encryptionConsumerConfig) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkReferenceList(OMElement reflist[" + DOMUtils.getDisplayName(oMElement) + "]," + "EncryptionConsumerConfig config)");
        }
        if (encryptionConsumerConfig != null && encryptionConsumerConfig.getKeyEncryptionMethod() != null && encryptionConsumerConfig.getKeyEncryptionMethod().getAlgorithm().length() > 0) {
            throw SoapSecurityException.format(Constants.UNSUPPORTED_ALGORITHM, "security.wssecurity.EncryptionConsumer.s12", encryptionConsumerConfig.getKeyEncryptionMethod().getAlgorithm());
        }
        int n = 0;
        OMElement oMElement2 = DOMUtils.getFirstElement(oMElement);
        while (oMElement2 != null) {
            String string = oMElement2.getNamespace() == null ? null : oMElement2.getNamespace().getNamespaceURI();
            String string2 = oMElement2.getLocalName();
            n = string == null ? 0 : string.hashCode() * 31;
            if ((n += string2 == null ? 0 : string2.hashCode()) == Constants.HASH_ENC_DATAREFERENCE || n == Constants.HASH_ENC_KEYREFERENCE) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string2 + " is OK.");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.warning(tc, "security.wssecurity.WSEC6833W", new Object[]{DOMUtils.getQualifiedName(oMElement2), DOMUtils.getQualifiedName(oMElement)});
            }
            oMElement2 = DOMUtils.getNextElement(oMElement2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkReferenceList(OMElement reflist, EncryptionConsumerConfig config)");
        }
    }

    private static void checkEncryptedData(OMElement oMElement, EncryptionConsumerConfig encryptionConsumerConfig) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkEncryptedKey(OMElement encdata[" + DOMUtils.getDisplayName(oMElement) + "]," + "EncryptionConsumerConfig config)");
        }
        int n = 0;
        OMElement oMElement2 = null;
        String string = oMElement.getNamespace() == null ? null : oMElement.getNamespace().getNamespaceURI();
        String string2 = oMElement.getLocalName();
        n = string == null ? 0 : string.hashCode() * 31;
        if ((n += string2 == null ? 0 : string2.hashCode()) == Constants.HASH_ENC_WSSE11_ENCRYPTEDHEADER) {
            oMElement2 = oMElement.getFirstElement();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "element was EncryptedHeader...so retrieved EncryptedData from it before checking EncryptedData");
            }
        } else {
            oMElement2 = oMElement;
        }
        OMElement oMElement3 = DOMUtils.getFirstElement(oMElement2);
        while (oMElement3 != null) {
            string = oMElement3.getNamespace() == null ? null : oMElement3.getNamespace().getNamespaceURI();
            string2 = oMElement3.getLocalName();
            n = string == null ? 0 : string.hashCode() * 31;
            if ((n += string2 == null ? 0 : string2.hashCode()) == Constants.HASH_ENC_ENCRYPTIONMETHOD) {
                String string3 = oMElement3.getAttributeValue(ALGORITHM_Q);
                if (!encryptionConsumerConfig.getDataEncryptionMethod().getAlgorithm().equals(string3)) {
                    throw SoapSecurityException.format(Constants.UNSUPPORTED_ALGORITHM, "security.wssecurity.PrivateConsumerConfig.s14", string3);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string2 + " [" + string3 + "] is OK.");
                }
            } else if (n == Constants.HASH_ENC_CIPHERDATA) {
                EncryptionConsumer.checkCipherData(oMElement3);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string2 + " is OK.");
                }
            } else if (n == Constants.HASH_DS_KEYINFO) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string2 + " is OK.");
                }
            } else if (n == Constants.HASH_ENC_ENCRYPTIONPROPS) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string2 + " is OK. But this consumer igonores it.");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.warning(tc, "security.wssecurity.WSEC6833W", new Object[]{DOMUtils.getQualifiedName(oMElement3), DOMUtils.getQualifiedName(oMElement)});
            }
            oMElement3 = DOMUtils.getNextElement(oMElement3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkEncryptedData(OMElement encdata, EncryptionConsumerConfig config)");
        }
    }

    private static void checkCipherData(OMElement oMElement) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkCipherData(OMElement cipdata[" + DOMUtils.getDisplayName(oMElement) + "])");
        }
        int n = 0;
        OMElement oMElement2 = DOMUtils.getFirstElement(oMElement);
        while (oMElement2 != null) {
            String string = oMElement2.getNamespace() == null ? null : oMElement2.getNamespace().getNamespaceURI();
            String string2 = oMElement2.getLocalName();
            n = string == null ? 0 : string.hashCode() * 31;
            if ((n += string2 == null ? 0 : string2.hashCode()) == Constants.HASH_ENC_CIPHERVALUE || n == Constants.HASH_ENC_CIPHERREFERENCE) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string2 + " is OK.");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.warning(tc, "security.wssecurity.WSEC6833W", new Object[]{DOMUtils.getQualifiedName(oMElement2), DOMUtils.getQualifiedName(oMElement)});
            }
            oMElement2 = DOMUtils.getNextElement(oMElement2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkCipherData(OMElement cipdata)");
        }
    }

    private static DecryptionResult decrypt(OMElement oMElement, EncryptionConsumerConfig encryptionConsumerConfig, IdUtils idUtils, OMDocument oMDocument, WSSConsumerConfig wSSConsumerConfig, Map<Object, Object> map, Map<Object, Object> map2, String string, String string2, Map<Object, Object> map3) throws SoapSecurityException {
        Object object;
        Object object2;
        Object object3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "decrypt(OMElement target[" + DOMUtils.getDisplayName(oMElement) + "]," + "EncryptionConsumerConfig config," + "IdUtil idResolver[" + idUtils + "]," + "OMDocument doc[" + DOMUtils.getDisplayName(oMDocument.getOMDocumentElement()) + "]," + "WSSConsumerConfig gconfig," + "Map type," + "Map properties," + "String nsWsse[" + string + "]," + "String nsWsu[" + string2 + "]," + "Map context)");
        }
        ArrayList<DecryptionResult.DecryptedPart> arrayList = new ArrayList<DecryptionResult.DecryptedPart>();
        DecryptionContext decryptionContext = new DecryptionContext();
        decryptionContext.setIdResolver(idUtils);
        decryptionContext.setContext(map3);
        WSSAlgorithmFactory wSSAlgorithmFactory = wSSConsumerConfig.getAlgorithmFactory();
        decryptionContext.setAlgorithmFactory(wSSAlgorithmFactory);
        if (tc.isDebugEnabled()) {
            decryptionContext.setResourceShower(ShowerImpl.getInstance());
        }
        Map<Object, Object> map4 = wSSConsumerConfig.getProperties();
        decryptionContext.setHWConfigName((String)map4.get("HWCONFIG"));
        String string3 = (String)map4.get("com.ibm.ws.wssecurity.handler.OffloadAllCryptography");
        decryptionContext.setHWKeyStoreName((String)map3.remove("com.ibm.ws.wssecurity.config.keystore.keyStoreRef"));
        String string4 = null;
        AlgorithmConfig algorithmConfig = encryptionConsumerConfig.getKeyEncryptionMethod();
        if (algorithmConfig != null) {
            string4 = algorithmConfig.getAlgorithm();
        }
        decryptionContext.setEncAlgorithm(string4);
        decryptionContext.setOffload(Boolean.TRUE);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Encryption Algorithm is : " + string4);
        }
        if (decryptionContext.shouldChangeProvider()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "HARDWARE Acceleration enabled, Key Store Name is: " + decryptionContext.getHWConfigName());
            }
            if ((object3 = ConfigUtil.getHWCryptoProviderInstance(decryptionContext.getHWConfigName())) == null) {
                Tr.audit(tc, "Failure to get Hardware crypto provider instance to use hardware acceleration, continue processing.");
            } else {
                object2 = (Integer)map4.get("com.ibm.ws.wssecurity.handler.hardwareCacheSize");
                decryptionContext.setHWAccelerationProvider((Provider)object3, (Integer)object2);
                decryptionContext.setCryptoOffloadProperty(string3);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "HW crypto provider instance for HW Acceleration" + ((Provider)object3).getName());
                }
            }
        }
        object3 = EncryptionConsumer.getIds(oMElement);
        Key key = null;
        Key key2 = null;
        Iterator iterator = object3.iterator();
        SecurityTokenWrapper securityTokenWrapper = null;
        while (iterator.hasNext()) {
            OMElement oMElement2;
            object2 = (String)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "decrypt, start id=" + (String)object2);
            }
            if ((oMElement2 = idUtils.resolveID(oMDocument, (String)object2)) != null) {
                if (EncryptedData.isOfType(oMElement2) || EncryptedHeader.isOfType(oMElement2)) {
                    try {
                        EncryptionConsumer.checkEncryptedData(oMElement2, encryptionConsumerConfig);
                        if (EncryptedKey.isOfType(oMElement)) {
                            if (key == null) {
                                key = SignatureConsumer.callKeyInfoConsumer(encryptionConsumerConfig.getEncryptionKeyInfo(), "DecryptingKey", map, map2, KeyInfo.searchForKeyInfo(oMElement), map3);
                                if (decryptionContext.useHWKeyStore()) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "HARDWARE Key Store Name is: " + decryptionContext.getHWKeyStoreName());
                                        Tr.debug(tc, "Encryption Algorithm is : " + string4);
                                    }
                                    if ((object = ConfigUtil.getHWCryptoProviderInstance(decryptionContext.getHWKeyStoreName())) == null) {
                                        Tr.audit(tc, "Failure to get Hardware crypto provider instance to use hardware keystore, continue processing.");
                                    } else {
                                        decryptionContext.setHWKeyStoreProvider((Provider)object);
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "HW crypto provider instance for the HW KeyStore" + ((Provider)object).getName());
                                        }
                                    }
                                }
                            }
                            if (key2 == null) {
                                key2 = EncryptionConsumer.decryptEncryptedKey(oMElement, decryptionContext, key, oMElement2);
                            }
                        } else {
                            object = null;
                            object = EncryptedHeader.isOfType(oMElement2) ? KeyInfo.searchForKeyInfo(oMElement2.getFirstElement()) : KeyInfo.searchForKeyInfo(oMElement2);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "KeyInfo element = " + DOMUtils.toString((OMNode)object));
                            }
                            key2 = SignatureConsumer.callKeyInfoConsumer(encryptionConsumerConfig.getEncryptionKeyInfo(), "DecryptingKey", map, map2, (OMElement)object, map3);
                            if (decryptionContext.useHWKeyStore()) {
                                Provider provider;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "HARDWARE Key Store Name is: ", decryptionContext.getHWKeyStoreName());
                                }
                                if ((provider = ConfigUtil.getHWCryptoProviderInstance(decryptionContext.getHWKeyStoreName())) == null) {
                                    Tr.audit(tc, "Failure to get Hardware crypto provider instance to use hardware keystore, continue processing.");
                                } else {
                                    decryptionContext.setHWKeyStoreProvider(provider);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "HW crypto provider instance for the HW KeyStore" + provider.getName());
                                    }
                                }
                            }
                        }
                        object = EncryptionConsumer.decryptEncryptedData(oMElement2, decryptionContext, key2, string, string2, map3);
                        arrayList.add((DecryptionResult.DecryptedPart)object);
                    }
                    catch (SoapSecurityException soapSecurityException) {
                        if (EncryptedHeader.isOfType(oMElement2)) {
                            Tr.processException(soapSecurityException, clsName + ".decrypt", "644");
                            Tr.error(tc, "security.wssecurity.EncryptionConsumer.s11", soapSecurityException);
                            throw soapSecurityException;
                        }
                        Tr.processException(soapSecurityException, clsName + ".decrypt", "648");
                        Tr.error(tc, "security.wssecurity.EncryptionConsumer.s11", soapSecurityException);
                        throw soapSecurityException;
                    }
                } else {
                    throw SoapSecurityException.format("security.wssecurity.EncryptionReceiver.enc13", oMElement2.getLocalName());
                }
            }
            if (!decryptionContext.useHWKeyStore()) continue;
            ConfigUtil.returnHWCryptoProviderInstance(decryptionContext.getHWKeyStoreName(), decryptionContext.getHWKeyStoreProvider());
            decryptionContext.setHWKeyStoreProvider(null);
            decryptionContext.setHWKeyStoreName(null);
        }
        if (decryptionContext.isHWAccelerationProvider()) {
            ConfigUtil.returnHWCryptoProviderInstance(decryptionContext.getHWConfigName(), decryptionContext.getHWAccelerationProvider());
        }
        if (decryptionContext.useHWKeyStore()) {
            ConfigUtil.returnHWCryptoProviderInstance(decryptionContext.getHWKeyStoreName(), decryptionContext.getHWKeyStoreProvider());
        }
        decryptionContext.clearLocalProviderMap();
        object = new DecryptionResult(encryptionConsumerConfig, arrayList);
        if (securityTokenWrapper == null) {
            securityTokenWrapper = EncryptionConsumer.getTokenWrapper((DecryptionResult)object, encryptionConsumerConfig, map3);
        }
        ((DecryptionResult)object)._tokenWrapper = securityTokenWrapper;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decrypt(OMElement target,EncryptionConsumerConfig config,IdUtil idResolver,OMDocument doc,WSSConsumerConfig gconfig,Map type,Map properties,String nsWsse,String nsWsu,Map context) returns DecryptionResult[" + object + "]");
        }
        return object;
    }

    private static List<String> getIds(OMElement oMElement) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIds(Element target[" + DOMUtils.getDisplayName(oMElement) + "])");
        }
        OMElement oMElement2 = null;
        if (EncryptedKey.isOfType(oMElement)) {
            oMElement2 = DOMUtils.getChildElement(oMElement, Constants.NS_ENC, "ReferenceList");
        } else if (ReferenceList.isOfType(oMElement)) {
            oMElement2 = oMElement;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (oMElement2 != null) {
            ReferenceList referenceList = new ReferenceList(oMElement2);
            for (ReferenceType referenceType : referenceList.getReferences()) {
                if (referenceType instanceof DataReference) {
                    String string = ((DataReference)referenceType).getURI();
                    if (string == null) {
                        throw SoapSecurityException.format("security.wssecurity.EncryptionConsumer.s01");
                    }
                    if (string.length() <= 1 || string.charAt(0) != '#') continue;
                    arrayList.add(string.substring(1));
                    continue;
                }
                if (!(referenceType instanceof KeyReference)) continue;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIds(OMElement target) returns List[" + arrayList + "]");
        }
        return arrayList;
    }

    private static Key decryptEncryptedKey(OMElement oMElement, DecryptionContext decryptionContext, Key key, OMElement oMElement2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "decryptEncryptedKey(OMElement enckey[" + DOMUtils.getDisplayName(oMElement) + "]," + "DecryptionContext dcontext[" + decryptionContext + "]," + "Key kek[" + key + "]," + "OMElement encData[" + DOMUtils.getDisplayName(oMElement2) + "])");
        }
        Key key2 = null;
        try {
            decryptionContext.setEncryptedType(oMElement, null, null, null);
            OMElement oMElement3 = null;
            if (EncryptedHeader.isOfType(oMElement2)) {
                OMElement oMElement4 = oMElement2.getFirstElement();
                oMElement3 = DOMUtils.getChildElement(oMElement4, Constants.NS_ENC, "EncryptionMethod");
            } else {
                oMElement3 = DOMUtils.getChildElement(oMElement2, Constants.NS_ENC, "EncryptionMethod");
            }
            decryptionContext.setEncryptionMethod(oMElement3);
            if (decryptionContext.isHWAccelerationProvider()) {
                decryptionContext.setHWKey(key);
            } else {
                decryptionContext.setKey(key);
            }
            decryptionContext.decrypt();
            key2 = (Key)decryptionContext.getData();
            decryptionContext.setEncryptionMethod((OMElement)null);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception from decrypting the key: ", exception);
            }
            Tr.processException(exception, clsName + ".decryptEncryptedKey", "784");
            Tr.error(tc, "security.wssecurity.EncryptionConsumer.s11", new Object[]{exception});
            throw SoapSecurityException.format("security.wssecurity.EncryptionConsumer.s11", new String[]{exception.getMessage()}, (Throwable)exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decryptEncryptedKey(OMElement enckey,DecryptionContext dcontext,Key kek,OMElement encdata) returns Key[" + key2 + "]");
        }
        return key2;
    }

    private static DecryptionResult.DecryptedPart decryptEncryptedData(OMElement oMElement, DecryptionContext decryptionContext, Key key, String string, String string2, Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "decryptEncryptedData(OMElement encdata[" + DOMUtils.getDisplayName(oMElement) + "]," + "DecryptionContext dcontext[" + decryptionContext + "]," + "Key kek[" + key + "]," + "String nsWsse[" + string + "]," + "String nsWsu[" + string2 + "]," + "Map context)");
        }
        DecryptionResult.DecryptedPart decryptedPart = null;
        try {
            decryptionContext.setEncryptedType(oMElement, null, null, null);
            decryptionContext.setKey(key);
            decryptionContext.decrypt();
            decryptionContext.replace();
            decryptedPart = EncryptionConsumer.createDecryptedPart(oMElement, decryptionContext, string, string2, map);
        }
        catch (Exception exception) {
            Tr.processException(exception, clsName + ".decryptEncryptedData", "823");
            Tr.error(tc, "security.wssecurity.EncryptionConsumer.s11", new Object[]{exception});
            throw SoapSecurityException.format("security.wssecurity.EncryptionConsumer.s11", new String[]{exception.getMessage()}, (Throwable)exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decryptEncryptedData(OMElement encdata,DecryptionContext dcontext,Key dek,String nsWsse,String nsWsu,Map context) returns DecryptedPart[" + decryptedPart + "]");
        }
        return decryptedPart;
    }

    private static DecryptionResult.DecryptedPart createDecryptedPart(OMElement oMElement, DecryptionContext decryptionContext, String string, String string2, Map<Object, Object> map) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDecryptedPart(OMElement encdata[" + DOMUtils.getDisplayName(oMElement) + "]," + "DecryptionContext dcontext[" + decryptionContext + "]," + "String nsWsse[" + string + "]," + "String nsWsu[" + string2 + "]," + "Map context)");
        }
        boolean bl = false;
        String string3 = decryptionContext.getType();
        DecryptionResult.DecryptedPart decryptedPart = null;
        Iterator iterator = decryptionContext.getDataAsNodeList();
        if (iterator.hasNext()) {
            OMContainer oMContainer;
            OMNode oMNode = (OMNode)iterator.next();
            if (string3.equals("http://www.w3.org/2001/04/xmlenc#Element")) {
                OMElement oMElement2 = (OMElement)oMNode;
                String string4 = IdUtils.getInstance().getId(oMElement2);
                OMElement oMElement3 = NonceUtil.getTimestamp(oMElement2, string2);
                OMElement oMElement4 = NonceUtil.getNonce(oMElement2, string);
                bl = NonceUtil.isNonceFirst(oMElement2, oMElement4, oMElement3);
                decryptedPart = new DecryptionResult.DecryptedPart(string3, string4, oMElement2, oMElement4, oMElement3, bl);
                ResultMessagePool.addElement(map, oMElement, oMElement2);
            } else if (string3.equals("http://www.w3.org/2001/04/xmlenc#Content") && (oMContainer = oMNode.getParent()) != null && oMContainer instanceof OMElement) {
                OMElement oMElement5 = (OMElement)oMContainer;
                String string5 = IdUtils.getInstance().getId(oMElement5);
                OMElement oMElement6 = NonceUtil.getTimestamp(oMElement5, string2);
                OMElement oMElement7 = NonceUtil.getNonce(oMElement5, string);
                bl = NonceUtil.isNonceFirst(oMElement5, oMElement7, oMElement6);
                decryptedPart = new DecryptionResult.DecryptedPart(string3, string5, oMElement5, oMElement7, oMElement6, bl);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDecryptedPart(OMElement encdata,DecryptionContext dcontext,String nsWsse,String nsWsu,Map context) returns DecryptedPart[" + decryptedPart + "]");
        }
        return decryptedPart;
    }

    private static void setDecryptionResult(DecryptionResult decryptionResult, Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDecryptionResult(DecryptionResult dresult[" + decryptionResult + "]," + "Map context)");
        }
        for (DecryptionResult.DecryptedPart decryptedPart : decryptionResult._decryptedParts) {
            SignatureConsumer.removeNode(decryptedPart._timestamp, "weenc");
            SignatureConsumer.removeNode(decryptedPart._nonce, "weenc");
        }
        ResultPool.add(map, decryptionResult);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setDecryptionResult(DecryptionResult dresult, Map context)");
        }
    }

    private static KeyInfoResult[] getKeyInfoResults(Map<Object, Object> map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyInfoResults(Map context)");
        }
        KeyInfoResult[] keyInfoResultArray = null;
        Result[] resultArray = ResultPool.get(map, KeyInfoResult.class);
        if (resultArray != null) {
            keyInfoResultArray = new KeyInfoResult[resultArray.length];
            for (int i = 0; i < resultArray.length; ++i) {
                keyInfoResultArray[i] = (KeyInfoResult)resultArray[i];
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyInfoResults(Map context) returns KeyInfoResult[][" + keyInfoResultArray + "]");
        }
        return keyInfoResultArray;
    }

    private static KeyInfoResult getProcessedResult(DecryptionResult decryptionResult, KeyInfoResult[] keyInfoResultArray, List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProcessedResult(DecryptionResult dresult,KeyInfoResult[] results,List kclist)");
        }
        KeyInfoResult keyInfoResult = null;
        if (keyInfoResultArray != null) {
            for (int i = 0; i < keyInfoResultArray.length; ++i) {
                KeyInfoResult keyInfoResult2 = keyInfoResultArray[i];
                if (keyInfoResult == null && list.contains(keyInfoResult2.getKeyInfoContentConsumer()) && keyInfoResult2.getError() == null) {
                    keyInfoResult = keyInfoResult2;
                    continue;
                }
                decryptionResult._kresults.put(keyInfoResult2.getKeyInfoContentConsumer(), keyInfoResult2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProcessedResult(DecryptionResult dresult,KeyInfoResult[] results,List kclist) returns KeyInfoResult[" + keyInfoResult + "]");
        }
        return keyInfoResult;
    }

    private static SecurityTokenWrapper getTokenWrapper(DecryptionResult decryptionResult, EncryptionConsumerConfig encryptionConsumerConfig, Map<Object, Object> map) throws SoapSecurityException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTokenWrapper(DecryptionResult dresult[" + decryptionResult + "]," + "EncryptionConsumerConfig econfig," + "Map context)");
        }
        SecurityTokenWrapper securityTokenWrapper = null;
        Collection<SecurityTokenWrapper> collection = null;
        KeyInfoResult[] keyInfoResultArray = EncryptionConsumer.getKeyInfoResults(map);
        KeyInfoResult keyInfoResult = EncryptionConsumer.getProcessedResult(decryptionResult, keyInfoResultArray, encryptionConsumerConfig.getEncryptionKeyInfo().getContentConsumers());
        if (keyInfoResult != null) {
            object4 = keyInfoResult.getIdInSubject();
            object3 = (SecurityTokenManagerImpl)map.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
            object = ((SecurityTokenManagerImpl)object3).getTokenWrapper((SecurityToken)(object2 = ((SecurityTokenManagerImpl)object3).getToken(keyInfoResult.getKeyInfoContentConsumer().getTokenConsumer(), (String)object4)));
            if (object != null) {
                if (((SecurityTokenWrapper)object).getError() != null) {
                    throw ((SecurityTokenWrapper)object).getError();
                }
                securityTokenWrapper = AccessController.doPrivileged(new PrivilegedAction<SecurityTokenWrapper>((SecurityTokenWrapper)object){
                    final /* synthetic */ SecurityTokenWrapper val$tokenWrapper;
                    {
                        this.val$tokenWrapper = securityTokenWrapper;
                    }

                    @Override
                    public SecurityTokenWrapper run() {
                        this.val$tokenWrapper.setReferenced(true);
                        SecurityTokenWrapper securityTokenWrapper = new SecurityTokenWrapper(this.val$tokenWrapper.getSecurityToken(), this.val$tokenWrapper.getWssapiCallbackHandler(), this.val$tokenWrapper.getWssapiLoginConfigName());
                        securityTokenWrapper.setKeyInfoType(this.val$tokenWrapper.getKeyInfoType());
                        securityTokenWrapper.setProcessed(this.val$tokenWrapper.isProcessed());
                        if (this.val$tokenWrapper.isReadOnly()) {
                            securityTokenWrapper.setReadOnly();
                        }
                        securityTokenWrapper.setReferenced(this.val$tokenWrapper.isReferenced());
                        securityTokenWrapper.setUsedTokenConsumer(this.val$tokenWrapper.getUsedTokenConsumerHash(), this.val$tokenWrapper.getUsedTokenConsumerClass());
                        securityTokenWrapper.setUsedTokenGenerator(this.val$tokenWrapper.getUsedTokenGeneratorHash());
                        securityTokenWrapper.setUsedToLogin(this.val$tokenWrapper.isUsedToLogin());
                        securityTokenWrapper.setWssapiReferenceType(this.val$tokenWrapper.getWssapiReferenceType());
                        return securityTokenWrapper;
                    }
                });
            }
            Collection<SecurityToken> object5 = ((SecurityTokenManagerImpl)object3).getTokens((String)object4);
            collection = ((SecurityTokenManagerImpl)object3).getTokenWrappers(object5);
        }
        if ((object4 = encryptionConsumerConfig.getIdentityList()) != null && object4.size() > 0) {
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = (EncryptionConsumerConfig)object3.next();
                block1: for (KeyInfoContentConsumerConfig keyInfoContentConsumerConfig : object2.getEncryptionKeyInfo().getContentConsumers()) {
                    for (int i = 0; i < keyInfoResultArray.length; ++i) {
                        if (!keyInfoContentConsumerConfig.equals(keyInfoResultArray[i].getKeyInfoContentConsumer())) continue;
                        decryptionResult._identities.put((EncryptionConsumerConfig)object2, keyInfoResultArray[i]);
                        continue block1;
                    }
                }
            }
        }
        if (collection != null && collection.size() > 0) {
            block3: for (int i = 0; i < keyInfoResultArray.length; ++i) {
                object2 = keyInfoResultArray[i];
                object = ((KeyInfoResult)object2).getKeyInfoContentConsumer().getTokenConsumer();
                if (object == null) continue;
                for (SecurityTokenWrapper securityTokenWrapper2 : collection) {
                    if (object.hashCode() != securityTokenWrapper2.getUsedTokenConsumerHash()) continue;
                    decryptionResult._kresults.put(object2, securityTokenWrapper2);
                    continue block3;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTokenWrapper(DecryptionResult dresult,EncryptionConsumerConfig econfig,Map context) returns SecurityTokenWrapper[" + securityTokenWrapper + "]");
        }
        return securityTokenWrapper;
    }

    private static class ShowerImpl
    implements ResourceShower {
        private static ShowerImpl _instance = new ShowerImpl();

        private ShowerImpl() {
        }

        private static ShowerImpl getInstance() {
            return _instance;
        }

        public void showEncryptedResource(byte[] byArray, Object object, OMElement oMElement) {
            String string = null;
            try {
                string = EncryptedData.isOfType(oMElement) ? new String(byArray, "UTF-8") : Base64.encode(byArray);
            }
            catch (Exception exception) {
                Tr.debug(tc, "WARNING: An exception occured while the content is encoded with [UTF-8].");
            }
            if (EncryptedData.isOfType(oMElement)) {
                Tr.debug(tc, "ResourceShower logs decrypt-" + oMElement.getAttributeValue(new QName("", "Id")) + ": " + string);
            } else {
                Tr.debug(tc, "ResourceShower logs decrypt-EncryptedKey: " + string);
            }
        }
    }
}

