/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.enc;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.common.Result;
import com.ibm.ws.wssecurity.common.ResultPool;
import com.ibm.ws.wssecurity.config.EncryptionConsumerConfig;
import com.ibm.ws.wssecurity.config.ReferencePartConfig;
import com.ibm.ws.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.wssecurity.core.WSSConsumerComponent;
import com.ibm.ws.wssecurity.dsig.SignatureGenerator;
import com.ibm.ws.wssecurity.enc.DecryptionResult;
import com.ibm.ws.wssecurity.enc.PartList;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoResult;
import com.ibm.ws.wssecurity.token.NonceManager;
import com.ibm.ws.wssecurity.util.ConfidentialDialectElementSelector;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.NonceUtil;
import com.ibm.ws.wssecurity.util.QNameHeaderSelector;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.IDResolver;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecryptedPartChecker
implements WSSConsumerComponent {
    private static final TraceComponent tc = Tr.register(DecryptedPartChecker.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private Map<Object, Object> _selectors = null;
    private IDResolver _idResolver = null;
    private boolean _initialized = false;

    @Override
    public void init(Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._selectors = map;
            this._idResolver = (IdUtils)map.get("com.ibm.ws.wssecurity.util.selector.IDResolver");
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map)");
        }
    }

    @Override
    public void invoke(OMNode oMNode, Map<Object, Object> map) throws SoapSecurityException {
        Object object;
        String string;
        boolean bl;
        Object object2;
        if (tc.isEntryEnabled()) {
            object2 = new StringBuffer("invoke(");
            ((StringBuffer)object2).append("OMNode target[").append(DOMUtils.getDisplayName(oMNode)).append("], ");
            ((StringBuffer)object2).append("Map context)");
            Tr.entry(tc, ((StringBuffer)object2).toString());
        }
        if (oMNode == null) {
            throw SoapSecurityException.format("security.wssecurity.SignatureConsumer.s11", "soapenv:Envelope");
        }
        object2 = map.get("com.ibm.ws.wssecurity.constants.wssVersion");
        int n = 0;
        if (object2 != null && object2 instanceof Integer) {
            n = (Integer)object2;
        }
        String string2 = Constants.NAMESPACES[0][n];
        String string3 = Constants.NAMESPACES[1][n];
        Map map2 = (Map)map.get("com.ibm.ws.wssecurity.constants.verifiedNonceMap");
        OMDocument oMDocument = null;
        oMDocument = DOMUtil.getOwnerDocument(oMNode);
        WSSConsumerConfig wSSConsumerConfig = (WSSConsumerConfig)map.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
        NonceManager nonceManager = wSSConsumerConfig.getNonceManager();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(map);
        hashMap.put(NonceManager.class, nonceManager);
        hashMap.put("com.ibm.ws.wssecurity.util.selector.IDResolver", this._idResolver);
        hashMap.put("com.ibm.ws.wssecurity.util.selector.config", wSSConsumerConfig.getTokenConsumers());
        Set<RequiredParts> set = DecryptedPartChecker.preprocess(oMDocument, wSSConsumerConfig.getRequiredConfidentialParts(), this._selectors, hashMap);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Processing the decrypted results...");
        }
        Result[] resultArray = ResultPool.get(map, DecryptionResult.class);
        HashSet<ReferencePartConfig> hashSet = new HashSet<ReferencePartConfig>();
        if (resultArray != null && resultArray.length > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, resultArray.length + " decrypted results found.");
            }
            for (int i = 0; i < resultArray.length; ++i) {
                DecryptionResult object3 = (DecryptionResult)resultArray[i];
                hashSet.clear();
                for (DecryptionResult.DecryptedPart decryptedPart : object3._decryptedParts) {
                    RequiredPart requiredPart = DecryptedPartChecker.getRelatedPart(object3, decryptedPart, set);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "DecryptedPart [" + decryptedPart + "], RequiredPart [" + requiredPart + "]");
                    }
                    if (requiredPart == null) continue;
                    if (requiredPart._requiredNonce) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Checking required nonce...");
                        }
                        if (decryptedPart._nonce == null) {
                            throw SoapSecurityException.format(Constants.FAILED_CHECK, "security.wssecurity.VerifiedPartChecker.s02", requiredPart._pconfig.getKeyword());
                        }
                        bl = false;
                        string = DOMUtil.getStringValue(decryptedPart._nonce);
                        if (string != null && string.length() > 0) {
                            object = null;
                            if (map2 != null) {
                                object = (OMElement)map2.get(string);
                            }
                            if (object != null && object == decryptedPart._object) {
                                bl = true;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Already verified nonce value of " + string + " for element " + decryptedPart._object + " in VerifiedPartChecker");
                                }
                            }
                        }
                        if (!bl) {
                            NonceUtil.checkNonce(decryptedPart._nonce, string2, nonceManager);
                        }
                    }
                    if (requiredPart._requiredTimestamp) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Checking required timestamp...");
                        }
                        if (decryptedPart._timestamp == null) {
                            throw SoapSecurityException.format(Constants.FAILED_CHECK, "security.wssecurity.TimestampChecker.s02", requiredPart._pconfig.getKeyword());
                        }
                        NonceUtil.checkTimestamp(decryptedPart._timestamp, string3, wSSConsumerConfig.getTimestampMaxAge(), wSSConsumerConfig.getTimestampClockSkew(), false);
                    }
                    requiredPart._processed = true;
                    requiredPart._tokenWrappers.add(object3._tokenWrapper);
                    hashSet.add(requiredPart._rconfig);
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Checking whether all required confidentiality is processed...");
        }
        for (RequiredParts requiredParts : set) {
            RequiredPart[] requiredPartArray = requiredParts._parts;
            boolean bl2 = "http://www.w3.org/2001/04/xmlenc#Content".equals(requiredParts._type);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Content type = " + requiredParts._type);
            }
            for (int i = 0; i < requiredPartArray.length; ++i) {
                bl = true;
                if (bl2) {
                    bl = ((RequiredPart)requiredPartArray[i])._element.getFirstOMChild() != null;
                } else {
                    boolean bl3 = bl = ((RequiredPart)requiredPartArray[i])._element != null;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "rpart[" + i + "]._element = " + DOMUtils.toString(((RequiredPart)requiredPartArray[i])._element));
                    Tr.debug(tc, "rpart[" + i + "]._element.hasChildNodes() = " + (((RequiredPart)requiredPartArray[i])._element.getFirstOMChild() != null));
                    Tr.debug(tc, "bHasContent = " + bl);
                }
                if (bl) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Encrypted target(s) is/are present and security constraint is enforced!");
                    }
                    if (((RequiredPart)requiredPartArray[i])._processed) continue;
                    string = ((RequiredPart)requiredPartArray[i])._pconfig.getKeyword();
                    if (string == null) {
                        object = ((RequiredPart)requiredPartArray[i])._pconfig.getHeaderName();
                        string = object != null ? ((RequiredPart)requiredPartArray[i])._pconfig.getHeaderNamespace() + ":" + (String)object : ((RequiredPart)requiredPartArray[i])._pconfig.getHeaderNamespace();
                    }
                    throw SoapSecurityException.format(Constants.FAILED_CHECK, "security.wssecurity.DecryptedPartChecker.s01", string);
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Encrypted target(s) is/are *not* present and security constraint is *not* enforced!");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(OMNode, Map)");
        }
    }

    private static Set<RequiredParts> preprocess(OMDocument oMDocument, Set<ReferencePartConfig> set, Map<Object, Object> map, Map<Object, Object> map2) throws SoapSecurityException {
        RequiredPart requiredPart;
        int n;
        RequiredParts requiredParts;
        OMElement oMElement;
        int n2;
        Class<QNameHeaderSelector> clazz;
        String string;
        String string2;
        Map<Object, Object> map3;
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            serializable = new StringBuffer("preprocess(");
            ((StringBuffer)serializable).append("OMDocument doc[").append(DOMUtils.getDisplayName(oMDocument)).append("], ");
            ((StringBuffer)serializable).append("Set requiredConfidentiality, Map selectors, Map selectorMap)");
            Tr.entry(tc, ((StringBuffer)serializable).toString());
        }
        serializable = new HashSet();
        HashSet<ReferencePartConfig.PartConfig> hashSet = new HashSet<ReferencePartConfig.PartConfig>();
        HashMap<ReferencePartConfig.PartConfig, Map<Object, Object>> hashMap = new HashMap<ReferencePartConfig.PartConfig, Map<Object, Object>>();
        HashMap<ReferencePartConfig.PartConfig, ReferencePartConfig> hashMap2 = new HashMap<ReferencePartConfig.PartConfig, ReferencePartConfig>();
        PartList partList = null;
        for (ReferencePartConfig referencePartConfig : set) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing ReferencePartConfig [" + referencePartConfig + "]...");
            }
            map3 = new HashMap<Object, Object>(map2);
            for (ReferencePartConfig.PartConfig partConfig : referencePartConfig.getParts()) {
                if (partConfig.isTimestamp() || partConfig.isNonce()) {
                    hashSet.add(partConfig);
                    hashMap.put(partConfig, map3);
                    hashMap2.put(partConfig, referencePartConfig);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing PartConfig [" + partConfig + "]...");
                }
                string2 = partConfig.getDialect();
                string = partConfig.getKeyword();
                clazz = ConfidentialDialectElementSelector.class;
                if (string2.equals(Constants.DIALECT_HEADER)) {
                    map3.put("com.ibm.ws.wssecurity.util.selector.headername", partConfig.getHeaderName());
                    map3.put("com.ibm.ws.wssecurity.util.selector.headernamespace", partConfig.getHeaderNamespace());
                    clazz = QNameHeaderSelector.class;
                }
                if ((partList = (PartList)SignatureGenerator.getMessagePart(oMDocument, string2, string, "decryption_mode", map, clazz, map3)) == null || partList.getLength() <= 0) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, partList.getLength() + " parts found.");
                }
                boolean bl = false;
                for (n2 = 0; n2 < partList.getLength(); ++n2) {
                    oMElement = (OMElement)partList.item(n2);
                    Iterator iterator = serializable.iterator();
                    block3: while (iterator.hasNext()) {
                        requiredParts = (RequiredParts)iterator.next();
                        for (n = 0; n < requiredParts._parts.length; ++n) {
                            requiredPart = requiredParts._parts[n];
                            if (!DOMUtils.equals(oMElement, requiredPart._element)) continue;
                            bl = true;
                            continue block3;
                        }
                    }
                    if (bl) continue;
                    RequiredPart[] requiredPartArray = new RequiredPart[]{new RequiredPart(referencePartConfig, partConfig, oMElement)};
                    requiredParts = new RequiredParts(requiredPartArray, partList.getType());
                    serializable.add(requiredParts);
                }
            }
        }
        for (ReferencePartConfig.PartConfig partConfig : hashSet) {
            ReferencePartConfig referencePartConfig;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing PartConfig [" + partConfig + "]...");
            }
            map3 = (Map)hashMap.get(partConfig);
            referencePartConfig = (ReferencePartConfig)hashMap2.get(partConfig);
            if (!partConfig.isTimestamp() && !partConfig.isNonce()) continue;
            string2 = partConfig.getDialect();
            string = partConfig.getKeyword();
            partList = (PartList)SignatureGenerator.getNoncePart(oMDocument, null, partConfig, "decryption_mode", map, ConfidentialDialectElementSelector.class, map3);
            if (partList == null || partList.getLength() <= 0) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, partList.getLength() + " parts found.");
            }
            for (n2 = 0; n2 < partList.getLength(); ++n2) {
                oMElement = (OMElement)partList.item(n2);
                Iterator<ReferencePartConfig.PartConfig> iterator = serializable.iterator();
                block7: while (iterator.hasNext()) {
                    requiredParts = (RequiredParts)((Object)iterator.next());
                    for (n = 0; n < requiredParts._parts.length; ++n) {
                        requiredPart = requiredParts._parts[n];
                        if (!DOMUtils.equals(oMElement, requiredPart._element)) continue;
                        if (partConfig.isTimestamp()) {
                            requiredPart._requiredTimestamp = partConfig.isTimestamp();
                        }
                        if (!partConfig.isNonce()) continue block7;
                        requiredPart._requiredNonce = partConfig.isNonce();
                        continue block7;
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            clazz = new StringBuffer("preprocess(");
            ((StringBuffer)((Object)clazz)).append("OMDocument, Set, Map, Map)");
            ((StringBuffer)((Object)clazz)).append(" returns Set [").append(serializable).append("]");
            Tr.exit(tc, ((StringBuffer)((Object)clazz)).toString());
        }
        return serializable;
    }

    private static RequiredPart getRelatedPart(DecryptionResult decryptionResult, DecryptionResult.DecryptedPart decryptedPart, Set<RequiredParts> set) throws SoapSecurityException {
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            serializable = new StringBuffer("getRelatedPart(");
            serializable.append("DecryptionResult dresult, ");
            serializable.append("DecryptedPart dpart[").append(decryptedPart).append("], ");
            serializable.append("Set requiredParts)");
            Tr.entry(tc, serializable.toString());
        }
        serializable = null;
        RequiredPart requiredPart = null;
        for (RequiredParts object : set) {
            RequiredPart[] requiredPartArray = object._parts;
            for (int i = 0; i < requiredPartArray.length; ++i) {
                if (requiredPartArray[i]._processed) continue;
                SoapSecurityException soapSecurityException = DecryptedPartChecker.checkBinding(requiredPartArray[i]._rconfig.getBindings(), decryptionResult);
                if (soapSecurityException == null) {
                    if (!DecryptedPartChecker.hasSameUri(requiredPartArray[i]._element, decryptedPart._object) && !DOMUtils.equals(requiredPartArray[i]._element, decryptedPart._object)) continue;
                    requiredPart = requiredPartArray[i];
                    break;
                }
                serializable = soapSecurityException;
            }
            if (requiredPart == null) continue;
            serializable = null;
            break;
        }
        if (serializable != null) {
            throw serializable;
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("getRelatedPart(");
            stringBuffer.append("DecryptionResult, DecryptedPart, Set)");
            stringBuffer.append(" returns RequiredPart [").append(requiredPart).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return requiredPart;
    }

    private static boolean hasSameUri(OMElement oMElement, OMElement oMElement2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("hasSameUri(");
            stringBuffer.append("OMElement rpart[").append(DOMUtils.getDisplayName(oMElement)).append("], ");
            stringBuffer.append("OMElement dpart[").append(DOMUtils.getDisplayName(oMElement2)).append("])");
            Tr.entry(tc, stringBuffer.toString());
        }
        boolean bl = false;
        String string = IdUtils.getInstance().getId(oMElement);
        String string2 = IdUtils.getInstance().getId(oMElement2);
        if (string != null && string.length() > 0 && string2 != null && string2.length() > 0 && string.equals(string2)) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("hasSameUri(OMElement, OMElement)");
            stringBuffer.append(" returns boolean [").append(bl).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return bl;
    }

    private static SoapSecurityException checkBinding(Set<Object> set, DecryptionResult decryptionResult) {
        Object object;
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            serializable = new StringBuffer("checkBinding(");
            serializable.append("Set bindings, DecryptionResult dresult)");
            Tr.entry(tc, serializable.toString());
        }
        serializable = null;
        boolean bl = set.contains(decryptionResult._config);
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The configuration of encryption consumer used for decryption was found in the bindings.");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The configuration of encryption consumer used for decryption was NOT found in the bindings.");
            }
            object = set.iterator();
            while (!bl && object.hasNext()) {
                EncryptionConsumerConfig encryptionConsumerConfig = (EncryptionConsumerConfig)object.next();
                KeyInfoResult keyInfoResult = decryptionResult._identities.get(encryptionConsumerConfig);
                if (keyInfoResult == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "There is no keyinfo result corresponding to the EncryptionConsumerConfig.");
                    continue;
                }
                Exception exception = keyInfoResult.getError();
                if (exception == null) {
                    SecurityTokenWrapper securityTokenWrapper;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The keyinfo result has no exception.");
                    }
                    if ((securityTokenWrapper = (SecurityTokenWrapper)decryptionResult._kresults.get(keyInfoResult)) == null) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "There is no token corresponding to the keyinfo result.");
                        continue;
                    }
                    if (securityTokenWrapper.getError() == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "The token [" + securityTokenWrapper + "] has no exception.");
                        }
                        bl = true;
                        break;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The token [" + securityTokenWrapper + "] has the exception [" + exception.getMessage() + "].");
                    }
                    serializable = securityTokenWrapper.getError();
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The keyinfo result has the exception [" + exception.getMessage() + "].");
                }
                if (exception instanceof SoapSecurityException) {
                    serializable = (SoapSecurityException)exception;
                    continue;
                }
                serializable = SoapSecurityException.format("security.wssecurity.KeyInfoConsumer.getKey04", new String[]{exception.getMessage()}, (Throwable)exception);
            }
            if (bl) {
                serializable = null;
            }
        }
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("checkBinding(");
            ((StringBuffer)object).append("Set, DecryptionResult)");
            ((StringBuffer)object).append(" returns SoapSecurityException [");
            ((StringBuffer)object).append(serializable == null ? "null" : ((Throwable)serializable).toString());
            ((StringBuffer)object).append("]");
            Tr.exit(tc, ((StringBuffer)object).toString());
        }
        return serializable;
    }

    private static class RequiredPart {
        private ReferencePartConfig _rconfig;
        private ReferencePartConfig.PartConfig _pconfig;
        private OMElement _element;
        private boolean _requiredTimestamp;
        private boolean _requiredNonce;
        private Set<SecurityTokenWrapper> _tokenWrappers;
        private boolean _processed;

        RequiredPart(ReferencePartConfig referencePartConfig, ReferencePartConfig.PartConfig partConfig, OMElement oMElement) {
            this._rconfig = referencePartConfig;
            this._pconfig = partConfig;
            this._element = oMElement;
            this._tokenWrappers = new HashSet<SecurityTokenWrapper>();
            this._processed = false;
            this._requiredTimestamp = false;
            this._requiredNonce = false;
        }
    }

    private static class RequiredParts {
        private RequiredPart[] _parts;
        private String _type;

        RequiredParts(RequiredPart[] requiredPartArray, String string) {
            this._parts = requiredPartArray;
            this._type = string;
        }
    }
}

