/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.dsig;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.dsig.WSSSignatureContext;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.XPathCanonicalizer;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.XMLDecryptionTransformer2;
import java.util.ArrayList;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;

public class XMLDecryptionTransformer
extends XMLDecryptionTransformer2 {
    private static final TraceComponent tc = Tr.register(XMLDecryptionTransformer.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = XMLDecryptionTransformer.class.getName();
    private String _nsWsse;
    private String _nsWsu;

    public void transform(TransformContext transformContext) throws TransformException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "transform(TransformContext context[" + transformContext + "])");
        }
        super.transform(transformContext);
        SignatureContext signatureContext = transformContext.getSignatureContext();
        if (signatureContext instanceof WSSSignatureContext) {
            object = (WSSSignatureContext)signatureContext;
            int n = ((WSSSignatureContext)object).getWssVersion();
            this._nsWsse = Constants.NAMESPACES[0][n];
            this._nsWsu = Constants.NAMESPACES[1][n];
        }
        object = null;
        switch (transformContext.getType()) {
            case 0: 
            case 1: {
                object = XPathCanonicalizer.toNodeset(transformContext.getDocument().getOMDocumentElement(), null, true);
                break;
            }
            case 3: {
                object = XPathCanonicalizer.toNodeset(transformContext.getNode(), null, true);
                break;
            }
            case 2: {
                object = transformContext.getNodeset();
            }
        }
        if (object != null) {
            object = this.removeNonce((ArrayList)object, this._nsWsse, this._nsWsu);
        }
        transformContext.setContent((ArrayList)object);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "transform(TransformContext context)");
        }
    }

    private ArrayList removeNonce(ArrayList arrayList, String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNonce(NodeList nl[" + arrayList + "]," + "String nsWsse[" + string + "]," + "String nsWsu[" + string2 + "])");
        }
        ArrayList arrayList2 = new ArrayList();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Object e = arrayList.get(i);
            if (e instanceof OMElement) {
                OMElement oMElement = (OMElement)e;
                if (DOMUtils.equals(oMElement, string, "Nonce")) {
                    if ("weenc".equals(oMElement.getAttributeValue(Constants.WAS_EXTENTION_Q))) {
                        i = this.removeNodes(arrayList, i + 1, oMElement);
                        continue;
                    }
                } else if (DOMUtils.equals(oMElement, string2, "Timestamp") && "weenc".equals(oMElement.getAttributeValue(Constants.WAS_EXTENTION_Q))) {
                    i = this.removeNodes(arrayList, i + 1, oMElement);
                    continue;
                }
            }
            arrayList2.add(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNonce(NodeList nl,String nsWsse,String nsWsu) returns NodeList[" + arrayList2 + "]");
        }
        return arrayList2;
    }

    private int removeNodes(ArrayList arrayList, int n, OMNode oMNode) {
        int n2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNodes(NodeList nl[" + arrayList + "]," + "int start[" + n + "]," + "Node root[" + DOMUtils.getDisplayName(oMNode) + "])");
        }
        boolean bl = false;
        int n3 = arrayList.size();
        for (n2 = n; n2 < n3; ++n2) {
            Object e = arrayList.get(n2);
            if (e instanceof OMElement) {
                if (((OMElement)e).getParent().equals(oMNode)) {
                    n2 = this.removeNodes(arrayList, n2 + 1, (OMElement)e);
                } else {
                    bl = true;
                    break;
                }
            }
            if (bl) break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNodes(NodeList nl,int start,Node root)");
        }
        return n2 - 1;
    }
}

