/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.dsig;

import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.common.Result;
import com.ibm.ws.wssecurity.common.ResultPool;
import com.ibm.ws.wssecurity.config.KeyInfoConsumerConfig;
import com.ibm.ws.wssecurity.core.WSSConsumer;
import com.ibm.ws.wssecurity.dsig.SignatureConsumer;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoConsumer;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoResult;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.NamespaceUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xml.xss4j.enc.KeyInfoResolverBase;
import com.ibm.ws.wssecurity.xml.xss4j.enc.KeyInfoResolvingException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptionMethod;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.KeyInfo;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.Configuration;
import com.ibm.wsspi.wssecurity.core.config.TokenConsumerConfig;
import java.io.Serializable;
import java.security.Key;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLDTKeyInfoResolver
extends KeyInfoResolverBase {
    private static final TraceComponent tc = Tr.register(XMLDTKeyInfoResolver.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = XMLDTKeyInfoResolver.class.getName();
    private IDResolver _idResolver;
    private Collection<TokenConsumerConfig> _tokenConsumers;
    private Collection<Configuration> _encKIConsumers;
    private Map<Object, Object> _context;
    private Map<Object, Object> _selectors;
    private boolean _storedToken = false;
    private Collection<SecurityTokenWrapper> _stokens = null;
    private Result[] _results = null;

    protected XMLDTKeyInfoResolver() {
    }

    protected void setTokenConsumers(Collection<TokenConsumerConfig> collection) {
        this._tokenConsumers = collection;
    }

    protected void setEncKeyInfoConsumers(Collection<Configuration> collection) {
        this._encKIConsumers = collection;
    }

    protected void setContext(Map<Object, Object> map) {
        this._context = map;
    }

    protected void setSelectors(Map<Object, Object> map) {
        this._selectors = new HashMap<Object, Object>(map);
    }

    @Override
    public void setIdResolver(IDResolver iDResolver) {
        this._idResolver = iDResolver;
        super.setIdResolver(iDResolver);
    }

    @Override
    public Key resolve(KeyInfo keyInfo, EncryptionMethod encryptionMethod) throws KeyInfoResolvingException {
        Object object;
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            serializable = new StringBuffer("resolve(");
            serializable.append("KeyInfo keyInfo[").append(keyInfo).append("],");
            serializable.append("EncryptionMethod encMethod[").append(encryptionMethod).append("])");
            Tr.entry(tc, serializable.toString());
        }
        serializable = null;
        if (keyInfo != null) {
            object = (SecurityTokenManagerImpl)this._context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
            try {
                OMElement oMElement = keyInfo.getBase();
                if (oMElement != null) {
                    if (!this._storedToken) {
                        this._stokens = XMLDTKeyInfoResolver.storeSubject((SecurityTokenManagerImpl)object);
                        this._results = XMLDTKeyInfoResolver.storeResult(this._context);
                        this._storedToken = true;
                    }
                    OMDocument oMDocument = DOMUtil.getOwnerDocument(oMElement);
                    HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
                    int n = 0;
                    Object object2 = this._context.get("com.ibm.ws.wssecurity.constants.wssVersion");
                    if (object2 != null && object2 instanceof Integer) {
                        n = (Integer)object2;
                    }
                    String string = Constants.NAMESPACES[0][n];
                    String string2 = KeyInfoConsumer.getKeyInfoType(oMElement, string);
                    boolean bl = "STRREF".equals(string2);
                    String string3 = null;
                    if (bl) {
                        string3 = XMLDTKeyInfoResolver.getReferenceURI(oMElement, string);
                    }
                    if (bl) {
                        OMElement oMElement2 = this._idResolver.resolveID(oMDocument, string3);
                        OMElement oMElement3 = oMDocument.getOMDocumentElement();
                        boolean bl2 = XMLDTKeyInfoResolver.isUNT(oMElement2, n);
                        boolean bl3 = bl2 ? false : XMLDTKeyInfoResolver.isBST(oMElement2, n);
                        WSSConsumer.callTokenConsumer(null, this._tokenConsumers, oMElement3, null, oMElement2, (SecurityTokenManagerImpl)object, this._context, bl2, bl3, n, true);
                    }
                    serializable = XMLDTKeyInfoResolver.callKeyInfoConsumer(this._encKIConsumers, hashMap, this._selectors, oMElement, this._context);
                }
                if (serializable == null) {
                    serializable = super.resolve(keyInfo, encryptionMethod);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (KeyInfoResolvingException keyInfoResolvingException) {
                throw keyInfoResolvingException;
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable throwable3;
                if (throwable instanceof SoapSecurityException && (throwable3 = ((SoapSecurityException)throwable).getCauseException()) != null) {
                    throwable2 = throwable3;
                }
                throw new KeyInfoResolvingException(throwable2.toString());
            }
            finally {
                if (this._storedToken) {
                    XMLDTKeyInfoResolver.restoreSubject((SecurityTokenManagerImpl)object, this._stokens);
                    XMLDTKeyInfoResolver.restoreResult(this._context, this._results);
                    this._storedToken = false;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("resolve(");
            ((StringBuffer)object).append("KeyInfo, EncryptionMethod)");
            ((StringBuffer)object).append(" returns Key[").append(serializable).append("]");
            Tr.exit(tc, ((StringBuffer)object).toString());
        }
        return serializable;
    }

    private static String getReferenceURI(OMElement oMElement, String string) throws SoapSecurityException {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("getReferenceURI(");
            ((StringBuffer)object).append("OMElement elem[").append(DOMUtils.getDisplayName(oMElement)).append("],");
            ((StringBuffer)object).append("String nsWsse[").append(string).append("])");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        if ((object = DOMUtils.getOneElement(oMElement, string, "Reference")) == null) {
            throw SoapSecurityException.format("security.wssecurity.STRReferenceContentConsumer.getReferenceURI01");
        }
        String string2 = DOMUtils.getAttribute((OMElement)object, "URI");
        if (string2 == null) {
            throw SoapSecurityException.format("security.wssecurity.STRReferenceContentConsumer.getReferenceURI02");
        }
        if (string2.startsWith("#")) {
            string2 = string2.substring(1);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("getReferenceURI(");
            stringBuffer.append("OMElement, String)");
            stringBuffer.append(" returns String[").append(string2).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return string2;
    }

    private static Key callKeyInfoConsumer(Collection<Configuration> collection, Map<Object, Object> map, Map<Object, Object> map2, OMElement oMElement, Map<Object, Object> map3) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("callKeyInfoConsumer(");
            stringBuffer.append("Collection kconfig, Map type, Map properties, ");
            stringBuffer.append("OMElement target[").append(DOMUtils.getDisplayName(oMElement)).append("],");
            stringBuffer.append("Map context)");
            Tr.entry(tc, stringBuffer.toString());
        }
        boolean bl = false;
        Throwable throwable = null;
        Object keyInfoConsumerConfig2 = null;
        Key key = null;
        for (KeyInfoConsumerConfig keyInfoConsumerConfig : collection) {
            try {
                key = SignatureConsumer.callKeyInfoConsumer(keyInfoConsumerConfig, "DecryptingKey", map, map2, oMElement, map3);
                bl = true;
                break;
            }
            catch (Exception exception) {
                Tr.processException(exception, clsName + ".callSignatureConsumer", "233");
                throwable = exception;
            }
        }
        if (!bl) {
            throw SoapSecurityException.format("security.wssecurity.DTKeyInfoResolver.s01", new String[]{throwable.getMessage()}, throwable);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("callKeyInfoConsumer(");
            stringBuffer.append("Collection, Map, Map, OMElement, Map)");
            stringBuffer.append(" returns Key[").append(key).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return key;
    }

    protected static Collection<SecurityTokenWrapper> storeSubject(SecurityTokenManagerImpl securityTokenManagerImpl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "storeSubject(SecurityTokenManagerImpl securityTokenManager)");
        }
        Collection<SecurityToken> collection = securityTokenManagerImpl.getTokens();
        Collection<SecurityTokenWrapper> collection2 = securityTokenManagerImpl.getTokenWrappers(collection);
        HashSet<SecurityTokenWrapper> hashSet = new HashSet<SecurityTokenWrapper>(collection2);
        securityTokenManagerImpl.removeTokens(collection);
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("storeSubject(");
            stringBuffer.append("SecurityTokenManagerImpl)");
            stringBuffer.append(" returns Collection[").append(hashSet).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return hashSet;
    }

    protected static void restoreSubject(SecurityTokenManagerImpl securityTokenManagerImpl, Collection<SecurityTokenWrapper> collection) {
        StringBuffer stringBuffer;
        if (tc.isEntryEnabled()) {
            stringBuffer = new StringBuffer("restoreSubject(");
            stringBuffer.append("SecurityTokenManagerImpl securityTokenManager, Collection tokens)");
            Tr.entry(tc, stringBuffer.toString());
        }
        if (collection != null) {
            securityTokenManagerImpl.removeAllTokens();
            securityTokenManagerImpl.addTokenWrappers(collection);
        }
        if (tc.isEntryEnabled()) {
            stringBuffer = new StringBuffer("restoreSubject(");
            stringBuffer.append("SecurityTokenManagerImpl, Collection)");
            Tr.exit(tc, stringBuffer.toString());
        }
    }

    protected static Result[] storeResult(Map<Object, Object> map) {
        Result[] resultArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "storeResult(Map context)");
        }
        if ((resultArray = ResultPool.get(map, KeyInfoResult.class)) != null) {
            ResultPool.remove(map, resultArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "storeResult(Map)");
        }
        return resultArray;
    }

    protected static void restoreResult(Map<Object, Object> map, Result[] resultArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "restoreResult(Map context, Result[] results)");
        }
        if (resultArray != null) {
            Result[] resultArray2 = ResultPool.get(map, KeyInfoResult.class);
            if (resultArray2 != null) {
                ResultPool.remove(map, resultArray2);
            }
            for (int i = 0; i < resultArray.length; ++i) {
                ResultPool.add(map, resultArray[i]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "restoreResult(Map, Result[])");
        }
    }

    protected static boolean isUNT(OMElement oMElement, int n) {
        return NamespaceUtil.checkWsseVersion(oMElement, n, "UsernameToken") >= 0;
    }

    protected static boolean isBST(OMElement oMElement, int n) {
        return NamespaceUtil.checkWsseVersion(oMElement, n, "BinarySecurityToken") >= 0;
    }
}

