/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.dsig;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.common.Result;
import com.ibm.ws.wssecurity.common.ResultPool;
import com.ibm.ws.wssecurity.common.WSSAlgorithmFactory;
import com.ibm.ws.wssecurity.config.AlgorithmConfig;
import com.ibm.ws.wssecurity.config.CallerConfig;
import com.ibm.ws.wssecurity.config.ReferencePartConfig;
import com.ibm.ws.wssecurity.config.SignatureConsumerConfig;
import com.ibm.ws.wssecurity.config.SigningReferenceConfig;
import com.ibm.ws.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.wssecurity.core.ResultMessagePool;
import com.ibm.ws.wssecurity.core.WSSConsumerComponent;
import com.ibm.ws.wssecurity.dsig.PartList;
import com.ibm.ws.wssecurity.dsig.SignatureGenerator;
import com.ibm.ws.wssecurity.dsig.VerificationResult;
import com.ibm.ws.wssecurity.dsig.VerifiedConfig;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoResult;
import com.ibm.ws.wssecurity.token.AuthResult;
import com.ibm.ws.wssecurity.token.NonceManager;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.IntegralDialectElementSelector;
import com.ibm.ws.wssecurity.util.NonceUtil;
import com.ibm.ws.wssecurity.util.QNameHeaderSelector;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.XPathCanonicalizer;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.Transform;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformException;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerifiedPartChecker
implements WSSConsumerComponent {
    private static final TraceComponent tc = Tr.register(VerifiedPartChecker.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private Map<Object, Object> _selectors = null;
    private IDResolver _idResolver = null;
    private boolean _initialized = false;

    @Override
    public void init(Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._selectors = map;
            this._idResolver = (IdUtils)map.get("com.ibm.ws.wssecurity.util.selector.IDResolver");
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map)");
        }
    }

    @Override
    public void invoke(OMNode oMNode, Map<Object, Object> map) throws SoapSecurityException {
        String string;
        Object object;
        Object object2;
        Object object3;
        if (tc.isEntryEnabled()) {
            object3 = new StringBuffer("invoke(");
            ((StringBuffer)object3).append("OMNode target[").append(DOMUtils.getDisplayName(oMNode)).append("], ");
            ((StringBuffer)object3).append("Map context)");
            Tr.entry(tc, ((StringBuffer)object3).toString());
        }
        if (oMNode == null) {
            throw SoapSecurityException.format("security.wssecurity.SignatureConsumer.s11", "soapenv:Envelope");
        }
        object3 = map.get("com.ibm.ws.wssecurity.constants.wssVersion");
        int n = 0;
        if (object3 != null && object3 instanceof Integer) {
            n = (Integer)object3;
        }
        String string2 = Constants.NAMESPACES[0][n];
        String string3 = Constants.NAMESPACES[1][n];
        HashMap<String, OMElement> hashMap = new HashMap<String, OMElement>();
        map.put("com.ibm.ws.wssecurity.constants.verifiedNonceMap", hashMap);
        OMDocument oMDocument = null;
        oMDocument = DOMUtil.getOwnerDocument(oMNode);
        HashMap<SignatureConsumerConfig, OMDocument> hashMap2 = new HashMap<SignatureConsumerConfig, OMDocument>();
        Result[] resultArray = ResultPool.get(map, VerificationResult.class);
        if (resultArray != null && resultArray.length > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, resultArray.length + " verified results found.");
            }
            for (int i = 0; i < resultArray.length; ++i) {
                object2 = (VerificationResult)resultArray[i];
                hashMap2.put(((VerificationResult)object2)._sconfig, ((VerificationResult)object2)._copiedDOM);
            }
        }
        WSSConsumerConfig wSSConsumerConfig = (WSSConsumerConfig)map.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
        object2 = wSSConsumerConfig.getNonceManager();
        HashMap<Object, Object> hashMap3 = new HashMap<Object, Object>(map);
        hashMap3.put(NonceManager.class, object2);
        hashMap3.put("com.ibm.ws.wssecurity.util.selector.IDResolver", this._idResolver);
        hashMap3.put("com.ibm.ws.wssecurity.util.selector.config", wSSConsumerConfig.getTokenConsumers());
        Set<RequiredParts> set = VerifiedPartChecker.preprocess(oMDocument, hashMap2, wSSConsumerConfig.getRequiredIntegralParts(), wSSConsumerConfig.getSignatureConsumers(), this._selectors, hashMap3, wSSConsumerConfig.getAlgorithmFactory(), this._idResolver);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Processing the verified results...");
        }
        HashSet<ReferencePartConfig> hashSet = new HashSet<ReferencePartConfig>();
        if (resultArray != null && resultArray.length > 0) {
            for (int i = 0; i < resultArray.length; ++i) {
                VerificationResult object4 = (VerificationResult)resultArray[i];
                hashSet.clear();
                for (VerificationResult.VerifiedPart verifiedPart : object4._verifiedParts) {
                    object = VerifiedPartChecker.getRelatedPart(object4, verifiedPart, set, map);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "VerifiedPart [" + verifiedPart + "], RequiredPart [" + object + "]");
                    }
                    if (object == null) continue;
                    if (((RequiredPart)object)._requiredNonce) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Checking required nonce...");
                        }
                        if (verifiedPart._nonce == null) {
                            throw SoapSecurityException.format(Constants.FAILED_CHECK, "security.wssecurity.VerifiedPartChecker.s02", ((RequiredPart)object)._pconfig.getKeyword());
                        }
                        NonceUtil.checkNonce(verifiedPart._nonce, string2, (NonceManager)object2);
                        string = DOMUtils.getStringValue(verifiedPart._nonce);
                        if (string != null && string.length() > 0) {
                            hashMap.put(string, verifiedPart._object);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Added verified nonce value of " + string + " for element " + verifiedPart._object + " to map.");
                            }
                        }
                    }
                    if (((RequiredPart)object)._requiredTimestamp) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Checking required timestamp...");
                        }
                        if (verifiedPart._timestamp == null) {
                            throw SoapSecurityException.format(Constants.FAILED_CHECK, "security.wssecurity.TimestampChecker.s02", ((RequiredPart)object)._pconfig.getKeyword());
                        }
                        NonceUtil.checkTimestamp(verifiedPart._timestamp, string3, wSSConsumerConfig.getTimestampMaxAge(), wSSConsumerConfig.getTimestampClockSkew(), false);
                    }
                    ((RequiredPart)object)._processed = true;
                    ((RequiredPart)object)._tokenWrappers.add(object4._tokenWrapper);
                    hashSet.add(((RequiredPart)object)._rconfig);
                }
                VerifiedPartChecker.checkCaller(object4, hashSet, wSSConsumerConfig, map);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Checking whether all required integrity is processed...");
        }
        for (RequiredParts requiredParts : set) {
            RequiredPart[] requiredPartArray = requiredParts._parts;
            for (int i = 0; i < requiredPartArray.length; ++i) {
                if (((RequiredPart)requiredPartArray[i])._processed) continue;
                object = ((RequiredPart)requiredPartArray[i])._pconfig.getKeyword();
                if (object == null) {
                    string = ((RequiredPart)requiredPartArray[i])._pconfig.getHeaderName();
                    object = string != null ? ((RequiredPart)requiredPartArray[i])._pconfig.getHeaderNamespace() + ":" + string : ((RequiredPart)requiredPartArray[i])._pconfig.getHeaderNamespace();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Required integrity not processed with keyword[" + (String)object + "]");
                }
                throw SoapSecurityException.format(Constants.FAILED_CHECK, "security.wssecurity.VerifiedPartChecker.s01", (String)object);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(OMNode, Map)");
        }
    }

    private static Set<RequiredParts> preprocess(OMDocument oMDocument, Map<SignatureConsumerConfig, OMDocument> map, Set<ReferencePartConfig> set, Set<SignatureConsumerConfig> set2, Map<Object, Object> map2, Map<Object, Object> map3, WSSAlgorithmFactory wSSAlgorithmFactory, IDResolver iDResolver) throws SoapSecurityException {
        RequiredParts requiredParts;
        int n;
        RequiredPart[] requiredPartArray;
        ArrayList[] arrayListArray;
        ArrayList<OMNode> arrayList;
        OMDocument oMDocument2;
        Map<Object, Object> map4;
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            serializable = new StringBuffer("preprocess(");
            ((StringBuffer)serializable).append("OMDocument doc[").append(DOMUtils.getDisplayName(oMDocument)).append("], ");
            ((StringBuffer)serializable).append("Map docMap, Set requiredIntegrity, Set sconsumers, ");
            ((StringBuffer)serializable).append("Map selectors, Map selectorMap)");
            Tr.entry(tc, ((StringBuffer)serializable).toString());
        }
        serializable = new HashSet();
        HashSet<ReferencePartConfig.PartConfig> hashSet = new HashSet<ReferencePartConfig.PartConfig>();
        HashMap<ReferencePartConfig.PartConfig, Map<Object, Object>> hashMap = new HashMap<ReferencePartConfig.PartConfig, Map<Object, Object>>();
        HashMap<ReferencePartConfig.PartConfig, ReferencePartConfig> hashMap2 = new HashMap<ReferencePartConfig.PartConfig, ReferencePartConfig>();
        HashMap<ReferencePartConfig.PartConfig, OMDocument> hashMap3 = new HashMap<ReferencePartConfig.PartConfig, OMDocument>();
        for (ReferencePartConfig referencePartConfig : set) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing ReferencePartConfig [" + referencePartConfig + "]...");
            }
            map4 = new HashMap<Object, Object>(map3);
            oMDocument2 = VerifiedPartChecker.setNecessaryInfo(map4, set2, referencePartConfig, oMDocument, map);
            for (ReferencePartConfig.PartConfig partConfig : referencePartConfig.getParts()) {
                if (partConfig.isTimestamp() || partConfig.isNonce()) {
                    hashSet.add(partConfig);
                    hashMap.put(partConfig, map4);
                    hashMap2.put(partConfig, referencePartConfig);
                    hashMap3.put(partConfig, oMDocument2);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing PartConfig [" + partConfig + "]...");
                }
                String string = partConfig.getDialect();
                String string2 = partConfig.getKeyword();
                Class clazz = IntegralDialectElementSelector.class;
                if (string.equals(Constants.DIALECT_HEADER)) {
                    map4.put("com.ibm.ws.wssecurity.util.selector.headername", partConfig.getHeaderName());
                    map4.put("com.ibm.ws.wssecurity.util.selector.headernamespace", partConfig.getHeaderNamespace());
                    clazz = QNameHeaderSelector.class;
                }
                if ((arrayList = SignatureGenerator.getMessagePart(oMDocument2, string, string2, "verification_mode", map2, clazz, map4)) == null || arrayList.size() <= 0) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, arrayList.size() + " parts found.");
                }
                arrayListArray = null;
                boolean bl = false;
                try {
                    for (SignatureConsumerConfig signatureConsumerConfig : set2) {
                        List<SigningReferenceConfig> list = signatureConsumerConfig.getReferences();
                        for (int i = 0; i < list.size(); ++i) {
                            SigningReferenceConfig signingReferenceConfig = list.get(i);
                            ReferencePartConfig referencePartConfig2 = signingReferenceConfig.getReference();
                            for (ReferencePartConfig.PartConfig partConfig2 : referencePartConfig2.getParts()) {
                                if (partConfig != partConfig2) continue;
                                List<AlgorithmConfig> list2 = signingReferenceConfig.getTransforms();
                                for (int j = 0; j < list2.size(); ++j) {
                                    AlgorithmConfig algorithmConfig = list2.get(j);
                                    String string3 = algorithmConfig.getAlgorithm();
                                    Map<Object, Object> map5 = algorithmConfig.getProperties();
                                    OMFactory oMFactory = oMDocument.getOMFactory();
                                    OMElement oMElement = null;
                                    if ("http://www.w3.org/2002/06/xmldsig-filter2".equals(string3)) {
                                        oMElement = SignatureGenerator.createXPath2Transform(oMFactory, string3, map5);
                                    } else if ("http://www.w3.org/TR/1999/REC-xpath-19991116".equals(string3)) {
                                        oMElement = SignatureGenerator.createXPathTransform(oMFactory, string3, map5);
                                    } else if (!"http://www.w3.org/2000/09/xmldsig#enveloped-signature".equals(string3)) continue;
                                    SignatureContext signatureContext = new SignatureContext();
                                    Transform transform = wSSAlgorithmFactory.getTransform(string3);
                                    transform.setParameter(DOMUtil.getFirstChildElement(oMElement));
                                    if (iDResolver != null) {
                                        signatureContext.setIDResolver(iDResolver);
                                    }
                                    arrayListArray = new ArrayList[arrayList.size()];
                                    for (int k = 0; k < arrayList.size(); ++k) {
                                        TransformContext transformContext = new TransformContext(signatureContext, arrayList.get(k));
                                        transform.transform(transformContext);
                                        bl = true;
                                        arrayListArray[k] = transformContext.getNodeset();
                                    }
                                }
                            }
                        }
                    }
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new SoapSecurityException(noSuchAlgorithmException);
                }
                catch (TransformException transformException) {
                    throw new SoapSecurityException(transformException);
                }
                if (arrayList instanceof PartList) {
                    requiredPartArray = new RequiredPart[]{new RequiredPart(referencePartConfig, partConfig, arrayList)};
                } else if (bl) {
                    requiredPartArray = new RequiredPart[arrayList.size()];
                    for (n = 0; n < requiredPartArray.length; ++n) {
                        requiredPartArray[n] = new RequiredPart(referencePartConfig, partConfig, (ArrayList<OMNode>)((Object)arrayListArray[n]));
                    }
                } else {
                    requiredPartArray = new RequiredPart[arrayList.size()];
                    for (n = 0; n < requiredPartArray.length; ++n) {
                        requiredPartArray[n] = new RequiredPart(referencePartConfig, partConfig, (OMElement)arrayList.get(n));
                    }
                }
                requiredParts = new RequiredParts(requiredPartArray);
                serializable.add(requiredParts);
            }
        }
        for (ReferencePartConfig.PartConfig partConfig : hashSet) {
            ReferencePartConfig referencePartConfig;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing PartConfig [" + partConfig + "]...");
            }
            map4 = (Map)hashMap.get(partConfig);
            referencePartConfig = (ReferencePartConfig)hashMap2.get(partConfig);
            oMDocument2 = (OMDocument)hashMap3.get(partConfig);
            if (!partConfig.isTimestamp() && !partConfig.isNonce() || (arrayList = SignatureGenerator.getNoncePart(oMDocument2, null, partConfig, "verification_mode", map2, IntegralDialectElementSelector.class, map4)) == null || arrayList.size() <= 0) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, arrayList.size() + " parts found.");
            }
            boolean bl = false;
            for (n = 0; n < arrayList.size(); ++n) {
                arrayListArray = arrayList.get(n);
                if (arrayListArray.getType() != 1) continue;
                OMElement oMElement = (OMElement)arrayListArray;
                Iterator<ReferencePartConfig.PartConfig> iterator = serializable.iterator();
                block14: while (iterator.hasNext()) {
                    requiredParts = (RequiredParts)((Object)iterator.next());
                    for (int i = 0; i < requiredParts._parts.length; ++i) {
                        RequiredPart requiredPart = requiredParts._parts[i];
                        if (!DOMUtils.equals(oMElement, requiredPart._element)) continue;
                        if (partConfig.isTimestamp()) {
                            requiredPart._requiredTimestamp = partConfig.isTimestamp();
                        }
                        if (partConfig.isNonce()) {
                            requiredPart._requiredNonce = partConfig.isNonce();
                        }
                        bl = true;
                        continue block14;
                    }
                }
                if (bl) continue;
                requiredPartArray = new RequiredPart[]{new RequiredPart(referencePartConfig, partConfig, oMElement)};
                requiredPartArray[0]._requiredTimestamp = partConfig.isTimestamp();
                requiredPartArray[0]._requiredNonce = partConfig.isNonce();
                requiredParts = new RequiredParts(requiredPartArray);
                serializable.add(requiredParts);
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("preprocess(");
            stringBuffer.append("OMDocument, Map, Set, Set, Map, Map)");
            stringBuffer.append(" returns Set [").append(serializable).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return serializable;
    }

    private static OMDocument setNecessaryInfo(Map<Object, Object> map, Set<SignatureConsumerConfig> set, ReferencePartConfig referencePartConfig, OMDocument oMDocument, Map<SignatureConsumerConfig, OMDocument> map2) {
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("setNecessaryInfo(");
            stringBuffer.append("Map selectorMap, Set sconsumers, ");
            stringBuffer.append("ReferencePartConfig rconfig[").append(referencePartConfig).append("], ");
            stringBuffer.append("OMDocument doc[").append(DOMUtils.getDisplayName(oMDocument)).append("], ");
            stringBuffer.append("Map docMap)");
            Tr.entry(tc, stringBuffer.toString());
        }
        boolean bl = false;
        OMDocument oMDocument2 = oMDocument;
        SigningReferenceConfig signingReferenceConfig22 = null;
        for (SignatureConsumerConfig object : set) {
            for (SigningReferenceConfig signingReferenceConfig22 : object.getReferences()) {
                if (!signingReferenceConfig22.getReference().equals(referencePartConfig)) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            OMDocument oMDocument3 = map2.get(object);
            if (oMDocument3 == null) break;
            oMDocument2 = oMDocument3;
            break;
        }
        if (bl) {
            SignatureGenerator.prepareTransform(signingReferenceConfig22, map);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("setNecessaryInfo(");
            stringBuffer.append("Map, Set, ReferencePartConfig, OMDocument, Map)");
            stringBuffer.append(" returns OMDocument [").append(oMDocument2).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return oMDocument2;
    }

    private static RequiredPart getRelatedPart(VerificationResult verificationResult, VerificationResult.VerifiedPart verifiedPart, Set<RequiredParts> set, Map<Object, Object> map) throws SoapSecurityException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("getRelatedPart(");
            stringBuffer.append("VerificationResult vresult, ");
            stringBuffer.append("VerifiedPart vpart[").append(verifiedPart).append("], ");
            stringBuffer.append("Set requiredParts, Map context)");
            Tr.entry(tc, stringBuffer.toString());
        }
        boolean bl2 = verifiedPart._nodeset != null;
        boolean bl3 = bl = verifiedPart._node != null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Is the verified part is nodeset?: " + bl2);
            Tr.debug(tc, "Is the verified part is node?: " + bl);
            Tr.debug(tc, set.size() + " required parts found.");
        }
        SoapSecurityException soapSecurityException = null;
        RequiredPart requiredPart = null;
        for (RequiredParts object : set) {
            RequiredPart[] requiredPartArray = object._parts;
            for (int i = 0; i < requiredPartArray.length; ++i) {
                if (requiredPartArray[i]._processed) continue;
                SoapSecurityException soapSecurityException2 = VerifiedPartChecker.checkBinding(requiredPartArray[i]._rconfig.getBindings(), verificationResult);
                if (soapSecurityException2 == null) {
                    Object object2;
                    if (requiredPartArray[i]._isNodeset) {
                        if (bl2) {
                            if (requiredPartArray[i]._nodeset == null) {
                                requiredPartArray[i]._nodeset = XPathCanonicalizer.toNodeset(requiredPartArray[i]._element, null, false);
                            }
                            if (!DOMUtils.includeNodeset(verifiedPart._nodeset, requiredPartArray[i]._nodeset)) continue;
                            requiredPart = requiredPartArray[i];
                            break;
                        }
                        if (bl) {
                            object2 = XPathCanonicalizer.toNodeset(verifiedPart._node, null, false);
                            if (!DOMUtils.includeNodeset((ArrayList)object2, requiredPartArray[i]._nodeset)) continue;
                            requiredPart = requiredPartArray[i];
                            break;
                        }
                        object2 = XPathCanonicalizer.toNodeset(verifiedPart._object, null, false);
                        if (!DOMUtils.includeNodeset((ArrayList)object2, requiredPartArray[i]._nodeset)) continue;
                        requiredPart = requiredPartArray[i];
                        break;
                    }
                    if (bl2) {
                        if (requiredPartArray[i]._nodeset == null) {
                            requiredPartArray[i]._nodeset = XPathCanonicalizer.toNodeset(requiredPartArray[i]._element, null, false);
                        }
                        if (!DOMUtils.includeNodeset(verifiedPart._nodeset, requiredPartArray[i]._nodeset)) continue;
                        requiredPart = requiredPartArray[i];
                        break;
                    }
                    if (bl) {
                        if (VerifiedPartChecker.hasSameUri(requiredPartArray[i]._element, verifiedPart._node) || DOMUtils.equals(requiredPartArray[i]._element, verifiedPart._node)) {
                            requiredPart = requiredPartArray[i];
                            break;
                        }
                        object2 = ResultMessagePool.getElement(map, verifiedPart._node);
                        if (object2 == null || !VerifiedPartChecker.hasSameUri(requiredPartArray[i]._element, (OMElement)object2) && !DOMUtils.equals(requiredPartArray[i]._element, (OMNode)object2)) continue;
                        requiredPart = requiredPartArray[i];
                        break;
                    }
                    if (VerifiedPartChecker.hasSameUri(requiredPartArray[i]._element, verifiedPart._object) || DOMUtils.equals(requiredPartArray[i]._element, verifiedPart._object)) {
                        requiredPart = requiredPartArray[i];
                        break;
                    }
                    object2 = ResultMessagePool.getElement(map, verifiedPart._object);
                    if (object2 == null || !VerifiedPartChecker.hasSameUri(requiredPartArray[i]._element, (OMElement)object2) && !DOMUtils.equals(requiredPartArray[i]._element, (OMNode)object2)) continue;
                    requiredPart = requiredPartArray[i];
                    break;
                }
                soapSecurityException = soapSecurityException2;
            }
            if (requiredPart == null) continue;
            soapSecurityException = null;
            break;
        }
        if (soapSecurityException != null) {
            throw soapSecurityException;
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("getRelatedPart(");
            stringBuffer.append("VerificationResult, VerifiedPart, Set, Map)");
            stringBuffer.append(" returns RequiredPart [").append(requiredPart).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return requiredPart;
    }

    private static boolean hasSameUri(OMElement oMElement, OMElement oMElement2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("hasSameUri(");
            stringBuffer.append("OMElement rpart[").append(DOMUtils.getDisplayName(oMElement)).append("], ");
            stringBuffer.append("OMElement vpart[").append(DOMUtils.getDisplayName(oMElement2)).append("])");
            Tr.entry(tc, stringBuffer.toString());
        }
        boolean bl = false;
        String string = IdUtils.getInstance().getId(oMElement);
        String string2 = IdUtils.getInstance().getId(oMElement2);
        if (string != null && string.length() > 0 && string2 != null && string2.length() > 0 && string.equals(string2)) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("hasSameUri(OMElement, OMElement)");
            stringBuffer.append(" returns boolean [").append(bl).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return bl;
    }

    private static void checkCaller(VerificationResult verificationResult, Set<ReferencePartConfig> set, WSSConsumerConfig wSSConsumerConfig, Map<Object, Object> map) throws SoapSecurityException {
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            serializable = new StringBuffer("checkCaller(");
            ((StringBuffer)serializable).append("VerificationResult vresult, Set rpconfigs, ");
            ((StringBuffer)serializable).append("WSSConsumerConfig  gconfig, Map context)");
            Tr.entry(tc, ((StringBuffer)serializable).toString());
        }
        if (verificationResult._tokenWrapper == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The token used for signature verification not found...");
            }
        } else {
            Set<CallerConfig> set2;
            serializable = verificationResult._tokenWrapper.getValueType();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The value type of the token: " + serializable);
            }
            if ((set2 = wSSConsumerConfig.getCallers()) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, set2.size() + " Callers found, so start to process it...");
                }
                for (CallerConfig callerConfig : set2) {
                    boolean bl;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Processing a CallerConfig [" + callerConfig + "]...");
                    }
                    QName qName = callerConfig.getCallerIdentity();
                    QName qName2 = callerConfig.getTrustedIdentity();
                    ReferencePartConfig referencePartConfig = callerConfig.getRequiredSigningPartReference();
                    boolean bl2 = qName != null && qName.equals(serializable) && referencePartConfig != null && qName2 == null;
                    boolean bl3 = bl = qName2 != null && qName2.equals(serializable) && referencePartConfig != null;
                    if (!bl2 && !bl) continue;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    if (bl2) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Checking the caller identity [" + qName + "]...");
                        }
                        if (referencePartConfig.isOneOfIntegralParts()) {
                            if (set.contains(referencePartConfig)) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Linked the token[" + verificationResult._tokenWrapper + "] and the Caller[" + callerConfig + "].");
                                }
                                bl4 = true;
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "ReferencePart of Caller Config is not integral part.");
                        }
                    }
                    if (bl) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Checking the trusted identity [" + qName2 + "]...");
                        }
                        if (referencePartConfig.isOneOfIntegralParts()) {
                            if (set.contains(referencePartConfig)) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Linked the token[" + verificationResult._tokenWrapper + "] and the Caller[" + callerConfig + "].");
                                }
                                bl5 = true;
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "ReferencePart of Caller Config is not integral part.");
                        }
                    }
                    if (!bl4 && !bl5) continue;
                    AuthResult authResult = new AuthResult(verificationResult._tokenWrapper, callerConfig, bl4, bl5);
                    ResultPool.add(map, authResult);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Added AuthResult[" + authResult + "] into the ResultPool.");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkCaller(VerificationResult, Set, WSSConsumerConfig, Map)");
        }
    }

    private static SoapSecurityException checkBinding(Set<Object> set, VerificationResult verificationResult) {
        Object object;
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            serializable = new StringBuffer("checkBinding(");
            serializable.append("Set bindings, VerificationResult vresult)");
            Tr.entry(tc, serializable.toString());
        }
        serializable = null;
        boolean bl = set.contains(verificationResult._sconfig);
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The configuration of signature consumer used for verification was found in the bindings.");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The configuration of signature consumer used for verification was NOT found in the bindings.");
            }
            object = set.iterator();
            block0: while (!bl && object.hasNext()) {
                SignatureConsumerConfig signatureConsumerConfig = (SignatureConsumerConfig)object.next();
                Iterator<SigningReferenceConfig> iterator = signatureConsumerConfig.getReferences().iterator();
                while (!bl && iterator.hasNext()) {
                    SigningReferenceConfig signingReferenceConfig = iterator.next();
                    KeyInfoResult keyInfoResult = verificationResult._identities.get(new VerifiedConfig(signatureConsumerConfig, signingReferenceConfig));
                    if (keyInfoResult == null) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "There is no keyinfo result corresponding to the SigningReferenceConfig.");
                        continue;
                    }
                    Exception exception = keyInfoResult.getError();
                    if (exception == null) {
                        SecurityTokenWrapper securityTokenWrapper;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "The keyinfo result has no exception.");
                        }
                        if ((securityTokenWrapper = (SecurityTokenWrapper)verificationResult._kresults.get(keyInfoResult)) == null) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "There is no token corresponding to the keyinfo result.");
                            continue;
                        }
                        if (securityTokenWrapper.getError() == null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "The token [" + securityTokenWrapper + "] has no exception.");
                            }
                            bl = true;
                            continue block0;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "The token [" + securityTokenWrapper + "] has the exception [" + exception.getMessage() + "].");
                        }
                        serializable = securityTokenWrapper.getError();
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The keyinfo result has the exception [" + exception.getMessage() + "].");
                    }
                    if (exception instanceof SoapSecurityException) {
                        serializable = (SoapSecurityException)exception;
                        continue;
                    }
                    serializable = SoapSecurityException.format("security.wssecurity.KeyInfoConsumer.getKey04", new String[]{exception.getMessage()}, (Throwable)exception);
                }
            }
            if (bl) {
                serializable = null;
            }
        }
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("checkBinding(");
            ((StringBuffer)object).append("Set, VerificationResult)");
            ((StringBuffer)object).append(" returns SoapSecurityException [");
            ((StringBuffer)object).append(serializable == null ? "null" : ((Throwable)serializable).toString());
            ((StringBuffer)object).append("]");
            Tr.exit(tc, ((StringBuffer)object).toString());
        }
        return serializable;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RequiredPart {
        private ReferencePartConfig _rconfig;
        private ReferencePartConfig.PartConfig _pconfig;
        private OMElement _element;
        private ArrayList<OMNode> _nodeset;
        private Set<SecurityTokenWrapper> _tokenWrappers;
        private boolean _isNodeset;
        private boolean _requiredTimestamp;
        private boolean _requiredNonce;
        private boolean _processed;

        RequiredPart(ReferencePartConfig referencePartConfig, ReferencePartConfig.PartConfig partConfig, OMElement oMElement) {
            this._rconfig = referencePartConfig;
            this._pconfig = partConfig;
            this._element = oMElement;
            this._nodeset = null;
            this._isNodeset = false;
            this._tokenWrappers = new HashSet<SecurityTokenWrapper>();
            this._processed = false;
            this._requiredTimestamp = false;
            this._requiredNonce = false;
        }

        RequiredPart(ReferencePartConfig referencePartConfig, ReferencePartConfig.PartConfig partConfig, ArrayList<OMNode> arrayList) {
            this._rconfig = referencePartConfig;
            this._pconfig = partConfig;
            this._element = null;
            this._nodeset = arrayList;
            this._isNodeset = true;
            this._tokenWrappers = new HashSet<SecurityTokenWrapper>();
            this._processed = false;
            this._requiredTimestamp = false;
            this._requiredNonce = false;
        }
    }

    private static class RequiredParts {
        private RequiredPart[] _parts;

        RequiredParts(RequiredPart[] requiredPartArray) {
            this._parts = requiredPartArray;
        }
    }
}

