/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.dsig;

import com.ibm.ws.wssecurity.config.AlgorithmConfig;
import com.ibm.ws.wssecurity.config.EncryptionGeneratorConfig;
import com.ibm.ws.wssecurity.config.KeyInfoGeneratorConfig;
import com.ibm.ws.wssecurity.config.ReferencePartConfig;
import com.ibm.ws.wssecurity.config.SignatureGeneratorConfig;
import com.ibm.ws.wssecurity.config.SigningReferenceConfig;
import com.ibm.ws.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateGeneratorConfig;
import com.ibm.ws.wssecurity.core.ElementSelector;
import com.ibm.ws.wssecurity.core.RequestMessagePool;
import com.ibm.ws.wssecurity.core.WSSGeneratorComponent;
import com.ibm.ws.wssecurity.dsig.STRDTKeyInfoResolver;
import com.ibm.ws.wssecurity.dsig.WSSSignatureContext;
import com.ibm.ws.wssecurity.handler.WSSecurityGeneratorHandler;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoGenerator;
import com.ibm.ws.wssecurity.time.TimestampGenerator;
import com.ibm.ws.wssecurity.token.NonceManager;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.IntegralDialectElementSelector;
import com.ibm.ws.wssecurity.util.NamespaceUtil;
import com.ibm.ws.wssecurity.util.QNameHeaderSelector;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.WSPFunctionElementSelector;
import com.ibm.ws.wssecurity.util.XPathElementSelector;
import com.ibm.ws.wssecurity.xml.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.OMNamespaceWithOwner;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.Reference;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.ResourceShower;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TemplateGenerator;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.XSignatureException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.HWKeyCache;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.EncryptedData;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.Configuration;
import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.llom.OMSourcedElementImpl;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.Phase;
import org.apache.axis2.saaj.SOAPElementImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureGenerator
implements WSSGeneratorComponent {
    private static final TraceComponent tc = Tr.register(SignatureGenerator.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = SignatureGenerator.class.getName();
    private static final String SIGNATURE_PREFIX = "ds";
    private IdUtils _idResolver = null;
    private Map<Object, Object> _selectors = null;
    private boolean _initialized = false;
    private static QName ID_Q = new QName("", "Id");

    @Override
    public void init(Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._selectors = map;
            this._idResolver = (IdUtils)map.get("com.ibm.ws.wssecurity.util.selector.IDResolver");
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    @Override
    public void invoke(OMDocument oMDocument, OMElement oMElement, Map<Object, Object> map) throws SoapSecurityException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        OMElement oMElement2;
        Object object10;
        Class<QNameHeaderSelector> clazz;
        Object object11;
        Object object12;
        boolean bl;
        Object object13;
        OMElement oMElement32;
        Object object14;
        Object object15;
        Iterator iterator;
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(Document doc[" + DOMUtils.getDisplayName(oMDocument) + "]," + "Element parent[" + DOMUtils.getDisplayName(oMElement) + "]," + "Map context)");
        }
        OMFactory oMFactory = oMDocument.getOMDocumentElement().getOMFactory();
        Object object162 = map.get("com.ibm.ws.wssecurity.constants.wssVersion");
        int n = 0;
        if (object162 != null && object162 instanceof Integer) {
            n = (Integer)object162;
        }
        String string2 = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[0][n];
        String string3 = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[1][n];
        String string4 = DOMUtils.getNamespacePrefix(oMElement, string2);
        if (oMElement == null) {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s13", "ds:Signature");
        }
        String string5 = oMElement.getLocalName();
        String string6 = string = oMElement.getNamespace() == null ? null : oMElement.getNamespace().getName();
        if (NamespaceUtil.isWsse(string) != n || !"Security".equals(string5)) {
            throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s03", DOMUtils.getQualifiedName(oMElement), "Security");
        }
        WSSGeneratorConfig wSSGeneratorConfig = (WSSGeneratorConfig)map.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
        SignatureGeneratorConfig signatureGeneratorConfig = (SignatureGeneratorConfig)map.remove("com.ibm.ws.wssecurity.impl.config.signatureGenerator.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SignatureGeneratorConfig [" + signatureGeneratorConfig + "].");
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        HashMap<Object, Object> hashMap2 = new HashMap<Object, Object>(map);
        hashMap2.put("com.ibm.ws.wssecurity.util.selector.IDResolver", this._idResolver);
        hashMap2.put(NonceManager.class, wSSGeneratorConfig.getNonceManager());
        String string7 = signatureGeneratorConfig.getCanonicalizationMethod().getAlgorithm();
        String string8 = signatureGeneratorConfig.getSignatureMethod().getAlgorithm();
        TemplateGenerator templateGenerator = new TemplateGenerator(oMFactory, null, string7, string8);
        templateGenerator.setPrefix(SIGNATURE_PREFIX);
        boolean bl2 = false;
        if (wSSGeneratorConfig instanceof PrivateGeneratorConfig) {
            iterator = (PrivateGeneratorConfig)wSSGeneratorConfig;
            boolean bl3 = ((PrivateGeneratorConfig)((Object)iterator)).isNormalProcessing();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isNormalProcessing = " + bl3);
            }
            if (bl3) {
                object15 = (MessageContext)map.get("com.ibm.wsspi.wssecurity.core.messageContext");
                if (object15 == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "no MessageContext");
                    }
                } else {
                    boolean arrayList3 = false;
                    ArrayList arrayList = ((MessageContext)object15).getConfigurationContext().getAxisConfiguration().getGlobalOutPhases();
                    if (arrayList != null && arrayList.size() > 0) {
                        object14 = (Phase)arrayList.get(arrayList.size() - 1);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "last phase = " + ((Phase)object14).getName());
                        }
                        if ("Security".equals(((Phase)object14).getName())) {
                            for (OMElement oMElement32 : ((Phase)object14).getHandlers()) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "handler class = " + oMElement32.getClass().getName());
                                }
                                if (!(oMElement32 instanceof WSSecurityGeneratorHandler)) continue;
                                arrayList3 = true;
                                break;
                            }
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "securityIsLastPhase = " + arrayList3);
                    }
                    if (arrayList3) {
                        map.put("com.ibm.ws.wssecurity.filter.BodyC14NFilter.IS_OUTBOUND_GOLDEN_PATH", Boolean.TRUE);
                        if (signatureGeneratorConfig.addInclusiveNamespaces()) {
                            map.put("com.ibm.ws.wssecurity.filter.BodyC14NFilter.IS_INCL_NS_ALL_PREFIXES", Boolean.TRUE);
                        }
                        bl2 = true;
                    }
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isGoldenPth = " + bl2);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Examining signing parts.");
        }
        oMElement32 = oMDocument.getOMDocumentElement();
        boolean bl4 = false;
        boolean bl5 = false;
        HashSet<ReferencePartConfig.PartConfig> hashSet = new HashSet<ReferencePartConfig.PartConfig>();
        HashMap<ReferencePartConfig.PartConfig, Object> hashMap3 = new HashMap<ReferencePartConfig.PartConfig, Object>();
        HashMap<ReferencePartConfig.PartConfig, Serializable> hashMap4 = new HashMap<ReferencePartConfig.PartConfig, Serializable>();
        boolean bl6 = false;
        HashSet<ReferencePartConfig.PartConfig> hashSet2 = new HashSet<ReferencePartConfig.PartConfig>();
        HashMap<ReferencePartConfig.PartConfig, Object> hashMap5 = new HashMap<ReferencePartConfig.PartConfig, Object>();
        HashMap<ReferencePartConfig.PartConfig, Serializable> hashMap6 = new HashMap<ReferencePartConfig.PartConfig, Serializable>();
        hashMap2.put("com.ibm.ws.wssecurity.util.selector.config", wSSGeneratorConfig.getTokenGenerators());
        ArrayList<Object> arrayList = new ArrayList<Object>();
        iterator = null;
        if (signatureGeneratorConfig != null && signatureGeneratorConfig.getReferences() != null && signatureGeneratorConfig.getReferences().iterator() != null) {
            iterator = signatureGeneratorConfig.getReferences().iterator();
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                object15 = new HashMap<Object, Object>(hashMap2);
                object13 = (SigningReferenceConfig)iterator.next();
                SignatureGenerator.prepareTransform((SigningReferenceConfig)object13, (Map<Object, Object>)object15);
                object14 = object13.getReference();
                if (object14 == null || object14.getParts() == null || object14.getParts().iterator() == null) continue;
                block13: for (ReferencePartConfig.PartConfig partConfig : object14.getParts()) {
                    if (partConfig.isTimestamp() || partConfig.isNonce()) {
                        bl5 = true;
                        hashSet.add(partConfig);
                        hashMap3.put(partConfig, object13);
                        hashMap4.put(partConfig, (Serializable)object15);
                        continue;
                    }
                    if (com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS.equals(partConfig.getDialect()) && (IntegralDialectElementSelector.WASDIALECTS[2].equals(partConfig.getKeyword()) || IntegralDialectElementSelector.WASDIALECTS[3].equals(partConfig.getKeyword())) || com.ibm.ws.wssecurity.common.Constants.DIALECT_XPATH.equals(partConfig.getDialect())) {
                        bl6 = true;
                        hashSet2.add(partConfig);
                        hashMap5.put(partConfig, object13);
                        hashMap6.put(partConfig, (Serializable)object15);
                        continue;
                    }
                    bl = false;
                    object12 = partConfig.getDialect();
                    object11 = partConfig.getKeyword();
                    clazz = IntegralDialectElementSelector.class;
                    if (((String)object12).equals(com.ibm.ws.wssecurity.common.Constants.DIALECT_HEADER)) {
                        object15.put("com.ibm.ws.wssecurity.util.selector.headername", partConfig.getHeaderName());
                        object15.put("com.ibm.ws.wssecurity.util.selector.headernamespace", partConfig.getHeaderNamespace());
                        clazz = QNameHeaderSelector.class;
                    }
                    object10 = oMDocument;
                    int n2 = -1;
                    while (object10 != null) {
                        ArrayList<OMNode> arrayList4 = SignatureGenerator.getMessagePart((OMDocument)object10, (String)object12, (String)object11, "signature_mode", this._selectors, clazz, (Map<Object, Object>)object15);
                        if (arrayList4 != null && arrayList4.size() > 0) {
                            bl = false;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, arrayList4.size() + " parts found.");
                            }
                            for (int i = 0; i < arrayList4.size(); ++i) {
                                oMElement2 = (OMElement)arrayList4.get(i);
                                if (n2 >= 0) {
                                    object9 = RequestMessagePool.convertElement(map, oMElement2, n2);
                                    if (object9 == null) continue;
                                    if (((RequestMessagePool.EncryptedObject)object9).getEncryptedData() != null) {
                                        object8 = "#" + SignatureGenerator.addWsuId(oMDocument, ((RequestMessagePool.EncryptedObject)object9).getEncryptedData(), string3);
                                        object7 = templateGenerator.createReference((String)object8);
                                        ((Reference)object7).setDigestMethod(object13.getDigestMethod().getAlgorithm());
                                        SignatureGenerator.addTransforms((Reference)object7, oMDocument, oMFactory, ((RequestMessagePool.EncryptedObject)object9).getEncryptedData(), object13.getTransforms(), string4, string2, signatureGeneratorConfig.addInclusiveNamespaces(), bl2);
                                        templateGenerator.addReference((Reference)object7);
                                        bl4 = true;
                                        arrayList.add(oMElement2);
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Added the encrypted data[" + DOMUtils.getDisplayName(((RequestMessagePool.EncryptedObject)object9).getEncryptedData()) + "] because the element[" + DOMUtils.getDisplayName(oMElement2) + "] has already encrypted.");
                                        }
                                    }
                                    if (((RequestMessagePool.EncryptedObject)object9).getHeaderInfo() == null) continue;
                                    object8 = "#" + SignatureGenerator.addWsuId(oMDocument, ((RequestMessagePool.EncryptedObject)object9).getHeaderInfo(), string3);
                                    object7 = templateGenerator.createReference((String)object8);
                                    ((Reference)object7).setDigestMethod(object13.getDigestMethod().getAlgorithm());
                                    SignatureGenerator.addTransforms((Reference)object7, oMDocument, oMFactory, ((RequestMessagePool.EncryptedObject)object9).getHeaderInfo(), object13.getTransforms(), string4, string2, signatureGeneratorConfig.addInclusiveNamespaces(), bl2);
                                    templateGenerator.addReference((Reference)object7);
                                    bl4 = true;
                                    arrayList.add(oMElement2);
                                    if (!tc.isDebugEnabled()) continue;
                                    Tr.debug(tc, "Added the header info[" + DOMUtils.getDisplayName(((RequestMessagePool.EncryptedObject)object9).getHeaderInfo()) + "] because the element[" + DOMUtils.getDisplayName(oMElement2) + "] has already encrypted.");
                                    continue;
                                }
                                object9 = DOMUtils.equals(oMElement2, oMElement32) ? "" : "#" + SignatureGenerator.addWsuId(oMDocument, oMElement2, string3);
                                object8 = templateGenerator.createReference((String)object9);
                                ((Reference)object8).setDigestMethod(object13.getDigestMethod().getAlgorithm());
                                SignatureGenerator.addTransforms((Reference)object8, oMDocument, oMFactory, oMElement2, object13.getTransforms(), string4, string2, signatureGeneratorConfig.addInclusiveNamespaces(), bl2);
                                templateGenerator.addReference((Reference)object8);
                                bl4 = true;
                                arrayList.add(oMElement2);
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "Added the element[" + DOMUtils.getDisplayName(oMElement2) + "].");
                            }
                            bl = true;
                            continue block13;
                        }
                        bl = true;
                        object10 = RequestMessagePool.getDocument(map, ++n2);
                    }
                }
            }
        }
        if (!bl4 && !bl6) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "invoke(Document doc, Element parent, Map context)");
            }
            return;
        }
        bl = false;
        if (!bl4) {
            bl = true;
            object12 = templateGenerator.createReference("#dummy001");
            templateGenerator.addReference((Reference)object12);
        }
        object12 = wSSGeneratorConfig.getAlgorithmFactory();
        object11 = signatureGeneratorConfig.getSignatureMethod();
        clazz = null;
        try {
            object10 = ((AlgorithmFactory)object12).convertParameter(object11.getAlgorithm(), object11.getProperties());
            if (object10 != null) {
                templateGenerator.setSignatureMethodParameter((AlgorithmParameterSpec)object10);
            }
            clazz = templateGenerator.getSignatureElement((AlgorithmFactory)object12);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            Tr.processException(invalidAlgorithmParameterException, clsName + ".invoke", "424");
            Tr.error(tc, "security.wssecurity.SignatureGenerator.s11", new Object[]{invalidAlgorithmParameterException});
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s11", new String[]{invalidAlgorithmParameterException.getMessage()}, (Throwable)invalidAlgorithmParameterException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Tr.processException(noSuchAlgorithmException, clsName + ".invoke", "428");
            Tr.error(tc, "security.wssecurity.SignatureGenerator.s11", new Object[]{noSuchAlgorithmException});
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s11", new String[]{noSuchAlgorithmException.getMessage()}, (Throwable)noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            Tr.processException(noSuchProviderException, clsName + ".invoke", "432");
            Tr.error(tc, "security.wssecurity.SignatureGenerator.s11", new Object[]{noSuchProviderException});
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s11", new String[]{noSuchProviderException.getMessage()}, (Throwable)noSuchProviderException);
        }
        if (wSSGeneratorConfig.isUserDefinedComponentsUsed()) {
            object10 = oMFactory.createOMElement("KeyInfo", com.ibm.ws.wssecurity.common.Constants.NS_DSIG, SIGNATURE_PREFIX);
            clazz.addChild((OMNode)object10);
        }
        clazz = SignatureGenerator.insertElement(oMElement, (OMElement)((Object)clazz), string3, map);
        object10 = wSSGeneratorConfig.getTimestampGenerator();
        if (object10 != null && !object10.isDefault()) {
            TimestampGenerator.moveTimestamp(oMDocument, wSSGeneratorConfig.getTimestampGenerator(), this._selectors, map);
        }
        map.put("com.ibm.ws.wssecurity.keyinfo.keyAlgorithm", signatureGeneratorConfig.getSignatureMethod().getAlgorithm());
        Key key = SignatureGenerator.callKeyInfoGenerator(signatureGeneratorConfig.getSigningKeyInfo(), "SigningKey", hashMap, this._selectors, oMDocument, (OMElement)((Object)clazz), map);
        OMElement oMElement4 = DOMUtils.getOneChildElement((OMElement)((Object)clazz), com.ibm.ws.wssecurity.common.Constants.NS_DSIG, "SignedInfo");
        if (signatureGeneratorConfig.addInclusiveNamespaces() && ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(string7) || "http://www.w3.org/2001/10/xml-exc-c14n#WithComments".equals(string7)) && (object9 = SignatureGenerator.createInclusiveNamespaces(oMFactory, oMElement2 = DOMUtils.getOneChildElement(oMElement4, com.ibm.ws.wssecurity.common.Constants.NS_DSIG, "CanonicalizationMethod"))) != null) {
            oMElement2.addChild((OMNode)object9);
        }
        if (bl) {
            oMElement2 = DOMUtils.getOneChildElement(oMElement4, com.ibm.ws.wssecurity.common.Constants.NS_DSIG, "Reference");
            oMElement2.detach();
        }
        if (bl6) {
            block16: for (ReferencePartConfig.PartConfig partConfig : hashSet2) {
                object13 = (SigningReferenceConfig)hashMap5.get(partConfig);
                object15 = (Map)hashMap6.get(partConfig);
                boolean bl7 = false;
                object9 = partConfig.getDialect();
                object8 = partConfig.getKeyword();
                object7 = oMDocument;
                int n3 = -1;
                while (object7 != null) {
                    ArrayList<OMNode> arrayList2 = SignatureGenerator.getSpecialPart((OMDocument)object7, partConfig, "signature_mode", this._selectors, (Map<Object, Object>)object15);
                    if (arrayList2 != null && arrayList2.size() > 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, arrayList2.size() + " parts found.");
                        }
                        bl7 = false;
                        for (int i = 0; i < arrayList2.size(); ++i) {
                            object6 = (OMElement)arrayList2.get(i);
                            if (n3 >= 0) {
                                object5 = RequestMessagePool.convertElement(map, (OMElement)object6, n3);
                                if (object5 == null) continue;
                                if (((RequestMessagePool.EncryptedObject)object5).getEncryptedData() != null) {
                                    object4 = "#" + SignatureGenerator.addWsuId(oMDocument, ((RequestMessagePool.EncryptedObject)object5).getEncryptedData(), string3);
                                    object3 = templateGenerator.createReference((String)object4);
                                    ((Reference)object3).setDigestMethod(object13.getDigestMethod().getAlgorithm());
                                    SignatureGenerator.addTransforms((Reference)object3, oMDocument, oMFactory, ((RequestMessagePool.EncryptedObject)object5).getEncryptedData(), object13.getTransforms(), string4, string2, signatureGeneratorConfig.addInclusiveNamespaces(), bl2);
                                    oMElement4.addChild(((Reference)object3).getReferenceElement());
                                    arrayList.add(object6);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Added the encrypted data[" + DOMUtils.getDisplayName(((RequestMessagePool.EncryptedObject)object5).getEncryptedData()) + "] because the element[" + DOMUtils.getDisplayName((OMNode)object6) + "] has already encrypted.");
                                    }
                                }
                                if (((RequestMessagePool.EncryptedObject)object5).getHeaderInfo() == null) continue;
                                object4 = "#" + SignatureGenerator.addWsuId(oMDocument, ((RequestMessagePool.EncryptedObject)object5).getHeaderInfo(), string3);
                                object3 = templateGenerator.createReference((String)object4);
                                ((Reference)object3).setDigestMethod(object13.getDigestMethod().getAlgorithm());
                                SignatureGenerator.addTransforms((Reference)object3, oMDocument, oMFactory, ((RequestMessagePool.EncryptedObject)object5).getHeaderInfo(), object13.getTransforms(), string4, string2, signatureGeneratorConfig.addInclusiveNamespaces(), bl2);
                                oMElement4.addChild(((Reference)object3).getReferenceElement());
                                arrayList.add(object6);
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "Added the header info[" + DOMUtils.getDisplayName(((RequestMessagePool.EncryptedObject)object5).getHeaderInfo()) + "] because the element[" + DOMUtils.getDisplayName((OMNode)object6) + "] has already encrypted.");
                                continue;
                            }
                            object5 = DOMUtils.equals((OMNode)object6, oMElement32) ? "" : "#" + SignatureGenerator.addWsuId(oMDocument, (OMElement)object6, string3);
                            object4 = templateGenerator.createReference((String)object5);
                            ((Reference)object4).setDigestMethod(object13.getDigestMethod().getAlgorithm());
                            SignatureGenerator.addTransforms((Reference)object4, oMDocument, oMFactory, (OMElement)object6, object13.getTransforms(), string4, string2, signatureGeneratorConfig.addInclusiveNamespaces(), bl2);
                            oMElement4.addChild(((Reference)object4).getReferenceElement());
                            arrayList.add(object6);
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Added the element[" + DOMUtils.getDisplayName((OMNode)object6) + "].");
                        }
                        bl7 = true;
                        continue block16;
                    }
                    bl7 = true;
                    object7 = RequestMessagePool.getDocument(map, ++n3);
                }
            }
        }
        if (bl5) {
            Object[] objectArray = arrayList.toArray();
            for (ReferencePartConfig.PartConfig partConfig : hashSet) {
                object13 = (SigningReferenceConfig)hashMap3.get(partConfig);
                object15 = (Map)hashMap4.get(partConfig);
                ArrayList<OMNode> arrayList3 = SignatureGenerator.getNoncePart(oMDocument, objectArray, partConfig, "signature_mode", this._selectors, IntegralDialectElementSelector.class, (Map<Object, Object>)object15);
                if (arrayList3 == null || arrayList3.size() <= 0) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, arrayList3.size() + " parts found.");
                }
                for (int i = 0; i < arrayList3.size(); ++i) {
                    object8 = (OMElement)arrayList3.get(i);
                    object7 = DOMUtils.equals((OMNode)object8, oMElement32) ? "" : "#" + SignatureGenerator.addWsuId(oMDocument, (OMElement)object8, string3);
                    Reference reference = templateGenerator.createReference((String)object7);
                    reference.setDigestMethod(object13.getDigestMethod().getAlgorithm());
                    SignatureGenerator.addTransforms(reference, oMDocument, oMFactory, (OMElement)object8, object13.getTransforms(), string4, string2, signatureGeneratorConfig.addInclusiveNamespaces(), bl2);
                    oMElement4.addChild(reference.getReferenceElement());
                    arrayList.add(object8);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Added the element[" + DOMUtils.getDisplayName((OMNode)object8) + "].");
                }
            }
        }
        if (wSSGeneratorConfig.doIndentation()) {
            DOMUtils.indent(clazz, 6, 2);
            clazz.insertSiblingBefore((OMNode)oMFactory.createOMText("\n      "));
        }
        WSSSignatureContext wSSSignatureContext = new WSSSignatureContext();
        if (tc.isDebugEnabled()) {
            wSSSignatureContext.setResourceShower(ShowerImpl.getInstance());
        }
        wSSSignatureContext.setIDResolver(this._idResolver);
        wSSSignatureContext.setAlgorithmFactory((AlgorithmFactory)object12);
        wSSSignatureContext.setDocument(oMDocument);
        if (signatureGeneratorConfig.getKeyInfoSignature() != null) {
            wSSSignatureContext.setKeyInfoSignature(signatureGeneratorConfig.getKeyInfoSignature().getAlgorithm());
        } else {
            wSSSignatureContext.setKeyInfoSignature(null);
        }
        if (bl2) {
            wSSSignatureContext.setContext(map);
        }
        HashSet<Configuration> hashSet3 = new HashSet<Configuration>();
        object8 = new HashSet();
        for (Object e : wSSGeneratorConfig.getOperationGenerators()) {
            if (e instanceof SignatureGeneratorConfig) {
                hashSet3.add(((SignatureGeneratorConfig)e).getSigningKeyInfo());
                continue;
            }
            if (!(e instanceof EncryptionGeneratorConfig)) continue;
            object8.add(((EncryptionGeneratorConfig)e).getEncryptionKeyInfo());
        }
        STRDTKeyInfoResolver sTRDTKeyInfoResolver = new STRDTKeyInfoResolver();
        sTRDTKeyInfoResolver.setContext(map);
        sTRDTKeyInfoResolver.setSelectors(this._selectors);
        sTRDTKeyInfoResolver.setDsigKeyInfoSet(hashSet3);
        sTRDTKeyInfoResolver.setEncKeyInfoSet((Collection<Configuration>)object8);
        sTRDTKeyInfoResolver.setGeneration(true);
        wSSSignatureContext.setSTRDTKeyInfoResolver(sTRDTKeyInfoResolver);
        String string9 = null;
        object6 = signatureGeneratorConfig.getSignatureMethod();
        if (object6 != null) {
            string9 = object6.getAlgorithm();
        }
        wSSSignatureContext.setSigAlgorithm(string9);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Signature Algorithm = " + string9);
        }
        object5 = signatureGeneratorConfig.getProperties();
        object4 = wSSGeneratorConfig.getProperties();
        wSSSignatureContext.setHWConfigName((String)object4.get("HWCONFIG"));
        wSSSignatureContext.setOffload(Boolean.TRUE);
        if (wSSSignatureContext.shouldChangeProvider()) {
            object3 = HWKeyCache.getInstance();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "HARDWARE Acceleration enabled, Key Store Name is: " + wSSSignatureContext.getHWConfigName());
            }
            if ((object2 = ConfigUtil.getHWCryptoProviderInstance(wSSSignatureContext.getHWConfigName())) == null) {
                Tr.audit(tc, "Failure to get Hardware crypto provider instance to use hardware acceleration, continue processing.");
            } else {
                wSSSignatureContext.setHWAccelerationProvider((Provider)object2);
                object = (Integer)object4.get("com.ibm.ws.wssecurity.handler.hardwareCacheSize");
                ((HWKeyCache)object3).setProvider((Provider)object2, (Integer)object);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "HW crypto provider instance for HW Acceleration" + ((Provider)object2).getName());
                }
            }
            try {
                key = ((HWKeyCache)object3).translate(key);
            }
            catch (Exception exception) {
                throw new SoapSecurityException(exception);
            }
        }
        wSSSignatureContext.setHWKeyStoreName((String)object5.get("com.ibm.ws.wssecurity.config.keystore.keyStoreRef"));
        if (wSSSignatureContext.useHWKeyStore()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "HARDWARE Key Store Name is: " + wSSSignatureContext.getHWKeyStoreName());
            }
            if ((object3 = ConfigUtil.getHWCryptoProviderInstance(wSSSignatureContext.getHWKeyStoreName())) == null) {
                Tr.audit(tc, "Failure to get Hardware crypto provider instance to use hardware keystore, continue processing.");
            } else {
                wSSSignatureContext.setHWKeyStoreProvider((Provider)object3);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "HW crypto provider instance for the HW KeyStore" + ((Provider)object3).getName());
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Signing started.");
        }
        try {
            object3 = wSSSignatureContext.sign((OMElement)((Object)clazz), key);
            object2 = (List)map.get("com.ibm.ws.wssecurity.constants.signatureConfirmationCache");
            if (object2 != null && (object = DOMUtil.getFirstChildElementNamed((OMNode)object3, "http://www.w3.org/2000/09/xmldsig#", "SignatureValue")) != null) {
                String string10 = DOMUtil.getStringValue((OMNode)object);
                object2.add(string10);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cached signature value for SignatureConfirmation: " + string10);
                }
            }
        }
        catch (XSignatureException xSignatureException) {
            object2 = xSignatureException.getException();
            Tr.processException((Throwable)object2, clsName + ".invoke", "711");
            Tr.error(tc, "security.wssecurity.SignatureGenerator.s12", object2);
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s12", new String[]{((Throwable)object2).getMessage()}, (Throwable)object2);
        }
        finally {
            if (wSSSignatureContext.isHWAccelerationProvider()) {
                ConfigUtil.returnHWCryptoProviderInstance(wSSSignatureContext.getHWConfigName(), wSSSignatureContext.getHWAccelerationProvider());
            }
            if (wSSSignatureContext.useHWKeyStore()) {
                ConfigUtil.returnHWCryptoProviderInstance(wSSSignatureContext.getHWKeyStoreName(), wSSSignatureContext.getHWKeyStoreProvider());
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Signing done.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Document doc, Element parent, Map context)");
        }
    }

    public static ArrayList<OMNode> getMessagePart(OMDocument oMDocument, String string, String string2, String string3, Map<Object, Object> map, Class clazz, Map<Object, Object> map2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMessagePart(OMDocument doc[" + DOMUtils.getDisplayName(oMDocument) + "]," + "String dialect[" + string + "]," + "String keyword[" + string2 + "]," + "String type[" + string3 + "]," + "Map selectors," + "Class dialectSelector[" + clazz + "]," + "Map selectorMap)");
        }
        map2.put("com.ibm.ws.wssecurity.util.selector.dialect", string);
        map2.put("com.ibm.ws.wssecurity.util.selector.keyword", string2);
        map2.put("com.ibm.ws.wssecurity.util.selector.operation", string3);
        ElementSelector elementSelector = null;
        if (com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS.equals(string)) {
            elementSelector = (ElementSelector)map.get(clazz);
        } else if (com.ibm.ws.wssecurity.common.Constants.DIALECT_FUNCTION.equals(string)) {
            elementSelector = (ElementSelector)map.get(WSPFunctionElementSelector.class);
        } else if (com.ibm.ws.wssecurity.common.Constants.DIALECT_XPATH.equals(string)) {
            elementSelector = (ElementSelector)map.get(XPathElementSelector.class);
        } else if (com.ibm.ws.wssecurity.common.Constants.DIALECT_HEADER.equals(string)) {
            elementSelector = (ElementSelector)map.get(QNameHeaderSelector.class);
        } else {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s02", string);
        }
        ArrayList<OMNode> arrayList = elementSelector.getElements(oMDocument.getOMDocumentElement(), map2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMessagePart(OMDocument doc,String dialect,String keyword,String type,Map selectors,Class dialectSelector,Map selectorMap,Map context) returns NodeList[" + arrayList + "]");
        }
        return arrayList;
    }

    private static ArrayList<OMNode> getSpecialPart(OMDocument oMDocument, ReferencePartConfig.PartConfig partConfig, String string, Map map, Map<Object, Object> map2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSpecialPart(OMDocument doc[" + DOMUtils.getDisplayName(oMDocument) + "]," + "PartConfig pconfig[" + partConfig + "]," + "String type[" + string + "]," + "Map selectors," + "Map selectorMap)");
        }
        String string2 = partConfig.getDialect();
        String string3 = partConfig.getKeyword();
        map2.put("com.ibm.ws.wssecurity.util.selector.dialect", string2);
        map2.put("com.ibm.ws.wssecurity.util.selector.keyword", string3);
        map2.put("com.ibm.ws.wssecurity.util.selector.operation", string);
        ElementSelector elementSelector = (ElementSelector)map.get(IntegralDialectElementSelector.class);
        if (com.ibm.ws.wssecurity.common.Constants.DIALECT_XPATH.equals(string2)) {
            elementSelector = (ElementSelector)map.get(XPathElementSelector.class);
        }
        ArrayList<OMNode> arrayList = elementSelector.getElements(oMDocument.getOMDocumentElement(), map2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSpecialPart(OMDocument doc,PartConfig pconfig,String type,Map selectors,Map selectorMap) returns NodeList[" + arrayList + "]");
        }
        return arrayList;
    }

    public static ArrayList<OMNode> getNoncePart(OMDocument oMDocument, Object[] objectArray, ReferencePartConfig.PartConfig partConfig, String string, Map<Object, Object> map, Class clazz, Map<Object, Object> map2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNoncePart(OMDocument doc[" + DOMUtils.getDisplayName(oMDocument) + "]," + "Object[] parents[" + objectArray + "]," + "PartConfig pconfig[" + partConfig + "]," + "String type[" + string + "]," + "Map selectors," + "Class dialectSelector[" + clazz + "]," + "Map selectorMap)");
        }
        String string2 = partConfig.getDialect();
        String string3 = partConfig.getKeyword();
        map2.put("com.ibm.ws.wssecurity.util.selector.dialect", string2);
        map2.put("com.ibm.ws.wssecurity.util.selector.keyword", string3);
        map2.put("com.ibm.ws.wssecurity.util.selector.operation", string);
        if (objectArray != null) {
            map2.put("com.ibm.ws.wssecurity.util.selector.element", objectArray);
        }
        if (partConfig.isTimestamp()) {
            map2.put("com.ibm.ws.util.selector.processType", "timestamp");
        } else if (partConfig.isNonce()) {
            map2.put("com.ibm.ws.util.selector.processType", "nonce");
        }
        ElementSelector elementSelector = null;
        if (com.ibm.ws.wssecurity.common.Constants.DIALECT_WAS.equals(string2)) {
            elementSelector = (ElementSelector)map.get(clazz);
        } else if (com.ibm.ws.wssecurity.common.Constants.DIALECT_FUNCTION.equals(string2)) {
            elementSelector = (ElementSelector)map.get(WSPFunctionElementSelector.class);
        } else if (com.ibm.ws.wssecurity.common.Constants.DIALECT_XPATH.equals(string2)) {
            elementSelector = (ElementSelector)map.get(XPathElementSelector.class);
        } else if (com.ibm.ws.wssecurity.common.Constants.DIALECT_HEADER.equals(string2)) {
            elementSelector = (ElementSelector)map.get(QNameHeaderSelector.class);
            map2.put("com.ibm.ws.wssecurity.util.selector.headername", partConfig.getHeaderName());
            map2.put("com.ibm.ws.wssecurity.util.selector.headernamespace", partConfig.getHeaderNamespace());
        } else {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s02", string2);
        }
        ArrayList<OMNode> arrayList = elementSelector.getElements(oMDocument.getOMDocumentElement(), map2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNoncePart(OMDocument doc,Object[] parents,PartConfig pconfig,String typeMap selectors,Class dialectSelector,Map selectorMap) returns ArrayList[" + arrayList + "]");
        }
        return arrayList;
    }

    private static String addWsuId(OMDocument oMDocument, OMElement oMElement, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addWsuId(OMDocument doc[" + DOMUtils.getDisplayName(oMDocument) + "]," + "OMElement part[" + DOMUtils.getDisplayName(oMElement) + "]," + "String nsWsu[" + string + "])");
        }
        String string2 = null;
        QName qName = IdUtils.getInstance().getIdAttributeName(oMElement);
        if (qName != null) {
            string2 = oMElement.getAttributeValue(qName);
        }
        if (string2 == null || string2.length() == 0) {
            String string3 = oMElement.getNamespace() == null ? null : oMElement.getNamespace().getName();
            String string4 = oMElement.getLocalName();
            int n = string3 == null ? 0 : string3.hashCode();
            int n2 = n * 31;
            n2 += string4 == null ? 0 : string4.hashCode();
            if (n == com.ibm.ws.wssecurity.common.Constants.HASH_DS) {
                if (n2 == com.ibm.ws.wssecurity.common.Constants.HASH_DS_SIGNATURE || n2 == com.ibm.ws.wssecurity.common.Constants.HASH_DS_SIGNATUREVALUE || n2 == com.ibm.ws.wssecurity.common.Constants.HASH_DS_SIGNEDINFO || n2 == com.ibm.ws.wssecurity.common.Constants.HASH_DS_REFERENCE || n2 == com.ibm.ws.wssecurity.common.Constants.HASH_DS_KEYINFO || n2 == com.ibm.ws.wssecurity.common.Constants.HASH_DS_OBJECT || n2 == com.ibm.ws.wssecurity.common.Constants.HASH_DS_MANIFEST || n2 == com.ibm.ws.wssecurity.common.Constants.HASH_DS_SIGNATUREPROPS || n2 == com.ibm.ws.wssecurity.common.Constants.HASH_DS_SIGNATUREPROP) {
                    string2 = IdUtils.getInstance().makeUniqueId("wssecurity_signature_id_");
                    oMElement.addAttribute("Id", string2, null);
                }
            } else if (n == com.ibm.ws.wssecurity.common.Constants.HASH_ENC && (n2 == com.ibm.ws.wssecurity.common.Constants.HASH_ENC_ENCRYPTEDKEY || n2 == com.ibm.ws.wssecurity.common.Constants.HASH_ENC_ENCRYPTEDDATA || n2 == com.ibm.ws.wssecurity.common.Constants.HASH_ENC_ENCRYPTIONPROPS || n2 == com.ibm.ws.wssecurity.common.Constants.HASH_ENC_ENCRYPTIONPROP)) {
                string2 = IdUtils.getInstance().makeUniqueId("wssecurity_signature_id_");
                oMElement.addAttribute("Id", string2, null);
            }
            if (string2 == null) {
                string2 = IdUtils.getInstance().makeUniqueId("wssecurity_signature_id_");
                String string5 = DOMUtils.getNamespacePrefix(oMElement, string);
                if (string5 == null) {
                    string5 = "wsu";
                }
                oMElement.declareNamespace(string, string5);
                oMElement.addAttribute("Id", string2, oMElement.getOMFactory().createOMNamespace(string, string5));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addWsuId(Document doc,Element part,String nsWsu) returns String[" + string2 + "]");
        }
        return string2;
    }

    private static void addTransforms(Reference reference, OMDocument oMDocument, OMFactory oMFactory, OMElement oMElement, List list, String string, String string2, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addTransforms(Reference gen[" + reference + "]," + "OMDocument doc[" + DOMUtils.getDisplayName(oMDocument) + "]," + "OMFactory factory[" + oMFactory + "]," + "OMElement part[" + DOMUtils.getDisplayName(oMElement) + "]," + "List config[" + list + "]," + "String pWsse[" + string + "]," + "String nsWsse[" + string2 + "]," + "boolean addIncNS[" + bl + "])");
        }
        for (AlgorithmConfig algorithmConfig : list) {
            String string3 = algorithmConfig.getAlgorithm();
            Map<Object, Object> map = algorithmConfig.getProperties();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding the transform [" + string3 + "]...");
            }
            if ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(string3) || "http://www.w3.org/2001/10/xml-exc-c14n#WithComments".equals(string3)) {
                reference.addTransform(SignatureGenerator.createInclusiveTransform(oMFactory, oMElement, string3, bl, bl2));
                continue;
            }
            if ("http://www.w3.org/2002/07/decrypt#XML".equals(string3)) {
                Set<String> set = SignatureGenerator.collectIdsOfEncryptedData(oMElement);
                reference.addTransform(SignatureGenerator.createDecryptionTransform(oMFactory, set, string3));
                continue;
            }
            if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform".equals(string3)) {
                reference.addTransform(SignatureGenerator.createSTRTransform(oMFactory, oMElement, string3, string, string2));
                continue;
            }
            if ("http://www.w3.org/TR/1999/REC-xpath-19991116".equals(string3)) {
                reference.addTransform(SignatureGenerator.createXPathTransform(oMFactory, string3, map));
                continue;
            }
            if ("http://www.w3.org/2002/06/xmldsig-filter2".equals(string3)) {
                reference.addTransform(SignatureGenerator.createXPath2Transform(oMFactory, string3, map));
                continue;
            }
            reference.addTransform(string3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addTransforms(Reference gen,OMDocument doc,OMFactory factory,OMElement part,List config,String pWsse,String nsWsse,boolean addIncNS)");
        }
    }

    private static OMElement createInclusiveTransform(OMFactory oMFactory, OMElement oMElement, String string, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createInclusiveTransform(OMFactory factory[" + oMFactory + "]," + "OMElement part[" + DOMUtils.getDisplayName(oMElement) + "]," + "String transform[" + string + "]," + "boolean addIncNS[" + bl + "])");
        }
        OMElement oMElement2 = oMFactory.createOMElement("Transform", com.ibm.ws.wssecurity.common.Constants.NS_DSIG, SIGNATURE_PREFIX);
        oMElement2.addAttribute("Algorithm", string, null);
        if (bl) {
            OMNode oMNode;
            if (bl2 && oMElement instanceof SOAPBody && (oMNode = oMElement.getFirstOMChild()) != null && oMNode instanceof OMSourcedElementImpl) {
                return oMElement2;
            }
            oMNode = SignatureGenerator.createInclusiveNamespaces(oMFactory, oMElement);
            if (oMNode != null) {
                oMElement2.addChild(oMNode);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createInclusiveTransform(OMFactory factory,OMElement part,String transform,boolean addIncNS) returns Element[" + DOMUtils.getDisplayName(oMElement2) + "]");
        }
        return oMElement2;
    }

    private static OMElement createInclusiveNamespaces(OMFactory oMFactory, OMElement oMElement) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createInclusiveNamespaces(OMFactory factory[" + oMFactory + "]," + "OMElement part[" + DOMUtils.getDisplayName(oMElement) + "])");
        }
        StringBuffer stringBuffer = null;
        if (oMElement != null && oMElement instanceof SOAPElementImpl) {
            object = ((SOAPElementImpl)((Object)oMElement)).getNamespacePrefixes();
            if (object != null) {
                stringBuffer = new StringBuffer();
                OMNamespace oMNamespace = null;
                while (object.hasNext()) {
                    oMNamespace = (OMNamespace)object.next();
                    if (oMNamespace instanceof OMNamespaceWithOwner) continue;
                    String string = oMNamespace.getPrefix();
                    if (string == null || string.length() == 0) {
                        stringBuffer.append("#default ");
                        continue;
                    }
                    stringBuffer.append(string);
                    stringBuffer.append(" ");
                }
            }
        } else {
            Iterator iterator;
            object = oMElement;
            HashSet<String> hashSet = new HashSet<String>();
            while (object != null && object.getType() == 1) {
                Object object2;
                iterator = ((OMElement)object).getAllDeclaredNamespaces();
                while (iterator.hasNext()) {
                    object2 = (OMNamespace)iterator.next();
                    if (object2 instanceof OMNamespaceWithOwner) continue;
                    String string = object2.getPrefix();
                    if (string == null || string.length() == 0) {
                        hashSet.add("#default");
                        continue;
                    }
                    hashSet.add(string);
                }
                object2 = object.getParent();
                if (object2 instanceof OMDocument) break;
                object = (OMNode)object2;
            }
            SignatureGenerator.scanNamespaceDecls(oMElement, hashSet);
            if (hashSet.size() > 0) {
                stringBuffer = new StringBuffer();
                iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    stringBuffer.append(iterator.next());
                    stringBuffer.append(" ");
                }
            }
        }
        object = null;
        if (stringBuffer != null) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "node search generated PrefixList: " + stringBuffer);
            }
            object = oMFactory.createOMElement("InclusiveNamespaces", "http://www.w3.org/2001/10/xml-exc-c14n#", "ec");
            object.declareNamespace("http://www.w3.org/2001/10/xml-exc-c14n#", "ec");
            object.addAttribute("PrefixList", new String(stringBuffer), null);
        } else if (tc.isEntryEnabled()) {
            Tr.debug(tc, "node search generated an empty list");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createInclusiveNamespaces(OMFactory factory,OMElement part) returns OMElement[" + DOMUtils.getDisplayName((OMNode)object) + "]");
        }
        return object;
    }

    private static void scanNamespaceDecls(OMNode oMNode, Set<String> set) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "scanNamespaceDecls(OMNode node[" + DOMUtils.getDisplayName(oMNode) + "]," + "Set prefixes[" + set + "])");
        }
        if (oMNode.getType() == 1) {
            Object object;
            Iterator iterator = ((OMElement)oMNode).getAllDeclaredNamespaces();
            while (iterator.hasNext()) {
                object = (OMNamespace)iterator.next();
                if (object instanceof OMNamespaceWithOwner) continue;
                String string = object.getPrefix();
                if (string == null || string.length() == 0) {
                    set.add("#default");
                    continue;
                }
                set.add(string);
            }
            for (object = ((OMElement)oMNode).getFirstOMChild(); object != null; object = object.getNextOMSibling()) {
                if (object.getType() != 1) continue;
                SignatureGenerator.scanNamespaceDecls((OMNode)object, set);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "scanNamespaceDecls(OMNode node, Set prefixes)");
        }
    }

    private static Set<String> collectIdsOfEncryptedData(OMNode oMNode) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "collectIdsOfEncryptedData(OMNode node[" + DOMUtils.getDisplayName(oMNode) + "])");
        }
        HashSet<String> hashSet = new HashSet<String>();
        if (oMNode != null) {
            SignatureGenerator.collectIdsOfEncryptedData(oMNode, hashSet);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "collectIdsOfEncryptedData(OMNode node) returns Set[" + hashSet + "]");
        }
        return hashSet;
    }

    private static void collectIdsOfEncryptedData(OMNode oMNode, Set<String> set) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "collectIdsOfEncryptedData(OMNode node[" + DOMUtils.getDisplayName(oMNode) + "]," + "Set ids[" + set + "])");
        }
        if (oMNode.getType() == 1) {
            if (EncryptedData.isOfType((OMElement)oMNode)) {
                OMElement oMElement = (OMElement)oMNode;
                String string = oMElement.getAttributeValue(ID_Q);
                if (string == null) {
                    string = IdUtils.getInstance().makeUniqueId("wssecurity_encryption_id_");
                    oMElement.addAttribute("Id", string, null);
                }
                set.add(string);
            } else {
                for (OMNode oMNode2 = ((OMElement)oMNode).getFirstOMChild(); oMNode2 != null; oMNode2 = oMNode2.getNextOMSibling()) {
                    if (oMNode2.getType() != 1 && oMNode2.getType() != 9) continue;
                    SignatureGenerator.collectIdsOfEncryptedData(oMNode2, set);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "collectIdsOfEncryptedData(OMNode node, Set ids)");
        }
    }

    private static OMElement createDecryptionTransform(OMFactory oMFactory, Set<String> set, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDecryptionTransform(OMFactory factory[" + oMFactory + "]," + "Set ids[" + set + "]," + "String transform[" + string + "])");
        }
        OMElement oMElement = oMFactory.createOMElement("Transform", com.ibm.ws.wssecurity.common.Constants.NS_DSIG, SIGNATURE_PREFIX);
        oMElement.addAttribute("Algorithm", string, null);
        for (String string2 : set) {
            OMElement oMElement2 = oMFactory.createOMElement("Except", "http://www.w3.org/2002/07/decrypt#", "");
            oMElement2.declareDefaultNamespace("http://www.w3.org/2002/07/decrypt#");
            oMElement2.addAttribute("URI", "#" + string2, null);
            oMElement.addChild(oMElement2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDecryptionTransform(OMFactory factory,Set ids) returns OMElement[" + DOMUtils.getDisplayName(oMElement) + "]");
        }
        return oMElement;
    }

    private static OMElement createSTRTransform(OMFactory oMFactory, OMElement oMElement, String string, String string2, String string3) {
        String string4;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSTRTransform(OMFactory factory[" + oMFactory + "]," + "OMElement part[" + DOMUtils.getDisplayName(oMElement) + "]," + "String transform[" + string + "]," + "String pWsse[" + string2 + "]," + "String nsWsse[" + string3 + "])");
        }
        OMNode oMNode = oMElement;
        HashSet<String> hashSet = new HashSet<String>();
        while (oMNode != null && oMNode.getType() == 1) {
            Object object2;
            object = oMNode.getAllDeclaredNamespaces();
            while (object.hasNext()) {
                object2 = (OMNamespace)object.next();
                if (object2 instanceof OMNamespaceWithOwner) continue;
                string4 = object2.getPrefix();
                if (string4 == null || string4.length() == 0) {
                    hashSet.add("#default");
                    continue;
                }
                hashSet.add(string4);
            }
            object2 = oMNode.getParent();
            if (object2 instanceof OMDocument) break;
            oMNode = (OMNode)object2;
        }
        SignatureGenerator.scanNamespaceDecls(oMElement, hashSet);
        object = oMFactory.createOMElement("Transform", com.ibm.ws.wssecurity.common.Constants.NS_DSIG, SIGNATURE_PREFIX);
        object.addAttribute("Algorithm", string, null);
        boolean bl = false;
        string4 = string2;
        if (string4 == null) {
            string4 = "wsse";
            bl = true;
        }
        OMElement oMElement2 = oMFactory.createOMElement("TransformationParameters", string3, string4);
        if (bl) {
            oMElement2.declareNamespace(string3, "wsse");
        }
        object.addChild(oMElement2);
        OMElement oMElement3 = oMFactory.createOMElement("CanonicalizationMethod", com.ibm.ws.wssecurity.common.Constants.NS_DSIG, SIGNATURE_PREFIX);
        oMElement3.addAttribute("Algorithm", "http://www.w3.org/2001/10/xml-exc-c14n#", null);
        oMElement2.addChild(oMElement3);
        if (hashSet.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next());
                stringBuffer.append(" ");
            }
            OMElement oMElement4 = oMFactory.createOMElement("InclusiveNamespaces", "http://www.w3.org/2001/10/xml-exc-c14n#", "ec");
            oMElement4.declareNamespace("http://www.w3.org/2001/10/xml-exc-c14n#", "ec");
            oMElement4.addAttribute("PrefixList", new String(stringBuffer), null);
            oMElement3.addChild(oMElement4);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSTRTransform(OMFactory factory,OMElement part,String transform,String pWsse,String nsWsse) returns OMElement[" + DOMUtils.getDisplayName((OMNode)object) + "]");
        }
        return object;
    }

    public static OMElement createXPathTransform(OMFactory oMFactory, String string, Map<Object, Object> map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createXPathTransform(OMFactory factory[" + oMFactory + "]," + "String transform[" + string + "]," + "Map properties)");
        }
        String string2 = (String)map.get(Constants.WSSECURITY_XPATH_EXPRESSION);
        OMElement oMElement = oMFactory.createOMElement("Transform", com.ibm.ws.wssecurity.common.Constants.NS_DSIG, SIGNATURE_PREFIX);
        oMElement.addAttribute("Algorithm", string, null);
        OMElement oMElement2 = oMFactory.createOMElement("XPath", com.ibm.ws.wssecurity.common.Constants.NS_DSIG, SIGNATURE_PREFIX);
        oMElement.addChild(oMElement2);
        OMText oMText = oMFactory.createOMText(string2);
        oMElement2.addChild(oMText);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createXPathTransform(OMFactory factory,String transform,Map properties) returns OMElement[" + DOMUtils.getDisplayName(oMElement) + "]");
        }
        return oMElement;
    }

    public static OMElement createXPath2Transform(OMFactory oMFactory, String string, Map<Object, Object> map) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createXPath2Transform(OMFactory doc[" + oMFactory + "]," + "String transform[" + string + "]," + "Map properties)");
        }
        OMElement oMElement = oMFactory.createOMElement("Transform", com.ibm.ws.wssecurity.common.Constants.NS_DSIG, SIGNATURE_PREFIX);
        oMElement.addAttribute("Algorithm", string, null);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        HashMap<String, Object> hashMap3 = new HashMap<String, Object>();
        String string2 = Constants.WSSECURITY_XPATH2_ORDER + "_";
        String string3 = Constants.WSSECURITY_XPATH2_FILTER + "_";
        String string4 = Constants.WSSECURITY_XPATH2_EXPRESSION + "_";
        for (String stringArray : map.keySet()) {
            object = (String)map.get(stringArray);
            if (stringArray.startsWith(string4)) {
                hashMap3.put(stringArray.substring(string4.length()), object);
                continue;
            }
            if (stringArray.startsWith(string3)) {
                hashMap2.put(stringArray.substring(string3.length()), object);
                continue;
            }
            if (!stringArray.startsWith(string2)) continue;
            hashMap.put(stringArray.substring(string2.length()), new Integer((String)object));
        }
        int n = hashMap.keySet().size();
        if (n > 0) {
            String string5;
            String[] stringArray = new String[n];
            object = new int[n];
            int n2 = -1;
            Iterator i = hashMap.keySet().iterator();
            while (i.hasNext()) {
                ++n2;
                string5 = (String)i.next();
                int string6 = (Integer)hashMap.get(string5);
                boolean bl = false;
                for (int j = 0; j < n2; ++j) {
                    if (string6 >= object[j]) continue;
                    for (int k = n2 - 1; k >= j; --k) {
                        stringArray[k + 1] = stringArray[k];
                        object[k + 1] = object[k];
                    }
                    stringArray[j] = string5;
                    object[j] = string6;
                    bl = true;
                    break;
                }
                if (bl) continue;
                stringArray[n2] = string5;
                object[n2] = string6;
            }
            for (int j = 0; j < stringArray.length; ++j) {
                string5 = (String)hashMap2.get(stringArray[j]);
                String string6 = (String)hashMap3.get(stringArray[j]);
                OMElement oMElement2 = oMFactory.createOMElement("XPath", "http://www.w3.org/2002/06/xmldsig-filter2", "dsf2");
                oMElement2.declareNamespace("http://www.w3.org/2002/06/xmldsig-filter2", "dsf2");
                oMElement2.addAttribute("Filter", string5, null);
                oMElement.addChild(oMElement2);
                OMText oMText = oMFactory.createOMText(string6);
                oMElement2.addChild(oMText);
                oMElement.addChild(oMElement2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createXPathTransform(OMFactory factory,String transform,Map properties) returns OMElement[" + DOMUtils.getDisplayName(oMElement) + "]");
        }
        return oMElement;
    }

    protected static void prepareTransform(SigningReferenceConfig signingReferenceConfig, Map<Object, Object> map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTransform(SigningReferenceConfig srconfig],Map selectorMap)");
        }
        boolean bl = false;
        for (AlgorithmConfig algorithmConfig : signingReferenceConfig.getTransforms()) {
            String string = algorithmConfig.getAlgorithm();
            if (!"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform".equals(string)) continue;
            bl = true;
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "STR-Transform transform found.");
        }
        if (bl) {
            map.put("security.wssecurity.integraldialectelementselector.existstrtransform", Boolean.toString(bl));
        } else {
            map.remove("security.wssecurity.integraldialectelementselector.existstrtransform");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTransform(SigningReferenceConfig srconfig,Map selectorMap)");
        }
    }

    public static Key callKeyInfoGenerator(KeyInfoGeneratorConfig keyInfoGeneratorConfig, String string, Map<Object, Object> map, Map<Object, Object> map2, OMDocument oMDocument, OMElement oMElement, Map<Object, Object> map3) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "callKeyInfoGenerator(KeyInfoGeneratorConfig config,String keytype[" + string + "]," + "Map type," + "Map properties," + "OMDocument doc[" + DOMUtils.getDisplayName(oMDocument) + "]," + "OMElement parent[" + DOMUtils.getDisplayName(oMElement) + "]," + "Map context)");
        }
        KeyInfoGenerator keyInfoGenerator = (KeyInfoGenerator)map2.get(KeyInfoGenerator.class);
        map.clear();
        map.put(Constants.WSSECURITY_KEY_TYPE, string);
        map3.put("com.ibm.ws.wssecurity.impl.config.keyinfoGenerator.configKey", keyInfoGeneratorConfig);
        Key key = keyInfoGenerator.getKey(oMDocument, oMElement, map, map3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "callKeyInfoGenerator(KeyInfoGeneratorConfig config,String keytype,Map type,Map properties,OMDocument doc,OMElement parent,Map context) returns Key[" + key + "]");
        }
        return key;
    }

    public static OMElement insertElement(OMElement oMElement, OMElement oMElement2, String string, Map<Object, Object> map) {
        String string2;
        OMElement oMElement3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "insertElement(OMElement parent[" + DOMUtils.getDisplayName(oMElement) + "]," + "OMElement elem[" + DOMUtils.getDisplayName(oMElement2) + "]," + "String nsWsu[" + string + "]," + "Map context)");
        }
        Set set = (Set)map.get("com.ibm.ws.wssecurity.constants.standAloneElements");
        String string3 = "Signature";
        String string4 = "EncryptedKey";
        String string5 = "ReferenceList";
        String string6 = "SignatureConfirmation";
        OMNode oMNode = null;
        OMElement oMElement4 = null;
        if (oMElement != null) {
            oMElement3 = DOMUtils.getFirstElement(oMElement);
            while (oMElement3 != null) {
                oMElement4 = oMElement3;
                if (set != null && set.contains(oMElement3)) {
                    oMNode = oMElement3;
                    break;
                }
                string2 = oMElement3.getNamespace() == null ? null : oMElement3.getNamespace().getNamespaceURI();
                String string7 = oMElement3.getLocalName();
                if (com.ibm.ws.wssecurity.common.Constants.NS_ENC.equals(string2) && (string4.equals(string7) || string5.equals(string7)) || com.ibm.ws.wssecurity.common.Constants.NS_DSIG.equals(string2) && string3.equals(string7) || com.ibm.ws.wssecurity.common.Constants.NS_WSSE11.equals(string2) && string6.equals(string7)) {
                    oMNode = oMElement3;
                    break;
                }
                oMElement3 = DOMUtils.getNextElement(oMElement3);
            }
        }
        if (oMNode == null && oMElement4 != null) {
            oMElement3 = oMElement4.getNamespace() == null ? null : oMElement4.getNamespace().getNamespaceURI();
            string2 = oMElement4.getLocalName();
            if (string.equals(oMElement3) && string2.equals("Timestamp")) {
                oMNode = oMElement4;
            }
        }
        if (oMElement4 == null) {
            oMElement.addChild(oMElement2);
        } else if (oMNode == null) {
            oMElement.addChild(oMElement2);
        } else {
            oMNode.insertSiblingBefore(oMElement2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "insertElement(OMElement parent,OMElement elem,String nsWsu,Map context) returns Element[" + DOMUtils.getDisplayName(oMElement2) + "]");
        }
        return oMElement2;
    }

    private static class ShowerImpl
    implements ResourceShower {
        private static ShowerImpl _instance = new ShowerImpl();

        private ShowerImpl() {
        }

        private static ShowerImpl getInstance() {
            return _instance;
        }

        public void showSignedResource(OMElement oMElement, int n, String string, String string2, byte[] byArray, String string3) {
            String string4 = null;
            try {
                string4 = string3 == null ? new String(byArray, "UTF-8") : new String(byArray, string3);
            }
            catch (Exception exception) {
                Tr.debug(tc, "WARNING: An exception occured while the content is encoded with [" + string3 + "].");
            }
            if (n < 0) {
                Tr.debug(tc, "ResourceShower logs sign-SignedInfo: " + string4);
            } else if (string == null || string.length() == 0) {
                Tr.debug(tc, "ResourceShower logs sign-resource_" + n + ": " + string4);
            } else {
                Tr.debug(tc, "ResourceShower logs sign-" + string + ": " + string4);
            }
        }
    }
}

