/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.dsig;

import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.common.Result;
import com.ibm.ws.wssecurity.common.ResultPool;
import com.ibm.ws.wssecurity.common.WSSAlgorithmFactory;
import com.ibm.ws.wssecurity.config.AlgorithmConfig;
import com.ibm.ws.wssecurity.config.EncryptionConsumerConfig;
import com.ibm.ws.wssecurity.config.KeyInfoConsumerConfig;
import com.ibm.ws.wssecurity.config.KeyInfoContentConsumerConfig;
import com.ibm.ws.wssecurity.config.SignatureConsumerConfig;
import com.ibm.ws.wssecurity.config.SigningReferenceConfig;
import com.ibm.ws.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.wssecurity.core.WSSConsumerComponent;
import com.ibm.ws.wssecurity.dsig.STRDTKeyInfoResolver;
import com.ibm.ws.wssecurity.dsig.VerificationResult;
import com.ibm.ws.wssecurity.dsig.VerifiedConfig;
import com.ibm.ws.wssecurity.dsig.WSSSignatureContext;
import com.ibm.ws.wssecurity.dsig.XMLDTKeyInfoResolver;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoConsumer;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoResult;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.NonceUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.KeyInfo;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.ResourceShower;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.HWKeyCache;
import com.ibm.ws.wssecurity.xml.xss4j.enc.EncryptedKeyRetriever;
import com.ibm.ws.wssecurity.xml.xss4j.enc.KeyInfoResolver;
import com.ibm.ws.wssecurity.xml.xss4j.enc.KeyInfoResolverBase;
import com.ibm.ws.wssecurity.xml.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.SameDocumentEncryptedKeyRetriever;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.Configuration;
import com.ibm.wsspi.wssecurity.core.config.TokenConsumerConfig;
import java.io.Serializable;
import java.security.AccessController;
import java.security.Key;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureConsumer
implements WSSConsumerComponent {
    private static final TraceComponent tc = Tr.register(SignatureConsumer.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = SignatureConsumer.class.getName();
    private static final QName ALGORITHM_Q = new QName("", "Algorithm");
    private IdUtils _idResolver = null;
    private Map<Object, Object> _selectors = null;
    private boolean _initialized = false;

    @Override
    public void init(Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._selectors = map;
            this._idResolver = (IdUtils)map.get("com.ibm.ws.wssecurity.util.selector.IDResolver");
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    @Override
    public void invoke(OMNode oMNode, Map<Object, Object> map) throws SoapSecurityException {
        OMElement oMElement;
        Cloneable cloneable;
        OMElement oMElement2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(Node target[" + DOMUtils.getDisplayName(oMNode) + "]," + "Map context)");
        }
        int n = 0;
        if (oMNode == null) {
            throw SoapSecurityException.format("security.wssecurity.SignatureConsumer.s11", "ds:Signature");
        }
        if (oMNode.getType() == 1) {
            oMElement2 = (OMElement)oMNode;
            String string = oMElement2.getNamespace() == null ? null : oMElement2.getNamespace().getName();
            String string2 = oMElement2.getLocalName();
            n = string == null ? 0 : string.hashCode() * 31;
            if ((n += string2 == null ? 0 : string2.hashCode()) != com.ibm.ws.wssecurity.common.Constants.HASH_DS_SIGNATURE) {
                throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s03", DOMUtils.getQualifiedName(oMNode));
            }
        } else {
            throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s03", DOMUtils.getQualifiedName(oMNode));
        }
        oMElement2 = (OMElement)oMNode;
        Object object = map.get("com.ibm.ws.wssecurity.constants.wssVersion");
        int n2 = 0;
        if (object != null && object instanceof Integer) {
            n2 = (Integer)object;
        }
        String string = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[0][n2];
        String string3 = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[1][n2];
        object = map.remove("com.ibm.ws.wssecurity.constants.copiedDOMTree");
        boolean bl = ConfigUtil.isTrue((String)object);
        WSSConsumerConfig wSSConsumerConfig = (WSSConsumerConfig)map.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
        SignatureConsumerConfig signatureConsumerConfig = (SignatureConsumerConfig)map.remove("com.ibm.ws.wssecurity.impl.config.signatureConsumer.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SignatureConsumerConfig [" + signatureConsumerConfig + "].");
        }
        OMDocument oMDocument = DOMUtil.getOwnerDocument(oMElement2);
        VerificationResult verificationResult = SignatureConsumer.checkSignature(oMDocument, oMElement2, wSSConsumerConfig, signatureConsumerConfig, this._idResolver, string, string3, bl, map);
        if (verificationResult._domRequired) {
            oMDocument = verificationResult._copiedDOM;
            cloneable = DOMUtils.getOneOrMoreElements(oMDocument.getOMDocumentElement(), com.ibm.ws.wssecurity.common.Constants.NS_DSIG, "Signature");
            for (int i = 0; i < ((ArrayList)cloneable).size(); ++i) {
                if (!DOMUtils.equals(oMElement2, (OMNode)((ArrayList)cloneable).get(i))) continue;
                oMElement2 = (OMElement)((ArrayList)cloneable).get(i);
                break;
            }
        }
        cloneable = new HashMap();
        map.put("com.ibm.ws.wssecurity.keyinfo.keyAlgorithm", signatureConsumerConfig.getSignatureMethod().getAlgorithm());
        Key key = SignatureConsumer.callKeyInfoConsumer(signatureConsumerConfig.getSigningKeyInfo(), "VerifyingKey", (Map<Object, Object>)((Object)cloneable), this._selectors, KeyInfo.searchForKeyInfo(oMElement2), map);
        SignatureConsumer.verify(oMElement2, key, wSSConsumerConfig, signatureConsumerConfig, this._idResolver, oMDocument, verificationResult, this._selectors, map);
        SignatureConsumer.setVerificationResult(verificationResult, signatureConsumerConfig, map);
        List list = (List)map.get("com.ibm.ws.wssecurity.constants.signatureConfirmationCache");
        if (list != null && (oMElement = DOMUtil.getFirstChildElementNamed(oMElement2, "http://www.w3.org/2000/09/xmldsig#", "SignatureValue")) != null) {
            String string4 = DOMUtil.getStringValue(oMElement);
            list.add(string4);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cached signature value for SignatureConfirmation: " + string4);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Node target, Map context)");
        }
    }

    private static VerificationResult checkSignature(OMDocument oMDocument, OMElement oMElement, WSSConsumerConfig wSSConsumerConfig, SignatureConsumerConfig signatureConsumerConfig, IDResolver iDResolver, String string, String string2, boolean bl, Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkSignature(Document doc[" + DOMUtils.getDisplayName(oMDocument) + "]," + "Element signature[" + DOMUtils.getDisplayName(oMElement) + "]," + "WSSConsumerConfig gconfig," + "SignatureConsumerConfig config," + "IDResolver idResolver[" + iDResolver + "]," + "String nsWsse[" + string + "]," + "String nsWsu[" + string2 + "]," + "boolean domRequired[" + bl + "]," + "Map context)");
        }
        VerificationResult verificationResult = new VerificationResult(signatureConsumerConfig);
        int n = 0;
        OMElement oMElement2 = DOMUtils.getFirstElement(oMElement);
        while (oMElement2 != null) {
            String string3 = oMElement2.getNamespace() == null ? null : oMElement2.getNamespace().getNamespaceURI();
            String string4 = oMElement2.getLocalName();
            n = string3 == null ? 0 : string3.hashCode() * 31;
            if ((n += string4 == null ? 0 : string4.hashCode()) == com.ibm.ws.wssecurity.common.Constants.HASH_DS_SIGNEDINFO) {
                SignatureConsumer.checkSignedInfo(oMDocument, oMElement2, wSSConsumerConfig, signatureConsumerConfig, verificationResult, iDResolver, string, string2, bl, map);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string4 + " is OK.");
                }
            } else if (n == com.ibm.ws.wssecurity.common.Constants.HASH_DS_KEYINFO || n == com.ibm.ws.wssecurity.common.Constants.HASH_DS_SIGNATUREVALUE) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string4 + " is OK.");
                }
            } else if (n == com.ibm.ws.wssecurity.common.Constants.HASH_DS_OBJECT) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string4 + " is OK. But this consumer ignores it.");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.warning(tc, "security.wssecurity.WSEC6833W", new Object[]{DOMUtils.getQualifiedName(oMElement2), DOMUtils.getQualifiedName(oMElement)});
            }
            oMElement2 = DOMUtils.getNextElement(oMElement2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkSignature(Document doc,Element signature,WSSConsumerConfig gconfig,SignatureConsumerConfig config,IDResolver idResolver,String nsWsse,String nsWsu,boolean domRequired,Map context) returns VerificationResult[" + verificationResult + "]");
        }
        return verificationResult;
    }

    private static void checkSignedInfo(OMDocument oMDocument, OMElement oMElement, WSSConsumerConfig wSSConsumerConfig, SignatureConsumerConfig signatureConsumerConfig, VerificationResult verificationResult, IDResolver iDResolver, String string, String string2, boolean bl, Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkSignedInfo(Document doc[" + DOMUtils.getDisplayName(oMDocument) + "]," + "Element sinfo[" + DOMUtils.getDisplayName(oMElement) + "]," + "WSSConsumerConfig gconfig," + "SignatureConsumerConfig config," + "VerificationResult vresult[" + verificationResult + "]," + "IDResolver idResolver[" + iDResolver + "]," + "String nsWsse[" + string + "]," + "String nsWsu[" + string2 + "]," + "boolean domRequired[" + bl + "]," + "Map context)");
        }
        int n = 0;
        OMElement oMElement2 = DOMUtils.getFirstElement(oMElement);
        while (oMElement2 != null) {
            String string3;
            String string4;
            String string5 = oMElement2.getNamespace() == null ? null : oMElement2.getNamespace().getNamespaceURI();
            String string6 = oMElement2.getLocalName();
            n = string5 == null ? 0 : string5.hashCode() * 31;
            if ((n += string6 == null ? 0 : string6.hashCode()) == com.ibm.ws.wssecurity.common.Constants.HASH_DS_C14NMETHOD) {
                string4 = DOMUtils.getAttribute(oMElement2, "Algorithm");
                string3 = null;
                if (signatureConsumerConfig.getCanonicalizationMethod() != null) {
                    string3 = signatureConsumerConfig.getCanonicalizationMethod().getAlgorithm();
                }
                if (string3 == null || !string3.equals(string4) || !wSSConsumerConfig.getAllowedCanonicalizationMethods().contains(string4)) {
                    throw SoapSecurityException.format(com.ibm.ws.wssecurity.common.Constants.UNSUPPORTED_ALGORITHM, "security.wssecurity.PrivateConsumerConfig.s08", string4);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string6 + " [" + string4 + "] is OK.");
                }
            } else if (n == com.ibm.ws.wssecurity.common.Constants.HASH_DS_SIGNATUREMETHOD) {
                string4 = DOMUtils.getAttribute(oMElement2, "Algorithm");
                string3 = null;
                if (signatureConsumerConfig.getSignatureMethod() != null) {
                    string3 = signatureConsumerConfig.getSignatureMethod().getAlgorithm();
                }
                if (string3 == null || !string3.equals(string4) || !wSSConsumerConfig.getAllowedSignatureMethods().contains(string4)) {
                    throw SoapSecurityException.format(com.ibm.ws.wssecurity.common.Constants.UNSUPPORTED_ALGORITHM, "security.wssecurity.PrivateConsumerConfig.s09", string4);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string6 + " [" + string4 + "] is OK.");
                }
            } else if (n == com.ibm.ws.wssecurity.common.Constants.HASH_DS_REFERENCE) {
                SignatureConsumer.checkReference(oMDocument, oMElement2, wSSConsumerConfig, signatureConsumerConfig.getReferences(), verificationResult, iDResolver, string, string2, bl, map);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string6 + " is OK.");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.warning(tc, "security.wssecurity.WSEC6833W", new Object[]{DOMUtils.getQualifiedName(oMElement2), DOMUtils.getQualifiedName(oMElement)});
            }
            oMElement2 = DOMUtils.getNextElement(oMElement2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkSignedInfo(Document doc,Element sinfo,WSSConsumerConfig gconfig,SignatureConsumerConfig config,VerificationResult vresult,IDResolver idResolver,String nsWsse,String nsWsu,boolean domRequired,Map context)");
        }
    }

    private static void checkReference(OMDocument oMDocument, OMElement oMElement, WSSConsumerConfig wSSConsumerConfig, List list, VerificationResult verificationResult, IDResolver iDResolver, String string, String string2, boolean bl, Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkReference(Document doc[" + DOMUtils.getDisplayName(oMDocument) + "]," + "Element reference[" + DOMUtils.getDisplayName(oMElement) + "]," + "WSSConsumerConfig gconfig," + "List config," + "VerificationResult vresult[" + verificationResult + "]," + "IDResolver idResolver[" + iDResolver + "]," + "String nsWsse[" + string + "]," + "String nsWsu[" + string2 + "]," + "boolean domRequired[" + bl + "]," + "Map context)");
        }
        boolean bl2 = false;
        Exception[] exceptionArray = new Exception[list.size()];
        int n = 0;
        int n2 = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                SigningReferenceConfig signingReferenceConfig = (SigningReferenceConfig)iterator.next();
                n2 = verificationResult._verifiedParts.size() - 1;
                SignatureConsumer.checkReference(oMDocument, oMElement, wSSConsumerConfig, signingReferenceConfig, verificationResult, iDResolver, string, string2, bl, map);
                verificationResult._srconfig = signingReferenceConfig;
                bl2 = true;
                break;
            }
            catch (Exception exception) {
                exceptionArray[n++] = exception;
                for (int i = verificationResult._verifiedParts.size() - 1; i > n2; --i) {
                    verificationResult._verifiedParts.remove(i);
                }
            }
        }
        if (!bl2) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, n + " exceptions were caught.");
                for (int i = 0; i < n; ++i) {
                    Tr.debug(tc, "No." + iterator + "'s exception: " + exceptionArray[i]);
                }
            }
            throw SoapSecurityException.format("security.wssecurity.SignatureConsumer.s12", new String[]{exceptionArray[n - 1].getMessage()}, (Throwable)exceptionArray[n - 1]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkReference(Document doc,Element reference,WSSConsumerConfig gconfig,List config,VerificationResult vresult,IDResolver idResolver,String nsWsse,String nsWsu,boolean domRequired,Map context)");
        }
    }

    private static void checkReference(OMDocument oMContainer, OMElement oMElement, WSSConsumerConfig wSSConsumerConfig, SigningReferenceConfig signingReferenceConfig, VerificationResult verificationResult, IDResolver iDResolver, String string, String string2, boolean bl, Map<Object, Object> map) throws SoapSecurityException {
        OMElement oMElement2;
        OMElement oMElement3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkReference(Document doc[" + DOMUtils.getDisplayName(oMContainer) + "]," + "Element reference[" + DOMUtils.getDisplayName(oMElement) + "]," + "WSSConsumerConfig gconfig," + "SigningReferenceConfig config," + "VerificationResult vresult[" + verificationResult + "]," + "IDResolver idResolver[" + iDResolver + "]," + "String nsWsse[" + string + "]," + "String nsWsu[" + string2 + "]," + "boolean domRequired[" + bl + "]," + "Map context)");
        }
        boolean bl2 = false;
        int n = 0;
        OMElement oMElement4 = null;
        VerificationResult.VerifiedPart verifiedPart = new VerificationResult.VerifiedPart();
        OMContainer oMContainer2 = DOMUtils.getFirstElement(oMElement);
        while (oMContainer2 != null) {
            String string3 = oMContainer2.getNamespace() == null ? null : oMContainer2.getNamespace().getNamespaceURI();
            String string4 = oMContainer2.getLocalName();
            n = string3 == null ? 0 : string3.hashCode() * 31;
            if ((n += string4 == null ? 0 : string4.hashCode()) == com.ibm.ws.wssecurity.common.Constants.HASH_DS_TRANSFORMS) {
                SignatureConsumer.checkTransforms((OMElement)oMContainer2, wSSConsumerConfig, signingReferenceConfig.getTransforms(), verifiedPart, bl, map);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string4 + " is OK.");
                }
            } else if (n == com.ibm.ws.wssecurity.common.Constants.HASH_DS_DIGESTMETHOD) {
                String string5 = DOMUtils.getAttribute((OMElement)oMContainer2, "Algorithm");
                String string6 = null;
                if (signingReferenceConfig.getDigestMethod() != null) {
                    string6 = signingReferenceConfig.getDigestMethod().getAlgorithm();
                }
                if (string6 == null || !string6.equals(string5) || !wSSConsumerConfig.getAllowedDigestMethods().contains(string5)) {
                    throw SoapSecurityException.format(com.ibm.ws.wssecurity.common.Constants.UNSUPPORTED_ALGORITHM, "security.wssecurity.PrivateConsumerConfig.s11", string5);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string4 + " [" + string5 + "] is OK.");
                }
            } else if (n == com.ibm.ws.wssecurity.common.Constants.HASH_DS_DIGESTVALUE) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string4 + " is OK.");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.warning(tc, "security.wssecurity.WSEC6833W", new Object[]{DOMUtils.getQualifiedName((OMNode)((Object)oMContainer2)), DOMUtils.getQualifiedName(oMElement)});
            }
            oMContainer2 = DOMUtils.getNextElement((OMNode)((Object)oMContainer2));
        }
        if (verificationResult._domRequired) {
            oMContainer = verificationResult._copiedDOM;
        } else if (verifiedPart._domRequired) {
            oMContainer2 = oMContainer.getOMDocumentElement().getOMFactory().createOMDocument();
            oMContainer2.addChild(oMContainer.getOMDocumentElement().cloneOMElement());
            verificationResult._domRequired = true;
            verificationResult._copiedDOM = oMContainer2;
            oMContainer = oMContainer2;
        }
        String string7 = DOMUtils.getAttribute(oMElement, "URI");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Processing URI [" + string7 + "]...");
        }
        if (string7.length() == 0) {
            oMElement4 = oMContainer.getOMDocumentElement();
        } else {
            if (string7.length() < 2 || string7.charAt(0) != '#') {
                throw SoapSecurityException.format("security.wssecurity.SignatureConsumer.s02", string7);
            }
            string7 = string7.substring(1);
            oMElement4 = iDResolver.resolveID((OMDocument)oMContainer, string7);
        }
        boolean bl3 = true;
        String string8 = (String)wSSConsumerConfig.getProperties().get("com.ibm.ws.wssecurity.EnforceStrictLayout");
        if (string8 != null) {
            bl3 = !string8.equals("false");
        }
        if (bl3) {
            HashMap hashMap;
            OMElement oMElement5;
            String string9 = oMElement4.getLocalName();
            if (wSSConsumerConfig.getLayout() == "Strict" && string9.equals("Timestamp") && (oMElement5 = (OMElement)(hashMap = (HashMap)map.get("com.ibm.ws.wssecurity.constants.timestampVerificationHash")).get(string7)) == null) {
                throw SoapSecurityException.format("Signature for timestamp found ahead of timestamp. Strict Layout not followed in incoming message. Check that the policy for sending application specifies a Strict layout.");
            }
        }
        verifiedPart._parent = oMElement4.getParent();
        verifiedPart._object = oMElement4;
        verifiedPart._timestamp = oMElement3 = NonceUtil.getTimestamp(oMElement4, string2);
        verifiedPart._nonce = oMElement2 = NonceUtil.getNonce(oMElement4, string);
        verifiedPart._noncefirst = bl2 = NonceUtil.isNonceFirst(oMElement4, oMElement2, oMElement3);
        verificationResult._verifiedParts.add(verifiedPart);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Added Verified part[" + verifiedPart + "].");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkReference(Document doc,Element reference,WSSConsumerConfig gconfig,SignatureConsumerConfig config,List parts,IDResolver idResolver,String nsWsse,String nsWsu,boolean domRequired,Map context)");
        }
    }

    private static void checkTransforms(OMElement oMElement, WSSConsumerConfig wSSConsumerConfig, List list, VerificationResult.VerifiedPart verifiedPart, boolean bl, Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkTransform(Element transforms[" + DOMUtils.getDisplayName(oMElement) + "]," + "WSSConsumerConfig gconfig," + "List config[" + list + "]," + "VerifiedPart part[" + verifiedPart + "]," + "boolean domRequired[" + bl + "]," + "Map context])");
        }
        int n = 0;
        OMElement oMElement2 = DOMUtils.getFirstElement(oMElement);
        while (oMElement2 != null) {
            OMElement oMElement3 = DOMUtils.getNextElement(oMElement2);
            String string = oMElement2.getNamespace() == null ? null : oMElement2.getNamespace().getNamespaceURI();
            String string2 = oMElement2.getLocalName();
            n = string == null ? 0 : string.hashCode() * 31;
            if ((n += string2 == null ? 0 : string2.hashCode()) == com.ibm.ws.wssecurity.common.Constants.HASH_DS_TRANSFORM) {
                SignatureConsumer.checkTransform(oMElement2, oMElement3 == null, wSSConsumerConfig, list, verifiedPart, bl, map);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string2 + " is OK.");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WARNING: There is unknown element " + DOMUtils.getQualifiedName(oMElement2) + " in the " + DOMUtils.getQualifiedName(oMElement) + " element.");
            }
            oMElement2 = oMElement3;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkTransform(Element transforms,WSSConsumerConfig gconfig,List config,VerifiedPart part,boolean domRequired,Map context)");
        }
    }

    private static void checkTransform(OMElement oMElement, boolean bl, WSSConsumerConfig wSSConsumerConfig, List list, VerificationResult.VerifiedPart verifiedPart, boolean bl2, Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkTransform(Element transform[" + DOMUtils.getDisplayName(oMElement) + "]," + "boolean lastTransform[" + bl + "]," + "WSSConsumerConfig gconfig," + "List config[" + list + "]," + "VerifiedPart part[" + verifiedPart + "]," + "boolean domRequired[" + bl2 + "]," + "Map context)");
        }
        boolean bl3 = false;
        Iterator iterator = list.iterator();
        String string = oMElement.getAttributeValue(ALGORITHM_Q);
        while (iterator.hasNext()) {
            AlgorithmConfig algorithmConfig = (AlgorithmConfig)iterator.next();
            String string2 = algorithmConfig.getAlgorithm();
            if (!string2.equals(string) || !wSSConsumerConfig.getAllowedTransforms().contains(string)) continue;
            bl3 = true;
            break;
        }
        if (!bl3) {
            throw SoapSecurityException.format(com.ibm.ws.wssecurity.common.Constants.UNSUPPORTED_ALGORITHM, "security.wssecurity.PrivateConsumerConfig.s12", string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Transform [" + string + "] is OK.");
        }
        if (ConfigUtil.isC14nTransform(string)) {
            ++verifiedPart._numC14n;
            if (bl) {
                verifiedPart._lastIsC14n = true;
            }
        } else if (bl2 && ConfigUtil.isDOMRequiredTransform(string)) {
            verifiedPart._domRequired = bl2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkTransform(List config,WSSConsumerConfig gconfig,String algorithm,VerifiedPart part,boolean domRequired,Map context)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verify(OMElement oMElement, Key key, WSSConsumerConfig wSSConsumerConfig, SignatureConsumerConfig signatureConsumerConfig, IDResolver iDResolver, OMDocument oMDocument, VerificationResult verificationResult, Map<Object, Object> map, Map<Object, Object> map2) throws SoapSecurityException {
        Object object;
        Object object2;
        Serializable serializable;
        Iterator<EncryptionConsumerConfig> iterator;
        HashSet<Configuration> hashSet;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "verify(Element signature[" + DOMUtils.getDisplayName(oMElement) + "]," + "Key key[" + key + "]," + "WSSConsumerConfig gconfig," + "SignatureConsumerConfig config," + "IDResolver idResolver[" + iDResolver + "]," + "Document document[" + DOMUtils.getDisplayName(oMDocument.getOMDocumentElement()) + "]," + "VerificationResult vresult[" + verificationResult + "]," + "Map selectors," + "Map context)");
        }
        WSSSignatureContext wSSSignatureContext = new WSSSignatureContext();
        wSSSignatureContext.setContext(map2);
        Map<Object, Object> map3 = wSSConsumerConfig.getProperties();
        wSSSignatureContext.setHWKeyStoreName((String)map2.remove("com.ibm.ws.wssecurity.config.keystore.consumerkeyStoreRef"));
        String string = null;
        if (signatureConsumerConfig.getSignatureMethod() != null) {
            string = signatureConsumerConfig.getSignatureMethod().getAlgorithm();
        }
        wSSSignatureContext.setSigAlgorithm(string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Signature Algorithm = " + string);
        }
        if (wSSSignatureContext.useHWKeyStore()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "HARDWARE Key Store Name is: " + wSSSignatureContext.getHWKeyStoreName());
            }
            if ((hashSet = ConfigUtil.getHWCryptoProviderInstance(wSSSignatureContext.getHWKeyStoreName())) == null) {
                Tr.audit(tc, "Failure to get Hardware crypto provider instance to use hardware keystore, continue processing.");
            } else {
                wSSSignatureContext.setHWKeyStoreProvider((Provider)((Object)hashSet));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "HW crypto provider instance for the HW KeyStore" + ((Provider)((Object)hashSet)).getName());
                }
            }
        }
        wSSSignatureContext.setHWConfigName((String)map3.get("HWCONFIG"));
        wSSSignatureContext.setOffload((Boolean)map3.get("com.ibm.ws.wssecurity.handler.OffloadRSAPublicKeyCryptography"));
        if (wSSSignatureContext.shouldChangeProvider()) {
            hashSet = HWKeyCache.getInstance();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "HARDWARE Acceleration enabled, Key Store Name is: " + wSSSignatureContext.getHWConfigName());
            }
            if ((iterator = ConfigUtil.getHWCryptoProviderInstance(wSSSignatureContext.getHWConfigName())) == null) {
                Tr.audit(tc, "Failure to get Hardware crypto provider instance to use hardware acceleration, continue processing.");
            } else {
                wSSSignatureContext.setHWAccelerationProvider((Provider)((Object)iterator));
                serializable = (Integer)map3.get("com.ibm.ws.wssecurity.handler.hardwareCacheSize");
                ((HWKeyCache)((Object)hashSet)).setProvider((Provider)((Object)iterator), (Integer)serializable);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "HW crypto provider instance for HW Acceleration" + ((Provider)((Object)iterator)).getName());
                }
            }
        }
        if (tc.isDebugEnabled()) {
            wSSSignatureContext.setResourceShower(ShowerImpl.getInstance());
        }
        if (iDResolver != null) {
            wSSSignatureContext.setIDResolver(iDResolver);
        }
        hashSet = new HashSet<Configuration>();
        iterator = wSSConsumerConfig.getSignatureConsumers().iterator();
        while (iterator.hasNext()) {
            hashSet.add(((SignatureConsumerConfig)iterator.next()).getSigningKeyInfo());
        }
        serializable = new HashSet();
        iterator = wSSConsumerConfig.getEncryptionConsumers().iterator();
        while (iterator.hasNext()) {
            serializable.add(iterator.next().getEncryptionKeyInfo());
        }
        Set<TokenConsumerConfig> set = wSSConsumerConfig.getTokenConsumers();
        WSSAlgorithmFactory wSSAlgorithmFactory = wSSConsumerConfig.getAlgorithmFactory();
        wSSSignatureContext.setAlgorithmFactory(wSSAlgorithmFactory);
        wSSSignatureContext.setDocument(oMDocument);
        if (signatureConsumerConfig.getKeyInfoSignature() != null) {
            wSSSignatureContext.setKeyInfoSignature(signatureConsumerConfig.getKeyInfoSignature().getAlgorithm());
        } else {
            wSSSignatureContext.setKeyInfoSignature(null);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "DecryptionTransform is used: " + signatureConsumerConfig.isDecryptionTransformEnabled());
        }
        if (signatureConsumerConfig.isDecryptionTransformEnabled()) {
            object2 = null;
            try {
                object2 = new SameDocumentEncryptedKeyRetriever(oMDocument);
            }
            catch (StructureException structureException) {
                Tr.processException(structureException, clsName + ".verify", "826");
                throw new SoapSecurityException(structureException);
            }
            wSSSignatureContext.setEncryptedKeyRetriever((EncryptedKeyRetriever)object2);
            object = new XMLDTKeyInfoResolver();
            ((KeyInfoResolverBase)object).setAlgorithmFactory(wSSAlgorithmFactory);
            ((XMLDTKeyInfoResolver)object).setContext(map2);
            ((XMLDTKeyInfoResolver)object).setSelectors(map);
            ((XMLDTKeyInfoResolver)object).setIdResolver(iDResolver);
            ((XMLDTKeyInfoResolver)object).setEncKeyInfoConsumers((Collection<Configuration>)((Object)serializable));
            ((XMLDTKeyInfoResolver)object).setTokenConsumers(set);
            wSSSignatureContext.setKeyInfoResolver((KeyInfoResolver)object);
        }
        object2 = new STRDTKeyInfoResolver();
        ((STRDTKeyInfoResolver)object2).setContext(map2);
        ((STRDTKeyInfoResolver)object2).setSelectors(map);
        ((STRDTKeyInfoResolver)object2).setDsigKeyInfoSet(hashSet);
        ((STRDTKeyInfoResolver)object2).setEncKeyInfoSet((Collection<Configuration>)((Object)serializable));
        ((STRDTKeyInfoResolver)object2).setGeneration(false);
        wSSSignatureContext.setSTRDTKeyInfoResolver((STRDTKeyInfoResolver)object2);
        wSSSignatureContext.setContext(map2);
        wSSSignatureContext.setVerificationResult(verificationResult);
        object = null;
        try {
            object = wSSSignatureContext.verify(oMElement, key);
        }
        finally {
            if (wSSSignatureContext.isHWAccelerationProvider()) {
                ConfigUtil.returnHWCryptoProviderInstance(wSSSignatureContext.getHWConfigName(), wSSSignatureContext.getHWAccelerationProvider());
            }
            if (wSSSignatureContext.useHWKeyStore()) {
                ConfigUtil.returnHWCryptoProviderInstance(wSSSignatureContext.getHWKeyStoreName(), wSSSignatureContext.getHWKeyStoreProvider());
            }
        }
        boolean bl = object.getCoreValidity();
        String string2 = null;
        if (!bl || tc.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Core validity=");
            stringBuffer.append(bl);
            stringBuffer.append(" Signed info validity=");
            stringBuffer.append(object.getSignedInfoValidity());
            stringBuffer.append(" Signed info message='");
            stringBuffer.append(object.getSignedInfoMessage());
            stringBuffer.append("'");
            int n = object.getNumberOfReferences();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(" Ref[");
                stringBuffer.append(iterator);
                stringBuffer.append("](validity=");
                stringBuffer.append(object.getReferenceValidity(i));
                stringBuffer.append(" message='");
                stringBuffer.append(object.getReferenceMessage(i));
                stringBuffer.append("' uri='");
                stringBuffer.append(object.getReferenceURI(i));
                stringBuffer.append("' type='");
                stringBuffer.append(object.getReferenceType(i));
                stringBuffer.append("')");
            }
            string2 = stringBuffer.toString();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string2);
            }
            if (bl) {
                string2 = null;
            }
        }
        if (string2 != null) {
            throw SoapSecurityException.format("security.wssecurity.SignatureConsumer.s01", string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "verify(Element signature,Key key,WSSConsumerConfig gconfig,SignatureConsumerConfig config,IDResolver idResolver,Document document,VerificationResult vresult,Map selectors,Map context)");
        }
    }

    public static Key callKeyInfoConsumer(KeyInfoConsumerConfig keyInfoConsumerConfig, String string, Map<Object, Object> map, Map<Object, Object> map2, OMElement oMElement, Map<Object, Object> map3) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "callKeyInfoConsumer(KeyInfoConsumerConfig config,String keytype[" + string + "]," + "Map type," + "Map properties," + "OMElement target[" + DOMUtils.getDisplayName(oMElement) + "]," + "Map context)");
        }
        KeyInfoConsumer keyInfoConsumer = (KeyInfoConsumer)map2.get(KeyInfoConsumer.class);
        map.clear();
        map.put(Constants.WSSECURITY_KEY_TYPE, string);
        map3.put("com.ibm.ws.wssecurity.impl.config.keyinfoConsumer.configKey", keyInfoConsumerConfig);
        Key key = keyInfoConsumer.getKey(oMElement, map, map3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "callKeyInfoConsumer(KeyInfoConsumerConfig config,String keytype,Map type,Map properties,OMElement target,Map context) returns Key[" + key + "]");
        }
        return key;
    }

    private static void setVerificationResult(VerificationResult verificationResult, SignatureConsumerConfig signatureConsumerConfig, Map<Object, Object> map) throws SoapSecurityException {
        SecurityTokenWrapper securityTokenWrapper;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setVerificationResult(VerificationResult vresult[" + verificationResult + "]," + "SignatureConsumerConfig sconfig," + "Map context)");
        }
        for (VerificationResult.VerifiedPart verifiedPart : verificationResult._verifiedParts) {
            SignatureConsumer.removeNode(verifiedPart._timestamp, "wedsig");
            SignatureConsumer.removeNode(verifiedPart._nonce, "wedsig");
        }
        verificationResult._tokenWrapper = securityTokenWrapper = SignatureConsumer.getTokenWrapper(verificationResult, signatureConsumerConfig, map);
        ResultPool.add(map, verificationResult);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setVerificationResult(VerificationResult vresult,SignatureConsumerConfig sconfig,Map context)");
        }
    }

    public static void removeNode(OMElement oMElement, String string) {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNode(OMElement element[" + DOMUtils.getDisplayName(oMElement) + "]," + "String type[" + string + "])");
        }
        if (oMElement != null && (string2 = oMElement.getAttributeValue(com.ibm.ws.wssecurity.common.Constants.WAS_EXTENTION_Q)) != null && string2.equals(string)) {
            oMElement.detach();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNode(OMElement element, String type)");
        }
    }

    protected static KeyInfoResult[] getKeyInfoResults(Map<Object, Object> map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyInfoResults(Map context)");
        }
        KeyInfoResult[] keyInfoResultArray = null;
        Result[] resultArray = ResultPool.get(map, KeyInfoResult.class);
        if (resultArray != null) {
            keyInfoResultArray = new KeyInfoResult[resultArray.length];
            for (int i = 0; i < resultArray.length; ++i) {
                keyInfoResultArray[i] = (KeyInfoResult)resultArray[i];
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyInfoResults(Map context) returns KeyInfoResult[][" + keyInfoResultArray + "]");
        }
        return keyInfoResultArray;
    }

    private static KeyInfoResult getProcessedResult(VerificationResult verificationResult, KeyInfoResult[] keyInfoResultArray, List<KeyInfoContentConsumerConfig> list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProcessedResult(VerificationResult vresult,KeyInfoResult[] results,List kclist");
        }
        KeyInfoResult keyInfoResult = null;
        if (keyInfoResultArray != null) {
            for (int i = 0; i < keyInfoResultArray.length; ++i) {
                KeyInfoResult keyInfoResult2 = keyInfoResultArray[i];
                if (keyInfoResult == null && list.contains(keyInfoResult2.getKeyInfoContentConsumer()) && keyInfoResult2.getError() == null) {
                    keyInfoResult = keyInfoResult2;
                    continue;
                }
                verificationResult._kresults.put(keyInfoResult2.getKeyInfoContentConsumer(), keyInfoResult2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProcessedResult(VerificationResult vresult,KeyInfoResult[] results,List kclist) returns KeyInfoResult[" + keyInfoResult + "]");
        }
        return keyInfoResult;
    }

    private static SecurityTokenWrapper getTokenWrapper(VerificationResult verificationResult, SignatureConsumerConfig signatureConsumerConfig, Map<Object, Object> map) throws SoapSecurityException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTokenWrapper(VerificationResult vresult[" + verificationResult + "]," + "SignatureConsumerConfig sconfig," + "Map context)");
        }
        SecurityTokenWrapper securityTokenWrapper = null;
        Collection<SecurityTokenWrapper> collection = null;
        KeyInfoResult[] keyInfoResultArray = SignatureConsumer.getKeyInfoResults(map);
        KeyInfoResult keyInfoResult = SignatureConsumer.getProcessedResult(verificationResult, keyInfoResultArray, signatureConsumerConfig.getSigningKeyInfo().getContentConsumers());
        if (keyInfoResult != null) {
            object4 = keyInfoResult.getIdInSubject();
            object3 = (SecurityTokenManagerImpl)map.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
            object = ((SecurityTokenManagerImpl)object3).getTokenWrapper((SecurityToken)(object2 = ((SecurityTokenManagerImpl)object3).getToken(keyInfoResult.getKeyInfoContentConsumer().getTokenConsumer(), (String)object4)));
            if (object != null) {
                if (((SecurityTokenWrapper)object).getError() != null) {
                    throw ((SecurityTokenWrapper)object).getError();
                }
                securityTokenWrapper = AccessController.doPrivileged(new PrivilegedAction<SecurityTokenWrapper>((SecurityTokenWrapper)object){
                    final /* synthetic */ SecurityTokenWrapper val$tokenWrapper;
                    {
                        this.val$tokenWrapper = securityTokenWrapper;
                    }

                    @Override
                    public SecurityTokenWrapper run() {
                        this.val$tokenWrapper.setReferenced(true);
                        SecurityTokenWrapper securityTokenWrapper = new SecurityTokenWrapper(this.val$tokenWrapper.getSecurityToken(), this.val$tokenWrapper.getWssapiCallbackHandler(), this.val$tokenWrapper.getWssapiLoginConfigName());
                        securityTokenWrapper.setKeyInfoType(this.val$tokenWrapper.getKeyInfoType());
                        securityTokenWrapper.setProcessed(this.val$tokenWrapper.isProcessed());
                        if (this.val$tokenWrapper.isReadOnly()) {
                            securityTokenWrapper.setReadOnly();
                        }
                        securityTokenWrapper.setReferenced(this.val$tokenWrapper.isReferenced());
                        securityTokenWrapper.setUsedTokenConsumer(this.val$tokenWrapper.getUsedTokenConsumerHash(), this.val$tokenWrapper.getUsedTokenConsumerClass());
                        securityTokenWrapper.setUsedTokenGenerator(this.val$tokenWrapper.getUsedTokenGeneratorHash());
                        securityTokenWrapper.setUsedToLogin(this.val$tokenWrapper.isUsedToLogin());
                        securityTokenWrapper.setWssapiReferenceType(this.val$tokenWrapper.getWssapiReferenceType());
                        return securityTokenWrapper;
                    }
                });
            }
            Collection<SecurityToken> object5 = ((SecurityTokenManagerImpl)object3).getTokens((String)object4);
            collection = ((SecurityTokenManagerImpl)object3).getTokenWrappers(object5);
        }
        if ((object4 = signatureConsumerConfig.getIdentityMap().get(verificationResult._srconfig)) != null && object4.size() > 0) {
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = (VerifiedConfig)object3.next();
                block1: for (KeyInfoContentConsumerConfig keyInfoContentConsumerConfig : ((VerifiedConfig)object2)._sconfig.getSigningKeyInfo().getContentConsumers()) {
                    for (int i = 0; i < keyInfoResultArray.length; ++i) {
                        if (!keyInfoContentConsumerConfig.equals(keyInfoResultArray[i].getKeyInfoContentConsumer())) continue;
                        verificationResult._identities.put((VerifiedConfig)object2, keyInfoResultArray[i]);
                        continue block1;
                    }
                }
            }
        }
        if (collection != null && collection.size() > 0) {
            block3: for (int i = 0; i < keyInfoResultArray.length; ++i) {
                object2 = keyInfoResultArray[i];
                object = ((KeyInfoResult)object2).getKeyInfoContentConsumer().getTokenConsumer();
                if (object == null) continue;
                for (SecurityTokenWrapper securityTokenWrapper2 : collection) {
                    if (object.hashCode() != securityTokenWrapper2.getUsedTokenConsumerHash()) continue;
                    verificationResult._kresults.put(object2, securityTokenWrapper2);
                    continue block3;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTokenWrapper(VerificationResult vresult,SignatureConsumerConfig sconfig,Map context) returns SecurityTokenWrapper[" + securityTokenWrapper + "]");
        }
        return securityTokenWrapper;
    }

    private static class ShowerImpl
    implements ResourceShower {
        private static ShowerImpl _instance = new ShowerImpl();

        private ShowerImpl() {
        }

        private static ShowerImpl getInstance() {
            return _instance;
        }

        public void showSignedResource(OMElement oMElement, int n, String string, String string2, byte[] byArray, String string3) {
            String string4 = null;
            try {
                string4 = string3 == null ? new String(byArray, "UTF-8") : new String(byArray, string3);
            }
            catch (Exception exception) {
                Tr.debug(tc, "WARNING: An exception occured while the content is encoded with [" + string3 + "].");
            }
            if (n < 0) {
                Tr.debug(tc, "ResourceShower logs verify-SignedInfo: " + string4);
            } else if (string == null || string.length() == 0) {
                Tr.debug(tc, "ResourceShower logs verify-resource_" + n + ": " + string4);
            } else {
                Tr.debug(tc, "ResourceShower logs verify-" + string + ": " + string4);
            }
        }
    }
}

